<?php
/**
 * 포인터 플러그인 
 *
 * @package net.lovelyus.g4.plugin.pointer
 * @author Chongmyung Park <byfun@byfun.com>
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 */
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

$luPointer = new LUPointer();
$luPointer->hook($gp_scope);

/**
 * 
 * 
 * @author Chongmyung Park <byfun@byfun.com> 
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 */
class LUPointer
{
  var $id;
  var $scope;
  var $plugin_url;
  var $plugin_path;
  var $plugin_config;
  var $config_file = 'cfg.plugin.pointer.php';
  var $do_url;

  /**
   * hook : gpf 후킹
   * 
   * @access public
   * @return void
   */
	function hook($gp_scope)
	{ 
		$this->scope = $gp_scope;
		$this->id = gp_plugin_id(__FILE__);
    $this->plugin_path = dirname(__FILE__);
    $this->plugin_url = gp_plugin_url(__FILE__);
		$this->plugin_config = gp_read_config($this->config_file, array(), $this->scope);
		$this->do_url = GP_URL . '/do.php?id='.$this->id.'&act=';

    gp_add_action('post_login_check', array($this, 'on_login_check'));
    gp_add_action('post_write_update', array($this, 'on_write_update'));
    gp_add_action('post_write_comment_update', array($this, 'on_write_comment_update'));

    gp_add_action('head_script', array($this, 'on_head_script'));

    if(defined('G4_IS_ADMIN')) 
    {
      gp_add_filter('gp_admin_menu', array($this, 'admin_menu'));

      foreach(glob($this->plugin_path."/pages/*.php") as $file)
      {
        $filename = basename($file);
        if($filename{0} == '_') continue;
        $px = str_replace('.php', '', $filename);
        gp_add_action('pxa_ptr_'.$px, array($this, 'on_px'));
      }

      gp_add_filter('gpa_menu_plugin_' . $this->id, array($this, 'plugin_menu'));
      gp_add_action('pxa_ptr_install', array($this, 'plugin_install'));
      gp_add_action('pxa_ptr_uninstall', array($this, 'plugin_uninstall'));
    }
	}

  function on_head_script()
  {
    $sess = get_session('ss_pointer');
    if(!$sess) return;
    ?>
    <link type="text/css" href="<?php echo $this->plugin_url; ?>/js/jquery.toastmessage.css" rel="stylesheet"/>
    <script type="text/javascript" src="<?php echo $this->plugin_url; ?>/js/jquery.toastmessage.js"></script>
    <script type="text/javascript">
      $(document).ready(function() {
        $().toastmessage('showToast', {
          text     : '[<strong><?php echo $sess['evt_name']; ?></strong>]<br/>축하합니다!! <a href="<?php echo G4_BBS_URL; ?>/point.php" class="ptr_win_point" style="color:#fff">☞ 포인트 확인</a>',
          sticky   : true,
          position : 'top-right',
          type     : 'notice'
        });
        setTimeout(function() { $('.ptr_win_point').click(function() { win_point(this.href); return false; }); }, 200);
      });
    </script> 
    <?php
    set_session('ss_pointer', false);
  }

  function _give_point_all($evt_type)
  {
    global $mb, $member, $bo_table, $is_guest, $wr_id, $comment_id;

    if($evt_type != 'login' && $is_guest) return;

    if($evt_type != 'login') $mb = $member;

    $now_date = G4_TIME_YMD;
    $now_time = G4_TIME_HIS;

    $sql = " SELECT * FROM gpf_pointer WHERE 
      evt_type = '{$evt_type}'
      AND ( mb_level_from <= {$mb['mb_level']} AND mb_level_to >= {$mb['mb_level']} )
      AND ( date_from <= '{$now_date}' AND date_to >= '{$now_date}' )
      AND ( time_from <= '{$now_time}' AND time_to >= '{$now_time}' )
      ";

    $res = sql_query($sql);
    while($row = sql_fetch_array($res))
    {
      if(rand(1, 100) > $row['probability']) continue;

      if($row['evt_type'] != 'login')
      {
        $target = sql_fetch("SELECT * FROM gpf_pointer_tables WHERE 
                              evt_id = '{$row['id']}' 
                              AND ( bo_table = '{$bo_table}' OR bo_table = '*') LIMIT 1");

        if(!$target) continue;

        if($row['cutline_gives'] > 0)
        {
          $whgives = ($row['evt_type'] == 'login' ? '' : ' AND bo_table = "'.$bo_table.'"');
          $setgives = ($row['evt_type'] == 'login' ? '' : ',bo_table = "'.$bo_table.'"');

          $gaves = sql_fetch("SELECT * FROM gpf_pointer_gives WHERE evt_id = '{$row['id']}' $whgives ORDER BY id DESC LIMIT 1");

          if($gaves && $gaves['gaves'] >= $row['cutline_gives']) continue;

          if(!$gaves || $gaves['log_date'] != G4_TIME_YMD)
          {
            sql_query(" INSERT INTO gpf_pointer_gives SET evt_id = '{$row['id']}', log_date = '".G4_TIME_YMD."', gaves = '1' $setgives");
            $next_give = 1;
          } else {
            sql_query(" UPDATE gpf_pointer_gives SET gaves = gaves + 1 WHERE evt_id = '{$row['id']}' AND log_date = '".G4_TIME_YMD."' $whgives");
            $next_give = $gaves['gaves'] + 1;
          }
        }
      } 

      $rel_id = G4_TIME_YMD;
      switch($evt_type)
      {
        case 'write': $rel_id = $bo_table.'/'.$wr_id; break;
        case 'write_comment': $rel_id = $bo_table.'/'.$comment_id; break;
      }

      $inserted = insert_point($mb['mb_id'], $row['point'], $row['content'], $rel_table='@pointer', $rel_id, $rel_action='pointer/event/'.$row['evt_name']);

      if($inserted == 1) 
      {
        set_session('ss_pointer', array('evt_name'=>$row['evt_name'], 'point'=>$row['point']));
      }
    }
  }

  function on_login_check()
  {
    $this->_give_point_all('login');
  }

  function on_write_update()
  {
    $this->_give_point_all('write');
  }

  function on_write_comment_update()
  {
    $this->_give_point_all('write_comment');
  }

	function admin_menu($menu)
	{
		array_push($menu, array("717030", "포인터", GP_ADMIN_URL."/admin_do.php?id=".$this->id."&act=ptr_front"));
		return $menu;
	}

  function on_px()
  {
    global $id;
    if($this->id != $id) return;

    extract($GLOBALS);
    $scope = $this->scope;
    $plugin_id = $this->id;
    $plugin_path = $this->plugin_path;
    $plugin_url = $this->plugin_url;
    $plugin_config = $this->plugin_config;
		$px_url = GP_ADMIN_URL . '/admin_do.php?id='.$this->id;
    $inc_file = $this->plugin_path.DS.'pages'.DS.basename(str_replace('ptr_', '', $act)).'.php'; 
    if(!file_exists($inc_file)) {
      gp_alert('포인터: 잘못된 접근');
    }
    include_once $inc_file;
  }

  /**
   * plugins 페이지에 메뉴 추가
   * 
   * @param mixed $menus 
   * @access public
   * @return void
   */
  function plugin_menu($menus) {
      global $bo_table;

      if (gp_table_exists('gpf_pointer')) {
          array_push($menus, array('href' => gp_url('admin_do.php', $this->scope) . '&id=' . $this->id . '&act=ptr_uninstall', 'attr' => 'onclick="return confirm(\'등록된 모든 DB 정보가 삭제됩니다.\\n진행하시겠습니까?\');"', 'text' => 'DB삭제'));
      } else {
          array_push($menus, array('href' => gp_url('admin_do.php', $this->scope) . '&id=' . $this->id . '&act=ptr_install', 'text' => 'DB생성', 'attr' => ''));
      }
      return $menus;
  }

  /**
   * 플러그인 설치
   * 
   * @access public
   * @return void
   */
  function plugin_install() {
    global $id;
    if($this->id != $id) return;
    $install_script = <<<EOF
      CREATE TABLE IF NOT EXISTS `gpf_pointer` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `evt_name` varchar(100) NOT NULL,
        `evt_type` varchar(20) NOT NULL,
        `mb_level_from` tinyint(4) NOT NULL,
        `mb_level_to` tinyint(4) NOT NULL,
        `date_from` date NOT NULL,
        `date_to` date NOT NULL,
        `time_from` time NOT NULL,
        `time_to` time NOT NULL,
        `point` int(11) NOT NULL,
        `probability` tinyint(4) NOT NULL,
        `content` varchar(255) NOT NULL,
        `cutline_gives` smallint(11) NOT NULL,
        `reg_date` datetime NOT NULL,
        PRIMARY KEY (`id`)
      ) ENGINE=MyISAM DEFAULT CHARSET=utf8;

      CREATE TABLE IF NOT EXISTS `gpf_pointer_tables` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `evt_id` int(11) NOT NULL,
        `bo_table` varchar(20) NOT NULL,
        PRIMARY KEY (`id`)
      ) ENGINE=MyISAM DEFAULT CHARSET=utf8;

      CREATE TABLE IF NOT EXISTS `gpf_pointer_gives` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `evt_id` int(11) NOT NULL,
        `bo_table` varchar(20) NULL,
        `log_date` date NOT NULL,
        `gaves` smallint(11) NOT NULL,
        PRIMARY KEY (`id`)
      ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
EOF;
    $f = explode(";", $install_script);
    for ($i = 0; $i < count($f); $i++) {
        if (trim($f[$i]) == "")
            continue;
        sql_query($f[$i]);
    }
    goto_url(gp_url('plugins.php', $this->scope));
  }

  /**
   * 플러그인 제거
   * 
   * @access public
   * @return void
   */
  function plugin_uninstall() {
    global $id;
    if($this->id != $id) return;
    sql_query("DROP TABLE gpf_pointer", false);
    sql_query("DROP TABLE gpf_pointer_tables", false);
    sql_query("DROP TABLE gpf_pointer_gives", false);
    gp_deactivate_plugin($this->id, $this->scope);
    goto_url(gp_url('plugins.php', $this->scope));
  }

}
?>
