<?php
/**
 * Copyright (c) 2012 Jacob Lee <letsgolee@naver.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA or check at http://www.gnu.org/licenses/gpl.html
 */

if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

$token = get_token();

$g4['title'] = "OpenSSL for HTTP 설정";

// 데이터베이스를 확인해서 만일 필드가 없다면 추가한다.
if (!array_key_exists('cf_http_openssl_use', $config)/* || !array_key_exists('cf_pem_privatekey', $config) || !array_key_exists('cf_pem_publickey', $config)*/) {
	$result = sql_query(" alter table {$g4[config_table]} 
	            ADD `cf_http_openssl_use` tinyint(4) NOT NULL default '0',
			    ADD `cf_pem_privatekey` varchar(900) NOT NULL default '', 
			    ADD `cf_pem_publickey` varchar(300) NOT NULL default '' ");

	if (!$result) alert("OpenSSL for HTTP을 데이터베이스에 설치 중 에러가 발생했습니다. 다시 시도합니다.", $_SERVER['PHP_SELF']);

	$config['cf_http_openssl_use'] = 0;
	$config['cf_pem_privatekey'] = '';
	$config['cf_pem_publickey'] = '';
}

include_once 'head.php';
?>
<form name="fhttpopensslform" id="fhttpopensslform" method="post" onsubmit="return fhttpopenssl_submit(this);">
<input type="hidden" name="token" id="token" value="<?php echo $token;?>" />
<input type="hidden" name="id" value="<?php echo $id;?>" />
<input type="hidden" name="act" value="<?php echo $act;?>" />
<input type="hidden" name="m" value="form_update" />
<input type="hidden" name="nolayout" id="nolayout" value="1" />

<section id="frm_http_openssl" class="cbox">

	<table class="frm_tbl">
    <colgroup>
        <col class="grid_3">
        <col class="grid_15">
    </colgroup>
    <tbody>
    <tr>
        <th scope="row"><label for="cf_http_openssl_use">OpenSSL for HTTP 사용</label></th>
        <td>
            OpenSSL for HTTP 사용 여부를 결정합니다. <br/>
            <input type="checkbox" name="cf_http_openssl_use" value="1" id="cf_http_openssl_use" <?=$config['cf_http_openssl_use']?'checked':'';?>/> 사용
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="gen_httpopenssl_key">RSA키 생성</label></th>
        <td>
<?php
	$pem_key = (strlen($config['cf_pem_publickey']) && strlen($config['cf_pem_privatekey'])) ? true : false;
?>
            http_openssl에서 사용할 RSA키를 생성합니다.<br/><? if($pem_key) { ?><b>RSA키가 있습니다.</b> <? } else { ?><b>RSA키 생성이 필요합니다. OpenSSL for HTTP을 사용하려면 반드시 키를 생성해야 합니다.</b><?}?><br/><br/>키 생성을 원하면 아래 키생성에 체크하십시오. 생성된 키는 데이터베이스에 저장됩니다. 만일 RSA키의 Private Key가 노출되었다면 반드시 키를 다시 생성해야 합니다(RSA에 사용할 키를 생성하는데 시간이 많이 소요됩니다. 만일 서버에서 bcmath를 지원하지 않으면 서버가 응답하지 않을 수 있습니다.<br/>
            <input type="checkbox" name="gen_http_openssl_key" value="1" id="gen_http_openssl_key" <?=$pem_key?'':'checked';?>/> RSA PEM키 생성
        </td>
    </tr>
    </tbody>
    </table>
</section>

<fieldset id="admin_confirm">
    <legend>XSS 혹은 CSRF 방지</legend>
    <p>관리자 권한을 탈취당하는 경우를 대비하여 패스워드를 다시 한번 확인합니다.</p>
    <label for="admin_password">관리자 패스워드<strong class="sound_only">필수</strong></label>
    <input type="password" name="admin_password" id="admin_password" required class="required frm_input">
</fieldset>

<div class="btn_confirm">
    <input type="submit" value="확인" class="btn_submit" accesskey="s">
</div>
</form>

<style type="text/css">
.frm_tbl { border-top:2px solid #eee; line-height:160%; font-size:10pt; }
.frm_tbl td,
.frm_tbl th { border-bottom:1px solid #eee; }
.frm_tbl th { vertical-align:top; width:150px; }
#admin_confirm { border:0; text-align:center;}
#admin_confirm legend { display:none; }
#admin_confirm p { padding:8px; text-align:center; border:0; }
.btn_confirm { text-align:center; margin-top:10px; }
.btn_confirm .btn_submit { background-color:#555; color:#fff; padding:5px 20px; border:0; }
.btn_confirm .btn_submit:hover { background-color:#888; }
</style>

<script type="text/javascript">
function fhttpopenssl_submit(f)
{
    f.action = "admin_do.php";
    return true;
}

</script>
<?php include_once 'tail.php'; ?>
