/**
 * JavaScript Pseudo-Random number generator for RSA Encryption.
 *
 * Copyright (c) 2012 Jacob Lee <letsgolee@naver.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA or check at http://www.gnu.org/licenses/gpl.html
 */

/**
 * Copyright (c) 2005-2009  Tom Wu
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL TOM WU BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * In addition, the following condition applies:
 *
 * All redistributions must retain an intact copy of this copyright notice
 * and disclaimer.
 */
function ARC4() {
	this.i = 0;
	this.j = 0;
	this.S = new Array();
};

// Initialize ARC4 context from key, an array of ints, each from [0..255]
ARC4.prototype.init = function(key) {
	var i, j, t;
	for(i = 0; i < 256; ++i)
		this.S[i] = i;
	j = 0;
	for(i = 0; i < 256; ++i) {
		j = (j + this.S[i] + key[i % key.length]) & 255;
		t = this.S[i];
		this.S[i] = this.S[j];
		this.S[j] = t;
	}
	this.i = 0;
	this.j = 0;
};

ARC4.prototype.next = function() {
	var t;
	this.i = (this.i + 1) & 255;
	this.j = (this.j + this.S[this.i]) & 255;
	t = this.S[this.i];
	this.S[this.i] = this.S[this.j];
	this.S[this.j] = t;
	return this.S[(this.S[this.j] + this.S[this.i]) & 255];
};


function PRNG() {
	// Pool size must be a multiple of 4 and greater than 32.
	// An array of bytes the size of the pool will be passed to init()
	this.psize = 256;
	this.pool = null;
	this.pptr = null;
	this.state = null;

	this._init();
};


// Mix in a 32-bit integer into the pool
PRNG.prototype.seedInt = function(x) {
	this.pool[this.pptr++] ^= x & 255;
	this.pool[this.pptr++] ^= (x >> 8) & 255;
	this.pool[this.pptr++] ^= (x >> 16) & 255;
	this.pool[this.pptr++] ^= (x >> 24) & 255;
	if(this.pptr >= this.psize) this.pptr -= this.psize;
};

// Mix in the current time (w/milliseconds) into the pool
PRNG.prototype.seedTime = function() {
	this.seedInt(new Date().getTime());
};

PRNG.prototype._init = function() {
	// Initialize the pool with junk if needed.
	if(this.pool == null) {
		this.pool = new Array();
		this.pptr = 0;
		var t;

		if(navigator.appName == "Netscape" && navigator.appVersion < "5" && window.crypto) {
			// Extract entropy (256 bits) from NS4 RNG if available
			var z = window.crypto.random(32);
			for(t = 0; t < z.length; ++t)
				this.pool[this.pptr++] = z.charCodeAt(t) & 255;
		}

		while(this.pptr < this.psize) {	// extract some randomness from Math.random()
			t = Math.floor(65536 * Math.random());
			this.pool[this.pptr++] = t >>> 8;
			this.pool[this.pptr++] = t & 255;
		}

		this.pptr = 0;
		this.seedTime();
		//this.seedInt(window.screenX);
		//this.seedInt(window.screenY);
	}

	if(this.state == null) {
		this.seedTime();
		this.state = new ARC4();
		this.state.init(this.pool);
		for(this.pptr = 0; this.pptr < this.pool.length; ++this.pptr)
			this.pool[this.pptr] = 0;
		this.pptr = 0;
		//this.pool = null;
	}
};

PRNG.prototype.getByte = function() {
	return this.state.next();
};

PRNG.prototype.getBytes = function(ba) {
	for(var i = 0; i < ba.length; ++i) ba[i] = this.getByte();
	return ba;
};
