<?php
/**
 * PHP Pseudo-Random number generator for RSA Encryption.
 *
 * Copyright (c) 2012 Jacob Lee <letsgolee@naver.com>
 *
 * $this program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * $this program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with $this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA or check at http://www.gnu.org/licenses/gpl.html
 */

// PHP does not have zero fill right shift operator
/*
>>> 
 
This is the zero-fill right shift operator which shifts the binary representation of the first operand
to the right by the number of places specified by the second operand. 
Bits shifted off to the right are discarded and zeroes are added on to the left. 
With a positive number you would get the same result as with the sign-propagating right shift operator, 
but negative numbers lose their sign becoming positive as in the next example, 
which (assuming 'a' to be -13) would return 1073741820: 
 
Code: 
result = a >>> b;
*/
if (!function_exists('zerofill_rightshift')) {
	function zerofill_rightshift($a,$b) { // 25.035852193832
		if ($a >= 0) return bindec(decbin($a>>$b)); //simply right shift for positive number
		$bin = decbin($a>>$b);
		$bin = substr($bin, $b); // zero fill on the left side
		$o = bindec($bin);
		return $o;
	}
}

class ARC4 {
	function ARC4()
	{
		$this->i = 0;
		$this->j = 0;
		$this->S = array();
	}

	// Initialize ARC4 context from key, an array of ints, each from [0..255]
	function init($key) {
		/*var i, j, t;*/
		for($i = 0; $i < 256; ++$i)
			$this->S[$i] = $i;
		$j = 0;
		for($i = 0; $i < 256; ++$i) {
			$j = ($j + $this->S[$i] + $key[$i % count($key)]) & 255;
			$t = $this->S[$i];
			$this->S[$i] = $this->S[$j];
			$this->S[$j] = $t;
		}
		$this->i = 0;
		$this->j = 0;
	}

	function next() {
		/*var t;*/
		$this->i = ($this->i + 1) & 255;
		$this->j = ($this->j + $this->S[$this->i]) & 255;
		$t = $this->S[$this->i];
		$this->S[$this->i] = $this->S[$this->j];
		$this->S[$this->j] = $t;
		return $this->S[($this->S[$this->j] + $this->S[$this->i]) & 255];
	}
}


class PRNG {
	function PRNG()
	{
		// Pool size must be a multiple of 4 and greater than 32.
		// An array of bytes the size of the pool will be passed to init()
		$this->psize = 256;
		$this->pool = null;
		$this->pptr = null;
		$this->state = null;

		$this->_init();
	}


	// Mix in a 32-bit integer into the pool
	function seedInt($x) {
		$this->pool[$this->pptr++] ^= $x & 255;
		$this->pool[$this->pptr++] ^= ($x >> 8) & 255;
		$this->pool[$this->pptr++] ^= ($x >> 16) & 255;
		$this->pool[$this->pptr++] ^= ($x >> 24) & 255;
		if($this->pptr >= $this->psize) $this->pptr -= $this->psize;
	}

	// Mix in the current time (w/milliseconds) into the pool
	function seedTime() {
		$this->seedInt(/*new Date().getTime()*/time()); // how about md5(microtime())?
	}

	function _init() {
		// Initialize the pool with junk if needed.
		if($this->pool == null) {
			$this->pool = array();
			$this->pptr = 0;
			/*var t;*/
/*
			if(navigator.appName == "Netscape" && navigator.appVersion < "5" && window.crypto) {
				// Extract entropy (256 bits) from NS4 RNG if available
				var z = window.crypto.random(32);
				for(t = 0; t < z.length; ++t)
					$this->pool[$this->pptr++] = z.charCodeAt(t) & 255;
			}
*/
			while($this->pptr < $this->psize) {	// extract some randomness from Math.random()
				$t = /*Math.floor(65536 * Math.random())*/rand(0, 65535);
				$this->pool[$this->pptr++] = /*$t >>> 8*/zerofill_rightshift($t, 8);
				$this->pool[$this->pptr++] = $t & 255;
			}

			$this->pptr = 0;
			$this->seedTime();
			//$this->seedInt(window.screenX);
			//$this->seedInt(window.screenY);
		}

		if($this->state == null) {
			$this->seedTime();
			$this->state = new ARC4();
			$this->state->init($this->pool);
			for($this->pptr = 0; $this->pptr < count($this->pool); ++$this->pptr)
				$this->pool[$this->pptr] = 0;
			$this->pptr = 0;
			//$this->pool = null;
		}
	}

	function getByte() {
		return $this->state->next();
	}

	function getBytes($ba) {
		for($i = 0; $i < count($ba); ++$i) $ba[$i] = $this->getByte();
		return $ba;
	}
}

?>