<?
/**
 * 
 * HTTP Open SSL 플러그인 정보 클래스
 *
 * @license GPL2 (http://www.gnu.org/licenses/gpl-2.0.html)
 * @author	chongmyung.park (http://byfun.com)
 *
 * OpenSSL for HTTP 를 사용하기 쉽도록 변환한 플러그인입니다.
 * 이 프로그램에 대한 자세한 정보는 http_openssl 디렉토리안의 도움 파일들을 참고하시기 바랍니다.
 *
 * OpenSSL for HTTP 저자 정보
 *
 * @author Jacob Lee <letsgolee@naver.com>
 * 
 */


if (!defined("GPF")) exit; // 개별 페이지 접근 불가 

class GPFPluginInfoHttpopenssl extends GPFPluginInfo 
{
	/**
	 * 생성자
	 */
	public function __construct() {				
		parent::__construct();
	
		$this->version = "2013-05-24";
		$this->author_name = "byfun";
		$this->author_homepage = "http://byfun.com";
		$this->plugin_link = "http://lovelyus.net/axis/gpf_plugin.php?plugin=ssl";

		$this->label = "HTTP Open SSL";
	}

	/**
	 * 
	 * 플러그인 설명
	 * 
	 * @return string 플러그인설명
	 */
	public function getDescription()
	{
		return <<<EOF
			PHP, JS 기반의 보안 서버 플러그인입니다. <br/>
			플러그인 활성화 후 상단 메뉴의 '플러그인 > HTTP Open SSL' 메뉴에서 설치 및 설정하세요. <br/>
			<br/>
			* HTTP Open SSL 프로그램 제작자 : <a href="mailto:letsgolee@naver.com">Jacob Lee</a> <br/>
			* 원본 게시물 : <a href="http://sir.co.kr/bbs/board.php?bo_table=g4s_plugin&wr_id=14">http://sir.co.kr/bbs/board.php?bo_table=g4s_plugin&wr_id=14</a>
EOF;
	}
}
?>
