<?
/**
 * 
 * HTTP Open SSL 플러그인
 *
 * @license GPL2 (http://www.gnu.org/licenses/gpl-2.0.html)
 * @author	chongmyung.park (http://byfun.com)
 *
 * OpenSSL for HTTP 를 사용하기 쉽도록 변환한 플러그인입니다.
 * 이 프로그램에 대한 자세한 정보는 http_openssl 디렉토리안의 도움 파일들을 참고하시기 바랍니다.
 *
 * OpenSSL for HTTP 저자 정보
 *
 * @author Jacob Lee <letsgolee@naver.com>
 * 
 */

if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

include_once dirname(__FILE__).DS.'http_openssl'.DS.'http_openssl.lib.php';
http_openssl_load();		

$luHttpOpenSSL = new LUHttpOpenSSL();
$luHttpOpenSSL->hook();

/**
 * edit 가 필요없는 폼에 secure 설정 (e.g. 로그인 폼)
 * 
 * @param mixed $form_name 암호화를 적용할 form 이름
 * @param mixed $create_cookie 쿠키를 설정할 것인가
 * @param string $js_code 추가적인 js 코드
 * @param string $form_action 폼의 액션 페이지 지정
 * @access public
 * @return void
 */
function secure_form( $form_name, $create_cookie = false, $js_code = '', $form_action = '') 
{
  http_openssl_simple_prepare($create_cookie, $js_code);
  if($form_name) _http_openssl_modify_form($form_name, $form_action);
}

/**
 * edit 가 필요한 폼에 secure 설정 (e.g. 회원 정보 수정 폼)
 *
 * @param string $condi_var_name 조건에 사용될 변수 이름
 * @param string $condi_val 조건에 사용될 변수의 값. 즉 $GLOBALS['condi_var_name'] 값이 $condi_val과 같을 경우를 체크한다.
 * @param string $encrypt_var_names  서버에서 암호화 할 변수들의 이름의 집합
 * @param string $save_array_name 암호화할 array 이름. register_form.skin.php에서는 $member가 사용되므로 'member'가 된다.
 * @param string $form_name 폼의 이름. 클라이언트에서 암호화 된 데이터를 복호화하여 폼에 입력하기 위해 사용된다.
 * @param string $js_code 폼처리 과정 추가적으로 필요한 javascript 코드를 적어준다. 예로 mb_email 외에 old_email 값도 복호화해야 한다.
 * @param string $form_action 폼의 액션 페이지 지정
 * @access public
 * @return void
 */
function secure_edit_form( $condi_var_name='', $condi_val='', $encrypt_var_names='', $save_array_name='', $form_name='', $js_code='', $form_action = '')
{
  http_openssl_prepare( $condi_var_name, $condi_val, $encrypt_var_names, $save_array_name, $form_name, $js_code, $add_script );
  _http_openssl_modify_form($form_name, $form_action);
}

/**
 * 폼 submit 전에 암호화 처리
 * 
 * @param mixed $form_name 폼이름
 * @param string $form_action 폼의 액션 페이지
 * @access public
 * @return void
 */
function _http_openssl_modify_form($form_name, $form_action = '')
{
  static $script_printed = false;

  if (defined('HTTP_OPENSSL_READY')) { ?>

    <script type="text/javascript">
    <?php if(!$script_printed) { ?>
    function http_openssl_modify_form() {
      var form = document.createElement('form');
      var div = document.createElement('div');
      div.style.display = 'none';
      div.style.visibility = 'hidden';
      div.appendChild(form);
      document.body.appendChild(div);

      for (var i = 0; i < this.elements.length; i++) {
        var el = this.elements[i];

        if (el.type != 'button' && el.type != 'image' && el.type != 'submit' && el.name) { 
          var input = document.createElement('input');
          input.name = el.name;
          input.type = el.type;
          input.value = aes.encrypt(el.value, aes_key);
          if (el.type == 'checkbox' || el.type == 'radio') input.checked = el.checked;
          form.appendChild(input);
        }			
      }

      form.enctype = this.enctype;
      form.action = this.action;
      form.method = this.method;
      form.name = this.name + '-2';

      var input = document.createElement('input');
      input.type = 'hidden';
      input.name = 'encrypted_aes_key';
      input.value = rsa.encrypt(BASE64.encode(aes_key));
      form.appendChild(input);
      <?php
      if (is_array($GLOBALS['http_openssl']) && is_array($GLOBALS['http_openssl']['save_array'])) {
        // 암호화 한 변수를 다음 사용을 위해 복원해야 하는 경우가 있다.
        // 예로 register_form.skin.php에서 $member의 일부 데이터를 암호화 한 후 클라이언트로 전송했는데
        // 작업이 끝나면 혹 다른 스킨이나 프로그램에서 $member를 사용할 수 있으므로 원래의 값으로 
        // 되돌리는 작업이 필요로 한다.
        $GLOBALS[$GLOBALS['http_openssl']['save_name']] = $GLOBALS['http_openssl']['save_array'];
        unset($GLOBALS['http_openssl']);
      }
      ?>
      
      if (this.oldsubmit && this.oldsubmit() == false) {
        return false;
      }

      this.disabled = true;
      form.submit();
      return false;
    }
    <?php $script_printed = true; } ?>

    $(document).ready(function() { 
      var f = document.forms['<?php echo $form_name;?>'];
      if(!f) return;
      if (f.oldsubmit) f.hosubmit = f.onsubmit;
      else if (f.onsubmit) f.hosubmit = f.onsubmit;
      <?php if($form_action) { ?>
      f.action = '<?php echo $form_action; ?>';
      <?php } ?>
      f.onsubmit = http_openssl_modify_form;
    });

    </script>

  <?php } // if defined HTTP_OPENSSL_READY
} // end of http_openssl_modify_form




class LUHttpOpenSSL
{	
  var $id;
	var $plugin_path;
	var $plugin_url;
	var $formnames = array(
		'register_form'=>'fregisterform',	// 회원가입 및 회원정보 수정
		'login'=>'flogin',					// 로그인
		'member_form'=>'fmember',			// 관리자페이지 회원정보수정
		'member_confirm'=>'fmemberconfirm'	// 회원 패스워드 확인
	);

  /**
   * 이벤트 후킹
   * 
   * @access public
   * @return void
   */
	function hook()
	{
    $this->id = gp_plugin_id(__FILE__);
		$this->plugin_path = dirname(__FILE__);
		$this->plugin_url = gp_plugin_url(__FILE__);

		gp_add_action('pre_login', array($this, 'modify_login_form'));  # for skin/member/<skinname>/login.skin.php 
		gp_add_action('pre_member_confirm', array($this, 'modify_mbconfirm_form'));	# for skin/member/<skinname>/member_confirm.skin.php 
		gp_add_action('pre_register_form', array($this, 'modify_reg_form'));	# for skin/member/<skinname>/register_form.skin.php 
		gp_add_action('pre_register_update', 'http_openssl_save_session');	# for skin/member/<skinname>/register_form_update.tail.skin.php 

		# 관리자 페이지
		if( strpos( realpath(dirname($_SERVER['SCRIPT_FILENAME'])), realpath($GLOBALS['g4']['admin_path']) ) === 0     )
		{
			# 관리지 페이지 상단에 스크립트 추가
			gp_add_action('head_script', array($this, 'admin_head'));

			switch(str_replace('.php', '', basename($_SERVER['SCRIPT_FILENAME'])))
			{
				case 'member_form': gp_add_action('head_script', array($this, 'admin_mbform_head'));	break;  # for adm/member_form.php 
				case 'member_form_update': http_openssl_save_session(); break;  # for adm/member_form_update.php
			}

		} else if($GLOBALS['is_admin'] && $GLOBALS['bo_table'] && $GLOBALS['board']['bo_use_sideview']) {
			gp_add_action('head_script', array($this, 'admin_head'));
		}

		gp_add_filter('gp_admin_menu', array($this, 'admin_menu'));
		gp_add_action('pxa_config', array($this, 'on_admin'));
	}

  /**
   * for skin/member/<skinname>/login.skin.php
   *
   * @access public
   * @return void
   */
	function modify_login_form()
	{
		secure_form($this->formnames['login'], false, '', G4_BBS_URL.'/login_check.php');
	}

  /**
   * for skin/member/<skinname>/member_confirm.skin.php
   *
   * @access public
   * @return void
   */
	function modify_mbconfirm_form()
	{
		secure_form($this->formnames['member_confirm'], true, '', $GLOBALS['url']);
	}

  /**
   * for skin/member/<skinname>/register_form.skin.php
   * 
   * @access public
   * @return void
   */
	function modify_reg_form()
	{
		secure_edit_form(
			'w', 'u', 
			array('mb_id', 'mb_nick', 'mb_name', 'mb_email', 'mb_birth', 'mb_homepage', 'mb_tel', 'mb_hp', 'mb_zip1', 'mb_zip2', 'mb_addr1', 'mb_addr2'),
			'member',
			$this->formnames['register_form'],
			" \t\tif (i == 'mb_nick' && f.elements['mb_nick_default']) { f.elements['mb_nick_default'].value = aes.decrypt(encrypt_data[i], aes_key); f.elements['mb_nick'].defaultValue = f.elements['mb_nick_default'].value; }",
			"./register_form_update.php"
		);
	}

  /**
   * for admin.head.php
   * 
   * @access public
   * @return void
   */
	function admin_head()
	{
		secure_form('' /* no modify form */, true, 
		"var encrypted_aes_key = rsa.encrypt(BASE64.encode(aes_key));

		// GET방식으로 encrypted_aes_key를 전송한다.
		$(document).ready(function(){
			$('a[href*=\"/member_form.php\"]').each(function () {
				var href = $(this).attr('href');
				if(href && href.match(/(\&|\?)w=u/gi)) $(this).attr('href', href+'&encrypted_aes_key='+encrypted_aes_key);
			 });
			$('a').filter(function() {
				var onclick = $(this).attr('onClick');
				return onclick && onclick.match(/^showSideView/);
			}).each(function () {
				var onclick = $(this).attr('onClick');
				$(this).attr('onclick', '').click(function() {
					eval(onclick);
					$('#nameContextMenu').find('a').each(function() {
						var href = $(this).attr('href');
						if(href && href.match(/(\&|\?)w=u/gi)) $(this).attr('href', href+'&encrypted_aes_key='+encrypted_aes_key);
					});
				});

			 });

		});"
		);
	}

  /**
   * for adm/member_form.php 
   *
   * @access public
   * @return void
   */
	function admin_mbform_head()
	{		
		secure_edit_form(
			'w', 'u', 
			array('mb_id', 'mb_nick', 'mb_name', 'mb_email', 'mb_birth', 'mb_homepage', 'mb_tel', 'mb_hp', 'mb_zip1', 'mb_zip2', 'mb_addr1', 'mb_addr2', 'mb_memo', 'mb_profile'),
			'mb',
			$this->formnames['member_form'],
			'', './member_form_update.php'
		);
	}

  /**
   * 관리자 메뉴 추가
   * 
   * @param mixed $menu 
   * @access public
   * @return void
   */
	function admin_menu($menu)
	{
		array_push($menu, array("717002", "HTTP OpenSSL", GP_ADMIN_URL."/admin_do.php?id=".$this->id."&act=config"));
		return $menu;
	}

  /**
   * HTTP OpenSSL 관리 기능
   * 
   * @access public
   * @return void
   */
	function on_admin()
	{
		extract($GLOBALS); extract($_GET); extract($_POST);

		$m = $_REQUEST['m'];

		if(!$m) $m = "form";
		$plugin_path = $this->plugin_path;
		$plugin_url = $this->plugin_url;

		$inc_file = $plugin_path."/adm/http_openssl_".basename($m).".php";

		if(file_exists($inc_file)) include_once $inc_file;
		else alert('HTTP Open SSL : 잘못된 접근입니다.');

	}
}
?>
