<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name The Simplog                                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 01/Feb/2006 23:48                                |
// +----------------------------------------------------------------------+
//
// $Id install.inc$

$dbcon = "";

class Install
{
    var $ok = true;

    var $required = array();
    var $dbcon;

    var $step = 0;

    var $okMessage = "";

    function Install()
    {
        $this->required['PHP']['version'] = "4.1.0";
    }

    function run()
    {
        // check dir permision
        if(!is_writable(SPG_ROOT) || !is_writable(SPG_ROOT."/_skin"))
        {
            $err['type'] = "퍼미션 오류!";
            $err['msg'] = "블로그를 설치한 폴더와 _skin에 쓰기권한을 주세요. 보통 707로 설정하면 됩니다.<br />리눅스라면 다음 명령어를 실행하세요.<br /> 심플로그 폴더에서 <br /> <b>chmod 707 . </b>(주의: 점있습니다.)<br /> <b>chmod 707 _skin</b><br />고친후 페이지를 다시 로드하세요.";
            require_once "error.tpl";
            exit;
        }

        // then make default folders : _data and _cache
        if(!is_dir(SPG_ROOT."/_cache"))
        {
            mkdir(SPG_ROOT."/_cache", 0707);
            chmod(SPG_ROOT."/_cache", 0707);
        }

        if(!is_dir(SPG_ROOT."/_data"))
        {
            mkdir(SPG_ROOT."/_data", 0707);
            chmod(SPG_ROOT."/_data", 0707);
        }

        // Session set
        @session_cache_limiter('nocache, must-revalidate');
        session_set_cookie_params(0,"/");
        @session_start();

        @header('Content-type: text/html; charset=UTF-8');

        if(isset($_POST['step']))
            $this->step = $_POST['step'];

        if($_POST['w'] == 'n')
            $this->step = $this->step + 1;
        else if($_POST['w'] == 'p')
            $this->step = $this->step - 1;

        // must set the language
        if(!$_POST['langu'])
            $this->step = 0;

        switch($_POST['mode'])
        {
            case 'db':
                require_once dirname(__FILE__)."/lang/".$_POST['langu']."/lang.inc";
                $this->DBCheck($lang);
                break;
            case 'admin':
                require_once dirname(__FILE__)."/lang/".$_POST['langu']."/lang.inc";
                $this->makeAdmin($lang);
                break;
            case 'link':
                if($_POST['board_type'])
                {
                    require_once dirname(dirname(__FILE__))."/_linked/link.inc";
                    define("SPG_PREFIX", "spg_".$_SESSION['PREFIX']);
                    // make linked setting file
                    $linked = new Linked();
                    $this->makeLinkedTable();
                    $linked->makeSetupFile($_POST);
                }
                break;
        }

        switch($this->step)
        {
            // system check
            case "2":
                require_once dirname(__FILE__)."/lang/".$_POST['langu']."/lang.inc";
                $this->systemCheck();
                $okMessage = "";
                if(!$this->required['PHP']['ok'])
                {
                    $okMessage = '<img src="images/no.gif" alt="no" />'.$lang['install']['nophp'];
                    $this->ok = false;
                }

                if(!$this->required['PEAR']['ok'])
                    $okMessage .= '<br><img src="images/no.gif" alt="no" />'.$lang['install']['nopeardb'];

                if(!$this->required['MBSTRING']['ok'])
                    $okMessage .= '<br><img src="images/no.gif" alt="no" />'.$lang['install']['nombstring'];

                if(!$this->required['ICONV']['ok'])
                    $okMessage .= '<br><img src="images/no.gif" alt="no" />'.$lang['install']['noiconv'];

                if($this->required['PHP']['ok'] && $this->required['MBSTRING']['ok'] && $this->required['PEAR']['ok'] && $this->required['ICONV']['ok'])
                    $okMessage .= $lang['install']['okrequired'];

                if(!$this->required['MBSTRING']['ok'] && !$this->required['ICONV']['ok'])
                {
                    $okMessage .= $lang['install']['noiconvmbstring'];
                    $this->ok = false;
                }
                
                $this->ok ? $disabled = "" :  $disabled = "disabled";
                include "install2.tpl";
                break;
            // super admin input
            case "3":
                require_once dirname(__FILE__)."/lang/".$_POST['langu']."/lang.inc";
                include "install3.tpl";
                break;
            // DB info input                
            case "4":
                require_once dirname(__FILE__)."/lang/".$_POST['langu']."/lang.inc";
                include "install4.tpl";
                break;
            // 보드 연동
            case "5":
                require_once dirname(__FILE__)."/lang/".$_POST['langu']."/lang.inc";
                $path = dirname(dirname(__FILE__));
                include "link.html";
                break;
            // finish
            case "6":
                require_once dirname(__FILE__)."/lang/".$_POST['langu']."/lang.inc";
                //make a config file
                $this->makeConfig();
                include "install_final.tpl";
                break;
            // set language
            case "1":
            default:
                include "install1.tpl";
                $this->step = 1;
                break;
        }
    }

    function makeLinkedTable()
    {
        require_once dirname(dirname(__FILE__))."/_lib/DB.php";
        $dsn = "mysql://".$_SESSION['USER'].":".$_SESSION['PASS']."@".$_SESSION['HOST']."/".$_SESSION['DB'];
        $this->dbcon = DB::connect($dsn);

        $query = "CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_boardlink` (
                  `board_user_id` VARCHAR( 255 ) NOT NULL ,
                  `simplog_user_id` VARCHAR( 255 ) NOT NULL ,
                  PRIMARY KEY ( `board_user_id` )
                ) TYPE=MyISAM";

        $result = $this->dbcon->query($query);
    }

    function makeConfig()
    {
        require_once dirname(dirname(__FILE__))."/_lib/data.inc";
        $data = new Data();

        $contents = sprintf("DATATYPE|mysql|DBHOST|%s|DBNAME|%s|DBUSER|%s|DBPASS|%s|PREFIX|%s|LANG|%s|ROOT|%s",$_SESSION['HOST'], $_SESSION['DB'], $_SESSION['USER'], $_SESSION['PASS'], $_SESSION['PREFIX'], $_POST['langu'], $_SESSION['ROOT']);

        $data->spgWriteFile(dirname(dirname(__FILE__))."/_data/global.php", $contents);

        // make folder and copy index.php 
        $username = $_SESSION['ROOT'];
        if(!is_dir(dirname(dirname(__FILE__))."/".$username))
        {
            mkdir(dirname(dirname(__FILE__))."/".$username, 0707);
            chmod(dirname(dirname(__FILE__))."/".$username, 0707);
            copy(dirname(dirname(__FILE__))."/_lib/index_copy.inc", dirname(dirname(__FILE__))."/".$username."/index.php");
            chmod(dirname(dirname(__FILE__))."/".$username."/index.php", 0707);
        }

        // then copy default skin to _skin folder
        /******** removed from v0.4.0
        if(!is_dir(dirname(dirname(__FILE__))."/_skin/simplog"))
        {
            require_once dirname(dirname(__FILE__))."/_lib/library.inc";
            $library = new Library();
            $library->copyDir("default_skin", dirname(dirname(__FILE__))."/_skin/simplog");    
        }
        **********/

        // destroy all sessions
        $_SESSION = array();
        unset($_SESSION);
        session_destroy();
    }

    function makeAdmin($lang)
    {
        $username = strtolower($_POST['username']);
        $userpass = $_POST['userpass'];

        if($_POST['w'] == 'n')  $this->step = 3;

        if(!trim($username))  $this->okMessage = $lang['install']['inputusername'];
        else if(!trim($userpass))  $this->okMessage = $lang['install']['inputuserpass'];
        else if(!$this->checkAvailableID($username))
            $this->okMessage = $lang['install']['hasdir'];
        else
        {
            $_SESSION['ROOT'] = $username;
            $_SESSION['USERPASS'] = $userpass;
            $this->step = 4;
        }
    }

    function checkAvailableID($username)
    {
        if($_POST['use'] != "use")
        {
            if(is_dir(dirname(dirname(__FILE__))."/".$username))
                return false;
            else
                return true;
        }
        else
            return true;
    }

    function DBCheck($lang)
    {
        $host = $_POST['host'];
        $db = $_POST['db'];
        $user = $_POST['user'];
        $pass = $_POST['pass'];
        $prefix = $_POST['prefix'];

        if($_POST['w'] == 'n')  $this->step = 4;

        if(!trim($host))  $this->okMessage = $lang['install']['inputhost'];
        else if(!trim($db))  $this->okMessage = $lang['install']['inputdb'];
        else if(!trim($user))  $this->okMessage = $lang['install']['inputdbudr'];
        else if(!trim($pass))  $this->okMessage = $lang['install']['inputdbpass'];
        else if(!trim($prefix))  $this->okMessage = $lang['install']['inputprefix'];
        else
        {
            require_once dirname(dirname(__FILE__))."/_lib/DB.php";

            $dsn = "mysql://".$user.":".$pass."@".$host."/".$db;

            $this->dbcon = DB::connect($dsn);
            $GLOBALS['dbcon'] = $this->dbcon;
            if (DB::isError($this->dbcon)) 
            {            
                $this->okMessage = $lang['install']['wrongdbinfo'];
            }
            else
            {
                $this->dbcon->setFetchMode(DB_FETCHMODE_ASSOC);
                $_SESSION['HOST'] = $host;
                $_SESSION['DB'] = $db;
                $_SESSION['USER'] = $user;
                $_SESSION['PASS'] = $pass;
                $_SESSION['PREFIX'] = $prefix;

                $this->checkCreateTables($lang);
            }
        }

        if($_POST['w'] == 'p') $this->okMessage = "";

    }

    function checkCreateTables($lang)
    {
        $this->okMessage = "";        

        define("SPG_PREFIX", "spg_".$_SESSION['PREFIX']);

        $id = $_SESSION['ROOT'];

        // load schema file
        include dirname(dirname(__FILE__))."/_lib/schema.inc";

        if($_POST['deltables'] == "del")
        {
            // drop existing tables
            // admin table            
            $result = $this->dbcon->query($adminSchemaDrop);
            if (DB::isError($result))
            {
                die ($result->getMessage());
            }
            // other tables
            unset($query);
            foreach ($simplerSchemaDrop as $query)
            {
                $result = $this->dbcon->query($query);
                if (DB::isError($result))
                {
                    die ($result->getMessage());
                }
            }

            // then creat table
            $this->createTables($id);
            $this->step = 5;
        }
        // use existing table
        else if($_POST['deltables'] == "use")
        {
            $query = "SELECT * FROM ".SPG_PREFIX."_admin ORDER BY reg_date ASC LIMIT 0, 1";
            $result = $this->dbcon->query($query);
            if (DB::isError($result))
            {
                $this->okMessage = $lang['install']['noexisttable'];
                $this->step = 4;
            }
            else
            {
                $aData = $result->fetchRow();
                $_SESSION['ROOT'] = $aData['user_name'];
                $this->step = 5;

                // ALTER TABLE `spg_simplog_comments` ADD `member_id` VARCHAR(255) NOT NULL ;
                $query = "SELECT member_id FROM ".SPG_PREFIX." LIMIT 0, 1";
                $result = $this->dbcon->query($query);
                if (DB::isError($result))
                {
                    $query = "ALTER TABLE ".SPG_PREFIX."_comments ADD `member_id` VARCHAR( 255 ) NOT NULL";
                    $result = $this->dbcon->query($query);
                }
            }
        }
        // may new fresh install
        else
        {
            $query = "SELECT * FROM ".SPG_PREFIX."_admin LIMIT 0, 1";

            $result = $this->dbcon->query($query);
            if (DB::isError($result))
            {
                // then creat table
                $this->createTables($id);
                $this->step = 5;
            }
            else
            {
                $this->okMessage = $lang['install']['sametable'];
                $this->step = 4;
            }
        }
    }

    function createTables($id)
    {
        include dirname(dirname(__FILE__))."/_lib/schema.inc";

        // creat new tables for a user
        // admin        
        $result = $this->dbcon->query($adminSchemaCreate);
        if (DB::isError($result))
        {
            die ($result->getMessage());
        }
        // other tables
        unset($query);
        foreach ($simplerSchemaCreate as $query)
        {
            $result = $this->dbcon->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage());
            }
        }

        // add root user
        $query = sprintf("INSERT INTO ".SPG_PREFIX."_admin".
            " (user_name, password, level, reg_date, language, owner)".
            " VALUES".
            " (%s, password(%s), 1, now(), %s, %s)",
            $this->quote_smart($_SESSION['ROOT']),
            $this->quote_smart($_SESSION['USERPASS']),
            $this->quote_smart($_POST['langu']),
            $this->quote_smart($_SESSION['ROOT']));

        $result = $this->dbcon->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage());
        }

        define("SPG_BLOG", SPG_PREFIX."_".$id);

        // insert a default category
        $query = "INSERT INTO ".SPG_PREFIX."_category".
            " (category_id, category_name, open, user_name)".
            " VALUES".
            " (1, 'Category', '1', '{$id}')";

        $result = $this->dbcon->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage());
        }

        // insert a default group for the link
        $query = "INSERT INTO ".SPG_PREFIX."_links_group".
            " (group_no, group_name, group_order, visible, user_name)".
            " VALUES".
            " (1, 'Bloggers', '1', '1', '{$id}')";

        $result = $this->dbcon->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage());
        }
         
        include dirname(dirname(__FILE__))."/_lib/data.inc";

        $data = new Data();

        // default setting for admin
        $newData['admin_guest_num'] = 10;
        $newData['admin_guest_use1'] = 1;
        $newData['admin_cate_show_num'] = 1;
        $newData['admin_nowiam_title'] = "Notice";
        $newData['admin_simpler_allowed_blog_num'] = 1;
        $newData['admin_simpler_allowed_metablog_num'] = 1;
        $newData['admin_simpler_blog_size'] = 10;
        $newData['admin_numrelated'] = 5;
        $newData['admin_numtags'] = 20;
        $newData['admin_listnum'] = 20;

        $data->updateDataTableByBlog($newData, $id);
    }

    // Quote variable to make safe
    function quote_smart($value)
    {
        // Stripslashes
        if (get_magic_quotes_gpc()) 
        {
            $value = stripslashes($value);
        }
        // Quote if not integer
        if (!is_numeric($value) || !$value) 
        {
            $value = "'" . addslashes($value) . "'";
        }
        return $value;
    }


    function systemCheck()
    {
        // php version check
        if(version_compare(phpversion(), $this->required['PHP']['version']) < 0)
        {
            $this->ok = false;
            $this->required['PHP']['ok'] = false;
        }
        else
        {
            $this->required['PHP']['ok'] = true;
        }

        // Pear DB version check
        @require_once dirname(dirname(__FILE__)).'/_lib/PEAR.php';
	    if (!class_exists('PEAR'))
        {
            $this->required['PEAR']['ok'] = false;
        }
        else
        {
            $this->required['PEAR']['ok'] = true;
        }

        // mb string module check
        if(!function_exists('mb_strcut'))
        {
            $this->required['MBSTRING']['ok'] = false;
        }
        else
        {
            $this->required['MBSTRING']['ok'] = true;
        }

        if(!function_exists('iconv'))
        {
            $this->required['ICONV']['ok'] = false;
        }
        else
        {
            $this->required['ICONV']['ok'] = true;
        }
    }

    function printCheck($ok)
    {
        if($ok) echo '<img src="images/ok.gif" alt="ok" />';
        else    echo '<img src="images/no.gif" alt="no" />';
    }


}
?>