<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version : The Simplog                                   |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005                                                   |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 29/Dec/2005 17:22                                |
// +----------------------------------------------------------------------+
//
// $Id make.php$

require_once dirname(dirname(__FILE__))."/_lib/init.inc";
require_once dirname(dirname(__FILE__))."/_lib/login.inc";
require_once dirname(dirname(__FILE__))."/_lib/library.inc";
require_once dirname(dirname(__FILE__))."/_linked/link.inc";

$linked = new Linked();
$linkedData = $linked->getLinkedSetting();

// session start again
@session_save_path($linkedData['SESLOC']);
@session_start();

// logged in Board
if(isset($_SESSION[$linkedData['SESSION']]))
{
    $boardUser = $linked->getBoardUser($_SESSION[$linkedData['SESSION']]);
    $boardid = $boardUser[$linkedData['ID']];
    
    if($_POST['exe'] == "ok")
    {
        $boardMember = $linked->getBoardMember($_SESSION[$linkedData['SESSION']]);
        if(!$boardMember[$linkedData['PASS']])
        {
            $what = "ERROR CODE 100";
            $msg = "비밀번호가 잘못되었습니다. 다시 한번 확인해주세요.";
            $back = "1";
            include "message.html";
            exit;
        }

        if(file_exists(dirname(dirname(__FILE__))."/".$_POST['blog_id']))
        {
            $what = "CODE 101";
            $msg = "사용할 수 없는 블로그아이디 입니다. 관리자에게 위의 코드 번호를 말하고 문의하세요.";
            $back = "1";
            include "message.html";
            exit;
        }

        $userData = $linked->getBoardLink($boardid);
        if($userData['board_user_id'])
        {
            $what = "CODE 102";
            $msg = "죄송하지만 님은 <b>".$userData['simplog_user_id']."</b>으로 이미 블로그를 생성하셨습니다. 만약에 아니라면 위의 코드 번호를 관리자에게 말하고 문의하세요.";
            $back = "1";
            include "message.html";
            exit;

        }

        // convert boardInfo to Simplog info
        $id = $_POST['blog_id'];
        $pass = $_POST['pass'];
        $nick = $boardMember[$linkedData['NICK']];

        // need to convert UTF-8
        $id = $linked->convertUTF8($id);
        $nick = "";

        $lang = "korean";
        $linked->addSimplerExe($id, $pass, $nick, $lang);
        $linked->insertBoardLink($boardid, $id);

        $what = " 성공";
        $msg = "블로그 생성이 성공했습니다. <br /><br /><a href='../".$id."'>내 블로그 가기</a>를 눌러 블로그 관지자 모드로 가서 기본 정보를 설정해주세요.";
        $back = "0";
        include "message.html";
    }
    else
    {
        include "make.html";
    }
}
// not logged in Board
else
{
    $what = "ERROR";
    $msg = "로그인이 되어있지 않습니다. 로그인후 다시 개설해주세요.";
    $back = "0";
    include "message.html";
}

?>