<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version The Simplog                                     |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 16/Jan/2006 01:34                                |
// +----------------------------------------------------------------------+
//
// $Id action.inc$

// to read java script
if($_GET['n'])
    $script = $_GET['n'];
else if($_POST['n'])
    $script = $_POST['n'];

require_once dirname(dirname(__FILE__))."/_lib/init.inc";
require_once dirname(dirname(__FILE__))."/_lib/skin.inc";
require_once dirname(dirname(__FILE__))."/_lib/data.inc";
require_once dirname(dirname(__FILE__))."/_lib/library.inc";
require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";

class Action
{
    var $skin;

    function Action()
    {
        $this->skin = new Skin();
    }

    function printContents($m, $num, $div = 'y')
    {
        $library = new Library();

        $tcdata2 = $this->startAction($m, $num, $div);

        $m_array = array("comment", "replycomment", "modifycomment", "blank", "guest", "replyguest", "modifyguest");

        if(in_array($m, $m_array))
        {
            $contents = $tcdata2;
            if($contents)
            {
                ob_start();
                include SPG_SKIN_CACHE_DIR."/comment_main.php";
                $tcdata2 = ob_get_contents();
                ob_end_clean();
            }
        }

        // escaping
        $tcdata = str_replace("\n","",str_replace("\r","",$tcdata2));
        $tcdata = $library->magicQuote($tcdata);

        if($div == 'y')
        {
            @header('Content-type: text/html; charset=UTF-8');
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<script type="text/javascript">
<!--
    var div = parent.document.getElementById("<?php echo $GLOBALS['where']; ?>");
	div.innerHTML = '<?php echo $tcdata;?>';
	div.style.display = '';
-->
</script>
<body>
</body>
</html>
<?php
        }
        else
            return $tcdata2;
    }

    function startAction($m, $num, $div = 'y')
    {
        $library = new Library();
        $data = new Data();
        $mainView = new Mainview();

        $m_array = array("comment", "replycomment", "modifycomment", "tb", "blank", "guest", "replyguest", "modifyguest");
        $x = array("delcomment");
        if(in_array($m, $m_array))
        {
            ob_start();
            if($m == "modifycomment" || $m == "modifyguest")
            {
                // get data entered
                $modify = $data->getOneComment($GLOBALS['child']);
            }

            if($m == "tb")
            {
                $postResult = $data->getItemsByNo($num, 0);
                $postData = $postResult->fetchRow();
                if($postData['dis_tb'])
                {
                    echo $GLOBALS['lang']['action']['distb'];
                    $this->printTBView();
                }
                else
                {
                    //trackback display
                    include SPG_SKIN_CACHE_DIR."/trackback_view.php";
                }

                $tcdata2 = ob_get_contents();                
                if(!ob_end_clean()) $library->dieError("Buffer error, ".__FILE__.__LINE__, 1);
            }
            else if($m == "blank")
            {
                // nothing to print
            }
            else if($m == "guest" || $m == "replyguest")
            {
                if($m == "guest" || $m == "replyguest")
                {
                    if(isset($_SESSION['spg_user_name']))
                    {
                        $userInfo = $data->getAdminData($_SESSION['spg_user_name']);
                        $modify['name'] = $userInfo['nick_name'];
                        $modify['homepage'] = (SPG_URI)."/".$_SESSION['spg_user_name'];
                    }
                    else if(isset($_SESSION['spg_neigh_user_id']))
                    {
                        $userInfo = $data->checkNeighBlog($_SESSION['spg_neigh_user_id']);
                        $modify['name'] = $userInfo['nick_name'];
                        $modify['homepage'] = $userInfo['blog_url'];
                    }
                    else if(IS_LINKED)
                    {
                        require_once dirname(dirname(__FILE__))."/_linked/link.inc";
                        $linked = new Linked();
                        $setup = new Setup();
                        $linkSetup = $setup->getLinkedSetting();
                        switch($linkSetup['BOARDTYPE'])
                        {
                           case 'zero':
                                if(isset($_SESSION['zb_logged_no']))
                                {
                                    $linkBoardMember = $linked->getBoardUser($_SESSION['zb_logged_no']);
                                }
                                if($linkBoardMember['name'])
                                {
                                    $modify['name'] = $linked->convertUTF8($linkBoardMember['name']);
                                    $modify['homepage'] = $linkBoardMember['homepage'];
                                }
                                break;
                            case 'gnu4':
                                // auto login
                                if(isset($_SESSION['ss_mb_id']))
                                {
                                    $linkBoardMember = $linked->getBoardUser($_SESSION['ss_mb_id']);
                                }
                                if($linkBoardMember['mb_nick'])
                                {
                                    $modify['name'] = $linked->convertUTF8($linkBoardMember['mb_nick']);
                                    $modify['homepage'] = $linkBoardMember['mb_homepage'];
                                }
                                break;
                            default:
                                break;
                        }
                    }
                }

                // focus move to here
                echo '<a name="rcom'.$num.'"></a>';

                $adminData2 = $data->getAdminData2();
                if($adminData2['admin_guest_use1'] != "1" && !isset($_SESSION['spg_neigh_user_id']) && ($_SESSION['spg_user_name'] != $mainView->getOwnerByBlog($GLOBALS['n'])))
                {
                    // display deny error message
                    echo $GLOBALS['lang']['action']['disguest'];
                }
                else
                {
                    $this->printGuestInstruc();
                    include SPG_SKIN_CACHE_DIR."/comment_form.php";
                }
                if($_POST['act'] == "guest")
                    $page = 1;
                else
                {
                    $page = $GLOBALS['page'];
                }
                $this->printGuestView($page, $adminData2);

                $tcdata2 = ob_get_contents();
                if(!ob_end_clean()) $library->dieError("buffer error, ".__FILE__.__LINE__, 1);  
            }
            else
            {
                if($m == "comment" || $m == "replycomment")
                {
                    if(isset($_SESSION['spg_user_name']))
                    {
                        $userInfo = $data->getAdminData($_SESSION['spg_user_name']);
                        $modify['name'] = $userInfo['nick_name'];
                        $modify['homepage'] = (SPG_URI)."/".$_SESSION['spg_user_name'];
                    }
                    else if(isset($_SESSION['spg_neigh_user_id']))
                    {
                        $userInfo = $data->checkNeighBlog($_SESSION['spg_neigh_user_id']);
                        $modify['name'] = $userInfo['nick_name'];
                        $modify['homepage'] = $userInfo['blog_url'];
                    }
                    else if(IS_LINKED)
                    {
                        require_once dirname(dirname(__FILE__))."/_linked/link.inc";
                        $linked = new Linked();
                        $setup = new Setup();
                        $linkSetup = $setup->getLinkedSetting();
                        switch($linkSetup['BOARDTYPE'])
                        {
                            case 'zero':
                                if(isset($_SESSION['zb_logged_no']))
                                {
                                    $linkBoardMember = $linked->getBoardUser($_SESSION['zb_logged_no']);
                                }
                                if($linkBoardMember['name'])
                                {
                                    $modify['name'] = $linked->convertUTF8($linkBoardMember['name']);
                                    $modify['homepage'] = $linkBoardMember['homepage'];
                                }
                                break;
                            case 'gnu4':
                                // auto login
                                if(isset($_SESSION['ss_mb_id']))
                                {
                                    $linkBoardMember = $linked->getBoardUser($_SESSION['ss_mb_id']);
                                }
                                if($linkBoardMember['mb_nick'])
                                {
                                    $modify['name'] = $linked->convertUTF8($linkBoardMember['mb_nick']);
                                    $modify['homepage'] = $linkBoardMember['mb_homepage'];
                                }
                                break;
                            default:
                                break;
                        }
                    }
                }

                // focus move to here
                echo '<a name="rcom'.$num.'"></a>';
                $postResult = $data->getItemsByNo($num, 0);
                $postData = $postResult->fetchRow();
                if($postData['dis_comment'])
                {
                    $this->printCommentView($m, $num, $postData['dis_comment']);
                    echo $GLOBALS['lang']['action']['disreply'];
                }
                else
                {
                    $this->printCommentView($m, $num);
                    include SPG_SKIN_CACHE_DIR."/comment_form.php";
                }

                $tcdata2 = ob_get_contents();
                if(!ob_end_clean()) $library->dieError("buffer error, ".__FILE__.__LINE__, 1);
            }   // end if else

            return $tcdata2;

        } // End if
        else if(in_array($m, $x))
        {            
            $library->dieError("Wrong request".__FILE__.__LINE__, 1);            
        } // End else if
    } // End startAction()

    /**
     * printCommentView()
     * :: print comment_view file looply
    **/
    function printCommentView($m, $num, $dis = "0")
    {
        $data = new Data();
        $skin = new Skin();
        $mainView = new Mainview();
        
        if($m == "replycomment")
        {
            // print instruction
            if($dis == "0")
            {
                // to print an original comment
                $comment = $data->getOneComment($GLOBALS['child']);

                include SPG_SKIN_CACHE_DIR."/comment_view.php";
                echo "<div class='replytitle'>".$GLOBALS['lang']['action']['reply']."</div>";
            }
        }
        else if($m == "modifycomment")
        {
            // print instruction
            if($dis == "0")
                echo $GLOBALS['lang']['action']['replymodify'];
            // nothing to print in modifying comment mode
        }        
        else if($m == "comment")
        {
            $result = $data->getAllTopComments($num);

            while($comment = $result->fetchRow())
            {
                // secret comment
                if($comment['is_secret'] == 1 && $_SESSION['spg_user_name'] != $mainView->getOwnerByBlog($GLOBALS['n']))
                {
                    $comment['name'] = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' border='0' alt='secret' />";
                    $comment['memo'] = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' border='0' alt='secret' />";
                }
                else if($comment['is_secret'] == 1 && $_SESSION['spg_user_name'] == $mainView->getOwnerByBlog($GLOBALS['n']))
                {
                    $comment['name'] = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' alt='secret' border='0' />".$comment['name'];

                }

                if($_SESSION['spg_user_name'] == $mainView->getOwnerByBlog($GLOBALS['n']))
                {
                    $comment['memo'] .= "&nbsp;&nbsp;&nbsp;&nbsp;".$comment['ip'];
                }
                
                include SPG_SKIN_CACHE_DIR."/comment_view.php";
            }
        }
    }

    function printGuestInstruc()
    {
        if($GLOBALS['m'] == "replyguest")
        {
            // print instruction
            echo $GLOBALS['lang']['action']['guest'];
        }
        else if($GLOBALS['m'] == "modifyguest")
        {
            echo $GLOBALS['lang']['action']['guestmodify'];
            // nothing to print in modifying comment mode
        }
    }
    /**
     * printGuestView()
     * :: print comment_view file looply for guest bbs
    **/
    function printGuestView($page, $adminData2)
    {
        $data = new Data();
        $skin = new Skin();
        $mainview = new Mainview();
        
        $num = $adminData2['admin_guest_num'];
        $start = $mainview->getStartNumOfPage($page, $num);
        $result = $data->getAllTopGuest($GLOBALS['num'], $start, $num);

        if($GLOBALS['m'] == "replyguest")
        {
            // nothing
        }
        else if($GLOBALS['m'] == "modifyguest")
        {
            // nothing
        }
        else
        {
            while($comment = $result->fetchRow())
            {
                // secret comment
                if($comment['is_secret'] == 1 && $_SESSION['spg_user_name'] != $mainview->getOwnerByBlog($GLOBALS['n']))
                {
                    $comment['name'] = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' border='0' alt='secret' />";
                    $comment['memo'] = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' border='0' alt='secret' />";
                }
                else if($comment['is_secret'] == 1 && $_SESSION['spg_user_name'] == $mainview->getOwnerByBlog($GLOBALS['n']))
                {
                    $comment['name'] = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' alt='secret' border='0' />".$comment['name'];
                }

                if($_SESSION['spg_user_name'] == $mainview->getOwnerByBlog($GLOBALS['n']))
                {
                    $comment['memo'] .= "&nbsp;&nbsp;&nbsp;&nbsp;".$comment['ip'];
                }
                
                include SPG_SKIN_CACHE_DIR."/comment_view.php";
            }
        }
    }

    /**
     * printTBView()
     * :: print trackback_contents file looply
    **/
    function printTBView()
    {
        $data = new Data();
        $skin = new Skin(); 

        $result = $data->getTrackBack($GLOBALS['num']);

        while($tb = $result->fetchRow())
        {
            include SPG_SKIN_CACHE_DIR."/trackback_contents.php";
        }

    }

    function printTBUrl()
    {
        $tb = sprintf((SPG_URI)."/%s/index.php/tb/%s",
            $GLOBALS['n'],
            $GLOBALS['num']);

        echo $tb;
    }

    function printTBSubject($tb)
    {
        // delete button
        if(isset($_SESSION['spg_user_name']) && $_SESSION['spg_user_name'] == $GLOBALS['n'])
        {
            $del = " ".sprintf('<a href="#dtb" class="DTB" onclick="popupDelCom(\'%s/_skin/_default_/ask_pass.html?mode=tb&amp;n=%s&amp;no=%s&amp;num=%s\');">', SPG_URI, $GLOBALS['n'], $tb['no'], $tb['post_no'])."X</a>";;
        }
        else $del = "";

        echo sprintf('<a href="%s" target="_blank">%s</a>%s',
            $tb['p_link'],
            strip_tags($tb['title']),
            $del);
    }

    function printTBContents($tb)
    {
        $mainview = new Mainview();
        echo $mainview->strCut(strip_tags($tb['contents'], "<br>"), 200);;
    }

    function printTBFrom($tb)
    {
        echo sprintf('<a href="%s" target="_blank">%s</a>',
            $tb['p_link'],
            $tb['site_name']);
    }

    /**
     * printCommentMemo()
     * :: print memo from DB
    **/
    function printCommentMemo($data)
    {
        echo nl2br($data['memo']);
    }

    function printCommentName($data)
    {
        if(IS_LINKED)
        {
            if($data['member_id'])
                $name = "<a href=\"javascript:send_memo('".$data['member_id']."')\" title='Send Memo'>".$data['name']."</a>";
            else if($data['homepage'])
            {
                if(substr($data['homepage'], 0, 7) != "http://")
                    $home = "http://".$data['homepage'];
                else
                    $home = $data['homepage'];

                $name = '<a href="'.$home.'" title="'.$home.'" onclick="window.open(this.href); return false;">'.$data['name'].'</a>';
            }
            else
                $name = $data['name'];
        }
        else
        {
            // get homepage
            if($data['homepage'])
            {
                if(substr($data['homepage'], 0, 7) != "http://")
                    $home = "http://".$data['homepage'];
                else
                    $home = $data['homepage'];

                $name = '<a href="'.$home.'" target="_blank">'.$data['name'].'</a>';
            }
            else $name = $data['name'];
        }

        $name = "<a name='com".$data['no']."' />".$name;

        echo $name;
    }

    function printCommentHomepage($data)
    {
        $home = "";
        // get homepage
        if($data['homepage'])
        {
            if(substr($data['homepage'], 0, 7) != "http://")
                $home = "http://".$data['homepage'];
            else
                $home = $data['homepage'];
        }            

        echo $home;

    }

    function printWriteForm()
    {
        $form = sprintf('<form name="frmwrite_%s" method="post">
            <input type="hidden" name="ato" value="%s" />
            <input type="hidden" name="act" value="%s" />
            <input type="hidden" name="num" value="%s" />
            <input type="hidden" name="n" value="%s" />
            <input type="hidden" name="where" value="%s" />
            <input type="hidden" name="child" value="%s" />
            <input type="hidden" name="seq" value="%s" />
            <input type="hidden" name="page" value="%s" />',
            $GLOBALS['num'],
            "".SPG_URI."/_lib/action.php",
            $GLOBALS['m'],
            $GLOBALS['num'],
            $GLOBALS['n'],
            $GLOBALS['where'],
            $GLOBALS['child'],
            $GLOBALS['seq'],
            $GLOBALS['page']);
        
        echo $form;
    }

    function printReplyView($childNo)
    {
        if($GLOBALS['m'] != "replycomment")
        {
            $data = new Data();
            $skin = new Skin();
            $mainView = new Mainview();

            $result = $data->getAllReplyComments($GLOBALS['num'], $childNo);

            while($comment = $result->fetchRow())
            {
                // secret comment
                if($comment['is_secret'] == 1 && $_SESSION['spg_user_name'] != $mainView->getOwnerByBlog($GLOBALS['n']))
                {
                    $comment['name'] = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' border='0'>";
                    $comment['memo'] = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' border='0'>";
                }
                else if($comment['is_secret'] == 1 && $_SESSION['spg_user_name'] == $mainView->getOwnerByBlog($GLOBALS['n']))
                {
                    $comment['name'] = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' border='0'>".$comment['name'];
                }

                if($_SESSION['spg_user_name'] == $mainView->getOwnerByBlog($GLOBALS['n']))
                {
                    $comment['memo'] .= "&nbsp;&nbsp;&nbsp;&nbsp;".$comment['ip'];
                }

                include SPG_SKIN_CACHE_DIR."/comment_reply.php";
            }
        }
    }

}   // End class
?>