<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name The Simplog                                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS <thesimplog@gmail.com>                                 |
// | Last Modified date: 05/Jan/2006 14:18                                |
// +----------------------------------------------------------------------+
//
// $Id mainview.inc$

class Mainview
{

    function Mainview()
    {

    }

    /**
     * printOneItemByPage
     * for permanent link, if user click next page button
     * this redirect to permanent url
    **/
    function printOneItemByPage($page)
    {
        require_once dirname(dirname(__FILE__))."/_lib/skin.inc";
        require_once dirname(dirname(__FILE__))."/_lib/data.inc";
        $data = new Data();
        $skin = new Skin();

        session_start();
        $level = $skin->checkLevel($_SESSION);
        $result = $data->getItems($page-1, 1, $level);
        $dataR = $result->fetchRow();
        
        goToPage(SPG_URI.'/'.$GLOBALS['n'].'/index.php/post/'.$dataR['no']);
    }

    /****
     *  general print from data
    *****/

    function getGroupVisible($visible)
    {
        if($visible == "1")
            return $GLOBALS['lang']['admin']['visible'];
        else 
            return $GLOBALS['lang']['admin']['invisible'];
    }
    function getMemberId($data)
    {
        return $data['member_no'];
    }
    function getMemberNickName($data)
    {
        return $data['nick_name'];
    }
    function getMemberBlog($data)
    {
        return $data['blog_url'];
    }
    function getVisitTime($data, $format = "Y/m/d H:i")
    {
        if(!$data)
            return false;
        return date($format, $data);
    }

    function getRelationship($data)
    {
        switch($data['relationship'])
        {
            case '0':
                return $GLOBALS['lang']['mainview']['none'];
                break;
            case '1':
                return $GLOBALS['lang']['mainview']['closer'];
                break;
            case '2':
                return $GLOBALS['lang']['mainview']['close'];
                break;
            case '3':
                return $GLOBALS['lang']['mainview']['nothing'];
                break;
            case '9':
                return $GLOBALS['lang']['mainview']['joining'];
                break;
        }
    }

    function getRelationshipFrom($data)
    {
        switch($data['relationship_from'])
        {            
            case '0':
                return $GLOBALS['lang']['mainview']['none'];
                break;
            case '1':
                return $GLOBALS['lang']['mainview']['closer'];
                break;
            case '2':
                return $GLOBALS['lang']['mainview']['close'];
                break;
            case '3':
                return $GLOBALS['lang']['mainview']['nothing'];
                break;
            case '9':
                return $GLOBALS['lang']['mainview']['joining'];
                break;
        }
    }

    function getNumVisit($data)
    {
        return $data['num_visit'];
    }

    /**
     * getTime($data)
     * to get time of the post
     * @param array $data
     */
    function getTime($data, $format = "Y/m/d")
    {
        return date($format, $data['publish_time']);
    }

    /**
     * getTimeStamp($data)
     * to get time of the post
     * @param array $data
     */
    function getTimeStamp($data)
    {
        return $data['publish_time'];
    }

    /**
     * getPostNo($data)
     * to get time of the post
     * @param array $data
     */
    function getPostNo($data)
    {
        return $data['no'];
    }

    function getOpenClose($data)
    {
        if($data['is_display'])
            return "open";
        else
            return "close";
    }

    /**
     * getSubject($data)
     * to Subject of the post
     * @param array $data
     */
    function getSubject($data)
    {
        $library = new Library();
        return $library->simHtmlentities($data['subject']);
    }

    /**
     * getSimplerStatus($data)
     * to get status of simplers
     * @param array $data
     */
    function getSimplerStatus($data)
    {
        if($data['is_use'] == 1)
        {
            $status = $GLOBALS['lang']['mainview']['use'];
        }
        else if($data['is_use'] == 0)
        {
            $status = $GLOBALS['lang']['mainview']['notuse'];

        }

        return $status;
    }

    /**

    /* getCateById($data)
     * to get category name by id
     * @param array $data
     */
    function getCateById($data)
    {
        require_once dirname(dirname(__FILE__))."/_lib/category.inc";

        $category = new Category();
        $cateName = $category->getCateById($data['category_id']);

        if($cateName['open'] == 0)
            $open = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' border='0' alt='secret' />";
        else
            $open = "";

        $library = new Library();
        $cateName['category_name'] = $library->simHtmlentities($cateName['category_name']);

        return '<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/list/category/'.$data['category_id'].'" class="CATELINK">'.$cateName['category_name'].'</a>'.$open;
    }

    /* getCateByIdOutLink($data)
     * to get category name by id without link
     * @param array $data
     */
    function getCateByIdOutLink($data)
    {
        require_once dirname(dirname(__FILE__))."/_lib/category.inc";

        $category = new Category();

        if($_GET['n'])
            $cateName = $category->getCateByIdByBlog($data['category_id'], $_GET['n']);
        else
            $cateName = $category->getCateByIdByBlog($data['category_id'], $GLOBALS['n']);

        if($cateName['open'] == 0)
            $open = "<img src='".SPG_URI."/_skin/_default_/images/secret.gif' border='0' alt='secret' />";
        else
            $open = "";

        $library = new Library();
        $cateName['category_name'] = $library->simHtmlentities($cateName['category_name']);

        return $cateName['category_name'].$open;
    }

    /*
     * stringPostLevel()
     * @param int level
     * @return String 
     */
    function stringPostLevel($level)
    {
        switch($level)
        {
            case '0':
                return $GLOBALS['lang']['mainview']['notopen'];
                break;
            case '1':
                return $GLOBALS['lang']['mainview']['1open'];
                break;
            case '2':
                return $GLOBALS['lang']['mainview']['2open'];
                break;
            case '3':
                return $GLOBALS['lang']['mainview']['open'];
                break;
        }
    }

    function printNumComment($post)
    {
        $data = new Data();

        $num = $data->getNumCommentByPost($post);

        echo $num;
    }

    function printNumTB($post)
    {
        $data = new Data();

        $num = $data->getNumTBByPost($post);

        echo $num;
    }

    function getStartNumOfPage($page, $num)
    {
        if(!isset($page) || $page == 0 || $page == 1)
        {
            $start = 0;
            $page = 1;
        }
        
        $start = ($page - 1) * $num;

        return $start;
    }

    /**
     * printPageNum
     * showing page numbering 
    **/
    function printPageNum($totalArticle, $numPPage, $queryArray, $pageNum, $thisPage)
    {
        $data = new Data();
        $library = new Library();
        $_getPage = $thisPage;
        $pageNum;

        //non page number or page number is 1
        if(!isset($_getPage) || $_getPage == 1 || !$_getPage)
        {
            $startNum = 0;
            $_getPage = 1;
        }
        else
        {
            $startNum = $numPPage * ($_getPage - 1);
        }

        $totalPage = ceil($totalArticle / $numPPage);

        //get number showing paging
        if($totalPage > $pageNum)
        {
            if($pageNum == 1)
            {
                $startNum = $_getPage;
                $endNum = $startNum;
            }
            else
            {
                if(is_int($pageNum / 2))
                {
                    $pageGap = $pageNum / 2;
                }
                else
                {
                    $pageGap = floor($pageNum / 2);
                }

                $startNum = $_getPage - $pageGap;

                if($startNum < 1)
                {
                    $startNum = 1;
                }
                
                if(($showingNum = $totalPage - $startNum + 1) < $pageNum)
                {
                    $endGap = $pageNum - $showingNum;
                    $startNum = $startNum - $endGap;
                }

                $endNum = $startNum + $pageNum - 1;

                if($endNum > $totalPage)
                {
                    $endNum = $totalPage;
                }
            }
        }
        else
        {
            $startNum = 1;
            $endNum = $totalPage;
        }

        if(isset($thisPage))
        {
            $page = $thisPage;
        }
        else
        {
            $page = 1;
        }

        // print page numbers
        for($i = $startNum; $i <= $endNum; $i++)
        {
            if($page == $i)
            {
                echo "<span class='NOWPAGE'>[$i]</span>";
            }
            else
            {
                $queryArray['p'] = $i;
                $queryString = $library->queryToStr($queryArray);
                echo " <a href=\"".$queryString."\" class='PAGENUM'>$i</a> ";
            }
        }

    }

    function printPermLink($no)
    {
        echo SPG_URI."/".$GLOBALS['n']."/index.php/post/".$no;
    }

    function strCut($str, $len)
    {
        $s = $this->_utf8Substr($str, 0, $len);
        $noen = 0;
        $en = 0;
        for ($i=0; $i < strlen($s); $i++)
        {
            if (ord($s[$i]) > 127)
                $noen++;
            else
                $en++;

            if(( ( ($noen/3) * 2 ) + $en ) >= $len) break;
        }

        $len2 = (($noen/3))+$en;
        $s = $this->_utf8Substr($s, 0, $len2);
        if ( $len < strlen($str) ) $s.="";
        return $s;
    }

    function strCut4($str, $len)
    {
        $s = substr($str, 0, $len);
        $cnt = 0;
        for ($i=0; $i<strlen($s); $i++)
        {
            if (ord($s[$i]) > 127)  $cnt++;
        }
        $s = substr($s, 0, $len - ($cnt % 3));

        return $s;
    }

    function strCut3($str, $len)
    {
        preg_match('/([\x00-\x7e]|..)*/', substr($str, 0, $len), $rtn);

        if ( $len < strlen($str) ) $rtn[0].="...";

        return $rtn[0];
    } 

    function strCut2($string, $long)
    {
        $string = $this->_utf8Substr($string, 0, $long);
        return $string;
    }

    /** 
     * from http://php.planetmirror.com/manual/en/function.substr.php
     * _utf8Substr
     * @access private
    **/
    function _utf8Substr($str, $start) 
    { 
       preg_match_all("/./su", $str, $ar); 

       if(func_num_args() >= 3) 
       { 
           $end = func_get_arg(2); 
           return join("", array_slice($ar[0], $start, $end)); 
       } 
       else 
       { 
           return join("", array_slice($ar[0], $start)); 
       } 
    }


    /**
     * printCal
     * print calendar 
    **/
    function printCal($calName)
    {
        global $mode, $arr;

        require_once dirname(dirname(__FILE__))."/_lib/skin.inc";
        require_once dirname(dirname(__FILE__))."/_lib/data.inc";
        $data = new Data();
        $skin = new Skin();

        $dayName = array("sun", "mon", "tue", "wed", "thu", "fri", "sat");

        if($mode == "date")
        {
            $year = $arr[2];
            $month = $arr['3'];
        }

        if(!$year)  $year = date("Y");
        if(!$month) $month = date("n");

        if(!checkdate($month, 1, $year))
        {
            $year = date("Y");
            $month = date("n");
        }

        // defined yesr
        define("YEAR", $year);
        require_once dirname(dirname(__FILE__))."/_skin/_calendar_/".$calName."/cal.inc";

        $today = mktime(0, 0, 0, date("m"), date("j"), date("Y"));

        $preMonth = $month;

        //first day of a month
        $firstDay = mktime(0, 0, 0, $month, 1, $year);

        //last day of a month
        $lastDay = mktime(0, 0, 0, $month+1, 0, $year);

        //last day of last month
        $lastDayPre = mktime(0, 0, 0, $month, 0, $year);

        // eg: sunday => 0
        $firstDayNum = date("w", $firstDay);
        $lastDayNum = date("w", $lastDay);
        $lastDateNum = date("j", $lastDay);
        $lastDateNumPre = date("j", $lastDayPre);

        if(START_FROM_SUNDAY == "NO")
        {
            $firstDayNum--;    
            array_push($dayName, array_shift($dayName));
        }
        else
        {
            $lastDayNum++;    
        }

        $monthArray = array();
        $index = array();

        // first week of a month
        if(OUTER_MONTH == "NO")
        {
            for($i = 0; $i < $firstDayNum; $i++)
            {
                $monthArray[$i] = "&nbsp;";        
            }
        }
        else if (OUTER_MONTH == "YES")
        {
            $weekStartNumPre = $lastDateNumPre - $firstDayNum + 1;
            for($i = $weekStartNumPre; $i <= $lastDateNumPre; $i++)
            {
                array_push($monthArray, $i);
                array_push($index, "outer");
            }
        }

        // day
        for($i = 1; $i <= $lastDateNum; $i++)
        {
            array_push($monthArray, $i);
            array_push($index, "this");
        }

        // end week
        $num = 1;
        for($i = $lastDayNum; $i <= 6; $i++)
        {
            if(OUTER_MONTH == "NO")
            {
                array_push($monthArray, "&nbsp;");
            }
            else if(OUTER_MONTH == "YES")
            {
                array_push($monthArray, $num);
                array_push($index, "outer");
                $num++;
            }

        }
        if($month == "12")
        {
            $nmonth = "1";
            $nyear = $year+1;
        }
        else
        {
            $nmonth = $month+1;
            $nyear = $year;
        }

        if($month == "1")
        {
            $pmonth = "12";
            $pyear = $year-1;
        }
        else
        {
            $pmonth = $month-1;
            $pyear = $year;
        }

        $aNextMonth = SPG_URI.'/'.$GLOBALS['n'].'/index.php/date/'.$nyear."/".$nmonth;
        $aPrevMonth = SPG_URI.'/'.$GLOBALS['n'].'/index.php/date/'.$pyear."/".$pmonth;
        
?>

        <table border="0" class="title_table" align="center">
          <tr>
            <td><a href="<?php echo $aPrevMonth;?>" class="title_pre"><?php echo CAL_PRE;?></a></td>
            <td class="title_month"><?php echo $this->printMonth($month);?></td>
            <td><a href="<?php echo $aNextMonth;?>" class="title_next"><?php echo CAL_NEX;?></a></td>
          </tr>
        </table>
        <table border="0" class="cal_table" width="100%">
          <tr class="week_title">
        <?php
        if(START_FROM_SUNDAY == "YES")
        {
        ?>
            <td class="sel_sun"><?php echo CAL_SUN;?></td>
            <td class="sel_mon"><?php echo CAL_MON;?></td>
            <td class="sel_tue"><?php echo CAL_TUE;?></td>
            <td class="sel_wed"><?php echo CAL_WED;?></td>
            <td class="sel_thu"><?php echo CAL_THU;?></td>
            <td class="sel_fri"><?php echo CAL_FRI;?></td>
            <td class="sel_sat"><?php echo CAL_SAT;?></td>
        <?php
        }
        else
        {
        ?>    
            <td class="sel_mon"><?php echo CAL_MON;?></td>
            <td class="sel_tue"><?php echo CAL_TUE;?></td>
            <td class="sel_wed"><?php echo CAL_WED;?></td>
            <td class="sel_thu"><?php echo CAL_THU;?></td>
            <td class="sel_fri"><?php echo CAL_FRI;?></td>
            <td class="sel_sat"><?php echo CAL_SAT;?></td>
            <td class="sel_sun"><?php echo CAL_SUN;?></td>
        <?php
        }
        ?>
          </tr>
        <?php
        reset($monthArray);
        $day = 0;

        for($i = 0; $i < count($monthArray); $i++)
        {
        ?>

        <?php
            if($day == 0)
            {
        ?>
          <tr>
        <?php
            }

            if(OUTER_MONTH == "YES")
            {        
                if($index[$i] == "outer")
                {
                    $styleName = "outer";
                }
                else
                {
                    $styleName = "day_".$dayName[$day];
                }
            }
            else
            {
                $styleName = "day_".$dayName[$day];
            }

            if($today == mktime(0, 0, 0, $month, $monthArray[$i], $year) && $index[$i] == "this")
            {
                $styleName = "today";
            }

            $level = $skin->checkLevel($_SESSION);
            
            $itemData = $data->getItemsByDate($year, $month, $monthArray[$i], "d1", "0", "0", $level);
            $numItemOnDay = $itemData->numRows();

            if($numItemOnDay > 0 && $index[$i] != "outer")
            {
                $hasItem = "<a href='".SPG_URI."/".$GLOBALS['n']."/index.php/date/".$year."/".$month."/".$monthArray[$i]."' title='$numItemOnDay' class='hasitem'>";
                $hasItemEnd = "</a>";
            }
            else
            {
                $hasItem = "";
                $hasItemEnd = "";
            }
        ?>
            <td class="sel_<?php echo $styleName;?>"><?php echo $hasItem;?><?php echo $monthArray[$i];?><?php echo $hasItemEnd;?></td>
        <?php
            $day++;
            if($day == 7)
            {
        ?>
          </tr>
        <?php
            $day = 0;
            }
        ?>
        <?php
        }
        ?>
        </table>
<?php
    } // end printCal

    function printMonth($month)
    {
        switch ($month)
        {
            case '1':
                echo CAL_JAN;
                break;
            case '2':
                echo CAL_FEB;
                break;
            case '3':
                echo CAL_MAR;
                break;
            case '4':
                echo CAL_APR;
                break;
            case '5':
                echo CAL_MAY;
                break;
            case '6':
                echo CAL_JUN;
                break;
            case '7':
                echo CAL_JUL;
                break;
            case '8':
                echo CAL_AUG;
                break;
            case '9':
                echo CAL_SEP;
                break;
            case '10':
                echo CAL_OCT;
                break;
            case '11':
                echo CAL_NOV;
                break;
            case '12':
                echo CAL_DEC;
                break;
        }

    }   // end printMonth

    function printFileSize($size)
    {
        $size = $size / 1024;
        $size = number_format($size, 1);

        return $size." KB";
    }

    function getFileSize($size)
    {
        $size = $size / 1024;
        if($size < 1000)
        {
            $size = number_format($size, 1);
            return $size." KB";
        }
        else
        {
            $size = $size / 1024;
            $size = number_format($size, 1);
            return $size." MB";
        }

        
    }

    function printFileName($fData)
    {
        return '<a href="'.SPG_URI.'/_data/'.$GLOBALS['n'].'/data/'.$fData['dir'].'/'.$fData['file_name'].'">'.$fData['original_file_name'].'</a>';
    }

    function getZero($data)
    {
        if(!$data)
            $data = 0;

        return $data;
    }

    function getBlogUri($name)
    {
        return (SPG_URI)."/".$name;
    }

    function getNumCoworker($num)
    {
        if(!$num)
            $num = 0;
        return $num;
    }

    function getBlogPostDate($date)
    {
        if($date)
            return date("Y/m/d H:i", $date);
        else
            return false;
    }

    function getOwnerByBlog($blog)
    {
        $data = new Data();
        $blogInfo = $data->getAdminData($blog);

        if($blogInfo['owner'])
            return $blogInfo['owner'];
        else
            return $blog;
    }

    function spgml2html($str, $postNo = 0)
    {
        $patternMulti = '/\<img[^>]*alt=(\'|")?multi(\'|")?[^>]*\>/i';
        $patternMoreLess = '/\<div[^>]*id=(\'|")?spgMoreLess(\'|")?[^>]*\>/i';
        $numMoreLess = 0;

        do
        {
            // get multimedia
            if(preg_match($patternMulti, $str, $match))
            {
                $multi = $match[0];

                // get src
                $pattern = '/<img[^>]*((id)=(\'|")?([^"\' ]*)(\'|")?)[^>]*/i';
                preg_match($pattern, $multi, $match);
                $src = $match[4];

                // get width
                $pattern = '/<img[^>]*width[:= ]+[\'" ]?([ 0-9]*)[^>]*/i';
                preg_match($pattern, $multi, $match);
                $width = $match[1];

                // get height
                $pattern = '/<img[^>]*height[:= ]+[\'" ]?([ 0-9]*)[^>]*/i';
                preg_match($pattern, $multi, $match);
                $height = $match[1];

                // get extension
                $ext = strrchr($src, ".");

                switch($ext)
                {
                    case '.mp3':
                        $changedStr = '<script type="text/javascript"> var obj = \'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0" width="200" height="20"> <param name="movie" value="'.(SPG_URI).'/_lib/player/dewplayer.swf?mp3='.($src).'" /><embed src="'.(SPG_URI).'/_lib/player/dewplayer.swf?mp3='.($src).'" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="200" height="20"></embed></object>\'; writeObj(obj);</script>';
                        break;
                    case '.mov':
                    case '.m4v':                    
                        $changedStr = '<script type="text/javascript"> var obj = \'<object classid="clsid:02bf25d5-8c17-4b23-bc80-d3488abddc6b" width="'.$width.'" height="'.$height.'" codebase="http://www.apple.com/qtactivex/qtplugin.cab"><param name="src" value="'.$src.'" /><param name="autoplay" value="false" /><param name="controller" value="true" /><embed src="'.$src.'" autoplay="false" controller="true" width="'.$width.'" height="'.$height.'"></embed></object>\'; writeObj(obj);</script>';
                        break;
                    case '.swf':
                        $changedStr = '<script type="text/javascript"> var obj = \'<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0" width="'.$width.'" height="'.$height.'" id="index" align="middle"><param name="movie" value="'.$src.'" /><param name="quality" value="high" /><embed src="'.$src.'" quality="high" bgcolor="#ffffff" width="'.$width.'" height="'.$height.'" name="index" align="middle" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" /></object>\'; writeObj(obj);</script>';
                        break;
                    case '.mp4':
                    case '.m4a':
                        $changedStr = '<script type="text/javascript"> var obj = \'<object classid="clsid:02bf25d5-8c17-4b23-bc80-d3488abddc6b" width="200" height="20" codebase="http://www.apple.com/qtactivex/qtplugin.cab"><param name="src" value="'.$src.'" /><param name="autoplay" value="false" /><param name="controller" value="true" /><embed src="'.$src.'" autoplay="false" controller="true" width="200" height="20"></embed></object>\'; writeObj(obj);</script>';
                        break;
                    case '.wma':
                        $changedStr = '<script type="text/javascript"> if(WMP7) var obj = \'<object classid="clsid:6BF52A52-394A-11D3-B153-00C04F79FAA6"  standby="Loading Microsoft Windows Media Player components..." type="application/x-oleobject" border="0" width="200" height="42" ><param name="url" value="'.$src.'" /><param name="AutoStart" value="0" /><param name="ShowControls" value="1" /><param name="ShowStatusBar" value="0" /></object>\'; else var obj = \'<object classid="clsid:22D6F312-B0F6-11D0-94AB-0080C74C7E95" codebase="http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=6,4,5,715" standby="Loading Microsoft Windows Media Player components..." type="application/x-oleobject" border="0" width="200" height="42" ><param name="FileName" value="'.$src.'" /><param name="AutoStart" value="0" /><param name="ShowControls" value="1" /><param name="ShowStatusBar" value="0" /><embed filename="'.$src.'" src="'.$src.'" type="application/x-mplayer2" pluginspage="http://www.microsoft.com/Windows/MediaPlayer/" AutoStart="0" ShowStatusBar="0" ShowControls="1" ShowDisplay="0" width="200" height="42"></embed></object>\'; writeObj(obj);</script>';
                        break;
                    case '.asf':
                    case '.wmv':
                    case '.avi':
                        $changedStr = '<script type="text/javascript"> if(WMP7) var obj = \'<object classid="clsid:6BF52A52-394A-11D3-B153-00C04F79FAA6"  standby="Loading Microsoft Windows Media Player components..." type="application/x-oleobject" border="0" width="'.$width.'" height="'.$height.'" ><param name="url" value="'.$src.'" /><param name="AutoStart" value="0" /><param name="ShowControls" value="1" /><param name="ShowStatusBar" value="0" /></object>\'; else var obj = \'<object classid="clsid:22D6F312-B0F6-11D0-94AB-0080C74C7E95" codebase="http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=6,4,5,715" standby="Loading Microsoft Windows Media Player components..." type="application/x-oleobject" border="0" width="'.$width.'" height="'.$height.'" ><param name="FileName" value="'.$src.'" /><param name="AutoStart" value="0" /><param name="ShowControls" value="1" /><param name="ShowStatusBar" value="0" /><embed filename="'.$src.'" src="'.$src.'" type="application/x-mplayer2" pluginspage="http://www.microsoft.com/Windows/MediaPlayer/" AutoStart="0" ShowStatusBar="0" ShowControls="1" ShowDisplay="0" width="'.$width.'" height="'.$height.'"></embed></object>\'; writeObj(obj);</script>';
                        break;
                }

                // exchange
                $str = preg_replace($patternMulti, $changedStr, $str, 1);
            }
            else if(preg_match($patternMoreLess, $str))
            {
                $numMoreLess++;

                // get more text
                $pattern = '/<div[^>]*((more)=(\'|")?([^"\' ]*)(\'|")?)[^>]*/i';
                preg_match($pattern, $str, $match);
                $more = $match[4];

                // get less text
                $pattern = '/<div[^>]*((less)=(\'|")?([^"\' ]*)(\'|")?)[^>]*/i';
                preg_match($pattern, $str, $match);
                $less = $match[4];

                $id = "moreless_".$postNo."_".$numMoreLess;
                $contentId = $id."_contents";

                $title = '<div style="cursor:pointer" id="'.$id.'" onclick="toggle(\''.$id.'\',\''.$contentId.'\', \''.$less.'\', \''.$more.'\');" class="MORELESS">'.$more.'</div>';
                $content = '<div id="'.$contentId.'" style="display:none;">';

                // exchange
                $str = preg_replace($patternMoreLess, $title.$content, $str, 1);

            }
            else    // if no, get out loop
                break;

        }while(1);

//        echo $str;
        return $str;
    }

    function getRidOfMulti($str)
    {
        $pattern = '/\<img[^>]*alt=(\'|")?multi(\'|")?[^>]*\>/i';
        return $str = preg_replace($pattern, "", $str);
    }

    function getMultiType($ext)
    {
        switch($ext)
        {
            case 'mp3':
                $type = "audio/mpeg";
                break;
            case 'mov':                        
            case 'm4v':
                $type = "video/quicktime";
                break;
            case 'mp4':
                $type = "audio/mpeg";
                break;
            case 'swf':
                $type = "flash/swf";
                break;
            case 'm4a':
                $type = "audio/mpeg4";
                break;
            case 'wma':
                $type = "audio/wma";
                break;
            case 'wmv':
                $type = "video/wmv";
                break;
            case 'asf':
                $type = "video/asf";
                break;
            case 'avi':
                $type = "video/avi";
                break;
        }

        return $type;
    }

    /**
     * get first media type
    **/
    function getMedia($str)
    {
        $type = "";

        // get multimedia
        $pattern = '/\<img[^>]*alt=(\'|")?multi(\'|")?[^>]*\>/i';
        if(preg_match($pattern, $str, $match))
        {
            $multi = $match[0];

            // get src
            $pattern = '/<img[^>]*((id)=(\'|")?([^"\' ]*)(\'|")?)[^>]*/i';
            preg_match($pattern, $multi, $match);
            $src = $match[4];
            
            // get extension
            $ext = substr(strrchr($src, "."), 1);
            $type = $this->getMultiType($ext);
        }

        return array("src" => $src, "type"=>$type);
    }

    function get_action($what)
    {
        switch($what)
        {
            case 'get_relationship':
                $member_url = $_GET['member_url'];
                $this->get_relation($member_url);
                break;
            case 'be_relation':
                $with = $_GET['with'];
                $library = new Library();
                $result = $library->getHost("thesimplog.com", "/login/action.php?todo=get_member&who=".($with));

                $parseData = $library->parseHost($result);
                $xmlStruct = $library->get_dataonly($parseData);

                if(trim($xmlStruct['WHAT']) == "member_info")
                {
                    $data = new Data();                    
                    $data->insert_my_neighbour(trim($xmlStruct['MEMBER_NO']), trim($xmlStruct['NICK']), 9, trim($xmlStruct['ID']), $GLOBALS['n']);
                }
                break;
        }
    }

    function get_relation($member_url)
    {
        $data = new Data();
        $relation = $data->get_relationship($member_url, $GLOBALS['n']);

        header ('Content-Type: text/xml');

        $rss = "";
        $rss .= '<?xml version="1.0" encoding="UTF-8" ?>'."\r\n";
        $rss .= '<simplog version="0.7.0">'."\r\n";
		$rss .= '<what>get_relationship</what>'."\r\n";
        $rss .= '<value>'.$relation['relationship'].'</value>'."\r\n";
        $rss .= '<member_no>'.$relation['member_no'].'</member_no>'."\r\n";
        $rss .= '<nick>'.$relation['nick_name'].'</nick>'."\r\n";
        $rss .= '</simplog>';

        echo $rss;
    }

    function send_action($what, $value = "")
    {
        switch($what)
        {
            case 'get_relationship':
                $blog = $_GET['blog'];
                $library = new Library();
                $myURL = rawurlencode((SPG_URI."/".$GLOBALS['n']));
                $blog_url = parse_url($blog);
                $result = $library->getHost($blog_url['host'], $blog_url['path']."/index.php?mode=get_action&what=get_relationship&member_url=".$myURL);

                $parseData = $library->parseHost($result);
                $xmlStruct = $library->get_dataonly($parseData);

                if(trim($xmlStruct['WHAT']) == "get_relationship")
                {
                    $data = new Data();
                    if($data->is_member_exists($blog, $GLOBALS['n']))
                    {
                        $this->change_relationship_from($blog, trim($xmlStruct['VALUE']));
                    }
                    else
                    {
                        $data->insert_my_neighbour(trim($xmlStruct['MEMBER_NO']), trim($xmlStruct['NICK']), trim($xmlStruct['VALUE']), $blog, $GLOBALS['n']);
                    }
                }
                break;

            case 'be_relation':
                $blog = $value;
                $library = new Library();
                $myURL = urlencode((SPG_URI."/".$GLOBALS['n']));
                $blog_url = parse_url($blog);
                $result = $library->getHost($blog_url['host'], $blog_url['path']."/index.php?mode=get_action&what=be_relation&with=".$myURL);

                break;
        }
    }

    function change_relationship_from($url, $toWhat)
    {
        $data = new Data();
            $data->change_relationship_from($url, $toWhat, $GLOBALS['n']);    
    }

    function _makeSeed()
	{
	   list($usec, $sec) = explode(' ', microtime());
	   return (float) $sec + ((float) $usec * 100000);
	}

	function suffleArray($arr)
	{
		srand($this->_makeSeed());
		shuffle($arr);

		return $arr;
	}

    function getTagCloud()
    {
        $data = new Data();
        $result = $data->getTagsWithNum($GLOBALS['n']);

        $sum = $min = $max = 0;

        $tags = array();

        $i = 0;
        while($row = $result->fetchRow())
        {
            $sum += $row['cnt'];
            if($i == 0)
                $min = $max = $row['cnt'];
            if($min > $row['cnt'])
                $min = $row['cnt'];
            if($max < $row['cnt'])
                $max = $row['cnt'];

            $tags[$i]['tag'] = $row['keywords'];
            $tags[$i]['cnt'] = $row['cnt'];
            $i++;
        }

        $number = $result->numRows();
        if($number)
            $average = $sum / $number;
        else $average = 0;

        return array("freq" => array($min, $max, $sum),"average" => $average,"tags" => $tags);
    }

    function getStyleForShortTag($cnt, $min, $max, $step = 5)
	{
        $average = ($min + $max) / 2;
		$diff = $average / ($step / 2);

		if($cnt <= $diff)
			$style = "TAG1";
		else if($cnt < ($diff * 2))
			$style = "TAG2";
		else if($cnt < ($diff * 3))
			$style = "TAG3";
		else if($cnt < ($diff * 4))
			$style = "TAG4";
		else
			$style = "TAG5";

		return $style;
	}

    function getStyleForAllTag($cnt, $min, $max, $step = 5)
	{
        $average = ($min + $max) / 2;
		$diff = $average / ($step / 2);

		if($cnt <= $diff)
			$style = "ALLTAG1";
		else if($cnt < ($diff * 2))
			$style = "ALLTAG2";
		else if($cnt < ($diff * 3))
			$style = "ALLTAG3";
		else if($cnt < ($diff * 4))
			$style = "ALLTAG4";
		else
			$style = "ALLTAG5";

		return $style;
	}

} // end class
?>