<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// | 2006/1/25 New Simplog DB Schema                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS <thesimplog@gmail.com>                                 |
// | Last Modified date: 25/01/2006 15:07                                 |
// +----------------------------------------------------------------------+
//
// $Id simplerschema.inc$

$adminSchemaDrop = "DROP TABLE IF EXISTS `".SPG_PREFIX."_admin`";
$adminSchemaCreate = "
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_admin` (
  `user_name` varchar(20) NOT NULL default '',
  `nick_name` varchar(100) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `password` varchar(45) NOT NULL default '',
  `owner` varchar(20) NOT NULL default '',
  `level` char(1) NOT NULL default '2',
  `reg_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `num_page` tinyint(3) unsigned NOT NULL default '10',
  `post_p_page` tinyint(3) unsigned NOT NULL default '2',
  `blog_name` varchar(150) NOT NULL default '',
  `blog_desc` varchar(255) NOT NULL default '',
  `skin` varchar(50) NOT NULL default 'simplog',
  `language` varchar(10) NOT NULL default 'korean',
  `is_use` char(1) NOT NULL default '1',
  `use_category` char(1) NOT NULL default '1',
  `use_newpost_list` tinyint(3) unsigned NOT NULL default '5',
  `newpost_cut` tinyint(3) unsigned NOT NULL default '20',
  `use_newcomment_list` tinyint(3) unsigned NOT NULL default '5',
  `newcomment_cut` tinyint(3) unsigned NOT NULL default '20',
  `use_newtb_list` tinyint(3) unsigned NOT NULL default '5',
  `newtb_cut` tinyint(3) unsigned NOT NULL default '20',
  `use_calendar` char(1) NOT NULL default '1',
  `cal_name` varchar(100) NOT NULL default 'cal_simplog',
  `use_archive_list` tinyint(3) unsigned NOT NULL default '5',
  `use_favorite_list` tinyint(3) unsigned NOT NULL default '5',
  `use_link_list` tinyint(3) unsigned NOT NULL default '5',
  `use_search` char(1) NOT NULL default '1',
  `use_nowiam` char(1) NOT NULL default '1',
  `nowiamcate` tinyint(3) unsigned NOT NULL default '0',
  `ip_filter` text NOT NULL,
  `words_filter` text NOT NULL,
  `rtbcharset` varchar(20) NOT NULL default 'euc-kr',
  `xml_num` tinyint(3) unsigned NOT NULL default '10',
  `xml_type_full` char(1) NOT NULL default 'f',
  `banner1` varchar(255) NOT NULL default '',
  `banner2` varchar(255) NOT NULL default '',
  `open_portal` char(1) NOT NULL default '1',
  PRIMARY KEY  (`user_name`)
) TYPE=MyISAM
";

$simplerSchemaDrop = array (
"DROP TABLE IF EXISTS `".SPG_PREFIX."_category`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_comments`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_files`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_keywords`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_links`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_links_group`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_members`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_post_keywords`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_posts`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_trackback_sent`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_trackbacks`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_count`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_count_data`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_count_log`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_count_stat`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_data`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_comm_notify`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_comm_notify_blogs`",
"DROP TABLE IF EXISTS `".SPG_PREFIX."_comm_notify_queue`");

$simplerSchemaCreate = array(
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_category` (
  `category_id` mediumint(8) unsigned NOT NULL default '0',
  `category_name` varchar(255) NOT NULL default '',
  `parent_id` mediumint(9) NOT NULL default '0',
  `depth` char(1) NOT NULL default '1',
  `open` char(1) NOT NULL default '0',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`category_id`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_comments` (
  `no` int(10) unsigned NOT NULL default '0',
  `parent_no` int(10) unsigned NOT NULL default '0',
  `child_no` int(10) unsigned NOT NULL default '0',
  `seq` int(10) unsigned NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `password` varchar(45) NOT NULL default '',
  `homepage` varchar(255) NOT NULL default '',
  `memo` text NOT NULL,
  `date` int(11) default NULL,
  `is_secret` char(1) NOT NULL default '1',
  `ip` varchar(15) NOT NULL default '',
  `user_name` varchar(100) NOT NULL default '',
  `member_id` VARCHAR(255) NOT NULL default '',
  PRIMARY KEY  (`no`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_files` (
  `no` int(10) unsigned NOT NULL default '0',
  `post_no` int(10) unsigned NOT NULL default '0',
  `file_name` varchar(255) NOT NULL default '',
  `original_file_name` varchar(255) default NULL,
  `file_size` int(7) unsigned NOT NULL default '0',
  `file_type` varchar(20) NOT NULL default 'data',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `author` varchar(100) NOT NULL default '',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`no`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_keywords` (
  `keywords` varchar(100) NOT NULL default '',
  `key_desc` text NOT NULL,
  `open` char(1) NOT NULL default '1',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`keywords`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_links` (
  `link_no` int(10) unsigned NOT NULL default '0',
  `link_url` varchar(255) NOT NULL default '',
  `group_no` smallint(5) unsigned NOT NULL default '0',
  `link_name` varchar(255) NOT NULL default '',
  `link_desc` varchar(255) NOT NULL default '',
  `link_rss` varchar(255) NOT NULL default '',
  `link_order` smallint(6) unsigned NOT NULL default '0',
  `visible` char(1) NOT NULL default '1',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`link_no`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_links_group` (
  `group_no` int(10) unsigned NOT NULL default '0',
  `group_name` varchar(255) NOT NULL default '',
  `group_order` smallint(5) unsigned NOT NULL default '0',
  `visible` char(1) NOT NULL default '1',
  `num_links` smallint(5) unsigned NOT NULL default '0',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`group_no`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_members` (
  `member_no` int(10) unsigned NOT NULL default '0',
  `nick_name` varchar(100) NOT NULL default '',
  `relationship` char(1) NOT NULL default '0',
  `relationship_from` char(1) NOT NULL default '0',
  `blog_url` varchar(255) NOT NULL default '',
  `last_visit` int(10) unsigned NOT NULL default '0',
  `first_date` int(10) NOT NULL default '0',
  `num_visit` int(10) unsigned NOT NULL default '0',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`member_no`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_post_keywords` (
  `post_no` int(10) unsigned NOT NULL default '0',
  `keywords` varchar(100) NOT NULL default '',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`post_no`,`keywords`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_posts` (
  `no` int(10) unsigned NOT NULL default '0',
  `category_id` mediumint(8) unsigned NOT NULL default '0',
  `author` varchar(20) NOT NULL default '',
  `subject` varchar(255) NOT NULL default '',
  `contents` text NOT NULL,
  `post_time` int(10) default NULL,
  `display_level` char(1) NOT NULL default '1',
  `is_sync` char(1) NOT NULL default '0',
  `dis_comment` char(1) NOT NULL default '0',
  `dis_tb` char(1) NOT NULL default '0',
  `modify_time` int(11) NOT NULL default '0',
  `publish_time` int(11) NOT NULL default '0',
  `click_view` int(11) NOT NULL default '0',
  `last_view_ip` varchar(255) NOT NULL default '',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`no`,`user_name`),
  KEY `user_name` (`user_name`),
  KEY `post_time` (`post_time`,`user_name`),
  KEY `publish_time` (`publish_time`,`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_trackback_sent` (
  `no` int(10) unsigned NOT NULL default '0',
  `post_no` int(10) unsigned NOT NULL default '0',
  `towhere` varchar(255) NOT NULL default '',
  `date` int(10) unsigned NOT NULL default '0',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`no`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_trackbacks` (
  `no` int(10) unsigned NOT NULL default '0',
  `post_no` int(10) unsigned NOT NULL default '0',
  `site_name` varchar(255) NOT NULL default '',
  `p_link` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `contents` text NOT NULL,
  `date` int(10) unsigned NOT NULL default '0',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`no`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_count` (
  `date` timestamp(14) NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `agent` varchar(255) NOT NULL default '',
  `user_name` varchar(100) NOT NULL default '',
  KEY `date` (`date`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_count_data` (
  `date` timestamp(14) NOT NULL,
  `request_uri_query` varchar(255) NOT NULL default '',
  `referer` varchar(255) NOT NULL default '',
  `ip` varchar(15) NOT NULL default '',
  `agent` varchar(255) NOT NULL default '',
  `user_name` varchar(100) NOT NULL default '',
  KEY `date` (`date`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_count_log` (
  `no` int(10) unsigned NOT NULL default '0',
  `what` varchar(255) NOT NULL default '',
  `type` char(1) NOT NULL default 'R',
  `count` int(10) unsigned NOT NULL default '1',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`no`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_count_stat` (
  `date` timestamp(8) NOT NULL,
  `total_count` int(10) unsigned NOT NULL default '0',
  `total_page_view` int(10) unsigned NOT NULL default '0',
  `count_by_time` varchar(255) NOT NULL default '',
  `page_view_by_time` varchar(255) NOT NULL default '',
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`date`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_data` (
  `name` varchar(200) NOT NULL default '',
  `value` text NOT NULL,
  `user_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`name`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_comm_notify` (
  `id` int(11) NOT NULL auto_increment,
  `post_id` int(11) NOT NULL default '0',
  `parent` int(11) NOT NULL default '0',
  `comm_no` int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `homepage` varchar(255) NOT NULL default '',
  `secret` char(1) NOT NULL default '0',
  `comment` text NOT NULL,
  `ip` varchar(20) NOT NULL default '',
  `regdate` int(11) NOT NULL default '0',
  `modified` int(11) NOT NULL default '0',
  `blog_id` int(11) NOT NULL default '0',
  `comm_url` varchar(255) NOT NULL default '',
  `item_url` varchar(255) NOT NULL default '',
  `item_title` varchar(255) NOT NULL default '',
  `user_name` varchar(200) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `user_name` (`user_name`),
  KEY `post_id` (`post_id`),
  KEY `blog_id` (`blog_id`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_comm_notify_blogs` (
  `blog_id` int(11) NOT NULL auto_increment,
  `blog_url` varchar(255) NOT NULL default '',
  `modified` int(11) NOT NULL default '0',
  `blog_name` varchar(255) NOT NULL default '',
  `blog_author` varchar(200) NOT NULL default '',
  PRIMARY KEY  (`blog_id`)
) TYPE=MyISAM
",
"
CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_comm_notify_queue` (
  `to_comment_id` int(11) NOT NULL default '0',
  `from_comment_id` int(11) NOT NULL default '0',
  `user_name` varchar(200) NOT NULL default '',
  PRIMARY KEY  (`to_comment_id`,`from_comment_id`,`user_name`),
  KEY `user_name` (`user_name`)
) TYPE=MyISAM
"
);
?>