<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2006 theSimplog.com                                    |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 25/Jan/2006 00:30                                |
// +----------------------------------------------------------------------+
//
// $Id linklib.inc$

require_once dirname(dirname(__FILE__))."/_lib/DB.php";
require_once dirname(dirname(__FILE__))."/_linked/link.inc";
require_once dirname(dirname(__FILE__))."/_lib/data.inc";
require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";

$simdbcon = connectSimplogDB();

function isThereBlog()
{
    global $simdbcon;

    $linked = new Linked();
    $linkedData = $linked->getLinkedSetting();
    
    // session start again
    @session_save_path($linkedData['SESLOC']);
    @session_start();

    if(isset($_SESSION[$linkedData['SESSION']]))
    {
        $boardUser = $linked->getBoardUser($_SESSION[$linkedData['SESSION']]);
        $boardid = $boardUser[$linkedData['ID']];

        $query = sprintf("SELECT * FROM ".SPG_PREFIX."_boardlink WHERE board_user_id = '%s'",
            $boardid);
        $result = $simdbcon->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        if($result['board_user_id'] == $boardid)
            return true;
        else return false;
    }
    else
    {
        return false;
    }
}

function getMyBlog($boardid)
{
    global $simdbcon;
    $query = sprintf("SELECT * FROM ".SPG_PREFIX."_boardlink WHERE board_user_id = '%s'",
            $boardid);
    $result = $simdbcon->getRow($query);
    if (DB::isError($result))
    {
        die ($result->getMessage().__FILE__.__LINE__);
    }

    return $result['simplog_user_id'];
}

function printRecentPosts($skinName, $title, $numPost = 10, $listfile = "simplog_list.php")
{
    global $simdbcon;
    $data = new Data();
    $mainview = new Mainview();
    $simUri = $GLOBALS['simplog_url'];

    // get skin file
    $file = dirname(__FILE__)."/skin/".$skinName."/index.html";

    if(substr($simUri, -1) != "/")
        $simUri = $simUri."/";

    if(file_exists($file))
    {
        $skin = file($file);
        $skin = str_replace("./", $simUri.'_linked/skin/'.$skinName.'/', join('', $skin));

        $skin = str_replace('[SIMPLOG::TITLE]', $title, $skin);
        $skin = preg_replace("/\[SIMPLOG::MORE\]/", $listfile."/post/", $skin);

        $query = "SELECT p.*, a.nick_name, b.blog_name, c.category_name FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_admin a, ".SPG_PREFIX."_admin b, ".SPG_PREFIX."_category c 
        WHERE p.display_level = 3 AND p.author = a.user_name AND b.is_use = 1 AND b.open_portal = 1 AND p.user_name = b.user_name AND c.user_name = p.user_name AND c.category_id = p.category_id ORDER BY post_time DESC LIMIT 0, $numPost";
        $result = $simdbcon->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        preg_match('|<SIMPLOG::LOOP>(.+)</SIMPLOG::LOOP>|s', $skin, $contents);

        $printContents = "";
        while($allData = $result->fetchRow())
        {
            if(empty($allData['blog_name'])) $allData['blog_name'] = "정보없음";
            if(empty($allData['blog_desc'])) $allData['blog_desc'] = "정보없음";

            $contents2 = $contents[1];
            // 변수 치환            
            preg_match("/\[SIMPLOG::BLOGNAME=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::BLOGNAME=\"([0-9]+)\"\]/", $mainview->strCut($allData['blog_name'], $cut[1]), $contents2);
            preg_match("/\[SIMPLOG::SUBJECT=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::SUBJECT=\"([0-9]+)\"\]/", '<a href="'.$simUri.$allData['user_name'].'/index.php/post/'.$allData['no'].'">'.$mainview->strCut($allData['subject'], $cut[1]).'</a>', $contents2);
            preg_match("/\[SIMPLOG::NAME=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::NAME=\"([0-9]+)\"\]/", $mainview->strCut($allData['nick_name'], $cut[1]), $contents2);
            preg_match("/\[SIMPLOG::CATEGORY=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::CATEGORY=\"([0-9]+)\"\]/", $mainview->strCut($allData['category_name'], $cut[1]), $contents2);

            preg_match("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", date($cut[1], $allData['post_time']), $contents2);

            $printContents .= $contents2;
        }
        $skin = preg_replace('|<SIMPLOG::LOOP>(.+)</SIMPLOG::LOOP>|s', $printContents, $skin);

        echo $skin;
    }
    else
    {
        echo "스킨 경로 설정이 잘못 되었습니다.";
    }
}

function printRecentBlogs($skinName, $title, $numBlog = 10, $listfile = "simplog_bloglist.php")
{
    global $simdbcon;
    $data = new Data();
    $mainview = new Mainview();
    $simUri = $GLOBALS['simplog_url'];

    // get skin file
    $file = dirname(__FILE__)."/skin/".$skinName."/index.html";

    if(substr($simUri, -1) != "/")
        $simUri = $simUri."/";

    if(file_exists($file))
    {
        $skin = file($file);
        $skin = str_replace("./", $simUri.'_linked/skin/'.$skinName.'/', join('', $skin));

        $skin = str_replace('[SIMPLOG::TITLE]', $title, $skin);
        $skin = preg_replace("/\[SIMPLOG::MORE\]/", $listfile."/blog/", $skin);

        $query = "SELECT * FROM ".SPG_PREFIX."_admin WHERE is_use = 1 AND open_portal = 1  ORDER BY reg_date DESC LIMIT 0, $numBlog";
        $adminResult = $simdbcon->query($query);
        if (DB::isError($adminResult))
        {
            die ($adminResult->getMessage().__FILE__.__LINE__);
        }

        preg_match('|<SIMPLOG::LOOP>(.+)</SIMPLOG::LOOP>|s', $skin, $contents);

        $printContents = "";
        while($allData = $adminResult->fetchRow())
        {
            if(empty($allData['blog_name'])) $allData['blog_name'] = "정보없음";
            if(empty($allData['blog_desc'])) $allData['blog_desc'] = "정보없음";

            $contents2 = $contents[1];
            // 변수 치환
            $contents2 = preg_replace("/\[SIMPLOG::BLOGURL\]/", $simUri.$allData['user_name'], $contents2);
            preg_match("/\[SIMPLOG::BLOGNAME=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::BLOGNAME=\"([0-9]+)\"\]/", '<a href="'.$simUri.$allData['user_name'].'">'.$mainview->strCut($allData['blog_name'], $cut[1]).'</a>', $contents2);
            preg_match("/\[SIMPLOG::BLOGDESC=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::BLOGDESC=\"([0-9]+)\"\]/", $mainview->strCut($allData['blog_desc'], $cut[1]), $contents2);
            preg_match("/\[SIMPLOG::NAME=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::NAME=\"([0-9]+)\"\]/", $mainview->strCut($allData['nick_name'], $cut[1]), $contents2);
            preg_match("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", date($cut[1], strtotime ($allData['reg_date'])), $contents2);
            // blog banner
            $adminData2 = getAdminData2($allData['user_name']);
            if($allData['banner1'] && $adminData2['admin_defaultbanner'] == "banner1")
            {
                $banner = $simUri.$allData['user_name'].'/'.$allData['banner1'];
            }
            else if($allData['banner2'] && $adminData2['admin_defaultbanner'] == "banner2")
            {
                $banner = $simUri.$allData['user_name'].'/'.$allData['banner2'];
            }
            else
            {
                $banner = $simUri.'_linked/skin/'.$skinName."/images/noimage.gif";
            }
            $contents2 = preg_replace("/\[SIMPLOG::BANNER\]/", $banner, $contents2);

            $printContents .= $contents2;
        }
        $skin = preg_replace('|<SIMPLOG::LOOP>(.+)</SIMPLOG::LOOP>|s', $printContents, $skin);

        echo $skin;
    }
    else
    {
        echo "스킨 경로 설정이 잘못 되었습니다.";
    }

    //$simdbcon->disconnect();
}


function getRandomTags($numTag = 20, $listfile = "simplog_list.php", $encoding = "utf-8")
{
    global $simdbcon;
    $data = new Data();
    $mainview = new Mainview();
    $simUri = $GLOBALS['simplog_url'];

    if(substr($simUri, -1) != "/")
        $simUri = $simUri."/";

    $query = "SELECT keywords, count(*) cnt FROM ".SPG_PREFIX."_post_keywords GROUP BY keywords";
    $result = $simdbcon->query($query);
    if (DB::isError($result))
    {
        die ($result->getMessage().__FILE__.__LINE__);
    }

    $sum = $min = $max = 0;

    $tags = array();

    $i = 0;
    while($row = $result->fetchRow())
    {
        $sum += $row['cnt'];
        if($i == 0)
            $min = $max = $row['cnt'];
        if($min > $row['cnt'])
            $min = $row['cnt'];
        if($max < $row['cnt'])
            $max = $row['cnt'];

        $tags[$i]['tag'] = $row['keywords'];
        $tags[$i]['cnt'] = $row['cnt'];
        $i++;
    }

    $number = $result->numRows();
    if($number)
        $average = $sum / $number;
    else $average = 0;

    $tags = $mainview->suffleArray($tags);

    $num = count($tags);
    if($numTag < $num)
    {
        $num = $numTag;
    }        
     
    for($i = 0; $i < $num; $i++)
    {
        $style = $mainview->getStyleForShortTag($tags[$i]['cnt'], $min, $max);
        $print_tag .= '<a href="'.$listfile.'/tag/'.rawurlencode($tags[$i]['tag']).'"  class="'.$style.'">'.$tags[$i]['tag']."</a> ";			
    }
    
    if(strtolower($encoding) == "euc-kr")
        $print_tag = euckr2utf8($print_tag);

    return $print_tag;   
}

function printList($skinName, $title, $num, $encoding = "utf-8")
{   
    $arr = explode("/", $_SERVER[PATH_INFO]);
    $what = $arr[1];

    if(strtolower($encoding) == "euc-kr")
    {
        foreach($title as $key => $value)
        {
            $title[$key] = utf82euckr($value);
        }
        ob_start();
    }

    // check type
    if(empty($title[$what])) 
    {
        echo <<<HEREDOC
<script type="text/javascript">
alert("잘못된 접근입니다.");
history.back();
</script>
HEREDOC;
    }

    $nowPage = $_GET['p'];
    $mainview = new Mainview();
    $start = $mainview->getStartNumOfPage($nowPage, $num);

    global $simdbcon;

    $data = new Data();
    $simUri = $GLOBALS['simplog_url'];

    // get skin file
    $file = dirname(__FILE__)."/skin/".$skinName."/index.html";

    if(substr($simUri, -1) != "/")
        $simUri = $simUri."/";

    if(file_exists($file))
    {
        $skin = file($file);
        $skin = str_replace("./", $simUri.'_linked/skin/'.$skinName.'/', join('', $skin));

        switch($what)
        {
            case "tag":
                $tag = $arr[2];
                if(strtolower($encoding) == "euc-kr")
                {
                    //$tag = utf82euckr($tag);
                }

                $title['tag'] = sprintf($title['tag'], $tag);
                $skin = str_replace('[SIMPLOG::TITLE]', $title['tag'], $skin);
                $query = "SELECT k.keywords, p.*, a.nick_name, b.blog_name, b.blog_desc, c.category_name 
                FROM ".SPG_PREFIX."_post_keywords k, ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_admin a, ".SPG_PREFIX."_admin b, ".SPG_PREFIX."_category c 
                WHERE p.display_level = 3 AND p.author = a.user_name AND p.user_name = b.user_name AND b.is_use = 1 AND b.open_portal = 1 AND k.user_name = p.user_name AND k.post_no = p.no AND c.user_name = p.user_name AND p.category_id = c.category_id AND k.keywords='$tag' 
                ORDER BY p.post_time DESC LIMIT $start, $num";

                $query2 = "SELECT count(*)
                FROM ".SPG_PREFIX."_post_keywords k, ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_admin b
                WHERE p.display_level = 3 AND k.user_name = p.user_name AND k.post_no = p.no AND b.user_name = p.user_name AND b.is_use = 1 AND b.open_portal = 1 AND k.keywords='$tag'";
                break;
            case "blog":
                $skin = str_replace('[SIMPLOG::TITLE]', $title['blog'], $skin);
                $query = "SELECT * FROM ".SPG_PREFIX."_admin WHERE is_use = 1 AND open_portal = 1 ORDER BY reg_date DESC LIMIT $start, $num";

                $query2 = "SELECT count(*) FROM ".SPG_PREFIX."_admin WHERE is_use = 1 AND open_portal = 1 ";
                break;
            case "post":
                $skin = str_replace('[SIMPLOG::TITLE]', $title['post'], $skin);
                $query = "SELECT p.*, a.nick_name, b.blog_name, c.category_name FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_admin a, ".SPG_PREFIX."_admin b, ".SPG_PREFIX."_category c WHERE p.author = a.user_name AND p.user_name = b.user_name AND c.user_name = p.user_name AND c.category_id = p.category_id AND b.is_use = 1 AND b.open_portal = 1 ORDER BY post_time DESC LIMIT $start, $num";

                $query2 = "SELECT count(*) FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_admin b WHERE p.display_level=3 AND p.user_name = b.user_name AND b.is_use = 1 AND b.open_portal = 1 ";
                break;
            default:
                break;
        }
        
        $adminResult = $simdbcon->query($query);
        if (DB::isError($adminResult))
        {
            die ($adminResult->getMessage().__FILE__.__LINE__);
        }

        preg_match('|<SIMPLOG::LOOP>(.+)</SIMPLOG::LOOP>|s', $skin, $contents);

        $printContents = "";
        if($adminResult->numRows() > 0)
            while($allData = $adminResult->fetchRow())
            {
                if(empty($allData['blog_name'])) $allData['blog_name'] = "정보없음";
                if(empty($allData['blog_desc'])) $allData['blog_desc'] = "정보없음";

                switch($what)
                {
                    case "tag":
                        $date = $allData['post_time'];
                        break;
                    case "blog":
                        $date = strtotime ($allData['timedate']);
                        break;
                    case "post":
                        $date = $allData['post_time'];
                        break;
                    default:
                        break;
                }
                $contents2 = $contents[1];
                // 변수 치환
                $contents2 = preg_replace("/\[SIMPLOG::BLOGURL\]/", $simUri.$allData['user_name'], $contents2);
                preg_match("/\[SIMPLOG::BLOGNAME=\"([0-9]+)\"\]/", $contents2, $cut);
                $contents2 = preg_replace("/\[SIMPLOG::BLOGNAME=\"([0-9]+)\"\]/", '<a href="'.$simUri.$allData['user_name'].'">'.$mainview->strCut($allData['blog_name'], $cut[1]).'</a>', $contents2);
                preg_match("/\[SIMPLOG::SUBJECT=\"([0-9]+)\"\]/", $contents2, $cut);
                $contents2 = preg_replace("/\[SIMPLOG::SUBJECT=\"([0-9]+)\"\]/", '<a href="'.$simUri.$allData['user_name'].'/index.php/post/'.$allData['no'].'">'.$mainview->strCut($allData['subject'], $cut[1]).'</a>', $contents2);
                preg_match("/\[SIMPLOG::BLOGDESC=\"([0-9]+)\"\]/", $contents2, $cut);
                $contents2 = preg_replace("/\[SIMPLOG::BLOGDESC=\"([0-9]+)\"\]/", $mainview->strCut($allData['blog_desc'], $cut[1]), $contents2);
                preg_match("/\[SIMPLOG::NAME=\"([0-9]+)\"\]/", $contents2, $cut);
                $contents2 = preg_replace("/\[SIMPLOG::NAME=\"([0-9]+)\"\]/", $mainview->strCut($allData['nick_name'], $cut[1]), $contents2);
                preg_match("/\[SIMPLOG::CATEGORY=\"([0-9]+)\"\]/", $contents2, $cut);
                $contents2 = preg_replace("/\[SIMPLOG::CATEGORY=\"([0-9]+)\"\]/", $mainview->strCut($allData['category_name'], $cut[1]), $contents2);
                preg_match("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", $contents2, $cut);
                $contents2 = preg_replace("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", date($cut[1], $date), $contents2);

                // blog banner
                $adminData2 = getAdminData2($allData['user_name']);
                if($allData['banner1'] && $adminData2['admin_defaultbanner'] == "banner1")
                {
                    $banner = $simUri.$allData['user_name'].'/'.$allData['banner1'];
                }
                else if($allData['banner2'] && $adminData2['admin_defaultbanner'] == "banner2")
                {
                    $banner = $simUri.$allData['user_name'].'/'.$allData['banner2'];
                }
                else
                {
                    $banner = $simUri.'_linked/skin/'.$skinName."/images/noimage.gif";
                }
                $contents2 = preg_replace("/\[SIMPLOG::BANNER\]/", $banner, $contents2);

                $printContents .= $contents2;
            }
        else
            $printContents = "글이 없거나 공개되지 않는 글입니다.";

        $skin = preg_replace('|<SIMPLOG::LOOP>(.+)</SIMPLOG::LOOP>|s', $printContents, $skin);

        echo $skin;
    }
    else
    {
        echo "스킨 경로 설정이 잘못 되었습니다.";
    }

    if(strtolower($encoding) == "euc-kr")
    {
        $out = ob_get_contents();
        ob_end_clean();
        $out = euckr2utf8($out);
        echo $out;
    }

    unset($adminResult);

    $total = $simdbcon->getOne($query2);
    if (DB::isError($total))
    {
        die ($total->getMessage().__FILE__.__LINE__);
    }

    return array($total, $num);
}

/**
 * printPageNum
 * showing page numbering 
**/
function printPageNum($pageinfo, $pageNum)
{
    $totalArticle = $pageinfo[0];
    $numPPage = $pageinfo[1];

    $data = new Data();
    $library = new Library();
    $thisPage = $_getPage = $_GET['p'];

    //non page number or page number is 1
    if(!isset($_getPage) || $_getPage == 1 || !$_getPage)
    {
        $startNum = 0;
        $_getPage = 1;
    }
    else
    {
        $startNum = $numPPage * ($_getPage - 1);
    }

    $totalPage = ceil($totalArticle / $numPPage);

    //get number showing paging
    if($totalPage > $pageNum)
    {
        if($pageNum == 1)
        {
            $startNum = $_getPage;
            $endNum = $startNum;
        }
        else
        {
            if(is_int($pageNum / 2))
            {
                $pageGap = $pageNum / 2;
            }
            else
            {
                $pageGap = floor($pageNum / 2);
            }

            $startNum = $_getPage - $pageGap;

            if($startNum < 1)
            {
                $startNum = 1;
            }
            
            if(($showingNum = $totalPage - $startNum + 1) < $pageNum)
            {
                $endGap = $pageNum - $showingNum;
                $startNum = $startNum - $endGap;
            }

            $endNum = $startNum + $pageNum - 1;

            if($endNum > $totalPage)
            {
                $endNum = $totalPage;
            }
        }
    }
    else
    {
        $startNum = 1;
        $endNum = $totalPage;
    }

    if(isset($thisPage))
    {
        $page = $thisPage;
    }
    else
    {
        $page = 1;
    }

    // print page numbers
    for($i = $startNum; $i <= $endNum; $i++)
    {
        if($page == $i)
        {
            echo "<span class='NOWPAGE'>[$i]</span>";
        }
        else
        {
            echo " <a href=\"?p=".$i."\" class='PAGENUM'>$i</a> ";
        }
    }

}

function printRecentPosts_euckr($skinName, $title, $numPost = 10)
{   
    ob_start();
    if(function_exists("mb_convert_encoding"))
        $title = mb_convert_encoding($title, "utf-8", "euc-kr");    
    else if(function_exists("iconv"))
        $title = iconv("euc-kr", "utf-8", $title);

    printRecentPosts($skinName, $title, $numPost);
    $out = ob_get_contents();
    ob_end_clean();

    if(function_exists("mb_convert_encoding"))
        echo mb_convert_encoding($out, "euc-kr", "utf-8");    
    else if(function_exists("iconv"))
        echo iconv("utf-8", "euc-kr", $out);
    else    echo "Please install mb_string or iconv";
}

function printRecentBlogs_euckr($skinName, $title, $numPost = 10)
{   
    ob_start();
    if(function_exists("mb_convert_encoding"))
        $title = mb_convert_encoding($title, "utf-8", "euc-kr");    
    else if(function_exists("iconv"))
        $title = iconv("euc-kr", "utf-8", $title);

    printRecentBlogs($skinName, $title, $numPost);
    $out = ob_get_contents();
    ob_end_clean();

    if(function_exists("mb_convert_encoding"))
        echo mb_convert_encoding($out, "euc-kr", "utf-8");    
    else if(function_exists("iconv"))
        echo iconv("utf-8", "euc-kr", $out);
    else    echo "Please install mb_string or iconv";
}



//**** Library *****//

function euckr2utf8($out)
{
    if(function_exists("mb_convert_encoding"))
        $out=mb_convert_encoding($out, "euc-kr", "utf-8");    
    else if(function_exists("iconv"))
        $out=iconv("utf-8", "euc-kr", $out);
    else    $out="Please install mb_string or iconv";

    return $out;
}

function utf82euckr($out)
{
    if(function_exists("mb_convert_encoding"))
        $out=mb_convert_encoding($out, "utf-8", "euc-kr");    
    else if(function_exists("iconv"))
        $out=iconv("euc-kr", "utf-8", $out);
    else    $out="Please install mb_string or iconv";

    return $out;
}

function connectSimplogDB()
{
    require_once dirname(dirname(__FILE__))."/_lib/setup.inc";

    $setup = new Setup();
    $GSetup = $setup->getGlobalSetting();
    define("SPG_PREFIX", "spg_".$GSetup['PREFIX']);

    $dsn = "mysql://".$GSetup['DBUSER'].":".$GSetup['DBPASS']."@".$GSetup['DBHOST']."/".$GSetup['DBNAME'];

    $simdbcon = DB::connect($dsn);
    if (DB::isError($simdbcon)) 
    {
        die ($simdbcon->getMessage());
    }
    $simdbcon->setFetchMode(DB_FETCHMODE_ASSOC);

    return $simdbcon;
}

function getAdminData2($n)
{
    $simdbcon = connectSimplogDB();

    $query = 
        "SELECT name, value".
        " FROM ".SPG_PREFIX."_data".
        " WHERE user_name='".$n."'";

    $adminData = $simdbcon->getAssoc($query);
    
    if (DB::isError($adminData))
    {
        die ($adminData->getMessage());
    }

    return $adminData;
}

?>