/**
 * 
 * Ű  ڹ ũƮ
 * 
 * @license GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author byfun (http://byfun.com)
 */
 
$(document).ready(function() {
		
	$(".wiki_modal").wiki_lightbox();
  
  $("#toc_fold").click(function(evt) {
  	evt.preventDefault();
  	$("#wiki_toc_content").slideToggle();
  	head = $("#wiki_toc_head a");
  	if(head.hasClass("fold_up")) {
  		head.removeClass("fold_up").addClass("fold_down");
  	} else head.removeClass("fold_down").addClass("fold_up");
  });  

  $(".button a, .button input").click(function() {
  	$(this).blur();
  }); 

	// ۾  
	if(!is_comment) {
		$(".wr_content").narinEditor('wiki_write');
		$(".markItUp .narin_media").click(function() {
			win_pop_center(wiki_url + '/media.php', 1000, 600, 'toolbar=0,resizable=1,scrollbars=1');
		});
	}
	
	// ܺ ũ â
	$(".wiki_external_link").attr('target', '_blank');
	
	//  ʺ񺸴 ū ̹ 
	// FIXME : IE  cw    ..;;
	$(".narin_contents").find('img').load(function() {
			$(".narin_contents").find('img').each(function() {
				var img = $(this);
				var iw = img.width();
				var ih = img.height();
				var cw = img.parents('div').eq(0).width() - 10;
				if(iw > cw) {
					img.css('width', cw+'px').css('height', Math.floor(ih * cw / iw)+'px');
				}
		});	// each
	});	// load
		    
});


// Ʈڽ wrapper function
$.wiki_lightbox_close = $.fancybox.close;
$.fn.wiki_lightbox = function(opt) {
	var settings = { 
		'centerOnScroll' : true,
		'overlayOpacity' : 0.5,
		'showCloseButton' : true,
		'enableEscapeButton' : true,
		'overlayColor' : '#222'
	}		
	opt = $.extend(settings, opt);
	return this.each(function() {
		$(this).fancybox(opt);
	});
};


/**
 * 
 * @param docname δ  
 */
function check_doc_name(docname, hidemsg)
{
	if($.trim(docname) == '') {
		if(!hidemsg) alert(" Էϼ");
		return false;
	}	
	var pattern = /[\|\/\\\\\?#\+]/;
	if(pattern.test(docname)) {
		if(!hidemsg) alert("  ڴ   ϴ : \\, |, /, ?, #, +");
		return false;
	}		
	return true;
}

/**
 * 
 * @param foldername   ü
 */
function check_folder_name(foldername, hidemsg)
{
	if($.trim(foldername) == '') {
		if(!hidemsg) alert(" Էϼ");
		return false;
	}
	var pattern = /[\|\\\\\?#\+]/;
	if(pattern.test(foldername)) {
		if(!hidemsg) alert("  ڴ   ϴ : \\, |, ?, #, +");
		return false;
	}
	
	pattern = /[\/]{2,}/;
	if(pattern.test(foldername)) {
		if(!hidemsg) alert(" /  Ͽ   ϴ.");
		return false;
	}	
	
	pattern = /^\//;
	if(!pattern.test(foldername)) {
		if(!hidemsg) alert(" /  ϴ ڿ ̾ մϴ.");
		return false;
	}	
	
	return true;
}

function recover_history(wr_id, hid)
{
	if(confirm("  Ͻðڽϱ?")) {
		$.post(wiki_url+"/exe/history.php", { w : 'r', wr_id : wr_id, hid : hid}, function(data) {
			if(data == 1) {
				location.href = g4_url + "/" + g4_bbs + "/board.php?bo_table="+g4_bo_table+"&wr_id=" + wr_id;
			} else {			
				alert(" ̷  Ͽϴ.");
			}
		});
	}
}

function delete_history(hid)
{
	if(confirm("  ̷ Ͻðڽϱ?")) {
		$.post(wiki_url+"/exe/history.php", { w : 'd', hid : hid}, function(data) {
			if(data == 1) {
				location.reload();
			} else {
				alert(" ̷  Ͽϴ.");
			}
		});
	}
}

function clear_history(wr_id)
{
	if(confirm("   ̷ Ͻðڽϱ?\n ǥõ ʴ ̷µ ˴ϴ.")) {
		$.post(wiki_url+"/exe/history.php", { w : 'da', wr_id : wr_id}, function(data) {
			if(data == 1) {
				location.href = g4_url + "/" + g4_bbs + "/board.php?bo_table="+g4_bo_table+"&wr_id=" + wr_id;
			} else {
				alert(" ̷  Ͽϴ.");
			}
		});
	}	
}

function delete_selected_history(wr_id)
{
	var hids = [];
	var chks = $("input[@name='hid[]']:checked").map(function() {
		hids.push(this.value);
	});
	
  if (hids.length == 0) 
  {
      alert(" ϳ ̻ ϼ.");
      return false;
  }	
	
	if(confirm("  ̷ Ͻðڽϱ?")) {		
		$.post(wiki_url+"/exe/history.php", { w : 'ds', wr_id : wr_id, hids : hids}, function(data) {
			if(data == 1) {
				location.reload();
			} else {
				alert(" ̷  Ͽϴ.");				
			}
		});
	}	
}

function delete_selected_changes()
{
	var cids = [];
	var chks = $("input[@name='cid[]']:checked").map(function() {
		cids.push(this.value);
	});
	
  if (cids.length == 0) 
  {
      alert("泻 ϳ ̻ ϼ.");
      return false;
  }	
	
	if(confirm(" 泻 Ͻðڽϱ?")) {		
		$.post(wiki_url+"/exe/changes.php", { w : 'ds', cids : cids}, function(data) {
			if(data == 1) {
				location.reload();
			} else {
				alert("泻  Ͽϴ.");				
			}
		});
	}	
}

function clear_changes()
{
	if(confirm(" 泻 Ͻðڽϱ?\n ǥõ ʴ   ˴ϴ.")) {
		$.post(wiki_url+"/exe/changes.php", { w : 'da'}, function(data) {
			if(data == 1) {
				location.reload();
			} else {
				alert("泻  Ͽϴ.");
			}
		});
	}	
}

function createDoc(folder)
{
	if(!check_folder_name(folder)) return;
	var doc = prompt(' Է : ', '');
	if(doc != null) {
		if(!check_doc_name(doc)) {
			createDoc(folder);
			return;
		}
		docpath = ( folder == "/" ? "/" : folder+"/") + doc;
		if(typeof wiki_fancy != 'undefined') {
			location.href = wiki_url + '/read' + docpath;
		} else {
			location.href = wiki_url + "/narin.php?doc=" + encodeURIComponent(docpath) + "&fj=1";
		}
		
	}
}

function wiki_search(f)
{
	var stx = $.trim(f.stx.value);
	if(stx == '') {
		alert("˻ Էϼ");
		return false;
	}
	if(typeof wiki_fancy != 'undefined') {
		location.href = wiki_url + '/search/' + stx;
		return false;
	}
	
	return true;
}




$.center = function($this) {
	var win = $(window);
	var top = (win.height() - $this.outerHeight()) / 2;
	var left = (win.width() - $this.outerWidth()) / 2;
	var pos = 'fixed';
	if($.browser.msie) {
		top += win.scrollTop() || 0;
		top = (top > 0 ? top : 0);
		left += win.scrollLeft() || 0;
		left = (left > 0 ? left : 0);			
		pos = 'absolute';		
	}
	$this.css({position:pos, top : top, left : left});				  			
};

$.fn.center = function() {
	return this.each(function() {
		$this = $(this);
		$(window).resize(function() { $.center($this); } ).scroll( function() { $.center($this); } );			 	    
		$.center($(this));
	});		
};

$.fn.center_now = function() {
	return this.each(function() {
		$.center($(this));
	});
};



function wiki_dialog(title, msg, options)
{
	var settings = { 
		msg_id : 'wiki_dialog', 
		title_bgcolor : "#555", 
		title_color : "#fff", 
		buttons : '<span class="button"><a href="javascript:$.wiki_lightbox_close();">Ȯ</a></span>',
		onClose : function() {} 
	};	
	jQuery.extend(settings, options);	
	
	msgLayer = $("<div></div>")
						.attr('style', 'display:none;')
						.html([
							'<div id="'+settings.msg_id+'">',
							'<div style="padding:5px 10px;background-color:'+settings.title_bgcolor+';color:'+settings.title_color+';font-weight:bold;">',
							title,
							'</div>',
							'<div style="padding:10px;line-height:160%;">',
							msg,
							'</div>',
							'<div style="margin-top:10px;border-top:1px dashed #ccc;padding-top:10px;text-align:center">',
							settings.buttons,
							'</div>',
							'<a href="#'+settings.msg_id+'" id="btn_'+settings.msg_id+'" style="display:none"></a>',
							'</div>'
							].join(''));
							
	$(document.body).prepend(msgLayer);
		
	$("#btn_"+settings.msg_id).wiki_lightbox({
		'hideOnOverlayClick' : false,
		'enableEscapeButton' : false,
		'onClosed'		: function() {
				msgLayer.remove();
				settings.onClose();
		}
	}).trigger('click');

}


function wiki_msg(msg, options) {
	
	var settings = { msg_id : 'wiki_msg', seconds : 2500, bgcolor : "#555", color : "#fff", callback : function() {} };
	jQuery.extend(settings, options);
	msgLayer = $("<div></div>")
		.attr('style', 'display:none;position:absolute;padding:10px 30px;text-align:center;background-color:'+settings.bgcolor+';color:'+settings.color+';z-index:999999')
		.html(msg).prependTo($('body'));
	msgLayer.center().fadeIn();
	// msgLayer.center_now();
	setTimeout(function() { msgLayer.fadeOut(function() { msgLayer.remove(); settings.callback(); });  }, settings.seconds);			
}

function objToString(o){
	var parse = function(_o){    
		var a = [], t;        
		for(var p in _o){        
			if(_o.hasOwnProperty(p)){            
				t = _o[p];                
				if(t && typeof t == "object"){                
					a[a.length]= p + ":{ " + arguments.callee(t).join(", ") + "}";                    
				}
				else {                    
					if(typeof t == "string"){                    
					  a[a.length] = [ p+ ": \"" + t.toString() + "\"" ];
					}
					else{
					  a[a.length] = [ p+ ": " + t.toString()];
					}                    
				}
			}
		}        
		return a;        
	}    
	return "{" + parse(o).join(", ") + "}";    
}

function win_pop_center(loc, w, h, opts) {
    var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
    var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;    
    var left = ((screen.width / 2) - (w / 2)) + dualScreenLeft;
    var top = ((screen.height / 2) - (h / 2)) + dualScreenTop;
    
    if(opts != undefined) opts = ',' + opts;
    else opts = '';
         
    var newwin = window.open(''+loc, 'narin_popup', 'top=' + top + ',left=' + left +',width=' + w + ',height=' + h + opts);
    if (window.focus) {newwin.focus();}
}
