<?
/**
 *
 * Ű  Ŭ ũƮ
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 *
 * Ű  Ŭ
 *
 * ,, Ʈ, 鸵ũ    ó ϴ Ŭ.
 * 
 * <b> </b>
 * <code>
 * // Ŭ ε
 * $wikiArticle =& wiki_class_load("Article");
 * 
 * // "/narin/Ű Ŵ"  ϴ  Ȯ
 * $is_exists = $wikiArticle->exists("/narin", "Ű Ŵ");
 *  
 * // "/narin/Ű Ŵ"  о
 * $write = $wikiArticle->getArticle("/narin", "Ű Ŵ");
 * 
 * // wr_id = 79   о
 * $write = $wikiArticle->getArticleById(79);
 *
 * // "/narin/Ű Ŵ"  ũϰ ִ ٸ  (backlinks) 
 * $back_links = $wikiArticle->getBackLinks("/narin/Ű Ŵ", $includeSelf=false);
 * 
 * // Ű   
 * $write_startpage = $wikiArticle->getFrontPage();
 * 
 * // $content  "/narin/Ű Ŵ"   ũ ִ ˻
 * $has_link = $wikiArticle->hasInternalLink($content, "/narin/Ű Ŵ");
 * 
 * // "/narin/Ű Ŵ"  "/narinwiki/Ŵ"  ϱ
 * $wikiArticle->moveDoc("/narin/Ű Ŵ", "/narinwiki/Ŵ");
 * 
 * //   cache  Ʈ ϵ  
 * $wikiArticle->shouldUpdateCache ($wr_id, 1);
 * 
 * // wr_id = 79   /θ "/narinwiki/Ŵ" ϱ 
 * $wikiArticle->updateArticle("/narinwiki/Ŵ", 79);
 * 
 * // "/narinwiki/Ŵ"  ٱ 5,   9  
 * $wikiArticle->updateLevel("/narinwiki/Ŵ", 5, 9);
 * </code>
 * 
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com) 
 */
class NarinArticle extends NarinClass {
	
	/**
	 * 
	 *  ̸     
	 * 
	 * ̸ (ٸ Ŭ )
	 * @var string
	 */
	public $fromDoc;
	
	/**
	 * 
	 *  ̸    
	 * 
	 * ٲ ̸ (ٸ Ŭ )
	 * @var string
	 */
	public $toDoc;
	
	
	/**
	 *
	 * DB о  ĳ
	 *
	 * @var array
	 */
	var $cache = array();
	
	/**
	 * 
	 * 
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * 
	 *  ȯ by 
	 * 
	 * @param string $ns ӽ̽()
	 * @param string $docname 
	 * @return array  
	 */
	public function & getArticle($ns, $docname)
	{		
		$full = wiki_doc($ns, $docname);
		if($this->cache[$full]) return $this->cache[$full];
		
		$e_ns = mysql_real_escape_string($ns);
		$e_docname = mysql_real_escape_string($docname);
		$sql = "SELECT wb.*, nt.*, wb.wr_subject AS doc, ht.reg_date AS update_date
						FROM ".$this->wiki['write_table']." AS wb 
						LEFT JOIN ".$this->wiki['nsboard_table']." AS nt ON wb.wr_id = nt.wr_id 
						LEFT JOIN ".$this->wiki['history_table']." AS ht ON wb.wr_id = ht.wr_id 
						WHERE nt.bo_table = '".$this->wiki['bo_table']."' AND nt.ns = '$e_ns' AND wb.wr_subject = '$e_docname'
						ORDER BY ht.reg_date DESC LIMIT 1
						";
		$write = sql_fetch($sql);		
		if($write['wr_id']) $write['contributors'] = $this->getContributor($write['wr_id']);
		$this->cache[$full] = &$write;
		$this->cache[$write[$wr_id]] = &$write;
		return $write;
	}
	
	/**
	 * 
	 *   ȯ
	 * 
	 * @param int $wr_id  id
	 * @return array  
	 */	
	public function getContributor($wr_id) {
		$sql = "SELECT ct.editor, mt.mb_id, mt.mb_name, mt.mb_nick FROM ". $this->wiki['contrib_table'] . " AS ct
						LEFT JOIN " . $this->g4['member_table'] . " AS mt
							ON ct.editor = mt.mb_id
						WHERE bo_table = '" . $this->wiki['bo_table'] . "' AND wr_id = " . $wr_id . "
						ORDER BY id ASC";
		return wiki_sql_list($sql);		
	}
	
	/**
	 * 
	 *  ȯ by wr_id
	 * 
	 * @param int $wr_id id (״ Խ wr_id)
	 * @return array  
	 */
	public function & getArticleById($wr_id)
	{
		if($this->cache[$wr_id]) return $this->cache[$wr_id];
		
		$wr_id = mysql_real_escape_string($wr_id);

		$sql = "SELECT wb.*, nt.*, wb.wr_subject AS doc, ht.reg_date AS update_date FROM ".$this->wiki['write_table']." AS wb 
				LEFT JOIN ".$this->wiki['nsboard_table']." AS nt ON wb.wr_id = nt.wr_id 
				LEFT JOIN ".$this->wiki['history_table']." AS ht ON wb.wr_id = ht.wr_id 
				WHERE nt.bo_table = '".$this->wiki['bo_table']."' AND wb.wr_id = '$wr_id'
				ORDER BY ht.reg_date DESC LIMIT 1
				";
		$write = sql_fetch($sql);
		$write['contributors'] = $this->getContributor($wr_id);		
		
		$full = wiki_doc($write['ns'], $write['doc']);
		$this->cache[$full] = &$write;
		$this->cache[$wr_id] = &$write;
		return $write;
	}
	

	/**
	 * 
	 *  ϴ Ȯ
	 * 
	 * @param string $ns ӽ̽()
	 * @param string $docname 
	 * @return true|false  ϸ true ƴϸ false
	 */
	public function exists($ns, $docname) {
		$ns = mysql_real_escape_string($ns);
		$docname = mysql_real_escape_string($docname);
		return sql_fetch("SELECT id FROM ".$this->wiki['nsboard_table']." AS nb 
						  LEFT JOIN {$this->wiki['write_table']} AS wt ON nb.wr_id = wt.wr_id 
						  WHERE nb.bo_table = '".$this->wiki['bo_table']."' AND nb.ns = '$ns' AND wt.wr_subject = '$docname'");
	}

	/**
	 * 
	 *  Ʈ ؾ ƾ .
	 * 
	 *  ƮǾ , Ʈϴ κп  should_update_cache ʵ带 1 ,
	 * ĳð Ʈ Ǿ  0 
	 * 
	 * @param int $wr_id
	 * @param int $value 0 Ǵ 1
	 */
	public function shouldUpdateCache($wr_id, $value) {
		$sql = "UPDATE ".$this->wiki['nsboard_table']." SET should_update_cache = '$value' 
				WHERE bo_table = '".$this->wiki['bo_table']."' AND wr_id = '$wr_id'";
		sql_query($sql);
	}

	/**
	 *
	 * '' ȯ
	 * 
	 * @return array   
	 */
	public function & getFrontPage() {
		return $this->getArticle("/", $this->board['bo_subject']);
	}

	/**
	 * 
	 * 鸵ũ ȯ
	 * (鸵ũ :  ũϰ ִ ٸ )
	 * 
	 * @param string $doc θ  
	 * @param boolean $includeSelf $doc ڽŵ 鸵ũ  
	 * @return array  迭
	 */
	public function getBackLinks($doc, $includeSelf = false)
	{
		$escapedDoc = mysql_real_escape_string($doc);
		$list = array();
		// 2011-12-11 :  hash ±׻  ֵ 
		$sql = "SELECT *, wb.wr_subject AS doc FROM ".$this->wiki['write_table']." AS wb 
				LEFT JOIN ".$this->wiki['nsboard_table']." AS nt ON wb.wr_id = nt.wr_id 
				WHERE nt.bo_table= '".$this->wiki['bo_table']."' 
							AND ( 
							      wb.wr_content LIKE '%[[".$escapedDoc."]]%' 
							      OR wb.wr_content LIKE '%[[".$escapedDoc."#%]]%'
							      OR wb.wr_content LIKE '%[[".$escapedDoc."|%'
							      OR wb.wr_content LIKE '%[[".$escapedDoc."#%|%'
							    ) 
							AND wb.wr_content NOT LIKE '%[[".$escapedDoc."/%'";
		$result = sql_query($sql);
		while($row = sql_fetch_array($result))
		{
			if(!$this->hasInternalLink($row['wr_content'], $doc)) {
				continue;
			}
			$bdoc = ($row['ns'] == "/" ? "/" : $row['ns'] . "/") . $row['doc'];
			if(!$includeSelf && $bdoc == $doc) continue;
				
			$row['href'] = wiki_url('read', array('doc'=>$bdoc));
			array_push($list, $row);
		}
		
		if(count($list)) $list = wiki_subval_asort($list, "doc");
		return $list;
	}

	/**
	 * 
	 *   by id
	 * 
	 *  ϰ  ִ     
	 * ( η ˻ϸ    )
	 * 
	 * @param int $wr_id  id
	 */
	public function deleteArticleById($wr_id)
	{
		$wr_id = mysql_real_escape_string($wr_id);
		$write = & $this->getArticleById($wr_id);
		if(!$write) return;

		$sql = "DELETE FROM ".$this->wiki['nsboard_table']." WHERE bo_table = '".$this->wiki['bo_table']."' AND wr_id = '$wr_id'";
		sql_query($sql);
		
		$sql = "DELETE FROM ".$this->wiki['contrib_table']." WHERE bo_table = '".$this->wiki['bo_table']."' AND wr_id = '$wr_id'";
		sql_query($sql);
		
		$namespace =& wiki_class_load("Namespace");
		$namespace->checkAndRemove($write['ns']);
	}
		
	/**
	 * 
	 * ״ Խù  Ű 
	 * 
	 *  ʴ       
	 * 
	 * @param string $doc  θ  
	 * @param int $wr_id  id
	 */
	public function addArticle($doc, $wr_id)
	{
		list($ns, $docname, $fullname) = wiki_page_name($doc);
		$namespace =& wiki_class_load("Namespace");
		$namespace->addNamespace($ns);
		if($ns) $ns = mysql_real_escape_string($ns);
		if($docname) $docname = mysql_real_escape_string($docname);
		if($fullname) $fullname = mysql_real_escape_string($fullname);
		if($wr_id) $wr_id = mysql_real_escape_string($wr_id);
		$sql = "INSERT INTO ".$this->wiki['nsboard_table']." VALUES ('', '".$this->wiki['bo_table']."', $wr_id, '$ns', '1', '', '')";
		sql_query($sql);
		$sql = "UPDATE ".$this->wiki['write_table']." SET wr_subject = '$docname' WHERE wr_id = $wr_id";
		sql_query($sql);
	}

	/**
	 *
	 *  
	 * 
	 * ־ $wr_id   $toDoc  ̸/ ϰ,
	 * write_table  wr_subject 
	 * 
	 * @param string $toDoc   ( θ  )
	 * @param int $wr_id  id
	 */
	public function updateArticle($toDoc, $wr_id)
	{
		list($ns, $docname, $fullname) = wiki_page_name($toDoc);
		$namespace =& wiki_class_load("Namespace");
		$namespace->addNamespace($ns);
		if($ns) $ns = mysql_real_escape_string($ns);
		if($docname) $docname = mysql_real_escape_string($docname);
		if($fullname) $fullname = mysql_real_escape_string($fullname);
		if($wr_id) $wr_id = mysql_real_escape_string($wr_id);
		$sql = "UPDATE ".$this->wiki['nsboard_table']." SET ns='$ns' WHERE bo_table='".$this->wiki['bo_table']."' AND wr_id='$wr_id'";
		sql_query($sql);
		$sql = "UPDATE ".$this->wiki['write_table']." SET wr_subject = '$docname' WHERE wr_id = $wr_id";
		sql_query($sql);
	}

	/**
	 * 
	 *  ߰ϱ
	 *
	 * @param int $wr_id  id
	 * @param string $editor ۼ id Ǵ ̸
	 */
	public function addContributor($wr_id, $editor)
	{
		$editor = mysql_real_escape_string($editor);
		$sql = "INSERT INTO ". $this->wiki['contrib_table'] . "
						SET bo_table = '" . $this->wiki['bo_table'] . "', 
								wr_id = $wr_id, 
								editor = '$editor'";
		sql_query($sql, false);
	}
		
	/**
	 * 
	 *  ̵
	 * 
	 * @param string $fromDoc   ( )
	 * @param string $toDoc   ( )
	 * @param int $wr_id  id
	 * @return true|false ̵  true, ׷  false
	 */
	public function moveDoc($fromDoc, $toDoc, $wr_id)
	{
		list($toNS, $toDocName, $toFullName) = wiki_page_name($toDoc);
		list($fromNS, $fromDocName, $fromFullName) = wiki_page_name($fromDoc);
		$this->fromDoc = $fromFullName;
		$this->toDoc = $toFullName;

		// ̹ Ѵٸ ̵ 
		$ex = $this->exists($toNS, $toDocName);
		if($ex) return false;
		
		$this->updateArticle($toDoc, $wr_id);

		$history =& wiki_class_load("History");

		// 鸵ũ Ʈ
		$backLinks = $this->getBackLinks($fromDoc, $includeSelf=true);
		for($i=0; $i<count($backLinks); $i++) {
			$content = $backLinks[$i]['wr_content'];
			$content = mysql_real_escape_string(preg_replace_callback('/(\[\[)(.*?)(\]\])/', array(&$this, 'wikiLinkReplace'), $content));
			
			/* 
			 FIXME : <pre></pre>, <nowiki></nowiki>  ִ°Ŵ ϰ  something wrong
			 $content = preg_replace_callback('/(<pre>)([\s\S]*)(<\/pre>)/i',array($this,"_saveNoWiki"),$content);
			 $content = preg_replace_callback('/(<nowiki>)(.*?)(<\/nowiki>)/i',array($this,"_saveNoWiki"),$content);
			 $content = mysql_real_escape_string(preg_replace_callback('/(\[\[)(.*?)(\]\])/', array(&$this, 'wikiLinkReplace'), $content));
			 $content = preg_replace_callback('/<nowiki><\/nowiki>/i', array($this,"_restoreNoWiki"),$content);
			 */
				
			//  ̷¿ 			
			$history->update($backLinks[$i]['wr_id'], stripcslashes($content), $this->member['mb_id'], " Ʈ  鸵ũ ڵ Ʈ");
			$this->shouldUpdateCache($backLinks[$i]['wr_id'], 1);
				
			sql_query("UPDATE {$this->wiki['write_table']} SET wr_content = '$content' WHERE wr_id = {$backLinks[$i]['wr_id']}");
		}

		$wikiEvent =& wiki_class_load("Event");
		$wikiEvent->trigger("MOVE_DOC", array("from"=>$fromFullName, "to"=>$toFullName));
		$namespace =& wiki_class_load("Namespace");
		$namespace->checkAndRemove($fromNS);
		
		return true;
	}

	/**
	 *
	 * Ű  ũ 
	 *
	 * $this->moveDoc()  {@link NarinNamespace}  ȣ.
	 * 
	 * @param array $matches Ű ũ ġ  ($matches[2] = [[ ]]  )
	 * @return string ο ũ 
	 */
	public function wikiLinkReplace($matches) {
		$sp = explode("|", $matches[2]);
		if(count($sp) > 1) {
			$doc = $sp[0];
			$opt = "|".$sp[1];
		} else {
			$doc = $sp[0];
			$opt = "";
		}
		if($doc != $this->fromDoc) return "[[".$matches[2]."]]";
		return "[[".$this->toDoc.$opt."]]";
	}

	/**
	 * 
	 *   
	 * 
	 * @param string $doc   ( θ  )
	 * @param int $access_level   
	 * @param int $edit_level   
	 */
	function updateLevel($doc, $access_level, $edit_level)
	{
		list($ns, $docname, $fullname) = wiki_page_name($doc);
		$wr = & $this->getArticle($ns, $docname, __FILE__, __LINE__);
		if(!$wr) return;
		$access_level = mysql_real_escape_string($access_level);
		$edit_level = mysql_real_escape_string($edit_level);
		sql_query("UPDATE ".$this->wiki['nsboard_table']." SET access_level = '$access_level', edit_level = '$edit_level' 
				   WHERE bo_table = '".$this->wiki['bo_table']."' AND wr_id = '".$wr['wr_id']."'");
	}

	/**
	 * 
	 * write_table   ʴ    ( )
	 * (write_table : ״ Խ ̺)
	 * 
	 */
	function removeAllNotExistsDoc()
	{
		sql_query("DELETE FROM ".$this->wiki['nsboard_table']." 
				   WHERE bo_table = '".$this->wiki['bo_table']."' AND wr_id NOT IN (  
				   		SELECT wr_id FROM ".$this->wiki['write_table'].")");
	}

	/**
	 * 
	 * content  $doc   ũ ϴ ˻
	 * 
	 * @param string $content  
	 * @param string $doc ˻  
	 * @return true|false ũ ϸ true, ׷  false
	 */
	function hasInternalLink($content, $doc)
	{
		$text = preg_replace('/<nowiki_block>([\s\S]*)<\/nowiki_block>/i', "",$content);
		$text = preg_replace('/<nowiki>(.*?)<\/nowiki>/i', "",$text);
		$regx = '/\[\['.preg_quote($doc, '/').'(.*?)\]\]/';
		return preg_match($regx, $text);
	}
}

?>
