<?
/**
 *
 * Ű 帧 (control) Ŭ ũƮ
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 *
 * Ű 帧 (control) Ŭ
 *
 * <b> </b>
 * <code>
 * // Ŭ ε
 * $wikiControl =& wiki_class_load("Control");
 * 
 * //  ޽ ֱ
 * $wikiControl->error("", " ʴ Դϴ. <a href='javascript:history.go(-1);'>ڷ</a>");
 *  
 * </code>
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinControl extends NarinClass {
	
	/**
	 * 
	 * @var array   
	 */
	var $g;
	
	/**
	 * 
	 */
	public function __construct() {
		parent::__construct();	
		
		$this->g = array(
			"member"=>$this->member, 
			"is_admin"=>$this->is_admin, 
			"is_wiki_admin"=>$this->is_wiki_admin,
			"urlencode"=>$this->urlencode,
			"is_member"=>$this->is_member,
			"is_guest"=>$this->is_guest,
			"config"=>$this->config);				
	}

	/**
	 * 
	 *    
	 * 
	 * @param string $doc  
	 */
	public function acl($doc) {
		$member = $this->member;
		
		list($ns, $docname, $doc) = wiki_page_name($doc);	
		
		$wikiArticle =& wiki_class_load("Article");
		
		$article = & $wikiArticle->getArticle($ns, $docname);										
	
		if($article && $article['access_level'] > $member['mb_level'] ) {
			$this->notAllowedDocument($ns, $docname, $doc);
		}
		
		$wikiNamespace =& wiki_class_load("Namespace");
		$n = $wikiNamespace->get($ns);
		
		if($n['ns_access_level'] > $member['mb_level']) {
			$this->notAllowedFolder($ns);
		}			
	}

	/**
	 * 
	 *  ʴ    ó
	 * 
	 * @param string $ns 
	 * @param string $docname 
	 * @param string $doc θ  
	 */  
	function noDocument($ns, $docname, $doc) {
		$write_href = $this->wiki['g4_url']."/bbs/write.php?bo_table=".$this->wiki['bo_table']."&doc=".urlencode($doc);
		$this->includePage(
						$this->wiki['inc_skin_path'] . "/nodoc.skin.php", 
						true, 
						array("folder"=>$ns, "docname"=>$docname, "doc"=>$doc, "write_href"=>$write_href)
					);
	}
	
	/**
	 * 
	 *      ó
	 * 
	 * @param string $ns 
	 * @param string $docname 
	 * @param string $doc θ  
	 */
	function notAllowedDocument($ns, $docname, $doc) {
		$this->error(" ", "$docname     ϴ.");
	}
	
	/**
	 * 
	 *      ó
	 * 
	 * @param string $ns 
	 */
	function notAllowedFolder($ns) {
		$this->error(" ", "$ns     ϴ.");
	}
	
	/**
	 * 
	 *   ֱ
	 * 
	 * <wiki>/skin/board/error.skin.php  ޽ 
	 * 
	 * @param string $title  
	 * @param string $msg  
	 */
	function error($title, $msg)
	{
		$this->includePage(
					$this->wiki['inc_skin_path'] . "/error.skin.php",
					true, 
					array("title"=>$title, "msg"=>$msg)
				);
		exit;
	}	
	
	/**
	 * 
	 *  
	 * 
	 * @param string $doc θ  
	 * @param int $wr_id  id
	 */ 
	function viewDocument($doc, $wr_id) {		
		$path = $this->wiki['g4_path']."/bbs/board.php";		
		chdir($this->g4['g4_path']."/bbs");
		$write = sql_fetch(" select * from ".$this->wiki['write_table']." where wr_id = '$wr_id' ");
		$this->includePage($path, false, array("wr_id"=>$wr_id, "write"=>$write));
	}
			
	/**
	 * 
	 * ״ extend ó
	 * 
	 * <g4>/extends/narin.wiki.extend.php  ȣϸ,
	 * ûǴ ũƮ Ͽ  Ű ʿ ó 
	 * 
	 * @param string $scriptFile ũƮ  (write.php, board.php, write_update.php ...)
	 */
	function board($scriptFile) {
		
		global $wiki, $bo_table,  $wr_id, $board, $doc;
					
		// view
		if($scriptFile == "board.php" && $wr_id) {
			$wikiArticle =& wiki_class_load("Article");
			$view = & $wikiArticle->getArticleById($wr_id);
			$doc = ($view[ns] == "/" ? "" : $view[ns]."/") . $view[doc];
			wiki_goto_url(wiki_url('read', array('doc'=>$doc)));
			exit;			
		}
		
		// list
		if($scriptFile == "board.php" && !$wr_id) {
			header("location:".wiki_url());
			exit;
		}	
						
		// Ϳ  ۼ  ֱ ...
		if($wr_id && $this->member['mb_id'] && $this->member['mb_id'] != $this->write['mb_id']) {
			
			$wikiArticle =& wiki_class_load("Article");			
			$wikiConfig =& wiki_class_load("Config");

			$default_edit_level = $wikiConfig->setting['edit_level'];
			$article = & $wikiArticle->getArticleById($wr_id);
			$edit_level = ( $article['edit_level'] ? $article['edit_level'] : $default_edit_level);				
			
			$is_doc_editor = ($this->member['mb_level'] >= $edit_level );
			if($scriptFile == "write.php" || $scriptFile == "write_update.php") {
				if($is_doc_editor) {					
					$this->write['mb_id'] = $this->member['mb_id'];			
					$this->write['is_editor'] = true;		
				}
			}
		} else if($wr_id && $this->member['mb_id'] && $this->member['mb_id'] == $this->write['mb_id']) {
			$this->write['is_owner'] = true;
		}
				
		// write
		if($scriptFile == "write.php" && !$doc && !$wr_id ) {
			header("location:".wiki_url());
			exit;			
		}						
	}
	
	/**
	 * 
	 *  include żҵ
	 * 
	 * @param string $include_path include   
	 * @param string $layout layout   
	 * @param string $params
	 */
	function includePage($include_path, $layout=false, $params=array()) {
		
		foreach ( $GLOBALS as $key => $value ) { $$key = $value; }	
		
		if(is_array($params)) foreach ( $params as $key => $value ) { $$key = $value; }	
		list($ns, $docname, $doc) = wiki_page_name($doc);
		
		if($layout) include_once WIKI_PATH . "/head.php";		
		include $include_path;		
		if($layout) include_once WIKI_PATH . "/tail.php";				
		
	}
	
	
}

?>
