<?
/**
 *
 * ŰJS/CSS  ũƮ
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 *
 * Ű JS/CSS  Ŭ
 *
 * ÷, Ų, ý js/css  / ϴ Ŭ
 *
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinJsCss extends NarinClass {

	/**
	 *
	 * @var string ./data/bo_table 
	 */
	public $data_path;

	/**
	 *
	 * @var array /minify  js  
	 */	
	public $js_files;

	/**
	 *
	 * @var array /minify  css  
	 */	
	public $css_files;

	/**
	 *
	 * @var string minify  js    
	 */	
	public $js;

	/**
	 *
	 * @var string minify  css    
	 */	
	public $css;
	
	/**
	 *
	 *  :   
	 * @var string minify  js     (print )	 
	 */		
	public $css_print;

  /**
   *
   * @var long $this->js  Ʈ Ÿӽ
   */
	public $js_modified = 0;

  /**
   *
   * @var long $this->css  Ʈ Ÿӽ
   */
	public $css_modified = 0;

  /**
   *
   * @var string css  url, src θ ϱ  ӽ 
   */
	protected $css_cur_path;

	/**
	 * 
	 */
	public function __construct() {

		parent::__construct();
		$this->data_path = WIKI_PATH.'/data/'.$this->wiki['bo_table'];
		if(!file_exists($this->data_path)) {
			@mkdir($this->data_path, 0707);
		}
		$this->js = $this->data_path .'/_js.txt';
		$this->css = $this->data_path .'/_css.txt';
		$this->css_print = $this->data_path .'/_css_print.txt';
	}

	/**
	 *
	 * js ϵ   / modified time 
	 */
	function loadJsFiles() {

		if($this->js_modified > 0) return;
			
		// js  ε
		$this->js_files = array(WIKI_PATH."/js/jquery.fancybox-1.3.4.js",
		WIKI_PATH."/js/jquery.markitup.js",
		WIKI_PATH."/js/jquery.treeview.js",
		WIKI_PATH."/js/jquery.cookie.js"
		);


		// just check modified time
		list($modified, $list) = $this->get_files(WIKI_PATH."/js", "js");
		$this->js_modified = $modified;
			
		// load plugins's js files
		if(file_exists($this->data_path."/js")) {
			list($modified, $list) = $this->get_files($this->data_path."/js", "js");
			if($modified > $this->js_modified) $this->js_modified = $modified;
			$this->js_files = array_merge($this->js_files, $list);
		}

		// load skin's js files
		list($modified, $list) = $this->get_files($this->wiki['skin_path'], "js");
		if($modified > $this->js_modified) $this->js_modified = $modified;
		$this->js_files = array_merge($this->js_files, $list);

		// narin.editor.js AND narin.wiki.js   ߿ 				
		array_push($this->js_files, WIKI_PATH."/js/narin.editor.js");				
		array_push($this->js_files, WIKI_PATH."/js/narin.wiki.js");
	}

	/**
	 *
	 * css ϵ   / modified time 
	 */
	function loadCssFiles() {

		if($this->css_modified > 0) return;
			
		// css  ε
		$this->css_files = array(WIKI_PATH."/css/jquery.fancybox-1.3.4.css",
		WIKI_PATH."/css/jquery.treeview.css",
		WIKI_PATH."/css/narin.tool.set.css",
		WIKI_PATH."/css/narin.tool.skin.css",
		WIKI_PATH."/css/narin.wiki.adm.css",
		WIKI_PATH."/css/narin.wiki.style.css"
		);


		// just check modified time
		list($modified, $list) = $this->get_files(WIKI_PATH."/css", "css");
		$this->css_modified = $modified;
			
		// load plugins's css files
		if(file_exists($this->data_path."/css")) {
			list($modified, $list) = $this->get_files($this->data_path."/css", "css");
			if($modified > $this->css_modified) $this->css_modified = $modified;
			$this->css_files = array_merge($this->css_files, $list);
		}

		// load skin's css files
		list($modified, $list) = $this->get_files($this->wiki['skin_path'], "css");
		if($modified > $this->css_modified) $this->css_modified = $modified;
		$this->css_files = array_merge($this->css_files, $list);

	}

	/**
	 *
	 * js  а, minify ؼ ϳ Ϸ 
	 */
	function updateJs() {
		if($this->js_modified == 0) $this->loadJsFiles();

		include_once WIKI_PATH."/lib/Minifier/jsmin.php";

		$contents = $this->get_js_contents_array($this->js_files);

		try {
			$contents = JSMin::minify($contents);
		} catch(Exception $ex) {}

		$fp = fopen($this->js, "w");
		fwrite($fp, $contents);
		fclose($fp);
	}

	/**
	 *
	 * css  а, minify ؼ ϳ Ϸ 
	 */
	function updateCss() {
		if($this->css_modified == 0) $this->loadCssFiles();

		include_once WIKI_PATH."/lib/Minifier/cssmin.php";

		$contents = $this->get_css_contents_array($this->css_files);
		$contents_print = $this->get_css_contents_array($this->css_files, $print=true);
		
		try {
			$contents = CssMin::minify($contents);
			if($contents_print) $contents_print = CssMin::minify($contents_print);
		} catch(Exception $ex) {}

		$fp = fopen($this->css, "w");
		fwrite($fp, $contents);
		fclose($fp);
		
		if($contents_print)  {
			$fp = fopen($this->css_print, "w");
			fwrite($fp, $contents_print);
			fclose($fp);		
		}
	}

	/**
	 *
	 * ־   迭  о
	 *
	 * @param array $files ߰   迭
	 * @return string յ  
	 */
	function get_js_contents_array($files) {
		$str = "";
		foreach($files as $k=>$file) {
			$str .= file_get_contents($file);
		}
		return $str;
	}

	/**
	 *
	 * CSS  о
	 *
	 * @param string $path  
	 * @param string $extension Ȯ
	 * @return string յ  
	 */
	function get_css_contents_array($files, $print_version = false) {
		$str = "";
		foreach($files as $k=>$file) {
			if(is_dir($files)) continue;
			if($print_version && strpos($file, "print") <= 0) continue;
			if(!$print_version && strpos($file, "print") > 0) continue;
			$this->css_cur_path = dirname($file);
			$contents = file_get_contents($file);
			$contents = preg_replace_callback("/url\s?\([\'|\"]?(.*?)[\'|\"]?\)/is", array(&$this, "replace_css_url_path"), $contents);
			$contents = preg_replace_callback("/src=\s?[\'|\"](.*?)[\'|\"]/is", array(&$this, "replace_css_src_path"), $contents);
			$str .= '/* '. $file . ' */'. $contents;
		}
		return $str;
	}

	/**
	 *
	 * CSS  (background:url(....)) URL η 
	 *
	 * @param array $matches  Ī 
	 * @return string ΰ  url
	 */
	function replace_css_url_path($matches) {
		if(preg_match("/^(http[s]?:\/\/|ftp:\/\/|\/)/i", $matches[1])) return $matches[0];
		return "url(".$this->wiki['url'].str_replace(WIKI_PATH, '', $this->css_cur_path).'/'.$matches[1].")";
	}

	/**
	 *
	 * CSS  (src=(....)) URL η 
	 *
	 * @param array $matches  Ī 
	 * @return string ΰ  url
	 */
	function replace_css_src_path($matches) {
		if(preg_match("/^(http[s]?:\/\/|ftp:\/\/|\/)/i", $matches[1])) return $matches[0];
		return "src='".$this->wiki['url'].str_replace(WIKI_PATH, '', $this->css_cur_path).'/'.$matches[1]."'";
	}

	/**
	 *
	 * ־  ο   о
	 *
	 * @param string $path  
	 * @param string $extension Ȯ
	 * @return string   迭
	 */
	function get_files($path, $extension) {
		$modified = 0;
		$str = "";
		$files = scandir($path);
		$extlen = -1 * (strlen($extension)+1);
		$list = array();
		foreach($files as $k=>$file) {
			if(is_dir($path."/".$file)) continue;
			if(substr($file, $extlen) != '.'.$extension) continue;
			if(!$is_ie6 && strpos($file, "ie6") > 0) continue;
			$age = filemtime($path."/".$file);
			if($age > $modified) {
				$modified = $age;
			}
			array_push($list, $path."/".$file);
		}
		return array($modified, $list);
	}

}
?>
