<?
/**
 * 
 * Ű  м(parsing)  Ŭ ũƮ
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

define("EVENT_AFTER_PARSING_ALL", "EVT_PARSING_FINSISHING_ALL");
define("EVENT_AFTER_PARSING_LINE", "EVT_PARSING_FINSISHING_LINE");

/**
 * 
 * Ű  м(parsing)  Ŭ
 * 
 * <b>뿹</b>
 * <code>
 * // Ŭ ε
 * $wikiParser =& wiki_class_load("Parser");
 * 
 * // Ű  -> HTML Ľ
 * // $view Ǵ $write : ״ Խù 迭
 * $html = $wikiParser->parse($view);
 * </code>
 * 
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinParser extends NarinClass
{
	/**
	 * 
	 * @var array nowiki  ӽ  迭
	 */
	protected $nowikis = array();
	
	/**
	 * 
	 * @var array pre  ӽ  迭
	 */	
	protected $pres = array();

	/**
	 * 
	 * @var array block ļ  迭
	 */	
	protected $blockParsers = array();
	
	/**
	 * 
	 * @var array variable ļ  迭
	 */	
	protected $variableParsers = array();
	
	/**
	 * 
	 * @var array line ļ  迭
	 */	
	protected $lineParsers = array();
	
	/**
	 * 
	 * @var array word ļ  迭
	 */	
	protected $wordParsers = array();
	
	/**
	 * 
	 * @var array event ڵ鷯  迭
	 */	
	protected $events = array();
	
	/**
	 * 
	 * @var array ÷  迭
	 */	
	protected $plugins = array();
	
	/**
	 * 
	 * @var array   block ļ 
	 */	
	protected $currentBlockParser = null;
	
	/**
	 * 
	 * @var array   word ļ 
	 */	
	protected $currentWordParser = null;
	
	/**
	 * 
	 * @var array  м Խù 迭 (״ view)
	 */	
	protected $view = null;
	
	/**
	 * 
	 * @var array  
	 */	
	protected $output = array();
	
	/**
	 * 
	 * @var array  ±
	 */	
	protected $ele = array("/~~NOCACHE~~/");

	/**
	 * 
	 * @var boolean   ļ  
	 */	
	public $stop = false;
	
	/**
	 * 
	 * @var boolean  Ľ ߴ
	 */		
	public $stop_all = false;
	
	/**
	 * 
	 * @var int  м line
	 */		
	public $current_row = 0;


	/**
	 * 
	 */
	public function __construct() {

		parent::__construct();
		$this->loadPlugins();
	}

	/**
	 *
	 * ʱȭ
	 */
	protected function init() {
		$nowikis = array();
		$stop = false;
		$stop_all = false;
		$current_row = 0;
		$currentBlockParser = null;
		$currentWordParser = null;
		$view = null;
		$output = array();
	}

	/**
	 *
	 * ÷ ε
	 *
	 * ý ⺻ ÷ lib/narin.syntax.php   ε ,
	 * plugins/  ִ syntax.php ϵ εѴ.
	 */
	protected function loadPlugins()
	{
		include_once WIKI_PATH."/lib/narin.Plugin.class.php";
		include_once WIKI_PATH."/lib/narin.SyntaxPlugin.class.php";

		$path = WIKI_PATH."/plugins";
		$use_plugins = array();
		foreach($this->wiki_config->using_plugins as $v) $use_plugins[$v] = $v;

		$plugins = array();
		
		// ⺻  ؼ ε
		include_once "narin.syntax.php";
		$syntax = new NarinSyntaxDefault();		
		array_push($plugins, array('order'=>$syntax->order, 'plugin'=>$syntax));

		// syntax ÷ ε
		$d = dir($path);
		while ($entry = $d->read()) {

			$pluginPath = $path ."/". $entry;

			if(is_dir($pluginPath) && substr($entry, 0, 1) != ".") {

				if(!$use_plugins[$entry]) {
					continue;
				}
				$classFile = $pluginPath ."/syntax.php";
				if(file_exists($classFile)) {

					$realClassName = "NarinSyntax".ucfirst($entry);
					include_once $classFile;

					if(class_exists($realClassName)) {

						$p = new $realClassName();
						if(!is_a($p, "NarinSyntaxPlugin")) continue;
						array_push($plugins, array('order'=>$p->order, 'plugin'=>$p));
					}

				}
			}
		}
		
		$plugins = wiki_subval_asort($plugins, 'order');
		
		foreach($plugins as $k=>$p) {
			$p['plugin']->register($this);
			array_push($this->plugins, $p['plugin']);
		}
		
		$this->addLineParser($id = $syntax->id."_wiki_par",
		$klass = $syntax,
		$regx = '^(.*?)$',
		$method = 'wiki_par');

	}

	/**
	 *
	 *  м
	 *
	 * @param array &$view ״ write_table   row
	 * @return string HTML
	 */
	public function parse(&$view)
	{
		$this->init();
		foreach($this->plugins as $p) {
			$p->init();
		}
			
		$this->view = &$view;
			
		$text = $this->_wikiTxt($view['wr_content']);
		$this->output = array();

		// nowiki  nowiki_block 
		$text = preg_replace_callback('/&lt;pre&gt;(.*?)&lt;\/pre&gt;/si',array($this,"_savePre"),$text);
		$text = preg_replace_callback('/&lt;nowiki&gt;(.*?)&lt;\/nowiki&gt;/si',array($this,"_saveNoWiki"),$text);

		// block parser 
		foreach($this->blockParsers as $id => $p) {
			$this->currentBlockParser = $p;
			$text = preg_replace_callback('/'.$p['start_regx'].'(.*?)'.$p['end_regx'].'/si', array($this, "do_block_parser"), $text);
		}


		// κ Ľ
		$lines = explode("\n",$text);

		foreach ($lines as $k=>$line)
		{
			$this->current_row = $k;
			$line = $this->parse_line($line);
			array_push($this->output, $line);
		}

			
		//   
		$output_string = implode(" ", $this->output);

		// URL ڵ ũ
		$output_string = str_replace("HREF=", "class='wiki_external_link' href=", url_auto_link($output_string));

		$output_string = $this->emoticons($output_string);

		// ̺Ʈ
		$this->trigger_event(EVENT_AFTER_PARSING_ALL, array("lines"=>&$this->output, "output"=>&$output_string, "parser"=>&$this, "view"=>$this->view, "plugins"=>&$this->plugins));

		$output_string = preg_replace($this->ele, "", $output_string);
			
		// nowiki 
		$output_string = preg_replace_callback('/<pre><\/pre>/i', array($this,"_restorePre"), $output_string);
		$output_string = preg_replace_callback('/<nowiki><\/nowiki>/i', array($this,"_restoreNoWiki"), $output_string);

		$output_string = "<div class='narin_contents'>".$output_string."</div>";

		return $output_string;
	}

	/**
	 *
	 *   м
	 *
	 * @param string $line Ű   
	 * @return string м HTML 
	 */
	protected function parse_line($line)
	{
		$this->stop = false;
		$this->stop_all = false;

		$called = array();
		$line = rtrim($line);


		// ܾ ڵ
		if (!$this->stop_all)
		{
			$this->stop = false;

			foreach ($this->wordParsers as $k => $p)
			{
				$regex = $p['regx'];
				$klass = $p['klass'];
				$func = $p['func'];
				$this->currentWordParser = $p;
				$line = preg_replace_callback("/$regex/i",array($this, "do_word_parser"),$line);
				if ($this->stop)
				{
					break;
				}
			}

			// variable  ó : {{ something }}
			$line = preg_replace_callback('/('. '\{\{' . '([^\}]*?)' . '\}\}' . ')/', array($this, "parse_variable"), $line);

			//  ڵ
			foreach ($this->lineParsers as $id => $p)
			{
				$regex = $p['regx'];
				$klass = $p['klass'];
				$func = $p['func'];
				if (preg_match("/$regex/i", $line, $matches))
				{
					$called[$id] = true;
					
					$line = $klass->$func($matches, array("lines"=>&$this->output, "parser"=>&$this, "view"=>&$this->view, "plugins"=>&$this->plugins));
					if ($this->stop || $this->stop_all)
					{
						break;
					}
				}
			}

		}

		$isline = strlen(trim($line)) > 0;

		// ̺Ʈ (EVENT_PARSING_FINISHING_LINE)
		$this->trigger_event(EVENT_AFTER_PARSING_LINE, array("line"=>&$line, "called"=>$called, "lines"=>&$this->output, "parser"=>&$this, "view"=>&$this->view, "plugins"=>&$this->plugins));

		return $line;
	}

	/**
	 *
	 * variable  м
	 *
	 * @param array $matches
	 * @return string ȯ 
	 */
	protected function parse_variable($matches)
	{
		$loc = wiki_input_value($this->folder);
		$path = WIKI_PATH;

		foreach ($this->variableParsers as $id => $p)
		{
			$regex = "^".$p['start_regx']."(.*?)".$p['end_regx']."$";
			if (preg_match("/$regex/i", $matches[2], $m))
			{
				if(method_exists($p['klass'], $p['func'])) {
					return $p['klass']->$p['func']($m, array("lines"=>&$this->output, "parser"=>&$this, "view"=>&$this->view, "plugins"=>&$this->plugins) );
				}
			}
		}

		return $matches[0];
	}

	/**
	 *
	 * ̺Ʈ ߰
	 *
	 *  м ʿ EVENT  ߻Ű 
	 *
	 * @param string $eventType ̺Ʈ Ÿ
	 * @param object $class ̺Ʈ ڵ鸵 ü
	 * @param string $func ̺Ʈ ڵ鸵 żҵ ̸
	 */
	public function addEvent($eventType, $class, $func) {
		$this->events[$eventType][] = array("klass"=>$class, "func"=>$func);
	}

	/**
	 *
	 * ̺Ʈ ߻
	 *
	 * ̺Ʈ ڵ鷯 Ű żҵ
	 *
	 * @param string $eventType ̺Ʈ Ÿ
	 * @param array $params Ķ
	 */
	protected function trigger_event($eventType, $params=array()) {
		foreach($this->events[$eventType] as $handler) {
			$handler['klass']->$handler['func']($params);
		}
	}

	/**
	 *
	 * block parser ߰
	 *
	 * @param string $id ÷  ̵
	 * @param object $class ÷ ü
	 * @param string $start_regx   ǥ
	 * @param string $end_regx   ǥ
	 * @param string $func ڵ鷯 żҵ ̸
	 */
	public function addBlockParser($id, $class, $start_regx, $end_regx, $func)
	{
		if($this->blockParsers[$id]) throw Exception("Already exists block parser : " . $id);
		$this->blockParsers[$id] = array("klass"=>$class, "start_regx"=>$start_regx, "end_regx"=>$end_regx, "func"=>$func);
	}

	/**
	 *
	 * variable parser ߰
	 *
	 * @param string $id ÷  ̵
	 * @param object $class ÷ ü
	 * @param string $start_regx  ǥ
	 * @param string $end_regx  ǥ
	 * @param string $func ڵ鷯 żҵ ̸
	 */
	public function addVariableParser($id, $class, $start_regx, $end_regx, $func)
	{
		if($this->variableParsers[$id]) throw Exception("Already exists variable parser : " . $id);
		$this->variableParsers[$id] = array("klass"=>$class, "start_regx"=>$start_regx, "end_regx"=>$end_regx, "func"=>$func);
	}

	/**
	 *
	 * line parser ߰
	 *
	 * @param string $id ÷  ̵
	 * @param object $class ÷ ü
	 * @param string $regx ǥ ǥ
	 * @param string $func ڵ鷯 żҵ ̸
	 */
	public function addLineParser($id, $class, $regx, $func)
	{
		if($this->lineParsers[$id]) throw Exception("Already exists line parser : " . $id);
		$this->lineParsers[$id] = array("klass"=>$class, "regx"=>$regx, "func"=>$func);
	}

	/**
	 *
	 * word parser ߰
	 *
	 * @param string $id ÷  ̵
	 * @param object $class ÷ ü
	 * @param string $regx ǥ ǥ
	 * @param string $func ڵ鷯 żҵ ̸
	 */
	public function addWordParser($id, $class, $regx, $func)
	{
		if($this->wordParsers[$id]) throw Exception("Already exists word parser : " . $id);
		$this->wordParsers[$id] = array("klass"=>$class, "regx"=>$regx, "func"=>$func);
	}



	/**
	 *
	 * block parser 
	 *
	 * @param array $matches Ī 
	 * @return string Ľ 
	 */
	protected function do_block_parser($matches)
	{
		$p = $this->currentBlockParser;
		return $p['klass']->$p['func']($matches, array("lines"=>&$this->output, "parser"=>$this, "view"=>&$this->view, "plugins"=>&$this->plugins));
	}

	/**
	 *
	 * word parser 
	 *
	 * @param array $matches Ī 
	 * @return string Ľ 
	 */
	protected function do_word_parser($matches)
	{
		$p = $this->currentWordParser;
		return $p['klass']->$p['func']($matches, array("lines"=>&$this->output, "parser"=>$this, "view"=>&$this->view, "plugins"=>&$this->plugins));
	}


	/**
	 *
	 * nowiki  
	 *
	 * @param array $matches Ī 
	 * @return string nowiki ±
	 */
	protected function _saveNoWiki($matches)
	{
		array_push($this->nowikis,$matches[1]);
		return "<nowiki></nowiki>";
	}

	/**
	 *
	 * pre  
	 *
	 * @param array $matches Ī 
	 * @return string nowiki ±
	 */
	protected function _savePre($matches)
	{
		array_push($this->pres,$matches[1]);
		return "<pre></pre>";
	}

	/**
	 *
	 * nowiki  
	 *
	 * @param array $matches Ī 
	 * @return string 
	 */
	protected function _restoreNoWiki($matches)
	{
		$m = $this->nowikis[0];
		array_shift($this->nowikis);
		return $m;
	}

	/**
	 *
	 * pre  
	 *
	 * @param array $matches Ī 
	 * @return string 
	 */
	protected function _restorePre($matches)
	{
		$m = $this->pres[0];
		array_shift($this->pres);
		return "<pre>".$m."</pre>";
	}

	/**
	 *
	 * ̸Ƽ ó
	 *
	 * @param string $content
	 * @return string ̸Ƽ ±
	 */
	protected function emoticons($content) {
		$source = array("8-)", "8-O", ":-(", ":-)", ":=)", ":-/", ":-\\", ":-?", ":-D", ":-P", ":-O", ":-X", ":-|", ";-)", "^_^", ":?:", ":!:", "LOL", "FIXME", "DELETEME");
		foreach($source as $k => $v) {
			$source[$k] = "/".preg_quote($source[$k], "/")."/";
		}
		$target = array("icon_cool.gif", "icon_eek.gif", "icon_sad.gif", "icon_smile.gif", "icon_smile2.gif", "icon_doubt.gif", "icon_doubt2.gif", "icon_confused.gif", "icon_biggrin.gif", "icon_razz.gif", "icon_surprised.gif", "icon_silenced.gif", "icon_neutral.gif", "icon_wink.gif", "icon_fun.gif", "icon_question.gif", "icon_exclaim.gif", "icon_lol.gif", "fixme.gif", "delete.gif", );
		foreach($target as $k => $v) {
			$target[$k] = "<img src=\"".$this->wiki['url']."/imgs/smileys/$v\" class=\"middle\" alt=\"\\0\" title=\"\\0\"/>";
		}
		$content = preg_replace($source, $target, $content);
		return $content;
	}

	/**
	 *
	 * html  text ͷ ȯ
	 *
	 * @param string $content HTML
	 * @return string TEXT 
	 */
	protected function _wikiTxt($content)
	{
		$content = html_symbol($content);
		$content = get_text($content, 0);
		return $content;
	}
}
