<?
/**
 * 
 * Ű ÷  Ŭ ũƮ
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 * 
 * Ű ÷  Ŭ
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinPluginInfo extends NarinClass {

	/**
	 *
	 * @var string ÷  ̵
	 */
	protected $id;

	/**
	 *
	 * @var string ÷ 
	 */
	protected $plugin_path;

	/**
	 *
	 * @var string  
	 */
	protected $data_path;

	/**
	 *
	 * @var array ÷ 
	 */
	protected $setting;

	/**
	 * 
	 */
	public function __construct() {
		
		parent::__construct();			
		
		$class_name = substr(get_class($this), 15);
		$class_name{0} = strtolower($class_name{0});
		$this->plugin_path = WIKI_PATH."/plugins/".$class_name;
		$this->data_path = WIKI_PATH."/data/".$this->wiki[bo_table];		
		
	}
	
	/**
	 *
	 * PluginInfo     ȣϴ ʱȭ żҵ
	 * 
	 * ÷ info Ŭ ߺ Ǿ 
	 */
	public function init() {
		// get default setting from plugin instance
		$default = $this->getSetting();
		
		if($default) {
				
			// load saved setting from db
			//$setting = wiki_get_option("plugin_setting/".$this->id);
			$setting = $this->wiki_config->plugin_setting[$this->id];
			// set setting as loaded value
			if($setting) {
				foreach($default as $k => $v) {
					// if default config is different with saved setting by updating plugin
					if(isset($setting[$k])) $default[$k][value] = $setting[$k];
				}
			}
				
			$this->setting = $default;
		}

		
	}

	/**
	 *
	 * ÷ ̵
	 *
	 * @return string ÷ id
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 *
	 * ÷  : narinwiki/plugins/÷
	 *
	 * @return string ÷ 
	 */
	public function getPluginPath() {
		return $this->plugin_path;
	}

	/**
	 *
	 *    : narinwiki/data/$bo_table
	 *
	 * @return string ÷
	 */
	public function getDataPath() {
		return $this->data_path;
	}

	/**
	 *
	 * ÷ 
	 *
	 * DB  ÷  ȯ
	 * (ó ̶ ⺻)
	 *
	 * @return string ÷
	 */
	public function getPluginSetting() {
		return $this->setting;
	}

	/**
	 *
	 *  
	 *
	 *  Ű   ÷ο     ֵ     setting 
	 *  setting  : array( ʵ1=>array(Ӽ), ʵ2=>array(Ӽ) ...);
	 *  Ӽ 
	 *  - type : text, textarea, select, checkbox  1
	 *      - type=>text : <input type="text" ...>   
	 *      - type=>textarea : <textarea ...></textarea>   
	 *      - type=>select : <select ..><option...></select>   
	 *      - type=>checkbox : <input type="checkbox" ..>   
	 *  - default : ⺻
	 *  - value : 
	 *  - label :  Է  ĭ  ̺
	 *  - desc : Է°   ʿϴٸ Է
	 *  - options : type=select   options  array  ݵ ؾ 
	 *
	 *   :
	 * <code>
	 * $setting = array(
	 *		"name"=>array("type"=>"text", "label"=>"̸ : ", "desc"=>"̸ Էؿ", "default"=>"it's default value", "value"=>"test"),
	 *		"desc"=>array("type"=>"textarea", "label"=>" : ", "default"=>"it's default value", "value"=>"ohohoh"),
	 *		"year"=>array("type"=>"select", "label"=>" : ", "options"=>array(1, 2, 3, 4, 5, 6, 7, 8), "default"=>2, "value"=>4),
	 *		"lunar"=>array("type"=>"checkbox", "label"=>" : ", "default"=>"checked", "setval"=>1)
	 *	);
	 * </code>
	 *
	 * syntax / action ÷ο ߺ Ǿ 
	 */
	public function getSetting() {}

	/**
	 *
	 * ÷  ȿ ˻
	 *
	 * @see adm/exe_plugin_setting.php
	 * @param array $setting ÷  
	 */
	public function checkSetting($setting) {
		foreach($setting as $name => $attr) {
			if(!isset($attr[type]) || !isset($attr[label]) || !isset($attr[value])) {
				return false;
			}
			if($attr[type] == "select" && ( !isset($attr[options]) || !is_array($attr[options]))) {
				return false;
			}
		}
		return true;
	}

	/**
	 *
	 * ÷ ġؾ ϳ?
	 *
	 * ÷ο ߺ Ǿ 
	 *
	 * @see adm/plugin.php
	 * @return true|false ġؾ ϸ true, ƴϸ false
	 */
	public function shouldInstall() { return false;	}

	/**
	 *
	 * ÷ νؾ ϳ?
	 *
	 * ÷ο ߺ Ǿ 
	 *
	 * @see adm/plugin.php
	 * @return true|false νؾ ϸ true, ƴϸ false
	 */
	public function shouldUnInstall() { return false;	}

	/**
	 *
	 * ÷ ġ
	 *
	 * @see adm/plugin_install.php
	 * ÷ο ߺ Ǿ 
	 */
	public function install() { }

	/**
	 *
	 * ÷ 
	 *
	 * @see adm/plugin_install.php
	 * ÷ο ߺ Ǿ 
	 */
	public function uninstall() { }

	/**
	 *
	 *  ÷   ȣ
	 *
	 * ÷ο ߺ Ǿ 
	 *
	 * @see adm/exe_plugin_setting.php
	 * @param array Ʈ  
	 */
	public function afterSetSetting($setting) {}

	/**
	 *
	 *  ÷     ȣ
	 *
	 * ÷ο ߺ Ǿ 
	 *
	 * @see adm/exe_plugin.php
	 * @param array Ʈ  
	 */	
	public function onUnused() {}
}
?>
