<?
/**
 *
 *  Ŭ ũƮ
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */


// easy php thumbnail Ŭ ̿
include_once WIKI_PATH."/lib/Thumb/easyphpthumbnail.class.php";

/**
 *
 *  Ŭ
 *
 * ̵/÷̹  , ϴ Ŭ
 * 
 * <b> </b>
 * <code>
 * // Ŭ ε
 * $wikiThumb =& wiki_class_load("Thumb");
 * 
 * // ̵ڿ ϵ "/images/example/bag.jpg"  
 * // ʺ 300px,  120px, ǰ 90% Ϸ 
 * //  н 
 * $thumb_path = $wikiThumb->getMediaThumb("/images/example", "bag.jpg", 300, 120, 90);
 * 
 * </code>
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinThumb extends NarinClass {

	/**
	 *
	 * @var string   
	 */
	var $thumb_path;
	
	/**
	 *
	 * @var string  URL
	 */
	var $thumb_url;	

	/**
	 * 
	 */
	public function __construct() {

		parent::__construct();
		$this->thumb_path = WIKI_PATH."/data/".$this->wiki['bo_table']."/thumb";
		$this->thumb_url = $this->wiki['url']."/data/".$this->wiki['bo_table']."/thumb";
	}

	/**
	 *
	 *  
	 *
	 * @param string $namePrefix ϸ  => "$namePrefix_ʺx"
	 */
	function deleteThumb($namePrefix) {
		if(!file_exists($this->thumb_path)) return;
		if ($handle = opendir($this->thumb_path)) {
			while (false !== ($file = readdir($handle))) {
				if ($file != "." && $file != "..") {
					if($this->_startsWith($file, $namePrefix)) {
						@unlink($this->thumb_path."/". $file);
					}
				}
			}
			closedir($handle);
		}
	}

	/**
	 *
	 *   
	 *
	 * @deprecated
	 * @param $expire_time      -   (⺻ 3)
	 * @param $trigger_time  ֱ -   (⺻ 6ð)
	 */
	function clearThumb($expire_time = 259200, $trigger_time = 21600)
	{
		$wikiConfig =& wiki_class_load("Config");
		$last_clean_time = $wikiConfig->thumb_clean_time;

		if(empty($last_clean_time)) $last_clean_time = 0;
		$ctime = time();

		// $trigger_time   Ŭ
		if($ctime - $last_clean_time > $trigger_time) {
			// $expire_time    
			$this->_clearImageCache($this->thumb_path, $expire_time);
			$wikiConfig->update("/thumb_clean_time", $ctime);
			sql_query($sql);
		}
	}

	/**
	 *
	 *    
	 *
	 * @deprecated
	 * @param string $path  丮 
	 * @param int $life  ð ( : )
	 * @param boolean $dbg ׸   
	 */
	function _clearImageCache($path, $life, $dbg = false)
	{
		// delete tmp image
		if ($handle = @opendir($path)) {
			while (false !== ($file = @readdir($handle))) {
				if ($file != "." && $file != "..") {
					$filemtime = @filemtime($path ."/". $file);  // returns FALSE if file does not exis
					$del = "";
					$ctime = time();
					$dur = $ctime - $filemtime;
					if (!$filemtime or ($dur >= $life)){
						$del = "should be deleted";
						if(!$dbg) @unlink($path ."/". $file);
					} else $del = "it's fresh!";
					if($dbg) echo ">> $file ($life, $ctime, $filemtime, $dur, $del)<br/>";
				}
			}
			closedir($handle);
		}
	}

	/**
	 *
	 * ڿ($haystack) ־ ($needle) ϴ  Ȯ
	 *
	 * @param $string ڿ
	 * @param $startString ã ڿ
	 * @return true|false ڿ  ġϸ true, ƴϸ false
	 */
	function _startsWith($string, $startString)
	{
		$length = strlen($startString);
		return (substr($string, 0, $length) == $startString);
	}

	/**
	 *
	 * Խ    н 
	 *
	 * @param int $wr_id  id
	 * @param int $thumb_width   ʺ
	 * @param int $thumb_height   
	 * @param int $img_idx  ̹ index (÷ index)
	 * @param int $quality ̹ Ƽ
	 * @param boolean $use_crop ũӱ 
	 * @return string  
	 */
	function getBoardThumb($wr_id, $thumb_width, $thumb_height, $img_idx=0, $quality=90, $use_crop=-1) {
			
		$bo_table = $this->wiki['bo_table'];
		$write_table = $this->g4[write_prefix] . $bo_table;

		$wr = sql_fetch("SELECT * FROM $write_table WHERE wr_id = $wr_id");
		if(!$wr) return;

		//   ε
		$fileinfo = get_file($bo_table, $wr_id);
			
		//  ̹  
		$file = $fileinfo[$img_idx]['path'] . '/' .$fileinfo[$img_idx]['file'];
		
		$pathinfo = pathinfo($file);
		$extension = strtolower($pathinfo[extension]);

		// Ȯ ˻ :  ̹ ƴϸ  ̹  ȯ
		if ($extension != 'jpg' && $extension != 'jpeg' && $extension != 'png' && $extension != 'gif') {
			return $file;
		}

		//  ̹ ϸ
		$filename = $fileinfo[$idx][source];
			
		//   н  (   : ԽǾ̵-ε-Ƽ)
		$thumb_name = $bo_table."-".$wr_id . "-" . $img_idx . "-". $quality ."_".$thumb_width."x".$thumb_height. "." . $extension;
		$thumb_file = $this->thumb_path."/".$thumb_name;

		//  ̹ ϸ 
		if(file_exists($thumb_file)) return $thumb_file;
			
		$thumbLib = new easyphpthumbnail;
		$thumbLib->Thumbwidth = $thumb_width;
		$thumbLib->Thumbheight = $thumb_height;
		$thumbLib->Quality = $quality;
		$thumbLib->Thumblocation = $this->thumb_path."/";
		$thumbLib->Thumbfilename = $thumb_name;
		$thumbLib->Createthumb($file, 'file');
			
		return $thumb_file;
	}

	/**
	 *
	 * ̵    н 
	 *
	 * @param string $ns ̵  
	 * @param string $filename ̵ ϸ
	 * @param int $thumb_width   ʺ
	 * @param int $thumb_height   
	 * @param int $quality  ǰ
	 * @return string  
	 */
	function getMediaThumb($ns, $filename, $thumb_width, $thumb_height, $quality=90, $crop = false) {
			
		$bo_table = $this->wiki['bo_table'];
		$write_table = $this->g4['write_prefix'] . $bo_table;

		//   ε
		$media =& wiki_class_load("Media");
		$fileinfo = $media->getFile($ns, $filename);
		if(!$fileinfo) {
			return;
		}
			
		//  ̹  
		$file = $fileinfo['path'];
		if(!file_exists($file)) return "";
		$pathinfo = pathinfo($file);
		$extension = strtolower($pathinfo['extension']);

		// Ȯ ˻ :  ̹ ƴϸ  ̹  ȯ
		if ($extension != 'jpg' && $extension != 'jpeg' && $extension != 'png' && $extension != 'gif') {
			return $this->wiki['url'] . "/data/".$this->bo_table."/files/".$fileinfo['source'];
		}

		//  ̹ ϸ
		$filename = $fileinfo['source'];
			
		//   н  (   : ԽǾ̵-ε-Ƽ)
		$croping = ($crop ? "-c" : "");
		$thumb_name = "media-".$bo_table."-".$fileinfo['id'] . "-". $quality . $croping . "_".$thumb_width."x".$thumb_height. "." . $extension;
		$thumb_file = $this->thumb_path."/".$thumb_name;
		
		//  ̹ ϸ 
		if(file_exists($thumb_file)) return $this->thumb_url . "/". $thumb_name;
			
			
		if($crop) {						
			$sizes = getimagesize($file);			
	    $source_width = $sizes[0];
	    $source_height = $sizes[1];					
			$top = $left = $right = $bottom = 0;				
			
			//  ΰ  
	    if (($source_width / $source_height) > ($thumb_width / $thumb_height)) {
	        $temp_width = $source_height * $thumb_width / $thumb_height;
	        $right = $left = ($source_width - $temp_width) / 2;
	    }			
			//  ΰ  
	    if (($source_width / $source_height) < ($thumb_width / $thumb_height)) {
	        $temp_height = $source_width * $thumb_height / $thumb_width;
	        $top = $bottom = ($source_height - $temp_height) / 2;
	    }
		}

		$thumbLib = new easyphpthumbnail;
		$thumbLib->Thumbwidth = $thumb_width;
		$thumbLib->Thumbheight = $thumb_height;
		$thumbLib->Quality = $quality;
		$thumbLib->Thumblocation = $this->thumb_path."/";
		$thumbLib->Thumbfilename = $thumb_name;
		if($crop) {
			$thumbLib->Cropimage = array(1, 1, $left, $right, $top, $bottom);
		}

		$thumbLib->Createthumb($file, 'file');
			
		return $this->thumb_url . "/".$thumb_name;
	}

}

?>
