<?
/**
 *
 * Ű ƿƼ Ŭ ũƮ
 * 
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 *
 * Ű ƿƼ Ŭ
 * 
 *  Űũ  nowiki    ȯϴ ɸ .
 *
 * <b> </b>
 * <code>
 * // Ŭ ε
 * $wikiUtil =& wiki_class_load("Util");
 * 
 * // $content  nowiki, pre, code    
 * $content = $wikiUtil->no_nowiki_content($content);


 * </code>
 *
 * @package	narinwiki
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinUtil extends NarinClass
{
	/**
	 *
	 * @var array nowiki  
	 */
	var $nowikis;

	/**
	 *
	 * @var string   id (pre, nowiki, code)
	 */
	var $current_pattern_id;

	/**
	 *
	 * @var array nowiki  迭
	 */
	protected $nowiki_patterns;

	/**
	 *
	 * 
	 */
	public function __construct() {
		parent::__construct();
		$this->nowiki_patterns = array(
		array("start_regex"=>"<pre>", "end_regex"=>"<\/pre>", "id"=>"pre"),
		array("start_regex"=>"<nowiki>", "end_regex"=>"<\/nowiki>", "id"=>"nowiki"),
		array("start_regex"=>"<code(.*?)>", "end_regex"=>"<\/code>", "id"=>"code")
		);
	}

	/**
	 *
	 * '/'   ʴ     θ 
	 *
	 * @see lib/actions/on_write_update.php
	 * @see lib/actions/on_write_comment_update.php
	 * @param string $wr_content  
	 * @return string  ũ ΰ  
	 */
	public function wiki_fix_internal_link($wr_content) {

		$nowikis = array();
		$content = $this->nowiki_backup($wr_content, $nowikis);
		$content = preg_replace_callback('/(\[\[)(.*?)(\]\])/', array($this, 'wiki_add_folder_to_link'), $content);
		$content = $this->nowiki_restore($content, $nowikis);

		return $content;
	}

	/**
	 *
	 * '/'   ʴ     θ  (ƾ)
	 *
	 * @param string $matches  Ī 
	 * @return string  ũ ΰ  
	 */
	protected function wiki_add_folder_to_link($matches) {

		$link = $matches[2];
		if(preg_match("/^#/", $link)) {
			return $matches[0];
		}
		$prefix = "[[";
		$subfix = "]]";

		if(!preg_match("/^\//", $link))	return $prefix.($this->folder == "/" ? "" : $this->folder)."/".$link.$subfix;
		else return $matches[0];
	}

	/**
	 *
	 * nowiki, pre, code ±׸   ȯ
	 *
	 * @param string $wr_content  
	 * @return string nowiki  ŵ  
	 */
	public function no_nowiki_content($wr_content) {
		$nowikis = array();
		$content = $this->nowiki_backup($wr_content, $nowikis);
		return $content;
	}


	/**
	 *
	 * nowiki  
	 *
	 * @param string $content  
	 * @param array $nowikis nowiki   
	 * @return  string nowiki  ŵ  
	 */
	public function nowiki_backup($content, &$nowikis) {
		$this->nowikis = &$nowikis;
		foreach($this->nowiki_patterns as $pattern) {
			$this->current_pattern_id = $pattern['id'];
			$regex = "/".$pattern['start_regex']."(.*?)".$pattern['end_regex'] . "/si";
			$content = preg_replace_callback($regex, array($this,"_saveNoWikiBlock"), $content);
		}
		return $content;
	}
	
	/**
	 *
	 * nowiki   :  ƾ
	 *
	 * @param array $matches  Ī 
	 * @return string nowiki ±
	 */
	protected function _saveNoWikiBlock($matches)
	{
		$id = $this->current_pattern_id;
		if(!isset($this->nowikis[$id])) $this->nowikis[$id] = array();
		array_push($this->nowikis[$id], $matches[0]);
		return "<$id></$id>";
	}

	/**
	 *
	 * nowiki  
	 *
	 * @param sitring $content  
	 * @param array $nowikis nowiki   
	 * @return string nowiki ±
	 */
	public function nowiki_restore($content, &$nowikis) {

		$this->nowikis = &$nowikis;
		asort($this->nowiki_patterns);
		foreach($this->nowiki_patterns as $pattern) {
			$this->current_pattern_id = $id = $pattern['id'];
			$regex = "/<".$pattern['id']."><\/".$pattern['id'] . ">/i";
			$content = preg_replace_callback($regex, array($this,"_restoreNoWikiBlock"), $content);
		}
		asort($this->nowiki_patterns);
		return $content;
	}

	/**
	 *
	 * nowiki   :  ƾ
	 *
	 * @param array $matches  Ī 
	 * @return string  
	 */
	protected function _restoreNoWikiBlock($matches)
	{
		$id = $this->current_pattern_id;
		$nowiki = $this->nowikis[$id][0];
		array_shift($this->nowikis[$id]);
		return $nowiki;
	}

}
?>
