<?
/**
 * 
 * Ű ڵ(code) ÷  Ŭ ũƮ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 * 
 * Ű ڵ(code) ÷ :  Ŭ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinSyntaxCode extends NarinSyntaxPlugin {

	/**
	 *
	 * @var array ڵ ӽ÷  
	 */
	var $blocks = array();

	/**
	 * Ľ ۵Ǳ   ʱȭ
	 */
	function init()
	{
		$this->blocks = array();
	}

	/**
	 * @see lib/NarinSyntaxPlugin::register()
	 */
	function register($parser)
	{
		$parser->addBlockParser(
		$id = $this->plugin_info->getId()."_wiki_code",
		$klass = $this,
		$startRegx = "&lt;code\s?([\w]{0,})&gt;",
		$endRegx = "&lt;\/code&gt;",
		$method = "wiki_code");

		/*
		$parser->addLineParser(
		$id = $this->plugin_info->getId()."_wiki_pre",
		$klass = $this,
		$regx = "^(&lt;[\/]?code&gt;)(.*?)",
		$method = "wiki_pre");
		*/
		$parser->addEvent(EVENT_AFTER_PARSING_ALL, $this, "wiki_restore_code");
	}

	/**
	 *
	 * ڵ ̶
	 * 
	 * @param array $matches ϸĪ 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string code ±
	 */
	public function wiki_code($matches, $params) {
		// $matches[1] = language
		// $matches[2] = code
		//print_r2($matches);
		if(!trim($matches[1])) {
			array_push($this->blocks, $matches[2]);
			return "<code></code>";
		}
		include_once "geshi.php";
		$geshi = new GeSHi(wiki_html($matches[2]), trim($matches[1]));
		$highlighted_code = trim(preg_replace('!^<pre[^>]*>|</pre>$!','',$geshi->parse_code()),"\n\r");
		array_push($this->blocks, $highlighted_code);
		return "<code></code>";
	}

	/**
	 *
	 * ڵ  (after line parsing)
	 * 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 */	
	public function wiki_restore_code($params) {
		$params['output'] = preg_replace_callback('/<code><\/code>/i', array($this,"_restoreCode"), $params['output']);
	}

	/**
	 *
	 * ڵ  (ƾ)
	 * 
	 * @param array $matches ϸĪ 
	 * @return string ̶  ڵ
	 */
	protected function _restoreCode($matches)
	{
		$m = $this->blocks[0];
		array_shift($this->blocks);
		// $m յڿ &nbsp;\n  ;;;;
		$m = preg_replace("/^(&nbsp;\s)/i", "", $m);
		$m = preg_replace("/(&nbsp;)$/i", "", $m);
		return "\n<pre class='wiki_code'>".$m."</pre><!--// code -->\n";
	}
}



?>
