<?
/**
 *
 * Ű Columns ÷  Ŭ ũƮ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 *
 * Ű Columns ÷ :  Ŭ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinSyntaxColumns extends NarinSyntaxPlugin {
	
	/**
	 *
	 * @var Į尡 ۵ǰ ù Į ȴ Ÿ flag
	 */
	var $opened;
	
	/**
	 *
	 * @var Į尡 ۵   ⺻ ļ section  
	 */
	var $prevSections;

	/**
	 *
	 * @var Į尡 ۵   ⺻ ļ section_level  
	 */	
	var $prevSectionLevel;

	/**
	 * Ľ ۵Ǳ   ʱȭ
	 */
	function init()
	{
		$this->opened = false;		
	}

	/**
	 *
	 * @see lib/NarinSyntaxPlugin::register()
	 */
	function register($parser)
	{
		// Į  (table)
		$parser->addLineParser(
	          $id = "wiki_columns_open",
	          $klass = $this,
	          $regx = "^&lt;columns(.*?)&gt;$",
	          $method = "columns_start");
		          
		//  Į (td)		          
		$parser->addLineParser(
	          $id = "wiki_columns_new",
	          $klass = $this,
	          $regx = "^&lt;col(.*?)&gt;$",
	          $method = "columns_new");		
	          
		//   (tr)		          
		$parser->addLineParser(
	          $id = "wiki_columns_newrow",
	          $klass = $this,
	          $regx = "^&lt;row(.*?)&gt;$",
	          $method = "columns_new_row");			          
		          
		// Į  (/table)		          
		$parser->addLineParser(
	          $id = "wiki_columns_close",
	          $klass = $this,
	          $regx = "^&lt;\/columns&gt;$",
	          $method = "columns_close");				          
		                    
	}

	/**
	 * 
	 * ÷ 
	 * 
	 * @param array $matches ϸĪ 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string HTML ±
	 */
	public function columns_start($matches, $params) {
		$params['parser']->stop = true;
		$this->save_section(&$params);
		return $this->get_close(&$params).'<!-- wiki_columns--><div style="overflow:hidden;"><table class="wiki_columns" border="0" cellspacing="0" cellpadding="0" '.strip_tags($matches[1]).'><tr>';
	}
	
	/**
	 * 
	 *  Į
	 * 
	 * @param array $matches ϸĪ 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string HTML ±
	 */
	public function columns_new($matches, $params) {
		$params['parser']->stop = true;
		$closeTd = ($this->opened ? '</td>' : '');
		$this->opened = true;
		return $this->get_close(&$params).$closeTd.'<td '.strip_tags($matches[1]).'>';
	}
	
	/**
	 * 
	 *  
	 * 
	 * @param array $matches ϸĪ 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string HTML ±
	 */
	public function columns_new_row($matches, $params) {
		$params['parser']->stop = true;
		$this->opened = false;
		return $this->get_close(&$params).'</td><tr '.strip_tags($matches[1]).'>';
	}	
	

	/**
	 * 
	 * ÷ ݱ
	 * 
	 * @param array $matches ϸĪ 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string HTML ±
	 */
	public function columns_close($matches, $params) {
		$params['parser']->stop = true;
		$this->opened = false;
		$closeTag = $this->get_close(&$params);
		$this->recover_section(&$params);
		return $closeTag."</td></tr></table></div><!--// wiki_columns -->";
	}

	/**
	 * 
	 * ÷ 忡  section  section_level 
	 * 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 */
	protected function save_section($params) {
		$plugins = &$params['plugins'];
		$default = &$plugins[array_search('wiki_default_parser', $plugins)];
		$this->prevSections = $default->sections;
		$this->prevSectionLevel = $default->section_level;
		$default->sections = array();
		$default->section_level = -1;			
	}
	
	/**
	 * 
	 * ÷ 忡  section  section_level 
	 * 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 */
	protected function recover_section($params)
	{
		$plugins = &$params['plugins'];
		$default = &$plugins[array_search('wiki_default_parser', $plugins)];
		$default->sections = $this->prevSections;
		$default->section_level = $this->prevSectionLevel;		
	}
	
	/**
	 * 
	 * ⺻  ؼ  ± 
	 *   - section, table, p, ul, ol  ±װ  ݾ
	 * 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string ݴ ±
	 */
	public function get_close($params) {
		$plugins = &$params['plugins'];
		$default = &$plugins[array_search('wiki_default_parser', $plugins)];

		$close_tag = '';
		
		if ($default->list_level>0)
		{
			$close_tag .= $default->wiki_list(false, array(), '', '', true);
		}
		if ($default->boxformat)
		{
			$close_tag .= $default->wiki_box(false, array(), true);
		}
		if ($default->pformat)
		{
			$close_tag .= $default->wiki_par(false, array(), true);
		}
		if ($default->table_opened)
		{
			$close_tag .= $default->wiki_table(false, array(), true);
		}
		
		while($pSection = array_pop($default->sections)) {
			$close_tag .= $pSection['close_tag'];
		}			
				
		return $close_tag;						
	}
}

?>
