<?
/**
 * 
 * Ű  ÷  Ŭ ũƮ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 * 
 * Ű  ÷ : ÷  Ŭ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
 
class NarinPluginInfoGallery extends NarinPluginInfo {

	/**
	 *
	 * @var string  JS  
	 */
	var $data_js_file;
	
	/**
	 *
	 * @var string  CSS  
	 */
	var $data_css_file;	


	/**
	 * 
	 */
	public function __construct() {
		
		parent::__construct();			
		
		$this->id = "wiki_gallery";				
		$this->data_js_file = $this->data_path."/js/gallery_plugin.js";
		$this->data_css_file = $this->data_path."/css/gallery_plugin.css";
		
		// {@link NarinPluginInfo} Ŭ ڿ getSetting()  ȣ		
		$this->init();
	}

	/**
	 * 
	 * ÷ 
	 * 
	 * @return string ÷ 
	 */
	public function description()
	{
		return " ÷ ( : byfun, byfun@byfun.com)";
	}

	/**
	 * 
	 * js   ġ
	 * 
	 * @see lib/NarinPluginInfo::shouldInstall()
	 */
	public function shouldInstall() {	
		return !file_exists($this->data_js_file) || !file_exists($this->data_css_file);
	}

	/**
	 * 
	 * js   
	 * 
	 * @see lib/NarinPluginInfo::shouldUnInstall()
	 */
	public function shouldUnInstall() {
		return file_exists($this->data_js_file) && file_exists($this->data_css_file);
	}

	/**
	 * 
	 * ġ : js    
	 * 
	 * @see lib/NarinPluginInfo::install()
	 */
	public function install() {
		$this->setJsCss();
	}

	/**
	 * 
	 *  : js  
	 * 
	 * @see lib/NarinPluginInfo::uninstall()
	 */
	public function uninstall() {
		// data  js  
		@unlink($this->data_js_file);
		@unlink($this->data_css_file);
		$this->wiki_config->delete('/plugin_setting/' . $this->id);
	}

	/**
	 * 
	 *   ÷  
	 * js  ٽ 
	 * 
	 * @see lib/NarinPluginInfo::afterSetSetting()
	 */
	public function afterSetSetting($setting) {
		$this->setJsCss($setting['css']);
	}


	/**
	 *
	 * @see lib/NarinPluginInfo::getSetting()
	 */
	public function getSetting() {
		$css = file_exists($this->data_css_file) ? file_get_contents($this->data_css_file) : file_get_contents($this->plugin_path."/gallery.css");
		return array("css"=>array("type"=>"textarea", 
															"label"=>"CSS : ", 
															"desc"=>" CSS ּ.", 
															"value"=>$css));
	}

	/**
	 * 
	 * JS    ۼ
	 * 
	 */
	protected function setJsCss($css = "")
	{
		
		$js = file_get_contents($this->plugin_path."/gallery.js");
		if(!$css) $css = file_get_contents($this->plugin_path."/gallery.css");
		
		// js  ۼ
		$fp = fopen($this->data_js_file, "w");
		fwrite($fp, $js);
		fclose($fp);
		
		// css  ۼ
		$fp = fopen($this->data_css_file, "w");
		fwrite($fp, $css);
		fclose($fp);
	}

}



?>
