<?
/**
 *
 * Ű HTML ÷  Ŭ ũƮ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 *
 * Ű HTML ÷ :  Ŭ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinSyntaxHtml extends NarinSyntaxPlugin {

	/**
	 *
	 * @var array HTML ڵ  ӽ÷  
	 */
	var $blocks = array();

	/**
	 *
	 * @var int HTML  
	 */
	var $allow_level;

	/**
	 *
	 * @var int script ±  
	 */
	var $allow_script_level;

	/**
	 *
	 * @var int iframe ±  
	 */
	var $allow_iframe_level;

	/**
	 *
	 * @var int ۼ ȸ level
	 */
	var $writer_level = -1;
	 
	/**
	 * Ľ ۵Ǳ   ʱȭ
	 */
	function init()
	{
		$this->blocks = array();
		$this->writer_level = -1;
	}

	/**
	 *
	 * @see lib/NarinSyntaxPlugin::register()
	 */
	function register($parser)
	{
		$setting = $this->plugin_info->getPluginSetting();
		$this->allow_level = $setting['allow_level']['value'];
		$this->allow_iframe_level = $setting['allow_iframe_level']['value'];
		$this->allow_script_level = $setting['allow_script_level']['value'];

		$parser->addBlockParser(
		$id = $this->plugin_info->getId()."_wiki_html",
		$klass = $this,
		$startRegx = "&lt;(html)&gt;",
		$endRegx = "&lt;\/html&gt;",
		$method = "wiki_html");

		$parser->addEvent(EVENT_AFTER_PARSING_ALL, $this, "wiki_restore_html");
	}

	/**
	 * 
	 * HTML ȯ
	 * 
	 * @param array $matches ϸĪ 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string HTML ±
	 */
	public function wiki_html($matches, $params) {
		// $matches[1] = html Ǵ HTML
		// $matches[2] = content

		// ۼ  
		if($this->writer_level < 0) {
			if($params['view']['mb_id']) {
				$writer = get_member($params['view']['mb_id']);
				$this->writer_level = $writer['mb_level'];
			} else $this->writer_level = 0;
		}

		// HTML  
		if($this->allow_level > $this->writer_level) return $matches[2];

		array_push($this->blocks, $matches[2]);
		return "<".$matches[1]."></".$matches[1].">";
	}

	/**
	 *
	 * ڵ  (after line parsing)
	 * 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 */	
	public function wiki_restore_html($params) {
		if($this->allow_level > $this->writer_level) return;

		$params['output'] = preg_replace_callback('/<(html)><\/html>/i', array($this,"_restoreHtml"), $params['output']);
	}

	/**
	 *
	 * ڵ  (ƾ)
	 * 
	 * @param array $matches ϸĪ 
	 * @return string HTML ȯ  ڵ
	 */
	protected function _restoreHtml($matches)
	{
		$m = $this->blocks[0];
		array_shift($this->blocks);

		// text -> html
		$html = wiki_html($m);

		//  ± 
		$html = $this->bad_tag_convert($html);

		// script ± 
		if($this->allow_script_level > $this->writer_level) $html = $this->prevent_script($html);

		// iframe ± 
		if($this->allow_iframe_level > $this->writer_level) $html = $this->prevent_iframe($html);

		// 
		if($matches[1] == "HTML") return "<div class='wiki_box'>".$html."</div>";
		else return $html;
	}

	/**
	 * 
	 *  ± ȯ (g4/lib/common.lib.php  )
	 * 
	 * @param string $html HTML 
	 * @return ȯ HTML
	 */
	protected function bad_tag_convert($html)
	{
		if ($this->is_admin && $this->member['mb_id'] != $this->write['mb_id']) {
			// embed Ǵ object ±׸  ʴ  ͸ ǵ 
			$html = preg_replace_callback("#(\<(embed|object)[^\>]*)\>?(\<\/(embed|object)\>)?#i",
			create_function('$matches', 'return "<div class=\"embedx\">ȹ Ͽ  ̵δ embed Ǵ object ±׸   ϴ. ȮϽ÷   ٸ ̵ ϼ.</div>";'),
			$html);
		}
		return $html;
	}

	/**
	 * 
	 * script ± 
	 * 
	 * @param string $html HTML 
	 * @return ȯ HTML
	 */
	protected function prevent_script($html)
	{
		return preg_replace("/\<([\/]?)(script)([^\>]*)\>?/i", "&lt;$1$2$3&gt;", $html);
	}

	/**
	 * iframe ± 
	 * 
	 * @param string $html HTML 
	 * @return ȯ HTML
	 */
	protected function prevent_iframe($html)
	{
		return preg_replace("/\<([\/]?)(iframe)([^\>]*)\>?/i", "&lt;$1$2$3&gt;", $html);
	}

}

?>
