<?
/**
 *
 * Ű Ʈ ÷  Ŭ ũƮ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 *
 * Ű Ʈ ÷ :  Ŭ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinSyntaxList extends NarinSyntaxPlugin {
	 
	/**
	 *
	 * @see lib/NarinSyntaxPlugin::register()
	 */
	function register($parser)
	{
		$parser->addVariableParser(
          $id = "wiki_list",
          $klass = $this,
          $startRegx = "list=",	// list=
          $endRegx = "((\?)(.*?))?",	// Ķ ?  ڿ (optional)
          $method = "wiki_list");
	}

	/**
	 * 
	 * HTML ȯ
	 * 
	 * @param array $matches ϸĪ 
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string HTML ±
	 */
	public function wiki_list($matches, $params) {
		// $matches[1] = list=
		// $matches[1] = 
		// $matches[4] = Ķ
		
		$args = array();

		if($matches[4]) {
			parse_str($matches[4], $args);	
		}
				
		$args['path'] = $matches[1];

		$list = $this->wiki_list_nojs($args, &$params);
		
		$options = wiki_json_encode($args);		
		
		return '<nocache plugin="list" method="cache_render" params="'.addslashes($options).'">'.$list.'</nocache>';
		//return $list.'<div class="wiki_lister" style="display:none">'.$options.'</div>';
	}

	/**
	 * 
	 * κ ĳ  Լ
	 * 
	 * @param array $args {@link narin.php}  ϴ Ķ
	 * @return string HTML ±
	 */
	public function cache_render($args) {
		return $this->wiki_list_nojs($args, null);
	}

	/**
	 * 
	 * ڹٽũƮ  ʴ 
	 * 
	 * @param array $args ֱٹ м Ķ
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string HTML ±
	 */
	protected function wiki_list_nojs($args, $params) {

		define("_LIST_PLUGIN_", 1);
		include_once dirname(__FILE__).'/list.lib.php';
		
		$recursive = (isset($args['nosub']) ? false : true);
		$rows = (isset($args['rows']) ? $args['rows'] : 5);
		$cutstr = (isset($args['title_length']) ? $args['title_length'] : 512);
		$dateformat = (isset($args['dateformat']) ? $args['dateformat'] : "Y-m-d h:i:s");
		$current_time = $this->g4['time_ymdhis'];
		$reverse = (isset($args['reverse']) ? true : false);
		$with_content = ($args['type'] == 'webzine' ? true : false);
		
		$args['emp'] = (isset($args['emp']) ? $args['emp'] : 0);
		$args['emp_style'] = (isset($args['emp_style']) ? $args['emp_style'] : 'font-weight:bold');
		$args['field'] = isset($args['field']) ? $args['field'] : 'title,editor,date';
		$args['title_length'] = isset($args['title_length']) ? $args['title_length'] : 512;
		$args['order'] = isset($args['order']) ? $args['order'] : 'date';
		
		$wild = '';
		foreach($args as $k => $v) {
			if(strpos($k, '*') !== false) {
				$wild = $k;				
				break;				
			}
		}		
		
		$list = wiki_list_docs($this->wiki, $this->g4, stripslashes($args['path']), $args['order'], $wild, $recursive, $dateformat, $rows, $cutstr, $reverse, $with_content);
		
		// TODO :   ()
		if($args['type'] == 'table' || $args['type'] == 'webzine') return $this->render_table($args, &$list, &$params);
		else return $this->render_list($args, &$list, &$params);
		
	}
	
	/**
	 * 
	 *  · 
	 * 
	 * @param array $args ֱٹ м Ķ
	 * @param array $list ֱٹ
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string HTML ±
	 */
	protected function render_list($args, $list, $params) {	
				
		$div = '';
		$ul = '<ul class="wiki_list wiki_list_1 list_list">';
		
		// 
		for($i=0; $i<count($list); $i++) {
			$item = $list[$i];
			
			$emp = '';
			if($args['emp'] > 0) {
				if($this->elapsed_hour($item['datetime']) <= $args['emp']) {
					$emp = ' '.$args['emp_style'];
				}
			}		
			$row = '<li><a href="'.$item['href'].'" class="wiki_active_link list_title" style="'.$args['title_style'].$emp.'">'.$item['title'].'</a>';
			if(!isset($args['nocomment']) && $item['comments'] > 0) {
				$row .= '<span class="list_comment" style="'.$args['comment_style'].'">('.$item['comments'].')</span>';
			}

			if(isset($args['showfolder'])) {
				$row .= '<span class="list_folder" style="'.$args['folder_style'].'">'.$item['ns'].'</span>';
			}
			
			if(isset($args['showeditor'])) {
				$name = $item['name'];
				if(isset($args['usename'])) $name = $item['name'];
				else if(isset($args['usenick'])) $name = $item['nick'];
				
				$row .= '<span class="list_editor" style="'.$args['folder_style'].'">'.$name.'</span>';
			}	
			
			if(isset($args['showdate'])) {
				$date = $item['date'];
				if(isset($args['elapsed'])) $date = $item['elapsed'];
				$row .= '<span class="list_date" style="'.$args['date_style'].'">'.$date.'</span>';
			}					
			
			$row .= '</li>';

			$ul .= $row;
		}		
				
		unset($list);				
		return $ul.'</ul>';
		
	}
	
	/**
	 * 
	 * ̺ · 
	 * 
	 * @param array $args ֱٹ м Ķ
	 * @param array $list ֱٹ
	 * @param array $params {@link NarinParser}  ϴ Ķ
	 * @return string HTML ±
	 */
	protected function render_table($args, $list, $params) {	

		$head = array('title'=>'', 'date'=>'¥', 'editor'=>'', 'hits'=>'ȸ');
		
		$field = explode(',', str_replace(' ', '', $args['field']));
		
		$table_style = (isset($args['table_style']) ? ' style="'.$args['table_style'].'"' : '');
		
		// ̺ 
		$table = '<table cellspacing="0" cellpadding="0" class="list_table" '.$table_style.'>';

		if(isset($args['elapsed'])) $head['date'] = 'ð';
		
		// ̺ ص
		if(!isset($args['nohead'])) {
			$table .= '<thead><tr>';
			for($i=0; $i<count($field); $i++) {
				$table .= '<td class="list_'.$field[$i].'">'.$head[$field[$i]].'</td>';
			}
			$table .= '</tr></thead>';
		}

		$table .= '<tbody>';

		// ̺ ٵ
		for($i=0; $i<count($list); $i++) {

			$item = $list[$i];
			$td = '';
			
			
			// ʵ  
			for($j=0; $j<count($field); $j++) {
				$content = $item[$field[$j]];
				$td .= '<td class="list_'.$field[$j].'" style="'.$args[$field[$j].'_style'].'">';
				
				// ʵ : Ʈ
				if($field[$j] == 'date') {
					if(isset($args['elapsed'])) $content = $item['elapsed'];					
				}
				
				// ʵ : 
				if($field[$j] == 'editor') {
					if(isset($args['usename'])) { 
						$content = $item['name'];
					} else if(isset($args['usenick'])) { 
						$content = $item['nick'];
					}
				}	
				
				// ʵ : 
				if($field[$j] == 'title') {

					$emp = '';
					if($args['emp'] > 0) {
						if($this->elapsed_hour($item['datetime']) <= $args['emp']) {
							$emp = ' style="'.$args['emp_style'].'"';
						}
					}

					//  ũ
					$content = '<a href="'.$item['href'].'" class="wiki_active_link" '.$emp.'>'.$content.'</a>';
					
					// 
					if(!isset($args['nocomment']) && $item['comments'] > 0) {
						$content .= '<span class="list_comment">'.$item['comments'].'</span>';
					}				
					
					// 	
					if(!isset($args['nofolder'])) {
						$content .= '<span class="list_folder">'.$item['ns'].'</span>';
					}
					
					// TODO :  ̱ ()
					//
					//if($args['type'] == 'webzine') {
					//	$content .= '<div class="list_content" style="width:100%;overflow:auto">'.$item['content'].'</div>';
					//}			
										
				}
				
				// TD  ߰
				$td .= $content . '</td>';
				
			} // for $j
						
			// TABLE TR ߰
			$table .= '<tr>'.$td.'</tr>';
			
		} // for $i

		$table .= '</tbody></table>';

		unset($list);
		return $table;
	}
		
	
	
	protected function elapsed_hour($datetime) {
		return (strtotime($this->g4['time_ymdhis']) - strtotime($datetime)) / 3600;
	}
}



?>
