<?
/**
 * 
 * Ű (Lock) ÷ ׼ Ŭ ũƮ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 * 
 * Ű (Lock) ÷ : ׼ Ŭ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinActionLock extends NarinActionPlugin {
	
	/**
	 * 
	 * @var string ÷ id
	 */	
	var $id;

	/**
	 * 
	 * @var boolean  ΰ
	 */	
	var $locked;
	
	/**
	 * 
	 * @var boolean ʱȭ Ǿ°
	 */	
	var $initialized = false;
	
	/**
	 * 
	 * @var int ʵ lock  ΰ
	 */	
	var $lock_life = 40;
	
	/**
	 * 
	 * 
	 */
	public function __construct() {
		$this->id = "wiki_action_lock";		
		parent::__construct();
	}	  	

	/**
	 * 
	 * @see lib/NarinActionPlugin::register()
	 */
	public function register($ctrl)
	{
		$ctrl->addHandler("WRITE_HEAD", $this, "on_write_head");
		$ctrl->addHandler("WRITE_UPDATE_HEAD", $this, "on_write_update_head");
		$ctrl->addHandler("WRITE_UPDATE", $this, "on_write_update");
		$ctrl->addHandler("PX_LOCK_KEEP_ALIVE", $this, "on_keep_alive");
		$ctrl->addHandler("PX_LOCK_UNLOCK", $this, "on_unlick");
		$ctrl->addHandler("LOAD_HEAD", $this, "on_load");
	}	
	
	/**
	 * 
	 *  ۼ  ε
	 * 
	 *  ִ ִ ȮϿ,
	 * head ڹٽũƮ wiki_is_locked  Ѵ.
	 * 
	 * @param array $params {@link NarinEvent)  Ѱִ Ķ
	 */
	public function on_load($params) {
		if($params['script'] != 'write.php') return;
		
		$setting = $this->plugin_info->getPluginSetting();
		list($ns, $docname, $doc) = wiki_page_name($params['doc']);
		
		$this->initialize_lock($doc);		
		
		$l_duration = ( time() - $this->locked['time'] );	// in sconds
		$wiki_is_locked = ( $this->lock_life < $l_duration ? "false" : "true" );
		
		echo <<<END
<script type="text/javascript">
var wiki_is_locked = $wiki_is_locked;
</script>			

END;

	}
	
	/**
	 * 
	 *  ۼ ε
	 * 
	 *  lock Ǿִ ˻ϰ lock
	 * 
	 * @param array $params {@link NarinEvent)  Ѱִ Ķ
	 */
	public function on_write_head($params) {		
		if($this->plugin_info->shouldInstall()) return;
		$doc = $params['doc'];
		$setting = $this->plugin_info->getPluginSetting();
		$this->initialize_lock($doc);
		if(!$this->locked) {
			$this->lock($doc);
		} else {
			$l_duration = ( time() - $this->locked['time'] );	// in seconds
			if($this->lock_life > $l_duration) {
				$wikiControl =& wiki_class_load("Control");
				$wikiControl->error(" ", " Դϴ.");
			} else {
				$this->lock($doc);
			}
		}
	}
	
	/**
	 * 
	 *  
	 * 
	 * lock ˻ : Ҷ ٸ ڰ ̶  
	 * 
	 * @param array $params {@link NarinEvent)  Ѱִ Ķ
	 */
	public function on_write_update_head($params) {
		list($ns, $docname, $doc) = wiki_page_name($params['wr_doc']);
		$this->initialize_lock();
		if($this->locked && $this->locked['ip'] != $this->user_ip) {
			alert(" Դϴ.");
		}
	}	
	
	/**
	 *   
	 * 
	 * lock 
	 * 
	 * @param array $params {@link NarinEvent)  Ѱִ Ķ
	 */
	public function on_write_update($params) {
		list($ns, $docname, $doc) = wiki_page_name($params['wr_doc']);
		$this->unlock($doc);
	}
	
	/**
	 * 
	 *  ۼ  keep_alive AJAX ݿ  
	 * 
	 * ajax  lock 
	 * 
	 * @param array $params {@link NarinEvent)  Ѱִ Ķ
	 */
	public function on_keep_alive($params) {
		list($ns, $docname, $doc) = wiki_page_name(stripslashes($params['post']['doc']));
		$doc_code = md5($doc);		

		$this->initialize_lock($doc);			
		if(!$this->locked) { echo "0"; return; }	// lock Ǿ   extend   			
		if($this->locked['ip'] != $this->user_ip) { echo "0"; return; }	// ڽ lock   extend   
		$this->lock($doc);
		echo "keep alive";
	}
	
	/**
	 * 
	 *  ۼ  unlick AJAX ݿ  
	 * 
	 * ajax  lock 
	 * 
	 * @param array $params {@link NarinEvent)  Ѱִ Ķ
	 */
	public function on_unlock($params) {
		list($ns, $docname, $doc) = wiki_page_name(stripslashes($params['post']['doc']));
		$doc_code = md5($doc);		
		$this->initialize_lock($doc);			
		if($this->locked['ip'] != $this->user_ip) { echo "0"; return; }	// ڽ lock   unlock   
		$this->unlock($doc);
		echo "unlock";
	}	
	
	/**
	 * 
	 * °?
	 * 
	 * @param string $doc θ  
	 */
	protected function initialize_lock($doc) {
		if($this->initialized) return;
		$doc_code = md5($doc);
		$this->locked = wiki_get_option("locked_docs/$doc_code");
		$this->initialized = true;
	}
	
	/**
	 * 
	 *  	
	 * 
	 * @param string $doc θ  
	 */
	protected function lock($doc) {
		$doc_code = md5($doc);
		wiki_set_option("locked_docs/$doc_code", array("time", "ip"), array(time(), $this->user_ip));		
	}
	
	/**
	 * 
	 *   
	 * 
	 * @param string $doc θ  
	 */
	protected function unlock($doc) {
		$doc_code = md5($doc);		
		wiki_set_option("locked_docs/$doc_code", null, null);	// remove
	}
}


?>
