<?
/**
 * 
 * Ű (Lock) ÷  Ŭ ũƮ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 * @filesource
 */

/**
 * 
 * Ű (Lock) ÷ : ÷  Ŭ
 *
 * @package	narinwiki
 * @subpackage plugin
 * @license GPL2 (http://narinwiki.org/license)
 * @author	byfun (http://byfun.com)
 */
class NarinPluginInfoLock extends NarinPluginInfo {

	/**
	 *
	 * @var string  JS  
	 */
	var $data_js_file;

	/**
	 *
	 * @var int LOCK  ð ⺻ : 15
	 */
	var $default_release_time = 15;

	/**
	 * 
	 */
	public function __construct() {		
		parent::__construct();
		
		$this->id = "wiki_lock";
		$this->data_js_file = $this->data_path."/js/lock_plugin.js";
		$this->init();
	}

	/**
	 * 
	 * ÷ 
	 * 
	 * @return string ÷ 
	 */
	public function description()
	{
		return " Lock ÷ ( : byfun, byfun@byfun.com)";
	}

	/**
	 * 
	 * js   ġ
	 * 
	 * @see lib/NarinPluginInfo::shouldInstall()
	 */
	public function shouldInstall() {
		return !file_exists($this->data_js_file);
	}

	/**
	 * 
	 * js   
	 * 
	 * @see lib/NarinPluginInfo::shouldUnInstall()
	 */
	public function shouldUnInstall() {
		return file_exists($this->data_js_file);
	}

	/**
	 * 
	 * ġ : js    
	 * 
	 * @see lib/NarinPluginInfo::install()
	 */
	public function install() {
		$this->setJs($this->default_release_time);
	}

	/**
	 * 
	 *  : js  
	 * 
	 * @see lib/NarinPluginInfo::uninstall()
	 */
	public function uninstall() {
		// data  js  
		@unlink($this->data_js_file);
		//  ÷  
		$this->wiki_config->delete('/plugin_setting/' . $this->id);
	}

	/**
	 * 
	 *   ÷  
	 * js  ٽ 
	 * 
	 * @see lib/NarinPluginInfo::afterSetSetting()
	 */
	public function afterSetSetting($setting) {
		$this->setJs($setting['lock_release_time']);
	}


	/**
	 *
	 * @see lib/NarinPluginInfo::getSetting()
	 */
	public function getSetting() {
		$option = array();
		for($i=2; $i<=60; $i+=1) array_push($option, $i);
		return array(
			"lock_release_time"=>array("type"=>"select", "label"=>"Lock  ð", "desc"=>" ð Է  lock  մϴ. ( : )", "options"=>$option, "value"=>$this->default_release_time)
		);
	}

	/**
	 * 
	 * JS    ۼ
	 * 
	 * @param int $release_time LOCK  ð ( : )
	 */
	protected function setJs($release_time)
	{
		// js  ۼ
		$fp = fopen($this->data_js_file, "w");
		fwrite($fp, $this->js($release_time));
		fclose($fp);
	}

	/**
	 * 
	 *  JS 
	 * 
	 * @param int $release_time LOCK  ð ( : )
	 */
	protected function js($release_time) {

		$expire_time = ($release_time) * 60 * 1000;
		$alert_time = ($release_time - 1) * 60 * 1000;

		return <<<END


// write.php  
if(wiki_script == 'write.php') {

	var lock_expire_timer;
	var lock_keep_alive_timer;
	var lock_alert_timer;
	var lock_expired = false;
	
	function lock_alert()
	{
		lock_alert_timer = setTimeout(function() {
			$("#confirm_lock_extend").trigger('click');
		}, $alert_time);
	}
	
	function lock_expire()
	{
		lock_expire_timer = setTimeout(function() {									
			lock_expired = true;
			lock_do_unlock();
			clearTimeout(lock_alert_timer);
			clearTimeout(lock_keep_alive_timer);			
			alert('  Ǿϴ.\\n   ٸ ڰ   ۼ̶  ʽϴ.\\nۼ̴  ٸ  Ͻð ϼ.');	
			$.wiki_lightbox_close();
		}, $expire_time);
		
	}	
	
	function lock_keep_alive() {
		lock_keep_alive_timer = setInterval(function() {
			lock_do();
		}, 30000);		
	}
	
	function lock_do() {
		$.post(wiki_url+"/p.php", { p : "lock", m : "keep_alive", bo_table : g4_bo_table, doc : wiki_doc }, function(data) {
		});			
	}
	
	function lock_do_unlock() {
		$.ajaxSetup({async:false, global: false});
		$.post(wiki_url+"/p.php", { p : "lock", m : "unlock", bo_table : g4_bo_table, doc : wiki_doc }, function(data) {
			
		});			
	}	
	
	function lock_extend()
	{
		clearTimeout(lock_alert_timer);
		clearTimeout(lock_expire_timer);
		lock_alert();
		lock_expire();
		$.wiki_lightbox_close();
	}
	
	function close_lock_dialog() {		
		$.wiki_lightbox_close();
	}
	
	if(typeof wiki_is_locked != 'undefined' && !wiki_is_locked) {
		$(document).ready(function() {
	
				lc_link = $("<a></a>").attr('href', '#lock_msg').attr('id', 'confirm_lock_extend').attr('style', 'display:none');
				lc_dialog = $("<div></div>").attr('style', 'display:none;').html([
					"<div id='lock_msg'>",
					"<div style='background-color:#3A3A3A;padding:5px;color:#fff;margin-bottom:10px;font-size:14pt;font-weight:bold;'>  </div>",
					"<div style='line-height:170%'>",
					"1    ˴ϴ.  ٽ ׽ðڽϱ?<br/>",
					"  Ǹ ٸ     <br/>",
					"ٸ   ̶    Ե˴ϴ.",
					"</div>",
					"<div style='text-align:center;margin-top:10px;padding-top:10px;border-top:1px dashed #ccc'><span class='button green'><a href='javascript:lock_extend();'></a></span>&nbsp;",
					"<span class='button'><a href='javascript:close_lock_dialog();'>ƴϿ</a></span></div>",
					"</div>"
				].join(''));
				$(document.body).append(lc_link);
				$(document.body).append(lc_dialog);
				lc_link.wiki_lightbox({'hideOnOverlayClick' : false, 
															 'enableEscapeButton' : false});	
				lock_alert();			
				lock_expire();	
				lock_do();
				lock_keep_alive();		
		});	

		$(window).unload(function() {
			lock_do_unlock();
		});

		$(window).bind('beforeunload', function(){
		  return ' ʰ ٸ  ̵Ͻðڽϱ?';
		});
				
	}
}		

		
END;

	}
}



?>
