var procD, codeD, numD, priceD, nameD;
var divCode, sumCode, addCode, delCode;

$(function() {
	$( "#adminBox" ).accordion({
		autoHeight: false,
		navigation: true
	});

	$( "#newStockNum" ).buttonset();
	$( "#newStockPrice" ).buttonset();

	$( "#newStockBtn" ).button().click(function(){
		procD = "insert";
		codeD = $( "#newStockName" ).val();
		numD = $( "[name = newStockNum]:checked" ).val();
		priceD = $( "[name = newStockPrice]:checked" ).val();
		updateStock(procD, codeD, numD, priceD);

		return false;
	});

	$( "#divStockNum" ).buttonset();

	$( "#divGetStockBtn" ).button().click(function(){
		divCode = "";
		$( "#divStockInfo" ).html( "&nbsp;" );
		procD = "info";
		nameD = $( "#divStockName" ).val();
		getStockInfo(procD, nameD, "divStockInfo", "div");

		return false;
	});

	$( "#divStockBtn" ).button().click(function(){
		if (!divCode) {
			dialog_show("확인된 기업정보가 없습니다.");
			return false;
		}

		procD = "div";
		codeD = divCode;
		numD = $( "[name = divStockNum]:checked" ).val();
		priceD = 1;
		updateStock(procD, codeD, numD, priceD);

		$( "#divStockInfo" ).html( "&nbsp;" );
		divCode = "";

		return false;
	});

	$( "#sumStockNum" ).buttonset();

	$( "#sumGetStockBtn" ).button().click(function(){
		sumCode = "";
		$( "#sumStockInfo" ).html( "&nbsp;" );
		procD = "info";
		nameD = $( "#sumStockName" ).val();
		getStockInfo(procD, nameD, "sumStockInfo", "sum");

		return false;
	});

	$( "#sumStockBtn" ).button().click(function(){
		if (!sumCode) {
			dialog_show("확인된 기업정보가 없습니다.");
			return false;
		}

		procD = "sum";
		codeD = sumCode;
		numD = $( "[name = sumStockNum]:checked" ).val();
		priceD = 1;
		updateStock(procD, codeD, numD, priceD);

		$( "#sumStockInfo" ).html( "&nbsp;" );
		sumCode = "";

		return false;
	});

	$( "#addStockNum" ).buttonset();

	$( "#addGetStockBtn" ).button().click(function(){
		addCode = "";
		$( "#addStockInfo" ).html( "&nbsp;" );
		procD = "info";
		nameD = $( "#addStockName" ).val();
		getStockInfo(procD, nameD, "addStockInfo", "add");

		return false;
	});

	$( "#addStockBtn" ).button().click(function(){
		if (!addCode) {
			dialog_show("확인된 기업정보가 없습니다.");
			return false;
		}

		procD = "add";
		codeD = addCode;
		numD = $( "[name = addStockNum]:checked" ).val();
		priceD = 1;
		updateStock(procD, codeD, numD, priceD);

		$( "#addStockInfo" ).html( "&nbsp;" );
		addCode = "";

		return false;
	});

	$( "#delStockNum" ).buttonset();

	$( "#delGetStockBtn" ).button().click(function(){
		delCode = "";
		$( "#delStockInfo" ).html( "&nbsp;" );
		procD = "info";
		nameD = $( "#delStockName" ).val();
		getStockInfo(procD, nameD, "delStockInfo", "del");

		return false;
	});

	$( "#delStockBtn" ).button().click(function(){
		if (!delCode) {
			dialog_show("확인된 기업정보가 없습니다.");
			return false;
		}

		procD = "del";
		codeD = delCode;
		numD = 1;
		priceD = 1;
		updateStock(procD, codeD, numD, priceD);

		$( "#delStockInfo" ).html( "&nbsp;" );
		delCode = "";

		return false;
	});
});

// 상장/분할/병합/증자/폐지
function updateStock(proc, code, num, price) {
	$.ajax({
        url: "stock_admin_exec.php",
		data : "proc="+proc+"&code="+encodeURIComponent(code)+"&num="+num+"&price="+price,
        type: "POST",
		timeout : 10000,
        dataType: "json",
        async: false,
        cache: false,
        success: function(data) {
			dialog_show(data.msgcode);
        },
		error: function(data) {
			dialog_show("서버와의 연결에 문제가 있습니다.");
        }
    });
	return;
}

// 기업정보 확인
function getStockInfo(proc, name, target, icode) {
	$.ajax({
        url: "stock_common_exec.php",
		data : "proc="+proc+"&name="+encodeURIComponent(name),
        type: "POST",
		timeout : 10000,
        dataType: "json",
        async: false,
        cache: false,
        success: function(data) {
			if (data.icode) {
				switch (icode) {
					case "div": divCode = data.icode; break;
					case "sum": sumCode = data.icode; break;
					case "add": addCode = data.icode; break;
					case "del": delCode = data.icode; break;
					default: break;
				}
				$( "#"+target ).html( data.icompany+" ("+data.icode+") => 현재가 : "+data.itoday+" | 발행량 : "+data.inum+" | 매물 : "+data.irest );
			}
			dialog_show(data.msgcode);
        },
		error: function(data) {
			dialog_show("서버와의 연결에 문제가 있습니다.");
        }
    });
	return;
}