<?
include_once("./_common.php");
include_once("./config.php");

$t1 = explode(" ", microtime());

if ($cron_on == 1) {
	$sql = " select *, UNIX_TIMESTAMP(qst_datetime) as unixtime from q_stock ";
	$row = sql_fetch($sql);

	$lastupdate = $row['unixtime'];
	$now = $g4['server_time'];

	$pricelag = floor($now/$pricedelay) - floor($lastupdate/$pricedelay);
}

if ($pricelag >= 0 && $cron_on == 1) {
	$qst_log_index = $row['qst_log_index'];
	$oldindex = $row['qst_index_yesterday'];
	$indexstd = $row['qst_index_std'];
	$stocksum = 0;
	$sumpool = array();
	$sumpoolnow = "";
	$sumpoolnum = 0;

	$datetime = $g4['time_ymdhis'];

	$hourx = floor(($lastupdate%3600)/$pricedelay);
	$hourloop = 3600/$pricedelay;
	$dayx = floor((($lastupdate+32400)%86400)/$pricedelay);
	$dayloop = $hourloop*24;
	$weekx = floor((($lastupdate-86400*3+32400)%604800)/$pricedelay);
	$weekloop = $dayloop*7;
	$rankx = floor(($lastupdate%$rankdelay)/$pricedelay);

	$weekup = floor((($pricelag+$weekx)/$dayloop)/7);

	if ($weekup > 0) {
		$member_arr = member_set();
		$own_arr = own_set();
	}

	$sql = " select * from q_stock_list ";
	$result = sql_query($sql);

	while ($row = sql_fetch_array($result))
	{
		$weekcount = 1;

		for ($i=$pricelag, $j=$weekx; $i>0; $i--, $j++) {
			if ($j%$hourloop == 0) {
				if ($j%$dayloop == 0) {
					if ($j%$weekloop == 0) {
						if ($weekcount == $weekup)
							$member_arr = member_invest($row, $own_arr, $member_arr);
						else
							$weekcount++;
					}
					$row = dayupdate($row);
				}
				$row = hourupdate($row);
			}
			$row = priceupdate($row, $i, $j);
		}

		$sql = " update q_stock_list
					set qst_today = '$row[qst_today]',
					qst_yesterday = '$row[qst_yesterday]',
					qst_log_day = '$row[qst_log_day]',
					qst_log_hour = '$row[qst_log_hour]',
					qst_log_min = '$row[qst_log_min]',
					qst_max = '$row[qst_max]',
					qst_min = '$row[qst_min]',
					qst_high = '$row[qst_high]',
					qst_low = '$row[qst_low]',
					qst_vol_buy = '$row[qst_vol_buy]',
					qst_vol_sell = '$row[qst_vol_sell]',
					qst_limit_up = '$row[qst_limit_up]',
					qst_limit_down = '$row[qst_limit_down]',
					qst_bonuspoint = '$row[qst_bonuspoint]',
					qst_item_up = '$row[qst_item_up]'
				where qst_code = '$row[qst_code]' ";
		sql_query($sql);

		$stocksum += $row[qst_today]*$row[qst_num];

	}

	for ($i=0; $i<count($sumpool); $i++) {
		$index = round($sumpool[$i]/$indexstd*100, 2);
		$qst_log_index = substr(strstr($qst_log_index, "|"), 1)."|".$index;
		if ($i == count($sumpool)-1)
			$oldindex = $index;
	}

	$index = round($stocksum/$indexstd*100, 2);
	$sql = " update q_stock set qst_index = '$index', qst_index_yesterday = '$oldindex', qst_datetime = '$datetime', qst_log_index = '$qst_log_index' ";
	sql_query($sql);

	if ($weekup > 0 && count($member_arr) > 0) {
		$sql = " truncate q_stock_member ";
		sql_query($sql);

		$sql = " insert into q_stock_member (mb_id, qst_invest) values ";

		$data_arr = each($member_arr);
		$sql.= " ('$data_arr[0]', '$data_arr[1]') ";

		while ($data_arr = each($member_arr)) {
			$sql.= " , ('$data_arr[0]', '$data_arr[1]') ";
		}
		sql_query($sql);
	}

	rank_update($row);
}

$t2 = explode(" ", microtime());
$t3 = ($t2[1]-$t1[1])+($t2[0]-$t1[0]);

function priceupdate($row, $i, $j) {
	global $stock_plus;
	$handycap = $row[qst_bonuspoint]+$row[qst_item_up]+$stock_plus;

	$rand = mt_rand(-300+ceil($handycap/50),300+ceil($handycap/50));

	$newtoday = round($row[qst_today]+$row[qst_today]*$rand/100000);
	if ($newtoday < 0)
		$newtoday = 0;

	if ($newtoday > $row[qst_limit_up])
		$newtoday = $row[qst_limit_up];
	else if ($newtoday < $row[qst_limit_down])
		$newtoday = $row[qst_limit_down];

	if ($row[qst_max] < $newtoday)
		$row[qst_max] = $newtoday;
	else if ($row[qst_min] > $newtoday)
		$row[qst_min] = $newtoday;

	if ($row[qst_high] < $newtoday)
		$row[qst_high] = $newtoday;
	else if ($row[qst_low] > $newtoday)
		$row[qst_low] = $newtoday;

	$row[qst_today] = $newtoday;

	if ($i <= 120 && $j%2 == 0)
		$row[qst_log_min] = substr(strstr($row[qst_log_min], "|"), 1)."|".$newtoday;
	
	return $row;
}

function hourupdate($row) {
	$todaymax = floor($row[qst_yesterday]*1.15);
	$todaymin = ceil($row[qst_yesterday]*0.85);

	$handycap = $row[qst_bonuspoint]+$row[qst_item_up];

	$rand = mt_rand(525,2000+$handycap);
	$limit_up = round($row[qst_today]+$row[qst_today]*$rand/100000);

	if ($limit_up > $todaymax)
		$limit_up = $todaymax;

	$rand = mt_rand(-2000+$handycap,-500);
	$limit_down = round($row[qst_today]+$row[qst_today]*$rand/100000);

	if ($limit_down < $todaymin)
		$limit_down = $todaymin;

	if ($row[qst_bonuspoint] > 4)
		$row[qst_bonuspoint]-=4;
	else if ($row[qst_bonuspoint] < -4)
		$row[qst_bonuspoint]+=4;

	if ($row[qst_bonuspoint] < 20 && $row[qst_bonuspoint] > -20)
	{
		$rand = mt_rand(1,1000);

		if ($rand < 111)
		{
			$rand = mt_rand(-360, 370);
			$row[qst_bonuspoint] = $rand;
		}
		else
			$row[qst_bonuspoint] = 0;
	}

	if ($row[qst_item_up] > 4)
		$row[qst_item_up]-=4;
	else
		$row[qst_item_up]=0;

	$row[qst_log_hour] = substr(strstr($row[qst_log_hour], "|"), 1)."|".$row[qst_today];

	$row['qst_limit_up'] = $limit_up;
	$row['qst_limit_down'] = $limit_down;

	return $row;
}

function dayupdate($row) {
	global $sumpool;
	global $sumpoolnow;
	global $sumpoolnum;

	if ($sumpoolnow != $row[qst_code]) {
		$sumpoolnow = $row[qst_code];
		$sumpool[0] += $row[qst_today]*$row[qst_num];
		$sumpoolnum = 0;
	}
	else {
		$sumpool[++$sumpoolnum] += $row[qst_today]*$row[qst_num];
	}

	$row[qst_yesterday] = $row[qst_today];
	$row[qst_high] = $row[qst_today];
	$row[qst_low] = $row[qst_today];
	$row[qst_vol_buy] = 0;
	$row[qst_vol_sell] = 0;
	$row[qst_log_day] = substr(strstr($row[qst_log_day], "|"), 1)."|".$row[qst_today];

	return $row;
}

function own_set() {
	$sql = " select mb_id, qst_code, qst_ownnum from q_stock_own ";
	$result = sql_query($sql);

	while ($row = sql_fetch_array($result)) {
		$arrnum = count($own_arr[$row['qst_code']]);
		$own_arr[$row['qst_code']][$arrnum][mb_id] = $row['mb_id'];
		$own_arr[$row['qst_code']][$arrnum][qst_ownnum] = $row['qst_ownnum'];
	}

	return $own_arr;
}

function member_set() {
	$sql = " select mb_id from q_stock_own ";
	$result = sql_query($sql);

	while ($row = sql_fetch_array($result)) {
		$member_arr[$row['mb_id']] = 0;
	}

	return $member_arr;
}

function member_invest($row, $own_arr, $member_arr) {
	$arr = $own_arr[$row['qst_code']];

	for ($i=0; $i<count($arr); $i++) {
		$member_arr[$arr[$i][mb_id]] += $arr[$i][qst_ownnum] * $row['qst_today'];
	}

	return $member_arr;
}

function rank_update($row) {
	$sql = " SELECT a.mb_id, e.mb_nick, ifnull(d.totalprice, 0) as totalprice,
			ROUND(((ifnull(d.totalprice, 0) + a.qst_balance) / a.qst_invest -1 ) *100, 3) AS rate
			FROM q_stock_member a
			LEFT OUTER JOIN
			(SELECT b.mb_id, SUM(b.qst_ownnum * c.qst_today) as totalprice
			 FROM q_stock_own b
			 inner join q_stock_list c ON b.qst_code = c.qst_code group by b.mb_id) d on a.mb_id = d.mb_id
			 inner join g4_member e on a.mb_id = e.mb_id
			order by rate desc ";
	$result = sql_query($sql);

	$sql = " truncate q_stock_rank ";
	sql_query($sql);

	$sql = " insert into q_stock_rank (mb_id, mb_nick, qst_return_per, qst_total, qst_rank) values ";

	for ($i=1; $row = sql_fetch_array($result); $i++) {
		if ($i > 1)
			$sql.= " , ";
		$sql.= " ('$row[mb_id]' ,'$row[mb_nick]' ,'$row[rate]' ,'$row[totalprice]' ,'$i') ";
	}

	if ($i > 1)
		sql_query($sql);
}
?>