<?
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

$sql = " select * from q_stock ";
$row = sql_fetch($sql);
$stockindex = $row[qst_index];
$stockindexyesterday = $row[qst_index_yesterday];
$stockindexgap = $row[qst_index]-$row[qst_index_yesterday];
$stockindexgapper = (($stockindexgap/$row[qst_index_yesterday])*100);

$sql = " select qst_company, qst_vol_sell + qst_vol_buy as qst_vol ";
$sql.= " from q_stock_list ";
$sql.= " order by qst_vol_sell + qst_vol_buy desc ";
$sql.= " limit 7 ";
$rank_vol = sql_query($sql);

$sql = " select qst_company, round(((qst_today / qst_yesterday)-1)*100, 2) as qst_up ";
$sql.= " from q_stock_list ";
$sql.= " order by qst_today / qst_yesterday desc ";
$sql.= " limit 7 ";
$rank_up = sql_query($sql);

$sql = " select qst_company, round(((qst_today / qst_yesterday)-1)*100, 2) as qst_down ";
$sql.= " from q_stock_list ";
$sql.= " order by qst_today / qst_yesterday asc ";
$sql.= " limit 7 ";
$rank_down = sql_query($sql);

$sql = " select * from q_stock_news order by qst_ne_id desc limit 6 ";
$market_arr = sql_query($sql);

$sql = " select a.qst_code, a.qst_tradenum, a.qst_proc, a.qst_datetime, b.qst_company from q_stock_trade a inner join q_stock_list b on a.qst_code = b.qst_code order by a.qst_tr_id desc limit 6 ";
$trade_arr = sql_query($sql);

$sql = " select sum(qst_tradenum) as total_vol, ";
$sql.= " sum(qst_tradenum * qst_price) as total_price ";
$sql.= " from q_stock_trade ";
$sql.= " where substring(qst_datetime, 1, 10) = '$g4[time_ymd]' ";
$row = sql_fetch($sql);
$total_vol = $row[total_vol];
$total_price = $row[total_price];
?>

<div id="newsHead">
	<span class="newsHeadIndex"><?=number_format($stockindex, 2)?></span>
	<span><?=updown($stockindexgap)?></span>&nbsp;
	<span><?=updownper($stockindexgapper)?></span>
	<span class="newsHeadContent">거래량&nbsp;<?=number_format($total_vol)?>&nbsp;&nbsp;|&nbsp&nbsp;거래금액&nbsp;<?=number_format($total_price)?></span>
</div>

<div style="height:10px;"></div>

<table class="newsListTable">
<tr>
	<th>거래량 상위종목</th>
	<th class="newsListSpace"></th>
	<th>상승률 상위종목</th>
	<th class="newsListSpace"></th>
	<th>하락률 상위종목</th>
<tr>
	<td>
	<div class="newsList">
		<ol>
		<?
			while ($tmp = sql_fetch_array($rank_vol)) {
				echo "<li>";
				echo $tmp[qst_company];
				echo "<span class='newsListValue'>".number_format($tmp[qst_vol])."</span>";
				echo "</li>";
			}
		?>
		</ol>
	</div>
	</td>
	<td class="newsListSpace"></td>
	<td>
	<div class="newsList">
		<ol>
		<?
			while ($tmp = sql_fetch_array($rank_up)) {
				echo "<li>";
				echo $tmp[qst_company];
				echo "<span class='newsListValue'>".updownper($tmp[qst_up])."</span>";
				echo "</li>";
			}
		?>
		</ol>
	</div>
	</td>
	<td class="newsListSpace"></td>
	<td>
	<div class="newsList">
		<ol>
		<?
			while ($tmp = sql_fetch_array($rank_down)) {
				echo "<li>";
				echo $tmp[qst_company];
				echo "<span class='newsListValue'>".updownper($tmp[qst_down])."</span>";
				echo "</li>";
			}
		?>
		</ol>
	</div>
	</td>
</tr>
</table>

<div class="newsMarket">
	<div class="newsListHead">증시 소식</div>
	<div class="newsListContent">
		<ul>
		<?
			for ($i=0; $tmp = sql_fetch_array($market_arr); $i++) {
				$tmp[qst_datetime] = gapprint($tmp[qst_datetime]);
				echo "<li class='stripe".($i%2)."'>";
				echo $tmp[qst_msg];
				echo "<span class='newsListTime'>{$tmp[qst_datetime]}</span>";
				echo "</li>";
			}
		?>
		</ul>
	</div>
</div>

<div class="newsTrade">
	<div class="newsListHead">거래 소식</div>
	<div class="newsListContent">
		<ul>
		<?
			for ($i=0; $tmp = sql_fetch_array($trade_arr); $i++) {
				if ($tmp[qst_proc] == "buy") {
					$proc = "매수";
				}
				else {
					$proc = "매도";
				}
				$tmp[qst_datetime] = gapprint($tmp[qst_datetime]);

				echo "<li class='stripe".($i%2)."'>";
				echo "{$tmp[qst_company]}({$tmp[qst_code]}) - {$tmp[qst_tradenum]}주 {$proc}";
				echo "<span class='newsListTime'>{$tmp[qst_datetime]}</span>";
				echo "</li>";
			}
		?>
		</ul>
	</div>
</div>

<?
function updown($num) {
	if ($num < 0)
	{
		$num = "<font color='#005dde'>▼".number_format(-$num, 2)."</font>";
	}
	else if ($num > 0)
	{
		$num = "<font color='#d90400'>▲".number_format($num, 2)."</font>";
	}
	else
	{
		$num = "<font color=green>-</font>";
	}
	return $num;
}
function updownper($num) {
	if ($num < 0)
	{
		$num = "<font color='#005dde'>".number_format($num, 2)."%</font>";
	}
	else if ($num > 0)
	{
		$num = "<font color='#d90400'>+".number_format($num, 2)."%</font>";
	}
	else
	{
		$num = "<font color=green>0</font>";
	}
	return $num;
}

function gapprint($datetime) {
	global $g4;

	$gap = $g4['server_time'] - strtotime($datetime);

	if (floor($gap/60)<1)
		$gap = $gap."초 전";
	else if (floor($gap/3600)<1)
		$gap = floor($gap/60)."분 전";
	else if (floor($gap/86400)<1)
		$gap = floor($gap/3600)."시간 전";
	else
		$gap = floor($gap/86400)."일 전";

	return $gap;
}
?>