<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가
/*
 * http://www.g4mob.com
 * g4m board view.skin.php
 * 
 */
?>

<!-- 게시글 보기 시작 -->
<script type="text/javascript">
$(document).ready(function() {
    <?php if ($prev_href) { ?>
        $('#wr_prev').click(function(){
            location.href='<?php echo $prev_href?>';
        });
    <?php } ?>
    <?php if ($next_href) {?>
        $('#wr_next').click(function(){
            location.href='<?php echo $next_href?>';
        });
    <?php } ?>
});
</script>

<br class="clear" />
<article class="g4board_basic">
    <header class="page-header">
        <h2>
            <?php
            if ($is_category) {
                echo ($category_name ? "[{$view['ca_name']}] " : "");
            }
            echo $view['wr_subject']
            ?>
        </h2>
        <div class="wr_info">
            <div class="pull-left"><?php echo $view['name']?><?php // if ($is_ip_view) { echo "&nbsp;($ip)"; } ?></div>
            <div class="pull-right"><time pubdate="">작성일 : <?php echo date("y-m-d H:i", strtotime($view['wr_datetime']))?></time> 조회 : <?php echo number_format($view['wr_hit'])?></div>
        </div>
    </header>

    <div class="page-btn">
        <?php
        ob_start();
        ?>
        <div class="btn-group pull-right">
            <a class="btn dropdown-toggle" data-toggle="dropdown" href="#">
                <i class="icon-tasks icon-black"></i>
                관리메뉴
                <span class="caret"></span>
            </a>
            <ul class="dropdown-menu bbs_menu">
                <?php
                if ($copy_href) {
                    echo "<li><a href=\"$copy_href\">복사</a></li> ";
                }
                if ($move_href) {
                    echo "<li><a href=\"$move_href\">이동</a></li> ";
                }
                if ($update_href) {
                    echo "<li><a href=\"$update_href\">수정</a></li> ";
                }
                if ($delete_href) {
                    echo "<li><a href=\"$delete_href\">삭제</a></li> ";
                }
                if ($search_href) {
                    echo "<li><a href=\"$search_href\">검색목록</a></li> ";
                }

                if ($reply_href) {
                    echo "<li><a href=\"$reply_href\">답변</a></li> ";
                }

                $link_buttons = ob_get_contents();
                ob_end_flush();
                ?>
            </ul>
        </div>
        <!-- 링크 버튼 -->
        <?php
        echo "<div class='pull-left'><a href=\"$list_href\" class='btn btn-mini'>목록</a></div>";
        ?>
    </div>
    <br class="clear"/>
    <div class="pull-right" style="padding: 5px">
        <ul>
            <?php
            // 가변 파일
            $file_count = count($view['file']);
            for ($i = 0; $i < $file_count; $i++) {
                if ($view[file][$i][source] && !$view[file][$i][view]) {
                    echo "<li>";
                    echo "<a href=\"javascript:file_download('{$view[file][$i][href]}', '" . urlencode($view[file][$i][source]) . "');\" title='{$view[file][$i][content]}'>";
                    echo "<i class='icon-download black'></i>{$view[file][$i][source]} ({$view[file][$i][size]})";
                    echo "<span>[{$view[file][$i][download]}]</span>";
                    //echo "<span>Date : {$view[file][$i][datetime]}</span>";
                    echo "</a></li>";
                }
            }
            // 링크
            for ($i = 1; $i <= $g4['link_count']; $i++) {
                $first = "";
                if ($i == 1)
                    $first = "first";
                if ($view['link'][$i]) {
                    $link = cut_str($view['link'][$i], 70);
                    echo "<li class='$first'>";
                    echo "<a href='{$view['link_href'][$i]}' target='_blank'>";
                    echo "<i class='icon-star black'></i>{$link}";
                    echo "<span>[{$view['link_hit'][$i]}]</span>";
                    echo "</a></li>";
                }
            }
            ?>
        </ul>
    </div>
    <div class="article">
        <?php
        // 파일 출력
        $list_view_count =  count($view['file']);
        for ($i = 0; $i <= $list_view_count; $i++) {
            if ($view['file'][$i]['view']){
                echo "<p><img src='{$g4['thumb']}?w={$board['bo_m_image_width']}&amp;bo_table={$_GET['bo_table']}&amp;img={$view['file'][$i]['file']}'></p>";
            }
        }
        echo $view['content'];
        ?>
    </div>
    <footer>
        <div class="pull-right">
        <?php if ($nogood_href) {?>
        <a href="<?php echo $nogood_href?>" target="hiddenframe" class="btn btn-danger">비추천(<?php echo number_format($view['wr_nogood'])?>)</a>
        <?php } ?>

        <?php if ($good_href) {?>
            <a href="<?php echo $good_href?>" target="hiddenframe" class="btn btn-info">추천(<?php echo number_format($view['wr_good'])?>)</a>
        <?php } ?>
        <?php //if ($is_signature) { echo "<div class='sign'>$signature</div>"; } // 서명 출력 ?>
        </div>
    </footer>

    <div class="page-btn" style="margin-top: 30px">
        <?php if ($prev_href) { ?><button id="wr_prev" class="btn pull-left" type="button">이전글</button> <?php } ?>
        <?php if ($next_href) { ?><button id="wr_next" class="btn pull-right" type="button">다음글</button> <?php } ?>
    </div>
    <br class="clear"/>
    <?php
    // 코멘트 입출력
    include_once "./view_comment.php";
    ?>
</article>

<script type="text/javascript">
function file_download(link, file) {
    <?php if ($board['bo_download_point'] < 0) { ?>
    if (confirm("'"+decodeURIComponent(file)+"' 파일을 다운로드 하시면 포인트가 차감(<?=number_format($board[bo_download_point])?>점)됩니다.\n\n포인트는 게시물당 한번만 차감되며 다음에 다시 다운로드 하셔도 중복하여 차감하지 않습니다.\n\n그래도 다운로드 하시겠습니까?"))
    <?php } ?> 
    document.location.href=link;
}
</script>

<!-- 게시글 보기 끝 -->