$(function() {
	$( ".menu_btn" ).button();

	// 메시지 팝업
	$( "#msg_dialog" ).dialog({
		autoOpen: false,
		modal: true,
		resizable: false,
		buttons: {
			Ok: function() {
				$( this ).dialog( "close" );
			}
		}
	});
});

// 세자리 콤마 표기
function commify(n) {
	var reg = /(^[+-]?\d+)(\d{3})/;
	n += '';

	while (reg.test(n))	{
		n = n.replace(reg, '$1' + ',' + '$2');
	}

	return n;
}

// 상하향 표기
function updown(n) {
	var tag;

	if (n<0) {
		tag = "<font color=#005dde>▼"+commify(n).replace("-","")+"</font>";
	}
	else if (n>0) {
		tag = "<font color=#d90400>▲"+commify(n)+"</font>";
	}
	else {
		tag = "<font color=green>-</font>";
	}

	return tag;
}

// 퍼센트 표기
function percent(n) {
	var tag;

	if (n<0) {
		tag = "<font color=#005dde>"+commify(n)+"</font>";
	}
	else if (n>0) {
		tag = "<font color=#d90400>+"+commify(n)+"</font>";
	}
	else {
		tag = "<font color=green>-</font>";
	}

	return tag;
}

// 페이징
function pagechange(choice) {
	if (choice == "prev") {
		if (viewpage == 1)
			dialog_show("처음 페이지입니다.");
		else {
			clearInterval(refreshTimer);
			viewpage--;
			stock_refresh();
			refreshTimer = setInterval("stock_refresh()", 10000);
		}
	}
	else {
		if (viewpage == maxpage)
			dialog_show("마지막 페이지입니다.");
		else {
			clearInterval(refreshTimer);
			viewpage++;
			stock_refresh();
			refreshTimer = setInterval("stock_refresh()", 10000);
		}
	}
	
	document.getElementById('pageNum').innerHTML = viewpage+" / "+maxpage;

	return;
}

// 매매주문
function trade(proc, code, num) {
	clearInterval(refreshTimer);

	$.ajax({
        url: "stock_trade_exec.php",
		data : "proc="+proc+"&code="+code+"&num="+num,
        type: "POST",
		timeout : 10000,
        dataType: "json",
        async: false,
        cache: false,
        success: function(data) {
			switch(data.msgcode) {
                case 100 : dialog_show("구매 성공."); break;
                case 101 : dialog_show("포인트가 부족합니다."); break;
                case 102 : dialog_show("구매 가능한 주식이 부족합니다."); break;
                case 200 : dialog_show("판매 성공."); break;
                case 201 : dialog_show("판매가능한 주식이 부족합니다."); break;
                case 999 : dialog_show("권한이 없습니다."); break;
                default : dialog_show(data.msgcode); break;
            }
			stock_refresh();
			refreshTimer = setInterval("stock_refresh()", 10000);
        },
		error: function(data) {
			refreshTimer = setInterval("stock_refresh()", 10000);
        }
    });
	return;
}

// 메시지 팝업
function dialog_show(msg) {
	$( "#dialog-text" ).html( msg );
	$( "#msg_dialog" ).dialog( "open" );
	return;
}


// 상세 페이지 팝업
function win_stock(code) {
	if (codeNum[code]) {
		win_open("stock_popup.php?code="+codeNum[code], "winStock", "left=200, top=200, width=620, height=500, scrollbars=1");
	}

	return;
}

// 구매 가능 수량
function tradeCal(price, rest) {
	rest = nocomma(rest);
	var tmp = Math.floor(userpoint / (nocomma(price) * (1 + commission) / pointratio));

	if (tmp < rest)	{
		return tmp;
	}
	else {
		return rest;
	}
}

// 콤마 제거
function nocomma(num) {
	return Number(num.replace(/,/gi, ""));
}