var viewpage = 1; // 현재 페이지
var codeNum = Array();
var userpoint = 0;
var commission = 0;
var tradeProc;
var refreshTimer = setInterval("stock_refresh()", 10000); // 목록 갱신 반복

$(function() {
	$( ".buy_btn" ).button().click(function(){
		$( "#codeNum" ).val( $(this).val() );
		$( "#buyCompany" ).val( $(this).parent().siblings( ".listCompany" ).children( "A" ).html().replace("&amp;", "&") );
		$( "#buyPrice" ).val( $(this).parent().siblings( ".listPrice" ).html() );
		$( "#trade_slider" ).slider({
			value: 0,
			max: tradeCal($(this).parent().siblings( ".listPrice" ).html(), $(this).parent().siblings( ".listRest" ).html() )
		});
		$( "#buyNum" ).val( 0 );
		$( ".validateTips" ).html( "매수 수량을 입력하신 후, 매매 버튼을 누르세요." );
		tradeProc = "buy";
		$( "#buy_dialog" ).dialog( "open" );
		return false;
	});

	$( ".sell_btn" ).button().click(function(){
		$( "#codeNum" ).val( $(this).val() );
		$( "#buyCompany" ).val( $(this).parent().siblings( ".listCompany" ).children( "A" ).html().replace("&amp;", "&") );
		$( "#buyPrice" ).val( $(this).parent().siblings( ".listPrice" ).html() );
		$( "#trade_slider" ).slider({
			value: 0,
			max: nocomma($(this).parent().siblings( ".listOwn" ).html())
		});
		$( "#buyNum" ).val( 0 );
		$( ".validateTips" ).html( "매도 수량을 입력하신 후, 매매 버튼을 누르세요." );
		tradeProc = "sell";
		$( "#buy_dialog" ).dialog( "open" );
		return false;
	});

	$( "#button_prev" ).button().click(function() { pagechange("prev"); return false; });
	$( "#button_next" ).button().click(function() { pagechange("next"); return false; });

	var buyNum = $( "#buyNum" ),
		allFields = $( [] ).add( buyNum ),
		tips = $( ".validateTips" );

	// 매수 팝업
	$( "#buy_dialog" ).dialog({
		autoOpen: false,
		resizable: false,
		height: 350,
		width: 350,
		modal: true,
		buttons: {
			"매매": function() {
				var bValid = true;
				allFields.removeClass( "ui-state-error" );

				bValid = bValid && checkRegexp( buyNum, /^[0-9]+$/i, "구매 수량을 정확히 입력하세요" );

				if ( bValid ) {
					trade(tradeProc, $( "#codeNum" ).val(), buyNum.val());
					$( this ).dialog( "close" );
				}
			},
			"취소": function() {
				$( this ).dialog( "close" );
			}
		},
		close: function() {
			allFields.val( "" ).removeClass( "ui-state-error" );
		}
	});

	$( "#trade_slider" ).slider({
		range: "max",
		min: 0,
		max: 10,
		value: 1,
		slide: function( event, ui ) {
			$( "#buyNum" ).val( ui.value );
		}
	});
	$( "#buyNum" ).val( $( "#trade_slider" ).slider( "value" ) );

	function updateTips( t ) {
		tips.text( t ).addClass( "ui-state-highlight" );
		setTimeout(function() {
			tips.removeClass( "ui-state-highlight", 1500 );
		}, 500 );
	}

	function checkRegexp( o, regexp, n ) {
		if ( !( regexp.test( o.val() ) ) ) {
			o.addClass( "ui-state-error" );
			updateTips( n );
			return false;
		} else {
			return true;
		}
	}

	setTimeout("stock_refresh()", 1); // 초기 목록 로드
});

// 목록 갱신
function stock_refresh() {
	clearInterval(refreshTimer);

	$.ajax({
        url: "stock_my_exec.php?page="+viewpage,
        type: "POST",
		timeout : 10000,
        dataType: "json",
        async: false,
        cache: false,
        success: function(data) {
			userpoint = data[1].userpoint;
			commission = data[1].commission;
			for (i=0; i<data[0].length; i++) {
				codeNum[i] = data[0][i].code;
				$( ".listCompany:eq("+i+") > A" ).html( data[0][i].company );
				$( ".listPrice:eq("+i+")" ).html( commify(data[0][i].price) );
				$( ".listGap:eq("+i+")" ).html( updown(data[0][i].gap) );
				$( ".listGapper:eq("+i+")" ).html( percent(data[0][i].gapper) );
				$( ".listRest:eq("+i+")" ).html( commify(data[0][i].rest) );
				$( ".listOwn:eq("+i+")" ).html( commify(data[0][i].ownnum) );
				$( ".listEve:eq("+i+")" ).html( commify(data[0][i].eve) );
				$( ".buy_btn:eq("+i+")" ).val( data[0][i].code );
				$( ".sell_btn:eq("+i+")" ).val( data[0][i].code );
				$( ".buy_btn:eq("+i+")" ).show();
				$( ".sell_btn:eq("+i+")" ).show();
			}
			for (; i<10; i++) {
				codeNum[i] = 0;
				$( ".listCompany:eq("+i+") > A" ).html( "&nbsp;" );
				$( ".listPrice:eq("+i+")" ).html( "&nbsp;" );
				$( ".listGap:eq("+i+")" ).html( "&nbsp;" );
				$( ".listGapper:eq("+i+")" ).html( "&nbsp;" );
				$( ".listHigh:eq("+i+")" ).html( "&nbsp;" );
				$( ".listLow:eq("+i+")" ).html( "&nbsp;" );
				$( ".listRest:eq("+i+")" ).html( "&nbsp;" );
				$( ".listOwn:eq("+i+")" ).html( "&nbsp;" );
				$( ".listEve:eq("+i+")" ).html( "&nbsp;" );
				$( ".buy_btn:eq("+i+")" ).val( "" );
				$( ".sell_btn:eq("+i+")" ).val( "" );
				$( ".buy_btn:eq("+i+")" ).hide();
				$( ".sell_btn:eq("+i+")" ).hide();
			}
			$( "#stockindex" ).html( data[1].index );
			$( "#myStock" ).html( commify(data[1].myStock) );
			$( "#mySumInc" ).html( data[1].myTotalInc );
			$( "#myInc" ).html( data[1].myInc );

			refreshTimer = setInterval("stock_refresh()", 10000);
        },
		error: function(data) {
			refreshTimer = setInterval("stock_refresh()", 10000);
        }
    });
}