<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005 JinSnet.com                                       |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 05/Jan/2006 14:22                                |
// +----------------------------------------------------------------------+
//
// $Id write.inc$

class WritePost
{
    function WritePost()
    {
    }

    function processWrite()
    {
        $this->_processWrite();
    }

    function processModify()
    {
        if($GLOBALS['usedb'])
        {
            $this->_processModify();
        }
    }

    //****
    // Mysql related functions
    //

    function _processWrite()
    {
        $keywords = array();
        $data = new Data();
        
        $library = new Library();
        $postData = $_POST;

        $id = $data->insertPost($postData);

        // keywords process
        if($postData['keywords'])
        {
            $keywords = $this->_splitKeywords($postData['keywords']);
            // insert keys into db table
            $this->_insertKeywords($keywords);
            // insert info of post and keywords relationship
            $data->linkKeyPost($id, $keywords);
        }

        $this->linkFiles($postData['filearray'], $id);

        // sync
        if($postData['sync'] == "1")
        {
            $admin = new Admin();
            $admin->postSync($id, 0);
        }
    }

    function _processModify()
    {
        $data = new Data();
        $library = new Library();
        $postData = $_POST;

        // get previous data
        $preResult = $data->getItemsByNoByBlog($postData['post'], 0, $postData['n']);
        $preData = $preResult->fetchRow();
        $data->modifyPost($postData);

        // keywords modify
        if($postData['keywords'])
        {
            $keywords = $this->_splitKeywords($postData['keywords']);
            // insert keys into db table
            $this->_modifyKeywords($postData['post'], $keywords);
            // insert info of post and keywords relationship
            $data->linkKeyPost($postData['post'], $keywords);
        }

        $this->linkFiles($postData['filearray'], $postData['post']);

        // sync if a user checks or not
        if(!$postData['sync']) $postData['sync'] = 0;
        if($postData['sync'] != $preData['is_sync'])
        {
            $admin = new Admin();
            $admin->postSync($postData['post'], $preData['is_sync']);
        }
    }

    function linkFiles($fileNos, $postNo)
    {
        $data = new Data();
        $files = explode(",", $fileNos);
        array_pop($files);
        foreach($files as $value)
        {
            $data->linkFile($value, $postNo);
        }
    }

    function _insertKeywords($keywords)
    {
        $data = new Data();

        $data->insertKeywords($keywords);

    }

    function _modifyKeywords($id, $keywords)
    {
        $data = new Data();

        $data->modifyKeywords($id, $keywords);
    }    

    function _splitKeywords($keywords)
    {
        $keywords = trim($keywords);        
        $keys = explode(",", $keywords);
        $keys = array_unique($keys);

        return $keys;
    }

/** Not used functions **

    function _splitTB($tb)
    {
        $tb = trim($tb);        
        $tbs = explode(",", $tb);
        $tbs = array_unique($tbs);

        return $tbs;
    }

    function _sendTB($to, $title, $excerpt, $blog_name, $url)
    {
        $tbData = "url=".rawurlencode($url)."&title=".rawurlencode($title)."&blog_name=".rawurlencode($blog_name)."&excerpt=".rawurlencode($excerpt);

        $library = new Library();

        $toBlog = parse_url($to);
        $result = $library->getPostToHost($toBlog['host'], $toBlog['path'], $tbData);

        $parseData = $library->parseTBResponse($result);

        require_once dirname(dirname(__FILE__))."/_lib/simplexml.inc";

        $simplexml = new SimpleXml();

        if (get_magic_quotes_gpc()) 
        {
            $parseData['body'] = stripslashes($parseData['body']);
        }

        $xmlParse = $simplexml->setInputString($parseData['body']);
        $xmlParse = $simplexml->parse();

        $xmlStruct = $simplexml->getStruct();

        return $xmlStruct;
    }

    function sendTB($tos, $title, $excerpt, $blog_name, $url)
    {
        $allTBResult = array();

        $toBlog = $this->_splitTB($tos);
        
        for($i = 0; $i < count($toBlog); $i++)
        {
            $result = $this->_sendTB($toBlog, $title, $excerpt, $blog_name, $url);
            $allTBResult[$i]['error'] = $result['ERROR'];
            if(isset($result['MESSAGE']))   $allTBResult[$i]['msg'] = $result['MESSAGE'];
        }

        return $allTBResult;
    }

**/

    //****
    // File system related functions
    //

    function _processWriteByFileSystem()
    {
        // make name for a post file
        $fileName = time();
        $fileName .= ".php";
        $fileName = SPG_DATA.'/'.$GLOBALS['n'].'/'.$this->_getPostDir().'/'.$fileName;

        $contents = $this->_groupInputs($_POST);

        // data class from data.inc that has read in setup.inc
        $data = new Data();
        if($data->spgWriteFile($fileName, $contents))
        {
        
        }
        else
        {
            echo __FILE__;
        }

    }

    /*
     * 
     * FILE SYSTEM
     */
    function _groupInputs($data)
    {
        $str = 'SUBJ'.'|';
        $str .= $data['subject'].'|';
        $str .= 'CONT'.'|';
        $str .= $data['contents'].'|';
        $str .= 'CATE'.'|';
        $str .= $data['category'].'|';
        $str .= 'LINK'.'|';
        $str .= $data['links'].'|';
        $str .= 'TIME'.'|';
        $str .= time().'|';
        $str .= 'DISP'.'|';
        $str .= $data['open'].'|';

        return $str;
    }

    /*
     * get dir to be saved post
     * FILE SYSTEM
     */
    function _getPostDir()
    {
        $year = date('Y');
        $month = date('m');

        // check if year dir exists
        if(!is_dir(SPG_DATA."/".$GLOBALS['n']."/".$year.$month))
        {
            if(!mkdir(SPG_DATA."/".$GLOBALS['n']."/".$year.$month, 0707))
            {
                echo __FILE__;
            }
            if(!chmod(SPG_DATA."/".$GLOBALS['n']."/".$year.$month, 0707))
            {
                echo __FILE__;
            }
        }

        $dir = $year.$month;

        return $dir;
    }
}
?>