<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version  The Simplog                                    |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 05/Jan/2006 14:12                                |
// +----------------------------------------------------------------------+
//
// $Id generatexml.inc$

require_once dirname(dirname(__FILE__))."/_lib/init.inc";
require_once dirname(dirname(__FILE__))."/_lib/library.inc";

class GenerateXML
{
    function GenerateXML()
    {
    }

    function generateRSS20($file = "n")
    {
        if (!empty($HTTP_SERVER_VARS['SERVER_SOFTWARE']) && strstr($HTTP_SERVER_VARS['SERVER_SOFTWARE'], 'Apache/2'))
        {
           header ('Cache-Control: no-cache, pre-check=0, post-check=0, max-age=0');
        }
        else
        {
           header ('Cache-Control: private, pre-check=0, post-check=0, max-age=0');
        }

        header ('Content-Type: text/xml');

        // generate data

        $data = new Data();
        $library = new Library();
        

        if($file == 'n')
        {
            $adminData = $data->getAdminData($GLOBALS['n']);
            $adminData2 = $data->getAdminData2($GLOBALS['n']);
            $url = SPG_URI;
        }
        else if($file == 'y')
        {
            if($_POST['n'])
                $user = $_POST['n'];
            else if($_POST['username'])
                $user = $_POST['username'];

            $adminData = $data->getAdminData($user);
            $adminData2 = $data->getAdminData2($user);
            $url = dirname(SPG_URI).'/'.$user;
        }

        require_once dirname(dirname(__FILE__))."/_lang/".$adminData['language']."/lang.inc";

        $result = $data->getItems(0, $adminData['xml_num'], 3);
        $post = $result->fetchRow();

        $rss = "";
        $rss .= '<?xml version="1.0" encoding="UTF-8" ?>'."\r\n";
		$rss .= '<rss version="2.0">'."\r\n";
		$rss .= '<channel>'."\r\n";
		$rss .= '<title>'.$library->simHtmlentities($adminData['blog_name']).'</title>'."\r\n";
		$rss .= '<link>'.$url.'</link>'."\r\n";
		$rss .= '<description>'.$library->simHtmlentities($adminData['blog_desc']).'</description>'."\r\n";
		$rss .= '<language>'.$GLOBALS['lang']['code'].'</language>'."\r\n";
		$rss .= '<pubDate>'.date("r", $post['post_time']).'</pubDate>'."\r\n";        
        $rss .= '<generator>The Simplog (http://thesimplog.com)</generator>'."\r\n";
        if($adminData['email'])
            $rss .= '<managingEditor>'.$adminData['email'].'</managingEditor>'."\r\n";
        $rss .= '<copyright>Copyright '.date('Y').' '.$library->simHtmlentities($adminData['nick_name']).'</copyright>'."\r\n";
        $rss .= '<docs>'.$url.'/rss.xml</docs>'."\r\n";

        // image banner
        if($adminData['banner1'] && $adminData2['admin_defaultbanner'] == "banner1")
        {
            $rss .= '<image>'."\r\n";
            $rss .= '<url>'.$url.'/'.$adminData['banner1'].'</url>'."\r\n";
            $rss .= '<title>'.$library->simHtmlentities($adminData['blog_name']).'</title>'."\r\n";
            $rss .= '<link>'.$url.'</link>'."\r\n";
            $rss .= '</image>'."\r\n";
        }
        else if($adminData['banner2'] && $adminData2['admin_defaultbanner'] == "banner2")
        {
            $rss .= '<image>'."\r\n";
            $rss .= '<url>'.$url.'/'.$adminData['banner2'].'</url>'."\r\n";
            $rss .= '<title>'.$library->simHtmlentities($adminData['blog_name']).'</title>'."\r\n";
            $rss .= '<link>'.$url.'</link>'."\r\n";
            $rss .= '</image>'."\r\n";
        }

        // item loop

        $result = $data->getItems(0, $adminData['xml_num'], 3);

        $mainview = new Mainview();

        while($post = $result->fetchRow())
        {
            if($adminData['xml_type_full'] != "f")
                $contents = $mainview->strCut($post['contents'], 150);
            else    $contents = $post['contents'];

            // get author info
            $authorinfo = $data->getAdminData($post['author']);

            $cateData = $data->getCateNameById($post['category_id']);
			$keywords = $data->getKeywordsByPost($post['no']);
			$tags = explode(",", $keywords);
			unset($keywords);

            $rss .= "<item>\r\n";
			$rss .= "<title>".$library->simHtmlentities($post['subject'])."</title>\r\n";
			$rss .= "<link>".$url."/?post=".$post['no']."</link>\r\n";
			$rss .= "<description><![CDATA[ ".$contents." ]]> </description>\r\n";
			$rss .= "<category>".$library->simHtmlentities($cateData['category_name'])."</category>\r\n";

            // tags(category) prints
			foreach($tags as $value)
			{
				if($value && $cateData['category_name'] != $value)
					$rss .= "<category>".$library->simHtmlentities($value)."</category>\r\n";
			}

//			$rss .= "<dc:creator>".$adminData['nick_name']."</dc:creator>\r\n";
            if($authorinfo['email'])
                $rss .= "<author>".$library->simHtmlentities($authorinfo['email'])."</author>\r\n";
			$rss .= "<pubDate>".date("r", $post['post_time'])."</pubDate>\r\n";
            $rss .= "<guid>".$url."/?post=".$post['no']."</guid>\r\n";

            // find multimedia file 
            // search mp3
            $string = $post['contents'];
            $pattern = '/(src|href)=(\'|")([^"]*\.mp3)/i';
            preg_match($pattern, $string, $match);

            // enclosure
            if($match[3])
            {
                $rss .= '<enclosure url="'.$match[3].'" type="audio/mpeg" />'."\r\n";
            }
            else    // or search movie file
            {
                $pattern = '/src=(\'|")([^"]*\.(mov|m4v|mp4))/i';
                preg_match($pattern, $string, $match);

                // enclosure
                if($match[2])
                {
                    $encl_type = "video/";
                    if($match[3] == "mov")  $encl_type .= "quicktime";
                    else if($match[3] == "m4v")     $encl_type .= "quicktime";
                    else if($match[3] == "mp4")     $encl_type .= "mpeg";

                    $rss .= '<enclosure url="'.$match[2].'" type="'.$encl_type.'" />'."\r\n";
                }
            }

            // or if there is a uploaded mp3
            $fileres = $data->getFileByPostNo($post['no']);
            while($filedata = $fileres->fetchRow())
            {
                if(strtolower(substr($filedata['file_name'],-3)) == "mp3")
                {
                    $rss .= '<enclosure url="'.(dirname($url))."/_data/".$adminData['user_name']."/data/".$filedata['dir']."/".$filedata['file_name'].'" type="audio/mpeg" length="'.$filedata['file_size'].'" />'."\r\n";

                    continue;
                }
            }

			$rss .= "</item>\r\n";
        }

        // close
        $rss .= "</channel>\r\n";
		$rss .= "</rss>\r\n";

        echo $rss;
    }


	/**
	 * only for Simplog Server
	**/
    function generateRSSbyPost($postNo)
    {
        if (!empty($HTTP_SERVER_VARS['SERVER_SOFTWARE']) && strstr($HTTP_SERVER_VARS['SERVER_SOFTWARE'], 'Apache/2'))
        {
           header ('Cache-Control: no-cache, pre-check=0, post-check=0, max-age=0');
        }
        else
        {
           header ('Cache-Control: private, pre-check=0, post-check=0, max-age=0');
        }

        header ('Content-Type: text/xml');

        // generate data

        $data = new Data();
        $library = new Library();

        $adminData = $data->getAdminData($GLOBALS['n']);

        require_once dirname(dirname(__FILE__))."/_lang/".$adminData['language']."/lang.inc";

        $result = $data->getItemsByNo($postNo, 3);
        $post = $result->fetchRow();

        $rss = "";
        $rss .= '<?xml version="1.0" encoding="UTF-8" ?>'."\r\n";
		$rss .= '<rss version="2.0">'."\r\n";
		$rss .= '<channel>'."\r\n";
		$rss .= '<title>'.$library->simHtmlentities($adminData['blog_name']).'</title>'."\r\n";
		$rss .= '<link>'.SPG_URI.'</link>'."\r\n";
		$rss .= '<description>'.$library->simHtmlentities($adminData['blog_desc']).'</description>'."\r\n";
		$rss .= '<language>'.$GLOBALS['lang']['code'].'</language>'."\r\n";
		$rss .= '<pubDate>'.date("r", $post['post_time']).'</pubDate>'."\r\n";
        if($adminData['email'])
            $rss .= '<managingEditor>'.$adminData['email'].'</managingEditor>'."\r\n";
        $rss .= '<generator>The Simplog (http://thesimplog.com)</generator>'."\r\n";
        $rss .= '<copyright>Copyright '.date('Y').' '.$library->simHtmlentities($adminData['nick_name']).'</copyright>'."\r\n";
        $rss .= '<docs>'.SPG_URI.'/rss.xml</docs>'."\r\n";

        // image banner
        if($adminData['banner1'] && $adminData2['admin_defaultbanner'] == "banner1")
        {
            $rss .= '<image>'."\r\n";
            $rss .= '<url>'.$url.'/'.$adminData['banner1'].'</url>'."\r\n";
            $rss .= '<title>'.$library->simHtmlentities($adminData['blog_name']).'</title>'."\r\n";
            $rss .= '<link>'.$url.'</link>'."\r\n";
            $rss .= '</image>'."\r\n";
        }
        else if($adminData['banner2'] && $adminData2['admin_defaultbanner'] == "banner2")
        {
            $rss .= '<image>'."\r\n";
            $rss .= '<url>'.$url.'/'.$adminData['banner2'].'</url>'."\r\n";
            $rss .= '<title>'.$library->simHtmlentities($adminData['blog_name']).'</title>'."\r\n";
            $rss .= '<link>'.$url.'</link>'."\r\n";
            $rss .= '</image>'."\r\n";
        }

        $mainview = new Mainview();

        // cut contents by 200 words
        //$contents = $mainview->strCut($post['contents'], 150);

        $contents = $post['contents'];

        // get author info
        $authorinfo = $data->getAdminData($post['author']);

        $cateData = $data->getCateNameById($post['category_id']);
        $keywords = $data->getKeywordsByPost($post['no']);
		$tags = explode(",", $keywords);

        $rss .= "<item>\r\n";
        $rss .= "<title>".$post['subject']."</title>\r\n";
        $rss .= "<link>".SPG_URI."/?post=".$post['no']."</link>\r\n";
        $rss .= "<description><![CDATA[ ".$contents." ]]> </description>\r\n";
        $rss .= "<category>".$library->simHtmlentities($cateData['category_name'])."</category>\r\n";

        // tags(category) prints
        foreach($tags as $value)
        {
            if($value && $cateData['category_name'] != $value)
                $rss .= "<category>".$library->simHtmlentities($value)."</category>\r\n";
        }

        if($authorinfo['email'])
            $rss .= "<author>".$library->simHtmlentities($authorinfo['email'])."</author>\r\n";
        $rss .= "<pubDate>".date("r", $post['post_time'])."</pubDate>\r\n";
        $rss .= "<guid>".SPG_URI."?post=".$post['no']."</guid>\r\n";
        $rss .= "<keywords>".$library->simHtmlentities($keywords)."</keywords>\r\n";

        // find multimedia file 
        // search mp3
        $string = $post['contents'];
        $pattern = '/(src|href)=(\'|")([^"]*\.mp3)/i';
        preg_match($pattern, $string, $match);

        // enclosure
        if($match[3])
        {
            $rss .= '<enclosure url="'.$match[3].'" type="audio/mpeg" />'."\r\n";
        }
        else    // or search movie file
        {
            $pattern = '/src=(\'|")([^"]*\.(mov|m4v|mp4))/i';
            preg_match($pattern, $string, $match);

            // enclosure
            if($match[2])
            {
                $encl_type = "video/";
                if($match[3] == "mov")  $encl_type .= "quicktime";
                else if($match[3] == "m4v")     $encl_type .= "quicktime";
                else if($match[3] == "mp4")     $encl_type .= "mpeg";

                $rss .= '<enclosure url="'.$match[2].'" type="'.$encl_type.'" />'."\r\n";
            }
        }

        // or if there is a uploaded mp3
        $fileres = $data->getFileByPostNo($post['no']);
        while($filedata = $fileres->fetchRow())
        {
            if(strtolower(substr($filedata['file_name'],-3)) == "mp3")
            {
                $rss .= '<enclosure url="'.(dirname($url))."/_data/".$adminData['user_name']."/data/".$filedata['dir']."/".$filedata['file_name'].'" type="audio/mpeg" length="'.$filedata['file_size'].'" />'."\r\n";

                continue;
            }
        }

        $rss .= "</item>\r\n";
        

        // close
        $rss .= "</channel>\r\n";
		$rss .= "</rss>\r\n";

        echo $rss;
    }

    function makeRSSFile($toWhere)
    {
        ob_start();
        echo $this->generateRSS20('y');
        $rss = ob_get_contents();
        ob_end_clean();

        $file = $toWhere."/rss.xml";

        $fd = @fopen($file, 'w');

        if ($fd)
        {
            flock( $fd, LOCK_EX );
            $result = fwrite($fd, $rss);
            flock($fd, LOCK_UN);
            if($result) chmod($file, 0707);
            fclose($fd);
        }
    }
}

?>