<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version The Simplog                                     |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// | functions for all use                                                |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 05/Jan/2006 14:14                                |
// +----------------------------------------------------------------------+
//
// $Id library.inc$

/**
 * goToPage()
 * go to another page
 *
 * @param string $url  destination page url
 * @return void
**/
function goToPage($url)
{
    header ("Location: $url");
    exit;
}


class Library
{
    function Library()
    {
    }    

    function queryToStr($queryArray)
    {
        reset($queryArray);
        $str = "?";
        foreach($queryArray as $key => $value)
        {
            $str .= $key."=".urlencode($value)."&amp;";
        }

        return $str;
    }

    function dataValidation($data)
    {
        //trim white spaces
        $data = trim($data);

        return $data;
    }

    function getHost($host, $path, $data = "", $port = '80') 
    { 
        $fp = fsockopen($host, $port, $errono, $errstr, 30); 

        if(!$fp)
        {
           $this->dieError("Host Connection Error");
        }
        else
        {
            $header = "GET ".$path." HTTP/1.1\r\n";
            $header .= "Host: ".$host."\r\n";
            $header .= "Connection: close\r\n";
            $header .= "Content-type: text/html; charset=utf-8\r\n";
            $header .= "\r\n";

            if($data)
            {
                $header .= strlen($data)."\r\n";
                $header .= $data."\r\n";
                $header .= 0;
            }

            // send header
            fputs($fp, $header);
            //socket_set_timeout($fp, 4);

            $i=0;
            while(!feof($fp))
            { 
                $f_array[$i] = fgets($fp, 1024); 
                $i++;
            }

            fclose($fp);
            
            return $f_array;
        }
    }

    function getPostToHost($host, $path, $data = "", $port = '80') 
    { 
        $fp = @fsockopen($host, $port, $errono, $errstr, 30);

        $len = strlen($data);

        if(!$fp)
        {
            $this->dieError("Host Connection Error");
        }
        else
        {
            $header = "POST ".$path." HTTP/1.1\r\n";
            $header .= "Host: ".$host."\r\n";
            $header .= "Content-type: application/x-www-form-urlencoded; charset=utf-8\r\n";
            $header .= "Content-length: ".$len."\r\n";
            $header .= "Connection: close\r\n\r\n";
            $header .= "$data\r\n\r\n";

            // send header
            fputs($fp, $header);
            //socket_set_timeout($fp, 4);
            $i=0;
            while(!feof($fp))
            { 
                $f_array[$i] = fgets($fp, 1024); 
                $i++;
            }

            fclose($fp);
            return $f_array;
        }
    }    

    function parseHOST($data)
    {
        $parse = array();

        $parse['code'] = substr($data[0], 9, 3);

        $start = -1;
        $body = "";

        for($i = 0; $i < count($data); $i++)
        {
            if (stristr($data[$i], "<?xml"))
            {
                $start = 1;            
            }

            if($start == 1)
            {
                $body .= $data[$i];
            }

            if (stristr($data[$i], "</simplog>"))
            {
                $start = -1; 
            }            
        }        

        $parse['body'] = $body;

        return $parse;
    }

    function getRSSContents($data)
    {
        for($i = 0; $i < count($data); $i++)
        {
            if (stristr($data[$i], "<?xml"))
            {
                $start = 1;            
            }

            if($start == 1)
            {
                $body .= $data[$i];
            }

            if (stristr($data[$i], "</rss>"))
            {
                $start = -1;
            }            
        }

        return $body;
    }

    function parseRSSWithCache($rssuri, $data, $h)
    {
        $age = 3600 * $h; // hour
        $now = time();

        $adminData2 = $data->getAdminRssById($GLOBALS['n']);
        $rssData = $adminData2['rss_'.$rssuri];
        if($rssData)
        {
            $pos = strpos($rssData, "|");
            $rssTime = substr($rssData, 0, $pos);
            $rssStuct = substr($rssData, $pos + 1);
        }
        require_once dirname(dirname(__FILE__))."/_lib/XML/RSS.php";

        if($now - $rssTime > $age)
        {
            $rss = & new XML_RSS($rssuri);
            $rssData = $rss->getXmlString();
            // get encoding part
            preg_match('|encoding="([^<>]+)"|i', substr($rssData, 0, 50), $match);
            $encode = $match[1];

            if(strtolower($encode) != "utf-8")
            {
                // mb_string first
                if(function_exists('mb_convert_encoding'))
                {
                    $rssData = mb_convert_encoding($rssData, "utf-8", $encode);
                }
                // or iconv, otherwise nothing, just send utf-8
                else if(function_exists('iconv'))
                {
                    $rssData = iconv($encode, "utf-8", $rssData);
                }
            }
            $newData['rss_'.$rssuri] = $now."|".$rssData;
            $rss->setInputString($rssData);
            $rss->parse();
            if(trim($rssData))
            {
                $data->updateDataTableByBlog($newData, "");
            }
            return $rss;
            
        }
        else
        {
            $rss = & new XML_RSS();
            $rss->setInputString($rssStuct);
            $rss->parse();
            return $rss;
        }
    }

    function printDateSring($date)
    {   
        $now = time();
        $pubDate = strtotime($date);

        $age = ($now - $pubDate);

        $start = 1;
        while($start)
        {
            if($age >= 86400)
            {
                $days = floor($age / 86400);
                $age = $age - (86400 * $days);
            }
            else if($age >= 3600)
            {
                $hours = floor($age / 3600);
                $age = $age - (3600 * $hours);
            }
            else if($age >= 60)
            {
                $mins = floor($age / 60);
                $age = $age - (60 * $mins);
            }
            else
            {
                $secs = $age;
                $start = 0;
            }
        }

        $text = "";
        if($days)
        {
            $text = $days.$GLOBALS['lang']['main']['days'];
            if(!$hours) $hours = "0";
            $text .= $hours.$GLOBALS['lang']['main']['hours'];
            if(!$mins) $mins = "0";
            $text .= $mins.$GLOBALS['lang']['main']['mins'];
            $text .= " ".$GLOBALS['lang']['main']['ago'];
        }
        else if($hours)
        {
            $text = $hours.$GLOBALS['lang']['main']['hours'];
            if(!$mins) $mins = "0";
            $text .= $mins.$GLOBALS['lang']['main']['mins'];
            $text .= " ".$GLOBALS['lang']['main']['ago'];
        }
        else if($mins)
        {
            $text = $mins.$GLOBALS['lang']['main']['mins'];
            $text .= " ".$GLOBALS['lang']['main']['ago'];
        }
        else
        {
            $text = $secs.$GLOBALS['lang']['main']['secs'];
            $text .= " ".$GLOBALS['lang']['main']['ago'];
        }
        echo $text;
    }

    function parseTBResponse($data)
    {
        $parse = array();

        $parse['code'] = substr($data[0], 9, 3);

        $start = -1;
        $body = "";

        for($i = 0; $i < count($data); $i++)
        {
            if (stristr($data[$i], "<?xml"))
            {
                $start = 1;            
            }

            if($start == 1)
            {
                $body .= $data[$i];
            }

            if (stristr($data[$i], "</response>"))
            {
                $start = -1; 
            }
        }

        $parse['body'] = $body;

        return $parse;
    }

    function get_dataonly($parseData)
    {        
        require_once dirname(dirname(__FILE__))."/_lib/simplexml.inc";
        $simplexml = new SimpleXml();
        if (get_magic_quotes_gpc()) 
        {
            $parseData['body'] = stripslashes($parseData['body']);
        }
        $simplexml->setInputString($parseData['body']);
        $simplexml->parse();
        $xmlStruct = $simplexml->getStruct();

        return $xmlStruct;
    }

    // Returns true if $string is valid UTF-8 and false otherwise.
    // by W3C
    function isUTF8_2($string) 
    {       
       // From http://w3.org/International/questions/qa-forms-utf-8.html
       return preg_match('%^(?:
             [\x09\x0A\x0D\x20-\x7E]            // ASCII
           | [\xC2-\xDF][\x80-\xBF]            // non-overlong 2-byte
           |  \xE0[\xA0-\xBF][\x80-\xBF]        // excluding overlongs
           | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  // straight 3-byte
           |  \xED[\x80-\x9F][\x80-\xBF]        // excluding surrogates
           |  \xF0[\x90-\xBF][\x80-\xBF]{2}    // planes 1-3
           | [\xF1-\xF3][\x80-\xBF]{3}          // planes 4-15
           |  \xF4[\x80-\x8F][\x80-\xBF]{2}    //  plane 16
       )*$%xs', $string);
       
    } // function isUTF82

    // by tattertools
    function isUTF8($str){
        $strlen=strlen($str);
        for($i=0;$i<$strlen;$i++){
            $high=ord($str{$i});
            if($high<0x80)
                continue;
            elseif($high<0xE0){
                if(++$i>=$strlen)
                    return true;
                elseif(($str{$i}&"\xC0")=="\x80")
                    continue;
            }elseif($high<0xF0){
                if(++$i>=$strlen)
                    return true;
                elseif(($str{$i}&"\xC0")=="\x80"){
                    if(++$i>=$strlen)
                        return true;
                    elseif(($str{$i}&"\xC0")=="\x80")
                        continue;
                }
            }elseif($high<0xF8){
                if(++$i>=$strlen)
                    return true;
                elseif(($str{$i}&"\xC0")=="\x80"){
                    if(++$i>=$strlen)
                        return true;
                    elseif(($str{$i}&"\xC0")=="\x80"){
                        if(++$i>=$strlen)
                            return true;
                        elseif(($str{$i}&"\xC0")=="\x80")
                            continue;
                    }
                }
            }
            return false;
        }
        return true;
    }


    function dieError($msg, $where = 1, $back = 0)
    {
        if($where == 1)
            goToPage("../_admin/start.php?mode=error&msg=".rawurlencode($msg)."&back=".$back);
        else if($where == 2)
            goToPage("../../_admin/start.php?mode=error&msg=".rawurlencode($msg)."&back=".$back);
    }

    function printError($msg)
    {
        include SPG_ROOT."/_skin/_default_/error.html";
        exit;
    }

    function printSimpleError($msg)
    {
        include SPG_ROOT."/_skin/_default_/simpleerror.html";
    }

    /**
     * delDir
     * delete all files and folders in $which
     * @param String $which : a folder to be deleted
    **/
    function delDir($which) 
    { 
		$folder = dir($which);

		while($in = $folder->read()) 
        { 
			if ($in != "." && $in != "..") 
            { 
				if (is_dir($which."/".$in))
                {
					$this->delDir($which."/".$in); 
				}
                else
                {
					@unLink ($which."/".$in); 
				}
			} 
		} 
		$folder->close(); 
	
        @rmdir($which); 
	}

    function getImage($data)
    {
        $pattern = '/\<img[^>]*src=(\'|")?([^"\' ]*)/i';
        preg_match($pattern, $data, $match);

        $image['src'] = $match[2];

        /*
        $data = stristr($data, "<img ");
        $data = stristr($data, "src");
        $data = substr($data, 0, strpos($data, ">"));

        $para = explode(" ", $data);

        $data = str_replace("\"", "", $para[0]);
        $data = str_replace(">", "", $data);
        parse_str($data, $image);
        */

        return $image;
    }

    function returnBytes($val) 
    {
        $val = trim($val);
        $last = strtolower($val{strlen($val)-1});
        
        switch($last) 
        {
            // The 'G' modifier is available since PHP 5.1.0
            case 'g':
                $val *= 1024;
            case 'm':
                $val *= 1024;
            case 'k':
                $val *= 1024;
        }

        return $val;
    }

    function copyDir($srcDir, $dstDir) 
    {
       $fileList = array();
       $dstCopyDir = $dstDir;
       $stack[] = $srcDir;
       $this->makeDir($dstDir, 0707);
       
       while ($stack) 
       {
           $currentDir = array_pop($stack);

           if ($dh = opendir($currentDir))
           {
               while (($file = readdir($dh)) !== false) 
               {
                   if ($file != '.' && $file != '..') 
                   {
                       $currentFile = "{$currentDir}/{$file}";

                       if (is_file($currentFile)) 
                       {
                           $fileList[] = "{$currentDir}/{$file}";
                           $dstCopyDir = $dstDir.substr($currentFile, strlen($srcDir));;
                           $this->fileCopy("{$currentDir}/{$file}", $dstCopyDir);
                       }
                       elseif (is_dir($currentFile)) 
                       {
                           $stack[] = $currentFile;
                           $dstCopyDir = $dstDir.substr($currentFile, strlen($srcDir));
                           $this->makeDir($dstCopyDir, 0707);
                       }
                   }
               }    // end of while
           }
       }    // end of while
    }

    function makeDir($dir, $mode)
    {
       if (!is_dir($dir))
       {
           mkdir($dir, $mode);
           chmod($dir, $mode);
       }
    }

    function fileCopy($src, $dst)
    {
       if (file_exists($src))
       {
           copy($src, $dst);
           chmod($dst, 0707);
       }
    }

    function getXhtml($data)
    {
        $skin = new Skin();
        $skinSetup = $skin->getSkinSetup();
        $size = $skinSetup['image_resize'];
        $data = preg_replace("|<br>|i", "<br />", $data);
        $data = stripslashes(preg_replace('|(<img [^<>]+)[>]|i', "$1 name='simimage' onclick='viewImage(this.src);' onload='imgResize(".$size.");' />", $data));

        return $data;
    }

    function simHtmlentities($str)
    {
        $str = str_replace("&", "&amp;", $str);
        $str = str_replace("\"", "&quot;", $str);
        $str = str_replace("<", "&lt;", $str);
        $str = str_replace(">", "&gt;", $str);

        return $str;
    }

    function magicQuote($value)
    {
        // Stripslashes
        if (get_magic_quotes_gpc()) 
        {
            $value = stripslashes($value);
        }
        
        $value = addslashes($value);
        
        return $value;
    }

    function getMicroTime() {
    	$microtimestmp = split(" ",microtime());
    	return $microtimestmp[0]+$microtimestmp[1];
	}    

}
?>