<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version The Simplog                                     |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS <thesimplo@gmail.com>                                  |
// | Last Modified date: 05/Jan/2006 14:15                                |
// +----------------------------------------------------------------------+
//
// $Id main.inc$

require_once dirname(dirname(__FILE__))."/_lib/init.inc";
require_once dirname(dirname(__FILE__))."/_lib/library.inc";
require_once dirname(dirname(__FILE__))."/_lib/setup.inc";
require_once dirname(dirname(__FILE__))."/_lib/skin.inc";
require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";


class Main
{
    function Main()
    {

    }

    function gogo()
    {
        $library = new Library();

        // checking if a blog is disabled
        $this->_blockBlog();

        // security checking here
        $this->_blockIP();

        // for comments notifying, add a $_POST['mode'] state
        if(isset($_POST['mode']) && !empty($_POST['mode']) && $_POST['mode'] == "fb")
        {
            require_once dirname(dirname(__FILE__))."/_lib/comment.inc";
            $comment = new Comment();

            $result = $comment->receiveNotifiedComments($_POST);
            header('Content-Type: text/xml; charset=utf-8');
            if($result > 0)
                echo "<?xml version=\"1.0\" encoding=\"utf-8\"?><response><error>1</error><message>error</message></response>";
		    else
			    echo "<?xml version=\"1.0\" encoding=\"utf-8\"?><response><error>0</error></response>";
                
            exit;
        }

        // get count data
        $this->doAllCount();

        // from POST method
        switch ($_POST['todo'])
        {
            case 'login':
                require_once dirname(dirname(__FILE__))."/_lib/login.inc";
                $login = new Login();
                if($login->authorise())
                {
                    if(isset($_POST['url']) && $_POST['url']) goToPage($_POST['url']);
                    else    goToPage("../_admin");
                }
                else
                {
                    if(!trim($_POST['user_name']))  $library->printSimpleError($GLOBALS['lang']['main']['nousername']);
                    else if(!trim($_POST['pass']))  $library->printSimpleError($GLOBALS['lang']['main']['nopassword']);
                    else $library->printSimpleError($GLOBALS['lang']['main']['loginfail']);
                }            
                break;
            case 'join':
                if(!$_SESSION['spg_neigh_user_id'])
                {
                    $library->dieError($GLOBALS['lang']['login']['wrongrequest']);
                }
                else
                {
                    require_once dirname(dirname(__FILE__))."/_lib/login.inc";
                    $login = new Login();
                    $login->doJoin();
                }
                break;
        }

        // from GET method
        switch ($_GET['mode'])
        {
            case "writecom":
                break;
            case "rss":
                require_once dirname(dirname(__FILE__))."/_lib/generatexml.inc";
                $rss = new GenerateXML();
                $rss->generateRSS20();
                break;
            case "sync":
                require_once dirname(dirname(__FILE__))."/_lib/generatexml.inc";
                $rss = new GenerateXML();
                $rss->generateRSSbyPost($_GET['post']);
                break;
            case 'login':
                require_once dirname(dirname(__FILE__))."/_lib/login.inc";
                $login = new Login();
                $login->showLoginPage();
                break;
            case 'logout':
                require_once dirname(dirname(__FILE__))."/_lib/login.inc";
                $login = new Login();
                $login->logout();
                break;
            case 'simplogin':
                require_once dirname(dirname(__FILE__))."/_lib/login.inc";
                $login = new Login();
                $login->simplogin($_GET['key'], $_GET['ip']);
                break;
            case 'handshake':
                break;
            case "tb":  // trackback receive here
                require_once dirname(dirname(__FILE__))."/_lib/tb.inc";
                $tb = new TBack();
                $re = $tb->RTB();
                $tb->resultTB($re);
                break;
            case 'perm':
                $mainview = new Mainview();
                $mainview->printOneItemByPage($_GET['p']);
                break;
            case 'error':
                $library->printError($_GET['msg']);
                break;
            case 'join':
                require_once dirname(dirname(__FILE__))."/_lib/login.inc";
                $login = new Login();
                $login->showJoinPage();
                break;
            case 'xinopen':
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<html>
<head>
<title>Login to Simplog</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
</head>
<body onunload="opener.location.reload();">
<iframe src="http://thesimplog.com/login/login.php?blog=<?php echo SPG_URI;?>" style="width:100%; height:300px;" frameborder="0" scrolling="no" ></iframe>
</body>
</html>
<?php
                break;
            case 'preview':
                // get image size

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<html>
<head>
<title>Image Preview</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<script type="text/javascript">
function resize(img)
{
    var width = document.getElementById(img).width;
    var height = document.getElementById(img).height;

    var swidth = screen.width - 200;
    var sheight = screen.height - 200;

    if (height >= sheight){
        height = height - (height - sheight);
    }
    if (width >= swidth){
        width = width - (width - swidth);
    }
    
    window.resizeTo(width + 50, height + 70);
}
</script>
</head>
<body onload="javascript:resize('preimg');">
<a href="#" title="close"><img id="preimg" src="<?php echo $_GET['img'];?>" alt="close" onclick="self.close();" border="0" /></a>
</body>
</html>
<?php
                exit;
                break;
            case 'init':
                require_once dirname(dirname(__FILE__))."/_lib/simplog.inc";
                $simplogInit = new SimplogInit();
                $simplogInit->checkServerData();
                $simplogInit->checkSimplogRegister();
                $simplogInit->checkLinkSites();                  
                require_once dirname(dirname(__FILE__))."/_lib/comment.inc";
                $comment = new Comment();
                $comment->notifyComment();
                exit;
                break;
            case 'get_action':
                $mainview = new Mainview();
                $what = $_GET['what'];
                $mainview->get_action($what);
                break;
            case 'send_action':
                $mainview = new Mainview();
                $what = $_GET['what'];
                $mainview->send_action($what);
                break;
                exit;
            default:
                $this->printBlog();
                break;
        }
    }

    /**
     * printBlog
     * print blog here
    **/
    function printBlog()
    {
        $skin = new Skin();        

        $skin->printBlog();
    }

    /**
     * _blockBlog
     * block a blog which is disabled by Admin
    **/
    function _blockBlog()
    {
        $data = new Data();
        $adminData = $data->getAdminData($GLOBALS['n']);

        if ($adminData['is_use'] == "0")
        {
            $library = new Library();
            $library->dieError($GLOBALS['lang']['main']['blockblog'], 1);
        }
    }

    /**
     * _blockIP
     * block host which has that IP to access blog
    **/
    function _blockIP()
    {
        $data = new Data();
        $adminData = $data->getAdminData($GLOBALS['n']);

        if($adminData['ip_filter'])
        {
            $ips = explode(",", $adminData['ip_filter']);

            $userIP = $_SERVER['REMOTE_ADDR'];

            foreach($ips as $value)
            {
                $find = strpos($userIP, $value);
                if($find !== false) break;            
            }

            if($find !== false)
            {
                $library = new Library();
                $library->dieError($GLOBALS['lang']['main']['blockip'], 1);
            }
        }
    }

    /**
     * blockWord
     * block to process which has that blocked words a user inputs
    **/
    function blockWord($input)
    {
        $data = new Data();
        $adminData = $data->getAdminData($GLOBALS['n']);

        if($adminData['words_filter'])
        {
            $words = explode(",", $adminData['words_filter']);            

            foreach($words as $value)
            {
                if(stristr($input, $value))
                {
                    require_once dirname(dirname(__FILE__))."/_lib/script.inc";
                    $script = new Script();
                    $script->alert($GLOBALS['lang']['script']['blockwords']);
                    exit;
                }                
            }
        }
    }

    function doAllCount()
    {
        if($_GET['mode'] != "init")
        {
            // make stat everyday and delete log data every week
            $this->makeCountStat();
            // page view
            $this->upPageView();
            // visit count with logging referers and agents
            $this->upCount();
        }
    }    

    function upPageView()
    {
        $query = sprintf("INSERT INTO ".SPG_PREFIX."_count_data".
            " (date, request_uri_query, referer, ip, agent, user_name)".
            " VALUES".
            " (now(), '%s', '%s', '%s', '%s', '%s')",
            $_SERVER['QUERY_STRING'], $_SERVER['HTTP_REFERER'], $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT'], $GLOBALS['n']);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage());
        }
        
    }

    /**
     * upCount
     * increase the count: one for same IP within 2 hours
    **/
    function upCount()
    {
        // check if there if same IP in latest 2 hours    
        $query = sprintf("SELECT ip ".
            " FROM ".SPG_PREFIX."_count".
            " WHERE ip = '%s' AND date >= DATE_SUB(NOW(), INTERVAL %s HOUR) AND user_name='%s'",
            $_SERVER['REMOTE_ADDR'], 2, $GLOBALS['n']);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage());
        }

        if($result->numRows() == 0)
        {
            $query = sprintf("INSERT INTO ".SPG_PREFIX."_count".
                " (date, ip, agent, user_name)".
                " VALUES".
                " (now(), '%s' , '%s', '%s')",
                $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT'], $GLOBALS['n']);

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage());
            }
            
            // loggin user agents when a user visits
            $this->upAgent();
        }

        // logging referer on every hit
        $this->upReferer();
    }

    function upReferer()
    {
        $referer = $_SERVER['HTTP_REFERER'];

        // only from outside
        if(!stristr($referer, SPG_URI) && $referer != "")
        {
            $data = new Data();

            // if there is a same referer then just increase
            $isThere = $data->updateCountLog($referer, "R");

            // if not insert a new referer
            if($isThere == 0)
                $data->insertCountLog($referer, "R");
        }

    }

    function upAgent()
    {
        $agent = $_SERVER['HTTP_USER_AGENT'];

        $data = new Data();

        // if there is a same agent then just increase
        $isThere = $data->updateCountLog($agent, "B");

        // if not insert a new agent
        if($isThere == 0)
            $data->insertCountLog($agent, "B");
    }

    function makeCountStat()
    {
        $data = new Data();

        // run once a day only
        $result = $data->checkCountStatDate();

        // get latest stat. if runs first, get first count date
        if($result['date']) $lastStat = strtotime($result['date']);
        else
        {
            $firstCount = $data->checkFirstCountDate();
            $lastStat = strtotime($firstCount['p_date']);
        }

        $yesterday = mktime (0,0,0, date("m"), date("d")-1, date("Y"));        

        // if not, make statistics for previous day
        if($yesterday != $lastStat)
        {
            $dayDiff = ($yesterday - $lastStat) / 86400;

            $setDate = "";

            for($i = 1; $i <= $dayDiff; $i++)
            {
                $setDate = date("Ymd", $lastStat + (86400*$i));

                // 1. count by time 
                $countByTime = array(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
                $pageviewByTime = array(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
                $countResult = $data->getCountByTime($setDate);

                while($countData = $countResult->fetchRow())
                {
                    $countByTime[$countData['time']] = $countData['num'];
                }

                unset($countData);

                $pageviewResult = $data->getPageViewByTime($setDate);

                while($pageviewData = $pageviewResult->fetchRow())
                {
                    $pageviewByTime[$pageviewData['time']] = $pageviewData['num'];
                }

                unset($pageviewData);

                // make array to string
                $countByTimeStr = implode(",", $countByTime);
                $pageviewByTimeStr = implode(",", $pageviewByTime);

                $data->insertCountStat($setDate, array_sum($countByTime), array_sum($pageviewByTime), $countByTimeStr, $pageviewByTimeStr);
            }   // End of for

            $this->deleteLogData($lastStat);
        }
    }

    function deleteLogData($lastStat)
    {
        $resetDay = 3;  // wendesday

        // day of the week
        $dayOfWeek = date("w");
        $diffDay = $dayOfWeek - $resetDay;

        if($diffDay >= 0)
            $thisResetDay = mktime (0,0,0,date("m"), date("d")-$diffDay, date("Y"));

        if($lastStat < $thisResetDay)
        {
            $data = new Data();
            $data->deleteLogData();
        }
                  
    }

}   // End of class

?>