<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 05/Jan/2006 14:20                                |
// +----------------------------------------------------------------------+
//
// $Id tb.inc$


class TBack
{
    function TBack()
    {
    }

    /**
     * RTB
     * receive trackback
    **/
    function RTB()
    {
        $result = array();
        $tbData = array();
        $data = new Data();

        if($_POST['post'])
            $tbData['postNo'] = trim($_POST['post']);
        else if($_GET['post'])
            $tbData['postNo'] = trim($_GET['post']);
        else
            $tbData['postNo'] = trim($post);

        if($_POST['title'])
            $tbData['title'] = trim($_POST['title']);
        else if($_GET['title'])
            $tbData['title'] = trim($_GET['title']);
        else
            $tbData['title'] = trim($title);

        if($_POST['url'])
            $tbData['url'] = trim($_POST['url']);
        else if($_GET['url'])
            $tbData['url'] = trim($_GET['url']);
        else
            $tbData['url'] = trim($url);

        if($_POST['excerpt'])
            $tbData['excerpt'] = trim($_POST['excerpt']);
        else if($_GET['excerpt'])
            $tbData['excerpt'] = trim($_GET['excerpt']);
        else
            $tbData['excerpt'] = trim($excerpt);

        if($_POST['blog_name'])
            $tbData['blog_name'] = trim($_POST['blog_name']);
        else if($_GET['blog_name'])
            $tbData['blog_name'] = trim($_GET['blog_name']);
        else
            $tbData['blog_name'] = trim($blog_name);

        require_once dirname(dirname(__FILE__))."/_lang/language.inc";

        $itemResult = $data->getItemsByNo($tbData['postNo'], 1);
        $checkItem = $itemResult->fetchRow();
        // no post
        if(!isset($checkItem['no']))
        {
            $result["error"] = "1";
		    $result["message"] = "Trackback failed! (T01).";
        }
        // trackback diabled
        else if($checkItem['dis_tb'] == 1)
        {
            $result["error"] = "1";
		    $result["message"] = "Trackback failed! (T02).";
        }
        // ok then get trackback.
        else
        {
            // convert encoding to UTF-8
            // first if not utf-8 then detect encoding from
            $library = new Library();
            $isUTF8 = $library->isUTF8(($tbData['excerpt']));

            // then convert from which to utf-8
            if(!$isUTF8)
            {
                // mb_string first
                if(function_exists('mb_convert_encoding'))
                {
                    mb_detect_order($encodingList);
                    $whichEncoding = mb_detect_encoding($tbData['excerpt']);

                    $tbData['title'] = mb_convert_encoding($tbData['title'], "utf-8", $whichEncoding);
                    $tbData['excerpt'] = mb_convert_encoding($tbData['excerpt'], "utf-8", $whichEncoding);
                    $tbData['blog_name'] = mb_convert_encoding($tbData['blog_name'], "utf-8", $whichEncoding);
                }
                // or iconv, otherwise nothing, just send utf-8
                else if(function_exists('iconv'))
                {
                    $data = new Data();
                    $adminData = $data->getAdminData($GLOBALS['n']);

                    $tbData['title'] = iconv($adminData['rtbcharset'], "utf-8", $tbData['title']);
                    $tbData['excerpt'] = iconv($adminData['rtbcharset'], "utf-8", $tbData['excerpt']);
                    $tbData['blog_name'] = iconv($adminData['rtbcharset'], "utf-8", $tbData['blog_name']);
                }
            }

            // some arguments miss
            if (!$tbData['postNo'] || !$tbData['url'])
            {
                $result["error"] = "1";
                $result["message"] = "Incomplete Information Sent.";
            }
            // get every arguments
            else
            {
                $data = new Data();

                $isThere = $data->checkTB($tbData);

                // but same trackback
                if($isThere >= 1)
                {
                    $result["error"] = "1";
                    $result["message"] = "You Sent Duplicated TrackBack.";
                }
                else
                {
                    // insert into DB
                    $data->insertTB($tbData);

                    $result["error"] = "0";
                    $result["message"] = "Completed! Thank you.";
                }
            }
        }

        return $result;
    }   // End RTB()

    /**
     * STB
     * send track back
    **/
    function STB($to, $pdata)
    {
        $library = new Library();
        $data = new Data();

        $toURL = trim($to);

        if(!$toURL)
            $library->dieError($GLOBALS['lang']['admin']['tberror'], 1, 1);

        $host = parse_url($toURL);
        if(!$host['port']) $host['port'] = "80";

        $posturl = dirname(SPG_URI)."/".$_POST['n']."/?post=".$pdata['no'];

        $admin = $data->getAdminData($_POST['n']);

        $title = $pdata['subject'];
        $url = $posturl;
        $excerpt = $pdata['contents'];
        $blogName = $admin['blog_name'];
        
        require_once dirname(dirname(__FILE__))."/_lib/simplexml.inc";

        $simplexml = new SimpleXml();

        if(strtolower($_POST['enco']) != "utf-8")
        {
            if(function_exists('mb_convert_encoding'))
            {
                $title = mb_convert_encoding($title, $_POST['enco'], "utf-8");
                $excerpt = mb_convert_encoding($excerpt, $_POST['enco'], "utf-8");
                $blogName = mb_convert_encoding($blogName, $_POST['enco'], "utf-8");
            }
            else if(function_exists('iconv'))
            {
                $title = iconv("utf-8", $_POST['enco'], $title);
                $excerpt = iconv("utf-8", $_POST['enco'], $excerpt);
                $blogName = iconv("utf-8", $_POST['enco'], $blogName); 
            }
        }

        $title = rawurlencode($title);
        $url = rawurlencode($url);
        $excerpt = rawurlencode($excerpt);
        $blogName = rawurlencode($blogName);

        $postData = "title=".$title."&url=".$url."&excerpt=".$excerpt."&blog_name=".$blogName;        

        $result = $library->getPostToHost($host['host'], $host['path']."?".$host['query']."&".$postData, $postData, $host['port']);

        //get TB response and parse
        $parseData = $library->parseTBResponse($result);
        if (get_magic_quotes_gpc()) 
        {
            $parseData['body'] = stripslashes($parseData['body']);
        }

        $xmlParse = $simplexml->setInputString($parseData['body']);
        $xmlParse = $simplexml->parse();

        $xmlStruct = $simplexml->getStruct();

        require_once dirname(dirname(__FILE__))."/_lib/script.inc";
        $script = new Script();

        if (!trim($xmlStruct['MESSAGE']))
        {
            if (trim($xmlStruct['ERROR']) == "0")
            {
                $return = "TrackBack OK.";
                // save into DB
                $data->insertTBSent($pdata['no'], $toURL);
                $script->alert($return);
                $script->closeWin();
            }
            else
            {
                $return = "TrackBack Failed.";
                $script->alert($return);
                echo $script->head."history.back();".$script->tail;
            }
        }
        else
        {
            $return = $xmlStruct['MESSAGE'];
            
            if (trim($xmlStruct['ERROR']) == "0")
            {
                // save into DB
                $data->insertTBSent($pdata['no'], $toURL);

                $script->alert($return);
                $script->closeWin();
            }
            else
            {
                $script->alert($return);
                echo $script->head."history.back();".$script->tail;
            }
        }

	    return trim($return);
    }

    function delTB($no, $post_no, $n)
    {
        $data = new Data();
        $script = new Script();

        $data->deleteTb($no, $n);
        $script->deleteOkClose($post_no, "tb");
    }

    /**
     *
    **/
    function resultTB($result)
    {
        header("Content-Type: text/xml");
        echo "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\r\n";
        echo "<response>\r\n";
        echo "<error>".$result['error']."</error>\r\n";
        echo "<message>".$result['message']."</message>\r\n";
        echo "</response>";
    }

}

?>