<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version : The Simplog                                   |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005                                                   |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 16/Jan/2006 12:35                                |
// +----------------------------------------------------------------------+
//
// $Id link.inc$

require_once dirname(dirname(__FILE__))."/_lib/data.inc";

class Linked
{
    // DB Object
    var $boardConnect;

    function Linked()
    {
    }

    function getBoardTableName($board)
    {
        switch($board)
        {
            case 'zero':
                $data['boardType'] = "zero";
                $data['memberTable'] = "zetyx_member_table";
                $data['memberId'] = "user_id";
                $data['memberNick'] = "name";
                $data['memberPass'] = "password";
                $data['session'] = "zb_logged_no";
                $data['sessionkey'] = "no";
                $data['sessionloc'] = "/data/__zbSessionTMP";
                $data['passtype'] = "password";
                break;
            case 'gnu4':
                $data['boardType'] = "gnu4";
                $data['memberTable'] = "g4_member";
                $data['memberId'] = "mb_id";
                $data['memberNick'] = "mb_nick";
                $data['memberPass'] = "mb_password";
                $data['session'] = "ss_mb_id";
                $data['sessionkey'] = "mb_id";
                $data['sessionloc'] = "/data/session";
                $data['passtype'] = "password";
                break;
            default:    // nothing
                break;
        }

        return $data;
    }

    function makeSetupFile($post)
    {
        $board = $this->getBoardTableName($post['board_type']);

        if(substr($post['board_path'], -1) == "/")
            $post['board_path'] = substr($post['board_path'], 0, -1);

        if( get_magic_quotes_gpc() )
        {
            $post['board_path'] = stripslashes($post['board_path']);
        }

        if(!file_exists($post['board_path']."/config.php"))
        {
            @header('Content-type: text/html; charset=UTF-8');
            echo "보드 경로가 잘못되었습니다. 다시한번 확인해주세요.";
            exit;
        }

        if($post['board_session'])
            $sessionPath = $post['board_session'];
        else
            $sessionPath = $post['board_path'].$board['sessionloc'];

        $contents = sprintf("BOARDTYPE|%s|TABLE|%s|ID|%s|NICK|%s|PASS|%s|SESSION|%s|KEY|%s|SESLOC|%s|PASSTYPE|%s|PATH|%s", $board['boardType'], $board['memberTable'], $board['memberId'], $board['memberNick'], $board['memberPass'], $board['session'], $board['sessionkey'], $sessionPath, $board['passtype'], $post['board_path']);

        $data = new Data();
        $data->spgWriteFile(dirname(dirname(__FILE__))."/_data/linked.php", $contents);

        $this->connectBoardDB($post['board_type'], $post['board_path']);

        return true;
    }

    function makeLinkedTable()
    {
        $query = "CREATE TABLE IF NOT EXISTS `".SPG_PREFIX."_boardlink` (
                  `board_user_id` VARCHAR( 255 ) NOT NULL ,
                  `simplog_user_id` VARCHAR( 255 ) NOT NULL ,
                  PRIMARY KEY ( `board_user_id` )
                ) TYPE=MyISAM";

        $result = $GLOBALS['dbcon']->query($query);
    }

    function connectBoardDB($board, $boardPath)
    {
        switch($board)
        {
            case 'zero':
                $dbInfo = $this->readConfigForZeroboard($boardPath);
                $dsn = "mysql://".$dbInfo[2].":".$dbInfo[3]."@".$dbInfo[1]."/".$dbInfo[4];
                $this->boardConnect = DB::connect($dsn);
                if (DB::isError($this->boardConnect)) 
                {
                    die ($this->boardConnect->getMessage());
                }
                
                break;
            case 'gnu4':
                if(file_exists($boardPath."/dbconfig.php"))
                {
                    include $boardPath."/dbconfig.php";
                    $dsn = "mysql://".$mysql_user.":".$mysql_password."@".$mysql_host."/".$mysql_db;

                    $this->boardConnect = DB::connect($dsn);
                    if (DB::isError($this->boardConnect)) 
                    {
                        die ($this->boardConnect->getMessage());
                    }
                }
                break;
            default:    // nothing
                break;
        }

        $this->boardConnect->setFetchMode(DB_FETCHMODE_ASSOC);
    }

    // from zero board
    function readConfigForZeroboard($path)
    {
        if(file_exists($path."/config.php"))
        {
            $f=@file($path."/config.php");

            for($i=1;$i<=4;$i++) $f[$i]=trim(str_replace("\n","",$f[$i]));

            return $f;
        }
    }

    function insertOldUser()
    {
        $linkedData = $this->getLinkedSetting();

        $query = "SELECT user_name FROM ".SPG_PREFIX."_admin";
        $simpleResult = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($simpleResult))
        {
            die ($simpleResult->getMessage().__FILE__.__LINE__);
        }

        while($simpleData = $simpleResult->fetchRow())
        {
            switch($linkedData['BOARDTYPE'])
            {
                case 'zero':
                    $key = $linkedData['ID'];
                    break;
                case 'gnu4':
                    $key = $linkedData['KEY'];
                    break;
                default:    // nothing
                    break;

            }
            
            $boardQuery = sprintf("SELECT %s, %s, %s FROM %s WHERE %s = '%s'",
                $linkedData['PASS'], $linkedData['ID'], $linkedData['NICK'], $linkedData['TABLE'], $key, $simpleData['user_name']);
            $boardResult =$this->boardConnect->query($boardQuery);
            if (DB::isError($boardResult))
            {
                die ($boardResult->getMessage().__FILE__.__LINE__);
            }
            
            if($boardResult->numRows() == "1")
            {
                $query = sprintf("INSERT INTO ".SPG_PREFIX."_boardlink (board_user_id, simplog_user_id) VALUES ('%s', '%s')",
                    $simpleData['user_name'], $simpleData['user_name']);
                $result = $GLOBALS['dbcon']->query($query);
        
                if (DB::isError($result))
                {
                    die ($result->getMessage().__FILE__.__LINE__);
                }
            }
        }
    }

    function getLinkedSetting()
    {
        $linkedFile = dirname(dirname(__FILE__))."/_data/linked.php";
        if(is_file($linkedFile))
        {
            //$globalSet = array();
            $data = new Data();

            $contents = $data->spgReadFile($linkedFile);
            $contents = $data->getRidTag($contents);
            $linkedSet = $data->getArrayWithKey($contents);
        }
        else
        {
            @header('Content-type: text/html; charset=UTF-8');
            echo "블로그연동이 되어 있지 않습니다. 관리자에게 문의하세요.";
            exit;
        }

        return $linkedSet;
    }

    function getBoardMember($key)
    {
        if(!file_exists(dirname(dirname(__FILE__))."/_data/linked.php"))
        {
            @header('Content-type: text/html; charset=UTF-8');
            echo "블로그연동이 되어 있지 않습니다. 관리자에게 문의하세요.";

            return false;
        }
        else
        {
            $linkedData = $this->getLinkedSetting();
            
            if(!$linkedData['PASSTYPE'])
            {
                @header('Content-type: text/html; charset=UTF-8');
                echo "블로그연동이 잘못 되었습니다. 관리자에게 문의하세요.";

                return false;
            }

            $this->connectBoardDB($linkedData['BOARDTYPE'], dirname(dirname($linkedData['SESLOC'])));

            if($linkedData['PASSTYPE'] == "password")
            {
                $password = sprintf("%s = password('%s')", $linkedData['PASS'], $_POST['pass']);
            }

            $query = sprintf("SELECT %s, %s, %s FROM %s WHERE %s = '%s' AND %s",
                $linkedData['PASS'], $linkedData['ID'], $linkedData['NICK'], $linkedData['TABLE'], $linkedData['KEY'], $key, $password);
            
            $result = $this->boardConnect->getRow($query);
            if (DB::isError($result))
            {
                die ($result->getMessage());
            }

            return $result;

        }
    }

    function getBoardUser($key)
    {
        if(!file_exists(dirname(dirname(__FILE__))."/_data/linked.php"))
        {
            @header('Content-type: text/html; charset=UTF-8');
            echo "블로그연동이 되어 있지 않았습니다. 관리자에게 문의하세요.";

            return false;
        }
        else
        {
            $linkedData = $this->getLinkedSetting();
            
            if(!$linkedData['PASSTYPE'])
            {
                @header('Content-type: text/html; charset=UTF-8');
                echo "블로그연동이 잘못 되었습니다. 관리자에게 문의하세요.";

                return false;
            }

            $this->connectBoardDB($linkedData['BOARDTYPE'], dirname(dirname($linkedData['SESLOC'])));

            $query = sprintf("SELECT * FROM %s WHERE %s = '%s'",
                $linkedData['TABLE'], $linkedData['KEY'], $key);
            
            $result = $this->boardConnect->getRow($query);
            if (DB::isError($result))
            {
                die ($result->getMessage());
            }

            return $result;
        }
    }

    function getBoardUserByKey($key, $value)
    {
        if(!file_exists(dirname(dirname(__FILE__))."/_data/linked.php"))
        {
            @header('Content-type: text/html; charset=UTF-8');
            echo "블로그연동이 되어 있지 않았습니다. 관리자에게 문의하세요.";

            return false;
        }
        else
        {
            $linkedData = $this->getLinkedSetting();
            
            if(!$linkedData['PASSTYPE'])
            {
                @header('Content-type: text/html; charset=UTF-8');
                echo "블로그연동이 잘못 되었습니다. 관리자에게 문의하세요.";

                return false;
            }

            $this->connectBoardDB($linkedData['BOARDTYPE'], dirname(dirname($linkedData['SESLOC'])));

            $query = sprintf("SELECT * FROM %s WHERE %s = '%s'",
                $linkedData['TABLE'], $key, $value);
            
            $result = $this->boardConnect->getRow($query);
            if (DB::isError($result))
            {
                die ($result->getMessage());
            }

            return $result;
        }
    }

    function insertBoardLink($boardId, $simplogId)
    {
        $query = sprintf("INSERT INTO ".SPG_PREFIX."_boardlink (board_user_id, simplog_user_id) VALUES ('%s', '%s')",
            $boardId, $simplogId);
        $result = $GLOBALS['dbcon']->query($query);

        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function getBoardLink($boardId)
    {
        $query = sprintf("SELECT * FROM ".SPG_PREFIX."_boardlink WHERE board_user_id='%s'",
            $boardId);

        $result = $GLOBALS['dbcon']->getRow($query);

        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function addSimplerExe($id, $pass, $nick, $lang)
    {
        require_once dirname(dirname(__FILE__))."/_lib/login.inc";
        require_once dirname(dirname(__FILE__))."/_lib/library.inc";
        require_once dirname(dirname(__FILE__))."/_lib/data.inc";
        $login = new login();
        $library = new Library();
        $data = new Data();

        //// 0. check if there is same folder name
        if(is_dir(SPG_ROOT."/".$id))
        {
            $library->dieError($GLOBALS['lang']['admin']['cannotuseid']);
        }

        //// 1. make blog folder
        if(!is_dir(SPG_ROOT."/".$id))
        {
            if(!mkdir(SPG_ROOT."/".$id, 0707))
            {
                $library->dieError(__FILE__.__LINE__.": ".$GLOBALS['lang']['admin']['failcfolder']);
            }
			else
			{
				chmod(SPG_ROOT."/".$id, 0707);
			}
        }

        //// 2. generate index.php
        $index = SPG_ROOT."/_lib/index_copy.inc";
        if (!copy($index, SPG_ROOT."/".$id."/index.php")) 
        {
            // delete blog folder to initialise
            rmdir(SPG_ROOT."/".$id);
            $library->dieError(__FILE__.__LINE__.": ".$GLOBALS['lang']['admin']['problemblog']);
        }

        //// 3. make data folder under _data/
        if(!is_dir(SPG_ROOT."/_data/".$id))
        {
            if(!mkdir(SPG_ROOT."/_data/".$id, 0707))
            {
                $library->dieError(__FILE__.__LINE__.": ".$GLOBALS['lang']['admin']['failcfolder']);
            }
			else
			{
				chmod(SPG_ROOT."/_data/".$id, 0707);
			}
        }

        //// 4. add configuration data
        $query = sprintf("INSERT INTO ".SPG_PREFIX."_admin".
            " (user_name, password, nick_name, level, reg_date, language, is_use, owner)".
            " VALUES".
            " (%s, password(%s), %s, 2, now(), %s, 1, %s)",
            $data->quote_smart($id), 
            $data->quote_smart($pass), 
            $data->quote_smart($nick), 
            $data->quote_smart($lang),
            $data->quote_smart($id));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage());
        }

        // insert a default category
        $query = "INSERT INTO ".SPG_PREFIX."_category".
            " (category_id, category_name, open, user_name)".
            " VALUES".
            " (1, 'Category', '1', '".$id."')";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        // insert a default group for the link
        $query = "INSERT INTO ".SPG_PREFIX."_links_group".
            " (group_no, group_name, group_order, visible, user_name)".
            " VALUES".
            " (1, 'Bloggers', '1', '1', '".$id."')";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        $newData['admin_guest_num'] = 10;
        $newData['admin_guest_use1'] = 1;
        $newData['admin_cate_show_num'] = 1;
        $newData['admin_nowiam_title'] = "Notice";

        $data->updateDataTableByBlog($newData, $id);
    }

    // Returns true if $string is valid UTF-8 and false otherwise.
    // by W3C
    function isUTF8($string) 
    {
       
       // From http://w3.org/International/questions/qa-forms-utf-8.html
       return preg_match('%^(?:
             [\x09\x0A\x0D\x20-\x7E]            // ASCII
           | [\xC2-\xDF][\x80-\xBF]            // non-overlong 2-byte
           |  \xE0[\xA0-\xBF][\x80-\xBF]        // excluding overlongs
           | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  // straight 3-byte
           |  \xED[\x80-\x9F][\x80-\xBF]        // excluding surrogates
           |  \xF0[\x90-\xBF][\x80-\xBF]{2}    // planes 1-3
           | [\xF1-\xF3][\x80-\xBF]{3}          // planes 4-15
           |  \xF4[\x80-\x8F][\x80-\xBF]{2}    //  plane 16
       )*$%xs', $string);

    } // function is_utf8

    function convertUTF8($string)
    {
        if(!$this->isUTF8($string))
        {
            if(function_exists('mb_convert_encoding'))
            {
                $string = mb_convert_encoding($string, "UTF-8", "EUC-KR");
            }
            // or iconv, otherwise nothing, just send utf-8
            else if(function_exists('iconv'))
            {
                $string = iconv("EUC-KR", "UTF-8", $string);
            }
        }

        return $string;
    }

    function getLinkedIdByBoardId($id)
    {
        require_once dirname(dirname(__FILE__))."/_lib/data.inc";
        $data = new Data();

        $query = sprintf("SELECT * FROM ".SPG_PREFIX."_boardlink b, ".SPG_PREFIX."_admin a".
            " WHERE b.board_user_id = %s AND b.simplog_user_id = a.user_name",
            $data->quote_smart($id));

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage());
        }

        return $result;
    }

    function getLinkedIdBySimplogId($id)
    {
        require_once dirname(dirname(__FILE__))."/_lib/data.inc";
        $data = new Data();

        $query = sprintf("SELECT * FROM ".SPG_PREFIX."_boardlink b, ".SPG_PREFIX."_admin a".
            " WHERE b.simplog_user_id = %s AND b.simplog_user_id = a.user_name",
            $data->quote_smart($id));

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage());
        }

        return $result;
    }

} // End class

?>