<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name : The Simplog                                           |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// | patch file to upgrade simplog to v0.7.1                              |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS <thesimplog@gmail.com>                                 |
// | Last Modified date: 23/Apr/2006  1:06                                |
// +----------------------------------------------------------------------+
//
// $Id patch.php$

require_once dirname(dirname(__FILE__))."/_lib/init.inc";
require_once dirname(dirname(__FILE__))."/_lib/login.inc";
require_once dirname(dirname(__FILE__))."/_lib/library.inc";

$login = new Login();

switch ($_POST['todo'])
{
    case 'login':
        if($login->authorise())
        {
            if(isset($_POST['url']) && $_POST['url']) goToPage($_POST['url']);
            else    goToPage("../_admin");
        }
        else
        {
            $library = new Library();
            if(!trim($_POST['user_name']))  $library->printSimpleError($GLOBALS['lang']['main']['nousername']);
            else if(!trim($_POST['pass']))  $library->printSimpleError($GLOBALS['lang']['main']['nopassword']);
            else $library->printSimpleError($GLOBALS['lang']['main']['loginfail']);
        }            
        break;
}

switch ($_GET['mode'])
{
    case "login":
        require_once dirname(dirname(__FILE__))."/_lib/login.inc";
        $login = new Login();
        $login->showLoginPage();
        break;
    default:
        if($login->is_authorised())
        {
            if($_SESSION['spg_user_name'])
            {
                require_once dirname(dirname(__FILE__))."/_lib/library.inc";
                $data = new Data();
                $adminData = $data->getAdminData($_SESSION['spg_user_name']);

                if($adminData['level'] == "1")
                {
                    if(version_compare(SPG_VERSION, "0.7.1", "<"))
                    {
                        @header('Content-type: text/html; charset=UTF-8');
                        echo "<CENTER>이 패치는 v0.7.1 이상 버전용 패치 입니다. 먼저 0.7.1 이상 버전 화일을 업로드후 패치를 진행해주시기 바랍니다. </CENTER>";
                        exit;
                    }

                    // patch process here!!
                    if($_POST['exe'] == "ok")
                    {                        
                        $patchquery = "ALTER TABLE `".SPG_PREFIX."_files` ADD `original_file_name` VARCHAR( 255 ) AFTER `file_name`";
                        $result = $GLOBALS['dbcon']->query($patchquery);

                        @header('Content-type: text/html; charset=UTF-8');
                        echo "<CENTER>패치가 완료되었습니다. 보안을 위해 _patch 폴더와 그 안에 있는 화일을 삭제 해주세요.</CENTER>";
                    }                    
                    else
                    {
@header('Content-type: text/html; charset=UTF-8');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Patch v0.7.1 UP</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" href="html/css/main.css" />
</head>
<body>
<br /><br />
<form method="post" name="patch" action="patch.php">
<input name="exe" type="hidden" value="ok" />
<table width="75%" border="0" align="center" cellpadding="0" cellspacing="2">
  <tr>
    <td bgcolor="#CCCCCC" align="center"><br /><b>심플로그를 v0.7.1 이상으로 패치합니다.<br />아래 버튼을 눌러 패치를 시작하세요.</b><br /><br /></td>
  </tr>
  <tr>
    <td align="center"><input type="submit" name="ok" value="Patch Now!" /></td>
  </tr>
</table>
</form>
</body>
</html>
<?php
                    }

                }
                else
                {
                    $library = new Library();
                    $library->printSimpleError("최고 사용자만 사용가능합니다.");
                    session_destroy();
                }
            }
        }
        break;
}
?>