<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// | 05/01/06 Fixed For PHP5                                              |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 20/Apr/2006  13:25                               |
// +----------------------------------------------------------------------+
//
// $Id admin.inc$
require_once dirname(dirname(__FILE__))."/_lib/category.inc";
require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";
require_once dirname(dirname(__FILE__))."/_lib/library.inc";

class Admin
{
    // object
    var $data;
    var $queryArray = array();

    function Admin()
    {
         $this->data = new Data();
         session_start();
         $GLOBALS['n'] = $_SESSION['spg_user_name'];
    }

    function start()
    {
        switch ($_GET['mode'])
        {
            case 'delete':
                $this->_deletePost($_GET['post']);
                goToPage("?n=".$_GET['n']."&mode=list");
                break;
            case 'chrel':
                $this->_changeRelation($_GET['what']);
                break;
            case 'delcate':
                $this->_delCate($_GET['no']);
                break;
            case 'stb':
                $this->_showSTB($result);
                break;
            case 'deluser':
                $this->_delNeigh($_GET['user']);
                goToPage("?n=".$_GET['n']."&mode=usersetting");
                break;
            case 'groupup':
                $this->_groupMove(-1, $_GET['gno'], $_GET['or']);
                goToPage("?n=".$_GET['n']."&mode=linksetting");
                break;
            case 'groupdown':
                $this->_groupMove(1, $_GET['gno'], $_GET['or']);
                goToPage("?n=".$_GET['n']."&mode=linksetting");
                break;
            case 'linkup':
                $this->_linkMove(-1, $_GET['lno'], $_GET['gno'], $_GET['or']);
                goToPage("?n=".$_GET['n']."&mode=linklist&gno=".$_GET['gno']);
                break;
            case 'linkdown':
                $this->_linkMove(1, $_GET['lno'], $_GET['gno'], $_GET['or']);
                goToPage("?n=".$_GET['n']."&mode=linklist&gno=".$_GET['gno']);
                break;
            case 'linkvistogl':
                $this->_linkVisibleToggle($_GET['lno'], $_GET['v']);
                goToPage("?n=".$_GET['n']."&mode=linklist&gno=".$_GET['gno']);
                break;
            case 'groupvistogl':
                $this->_groupVisibleToggle($_GET['gno'], $_GET['v']);
                goToPage("?n=".$_GET['n']."&mode=linksetting");
                break;
            case 'linkgroupdel';
                $this->_linkGroupDel($_GET['gno']);
                goToPage("?n=".$_GET['n']."&mode=linksetting");
                break;
            case 'linklinkdel':
                $this->_linkLinkDel($_GET['lno'], $_GET['gno'], $_GET['or']);
                goToPage("?n=".$_GET['n']."&mode=linklist&gno=".$_GET['gno']);
                break;
            case 'delafile':
                $del = $this->delAFile($_GET['fno']);
                if($del['file_size'])
                {
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<html>
<head>
<title>File Del</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<body>
<script type="text/javascript">
parent.document.frmWrite.tfilesize.value = parseInt(parent.document.frmWrite.tfilesize.value) - <?php echo $del['file_size']; ?>;
</script>
</body>
</html>
<?php
                }
                exit;
                break;            
            case 'postsync':
                $this->postSync($_GET['post'], $_GET['issync']);
                require_once dirname(dirname(__FILE__))."/_lib/script.inc";
                $script = new Script();
                $script->endSync();
                //goToPage("?n=".$_GET['n']."&mode=list");
                exit;
                break;
            case 'unsync':
                break;            
            case 'regsimplog':
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<html>
<head>
<title>Register Simplog Center(Centre)</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<body>
<iframe src="http://thesimplog.com/login/register.php?blog=<?php echo rawurlencode((SPG_URI).'/'.$GLOBALS['n']);?>" style="width:100%; height:420px;" frameborder="0" scrolling="no" ></iframe>
<center><input type="button" value="CLOSE" onclick="window.close();"></center>
</body>
</html>
<?php
                exit;
                break;
            case 'changesimpass':
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<html>
<head>
<title>Register Simplog Center(Centre)</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<body>
<iframe src="http://thesimplog.com/login/register.php?mode=changepass&blog=<?php echo rawurlencode((SPG_URI).'/'.$GLOBALS['n']);?>" style="width:100%; height:420px;" frameborder="0" scrolling="no" ></iframe>
<center><input type="button" value="CLOSE" onclick="window.close();"></center>
</body>
</html>
<?php
                exit;
                break;
            case 'preview':
                // get image size

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<html>
<head>
<title>Image Preview</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<script type="text/javascript">
function resize(img)
{
    var width = document.getElementById(img).width;
    var height = document.getElementById(img).height;

    var swidth = screen.width - 200;
    var sheight = screen.height - 200;

    if (height >= sheight){
        height = height - (height - sheight);
    }
    if (width >= swidth){
        width = width - (width - swidth);
    }
    
    window.resizeTo(width + 50, height + 70);
}
</script>
</head>
<body onload="javascript:resize('preimg');">
<a href="#" title="close"><img id="preimg" src="<?php echo $_GET['img'];?>" alt="close" onclick="self.close();" border="0" /></a>
</body>
</html>
<?php
                exit;
                break;
                case 'multipreview':
                // get image size

?>
<html>
<head>
<title>Preview</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<script language="JavaScript" type="text/javascript" src="<?php echo  SPG_URI; ?>/_lib/javascript.php?script=<?php echo $_GET['n']; ?>"></script>
</head>
<body>
<script type="text/javascript">
var obj = '<embed src="<?php echo $_GET['src'];?>" width="100%" height="90%"></embed>';
writeObj(obj);
</script>
<br />
<center><input type="button" value="close" name="close" onclick="self.close();"></center>
</body>
</html>
<?php
                exit;
                break;
            case 'imagedel':
                $fileno = $_GET['fileno'];
                $file = $this->data->getFileInfo($_GET['n'], $fileno);
                if($file['author'])
                {
                    if($file['author'] == $_SESSION['spg_user_name'])
                    {
                        $this->delAFile($file['no']);
                    }
                    else
                    {
                        echo "You have NO permision to delete.";
                        exit;
                    }
                }
                else
                {
                    $path = SPG_ROOT."/_data/".$_GET['n']."/images/";
                    $imgPath = $path.$file['dir']."/".$file['file_name'];
                    if(file_exists($imgPath))
                    {
                        unlink($imgPath);
                        @rmdir(dirname($imgPath));
                    }
                    else
                    {
                        echo "File does not exist!";
                        exit;
                    }
                }
                goToPage("html/imagelibrary.html?script=".$_GET['n']);
                exit;
                break;
            case 'filedel':
                $fileno = $_GET['fileno'];
                $type = $_GET['type'];
                $file = $this->data->getFileInfo($_GET['n'], $fileno);
                if($file['author'])
                {
                    if($file['author'] == $_SESSION['spg_user_name'] || $file['user_name'] == $_SESSION['spg_user_name'])
                    {
                        if(!$this->delAFile($file['no']))
                        {
                            echo "File does not exist!";
                            exit;
                        }
                    }
                    else
                    {
                        echo "You have NO permision to delete.";
                        exit;
                    }
                }
                else
                {
                    if(!$this->delAFile($file['no']))
                    {
                        echo "File does not exist!";
                        exit;
                    }
                }
                goToPage("html/".$type."library.html?script=".$_GET['n']);
                exit;
                break;            
            case 'processfileup':
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<html>
<head>
<title>File Up</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<script language="JavaScript" type="text/javascript" src="html/js/fileup.php?script=<?php echo $_GET['n'];?>"></script>
</head>
<body>
<script type="text/javascript">
insertFile('<?php echo $_GET['name']; ?> (<?php echo $_GET['size']; ?>Bytes)', '<?php echo $_GET['fno']; ?>');
</script>
</body>
</html>
<?php
                exit;
                break;
            case 'uninstall':
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uninstall</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" href="html/css/main.css" />
</head>
<body>
<br /><br />
<form method="post" name="uninstall" action="start.php">
<input name="todo" type="hidden" value="uninstall" />
<input name="n" type="hidden" value="<?php echo $_GET['n'];?>" />
<table width="75%" border="0" align="center" cellpadding="0" cellspacing="2">
  <tr>
    <td bgcolor="#CCCCCC"><?php echo $GLOBALS['lang']['admin']['uninstalldesc'];?><br /><center><?php echo $GLOBALS['lang']['admin']['uninstallsure'];?></center></td>
  </tr>
  <tr>
    <td align="center"><input type="submit" name="ok" value="Uninstall" /> 
      <input name="cancel" type="button" id="cancel" value="Cancel" onclick="history.back();" /></td>
  </tr>
</table>
</form>
</body>
</html>
<?php
                exit;
                break;
            case 'getautorss':
                $this->autoGetRss($_GET['rss']);
                exit;
                break;
            // search and add an author
            case 'addauthor':
                $this->_showAddAuthor();
                exit;
                break;
            case 'makeblog':
                $this->_showMakeBlog();
                exit;
                break;
            case 'delcoworker':
                $this->delCoworker($_GET['id']);
                goToPage("?n=".$_GET['n']."&mode=authoredit");
                break;
            case 'selectauthor':
                $this->addAuthor($_GET['id'], $_GET['n']);
                exit;
                break;
            case 'blogdel':
                $this->blogDel($_GET['id']);
                break;
            case 'del_comm':
                $this->delComment($_GET['no'], $_GET['n']);
                goToPage("?n=".$_GET['n']."&mode=comment_list");
                break;
            case 'del_commnotify':
                $this->delCommentNotify($_GET['no'], $_GET['n']);
                goToPage("?n=".$_GET['n']."&mode=comment_notify");
                break;                
            case 'getcommtification':
                include "html/getcommnotify.html"; 
                exit;
                break;
            case 'userset':
                $this->submitUserSet();
                goToPage("?n=".$_GET['n']."&mode=simplersetting");
                exit;
                break;
        }

        switch ($_POST['todo'])
        {
            case 'write':
                require_once 'write.inc';
                require_once dirname(dirname(__FILE__))."/_lib/generatexml.inc";
                $rss = new GenerateXML();
                $writePost = new WritePost();
                $writePost->processWrite();
                $rss->makeRSSFile(dirname(dirname(__FILE__))."/".$_POST['n']);
                goToPage("?n=".$_POST['n']."&mode=list");
                break;
            case 'modify':
                require_once 'write.inc';
                require_once dirname(dirname(__FILE__))."/_lib/generatexml.inc";
                $rss = new GenerateXML();
                $writePost = new WritePost();
                $writePost->processModify();
                $rss->makeRSSFile(dirname(dirname(__FILE__))."/".$_POST['n']);
                goToPage("?n=".$_POST['n']."&mode=list");
                break;
            case 'settingsave':
                $this->_saveSettings();
                require_once dirname(dirname(__FILE__))."/_lib/generatexml.inc";
                $rss = new GenerateXML();
                $rss->makeRSSFile(dirname(dirname(__FILE__))."/".$_POST['username']);
                goToPage("?n=".$_POST['username']."&mode=settingok");
                break;
            case 'secsettingsave':
                $this->_saveSecSettings();
                break;
            case 'listexe':
                $this->listExe($_POST['post'], $_POST['select']);
                break;
            case 'commlist':
                $this->commentExe($_POST['commentlist']);
                break;
            case 'commnotifyexe':
                $this->commentNotifyExe($_POST['commentlist']);
                break;
            case 'neighexe':
                $this->neighbourExe($_POST['neighbours'], $_POST['select']);
                break;
            case 'addsimplerexe':
                $this->_addSimplerExe();
                goToPage("?n=".$GLOBALS['n']."&mode=simplersetting");
                break;
            case 'simplerexe':
                $this->_simplerExe($_POST['simpler'], $_POST['select']);
                break;
            case 'addgroupexe':
                $this->_addGroup($_POST);
                goToPage("?n=".$_POST['n']."&mode=linksetting");
                break;
            case 'modaddgroupexe':
                $this->_modGroup($_POST);
                goToPage("?n=".$_POST['n']."&mode=linksetting");
                break;
            case 'addlinkexe':
                $this->_addLink($_POST);
                goToPage("?n=".$_POST['n']."&mode=linklist&gno=".$_POST['linkgroup']);
                break;
            case 'modaddlinkexe':
                $this->_modLink($_POST);
                goToPage("?n=".$_POST['n']."&mode=linklist&gno=".$_POST['linkgroup']);
                break;
            case 'linkexe':
                $this->_linkListsExe($_POST['linklists'], $_POST['togroup']);
                goToPage("?n=".$_POST['n']."&mode=linklist&gno=".$_POST['gno']);
                break;
            case 'stb':
                require_once dirname(dirname(__FILE__))."/_lib/tb.inc";
                $tb = new TBack();
                $result = $this->data->getItemsByNoByBlog($_POST['post'], 0, $_POST['n']);
                $postData = $result->fetchRow();
                $tb->STB($_POST['stb_url'], $postData);
                break;
            case 'fileup':
                $this->uploadFile();
                exit;
                break;
            case 'multiup':
                $this->uploadMultimedia();
                exit;
                break;
            case 'uninstall':   // uninstall SIMPLOG, 
                // delete DB
                $this->_uninstall();
                exit;
                break;
            case 'addauthor':
                $this->checkAuthorId($_POST['author']);
                exit;
                break;
            case 'addblog':
                $this->makeBlogId();
                exit;
                break;
            case 'blogset':
                $this->submitSimplerSet();
                goToPage("?n=".$_POST['n']."&mode=simplersetting");
                break;
            default:
                $main = new Mainview();
                include "html/admin.html";
                break;
        }        
    }

    function contents()
    {
        switch ($_GET['mode'])
        {
            case 'write':
                $this->_showWriteForm();
                break;
            case 'modify':
                $this->_showWriteForm();
                break;
            case 'open':
                $this->_closePost();
                break;
            case 'close':
                $this->_openPost();
                break;
            case 'settingok':
            case 'setting':
                $adminData = $this->data->getAdminData($_GET['n']);
                $this->_showSettingPage($adminData);
                break;
            case 'usersetting':
                $this->_showUserSettingPage();
                break;
            case 'simplersetting':                
                $this->_showSimplerSettingPage(); 
                break;
            case 'addsimpler':
                $adminData = $this->data->getAdminData($_SESSION['spg_user_name']);
                $this->_showNewSimplerForm($adminData);
                break;
            case 'secsetting':
                $adminData = $this->data->getAdminData($_GET['n']);
                $this->_showSecuritySetting($adminData);
                break;
            case 'linksetting':
                $this->_showLinkSettingPage();
                break;
            case 'addlinkgroup':
                $this->_showGroupForm($_GET['gno']);
                break;
            case 'addlink':
                $this->_showLinkForm($_GET['lno']);
                break;
            case 'linklist':
                $this->_showLinkList($_GET['gno']);
                break;
            case 'list':
                $this->listPosts();
                break;
            case 'stat':
                $this->_showMonthStat();
                break;
            case 'statday':
                $this->_showDayStat();
                break;
            case 'stattime':
                $this->_showTimeStat();
                break;
            case 'countlog':
                $this->_showCoungLog();
                break;
            case 'countlog2':
                $this->_showCoungLog2();
                break;
            case 'bloglist':
                $this->_showBlogList();
                break;
            case 'authoredit':
                $this->_showAuthorEdit();
                break;
            case 'comment_list':
                $this->_showCommentList();
                break;
            case 'comment_notify':
                $this->_showCommentNotify();
                break;
            default:
                include "html/home.html";
                break;
        }        
    }

    function _showCommentList()
    {
        $main = new Mainview();

        $this->queryArray['mode'] = "comment_list";
        $this->queryArray['n'] = $_GET['n'];

        $numPPage = 15;
        $pageNum = 10;
        $totalArticle = $this->data->getAllNumberComment($_GET['n']);
        $start = $main->getStartNumOfPage($_GET['p'], $numPPage);
        
        if($_GET['n'])
        {
            $query = sprintf("SELECT c.*, p.subject ".
                " FROM ".SPG_PREFIX."_comments c, ".SPG_PREFIX."_posts p".
                " WHERE c.user_name=%s AND c.parent_no = p.no".
                " GROUP BY c.no".
                " ORDER BY date DESC LIMIT %s, %s",
                $this->data->quote_smart($_GET['n']),
                $start,
                $numPPage);

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            } 

            include "html/comment_list.html";
        }
        else
        {
            echo "Error:".__FILE__.__LINE__;
        }
    }

    function _showCommentNotify()
    {
        $main = new Mainview();

        $this->queryArray['mode'] = "comment_notify";
        $this->queryArray['n'] = $_GET['n'];

        $numPPage = 15;
        $pageNum = 10;

        $query = sprintf("SELECT count(*)".
                " FROM ".SPG_PREFIX."_comm_notify c".
                " WHERE c.user_name=%s AND c.parent = 0".
                " GROUP By post_id",
                $this->data->quote_smart($_GET['n']));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
        $totalArticle = $result;
        $start = $main->getStartNumOfPage($_GET['p'], $numPPage);

        if($_GET['n'])
        {
            $query = sprintf("SELECT c.*, b.blog_url, b.blog_name, b.blog_author ".
                " FROM ".SPG_PREFIX."_comm_notify c, ".SPG_PREFIX."_comm_notify_blogs b".
                " WHERE c.user_name=%s AND c.parent = 0 AND c.blog_id=b.blog_id".
                " GROUP By post_id".
                " ORDER BY modified DESC LIMIT %s, %s",
                $this->data->quote_smart($_GET['n']),
                $start,
                $numPPage);

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            } 

            include "html/comment_notify.html";
        }
        else
        {
            echo "Error:".__FILE__.__LINE__;
        }
    }


    function blogDel($blogId)
    {
        $adminData = $this->data->getAdminData($blogId);

        // check permision
        if($adminData['owner'] != $_SESSION['spg_user_name'])
        {
            $library = new Library();
            $library->dieError($GLOBALS['lang']['script']['nopermision'], 1, 1);
        }
        else
        {
            $this->_delSimpler($blogId);
            goToPage("?n=".$_GET['n']."&mode=bloglist");
        }
    }

    function delComment($no, $n)
    {
        // delete child comments first
        $query = "DELETE FROM ".SPG_PREFIX."_comments WHERE child_no='$no' AND user_name='$n'";
        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        // then delete a parent comment
        $query = "DELETE FROM ".SPG_PREFIX."_comments WHERE no='$no' AND user_name='$n'";
        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }        
    }

    function delCommentNotify($no, $n)
    {
        $what = $_GET['what'];
        // delete all comments in this post
        // $no => post_id
        if($what == "post")
        {
            $query = "DELETE FROM ".SPG_PREFIX."_comm_notify WHERE post_id='$no' AND user_name='$n'";
            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }
        }
        else if($what == "comment")
        {
            //first, get data
            $query = "SELECT parent, comm_no FROM ".SPG_PREFIX."_comm_notify WHERE id='$no' AND user_name='$n'";
            $comm = $GLOBALS['dbcon']->getRow($query);
            if (DB::isError($comm))
            {
                die ($comm->getMessage().__FILE__.__LINE__);
            }

            if($comm['parent'] == "0")
            {
                // delete child comments first
                $query = "DELETE FROM ".SPG_PREFIX."_comm_notify WHERE parent='".$comm['comm_no']."' AND user_name='$n'";
                $result = $GLOBALS['dbcon']->query($query);
                if (DB::isError($result))
                {
                    die ($result->getMessage().__FILE__.__LINE__);
                }
            }

            // then delete a parent comment
            $query = "DELETE FROM ".SPG_PREFIX."_comm_notify WHERE id='".$no."' AND user_name='$n'";
            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }
        }        
    }


    function submitSimplerSet()
    {
        $newData['admin_simpler_allowed_blog_num'] = $_POST['blog_num'];
        $newData['admin_simpler_allowed_metablog_num'] = $_POST['metablog_num'];
        $newData['admin_simpler_blog_size'] = $_POST['blog_size'];

        $this->data->updateDataTable($newData);
    }

    function submitUserSet()
    {
        $user = $_GET['user'];
        $global = $_GET['global'];
        if($global)
        {
            // delete user individual setting
            $array = array('admin_simpler_allowed_blog_num', 'admin_simpler_allowed_metablog_num', 'admin_simpler_blog_size');
            foreach($array as $value)
            {
                $query = sprintf("DELETE FROM ".SPG_PREFIX."_data".
                " WHERE name=%s AND user_name = %s",
                $this->data->quote_smart($value),
                $this->data->quote_smart($user));
                $result = $GLOBALS['dbcon']->query($query);
            }
        }
        else
        {
            if($user)
            {
                $newData['admin_simpler_allowed_blog_num'] = $_GET['blog_num'];
                $newData['admin_simpler_allowed_metablog_num'] = $_GET['metablog_num'];
                $newData['admin_simpler_blog_size'] = $_GET['blog_size'];

                $this->data->updateDataTableByBlog($newData, $user);
            }
        }
    }

    function makeBlogId()
    {
        if(!$_POST['simpler_id'])
        {
            $library = new Library();
            $library->dieError($GLOBALS['lang']['admin']['cannotuseid'], 1, 1);
        }
        $this->_addSimplerExe(1);
        require_once dirname(dirname(__FILE__))."/_lib/script.inc";
        $script = new Script();
        $script->addBlogOK();
    }

    function _showMakeBlog()
    {
        $adminData = $this->data->getAdminData($_GET['n']);
        $adminData2 = $this->data->getAdminData2ById($_GET['n']);
        if(!$adminData2['simpler_allowed_blog_num'])
        {
            // get super admindata2 
            $superAdminData2 = $this->data->getAdminData2ById($GLOBALS['GSetup']['ROOT']);
            $allowedBlogNum = $superAdminData2['admin_simpler_allowed_blog_num'];
        }
        else
        {
            $allowedBlogNum = $adminData2['simpler_allowed_blog_num'];
        }

        // get users number of blogs
        $query = sprintf("SELECT count(owner) FROM ".SPG_PREFIX."_admin WHERE owner = '%s'",
                $_SESSION['spg_user_name']);
        $numBlogs = $GLOBALS['dbcon']->getOne($query);

        // if user's blogs are greater than allowed blog
        if($allowedBlogNum <= $numBlogs && $_SESSION['spg_user_name'] != $GLOBALS['GSetup']['ROOT'])
        {
            $library = new Library();
            $library->dieError($GLOBALS['lang']['admin']['notmakeblog'], 1);
        }
        else
        {
            include "html/addblog.html";
        }
    }

    function delCoworker($id)
    {
        $query = sprintf("DELETE FROM ".SPG_PREFIX."_data WHERE name = 'coworker_%s' AND user_name='%s'",
            $id, $_GET['n']);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        $adminData2 = $this->data->getAdminData2ById($_GET['n']);

        $newData['num_authors'] = $adminData2['num_authors'] - 1;
        if($newData['num_authors'] < 0) $newData['num_authors'] = 0;
        $this->data->updateDataTableByBlog($newData, $_GET['n']);

    }

    function checkAuthorId($nick)
    {
        $userResult = $this->data->getUser($nick);
        require_once dirname(dirname(__FILE__))."/_lib/script.inc";
        $script = new Script();

        if($userResult->numRows() < 1)
        {
            // user is not exists
            $script->alertAndBack($GLOBALS['lang']['script']['usernotexist']);
        }
        else if($userResult->numRows() == 1)
        {
            $user = $userResult->fetchRow();
            $this->addAuthor($user['owner'], $_POST['n']);
        }
        else
        {
            include "html/selectauthor.html";
        }
    }

    function addAuthor($id, $blog)
    {
        require_once dirname(dirname(__FILE__))."/_lib/script.inc";
        $script = new Script();

        if(!$id)
        {
            // user is not exists
            $script->alertAndBack($GLOBALS['lang']['script']['usernotexist']);
        }
        else if($id == $_SESSION['spg_user_name'])
        {
            // if you typed owner
            $script->alertAndBack($GLOBALS['lang']['script']['notaddowner']);
        }
        else
        {
            $adminData2 = $this->data->getAdminData2ById($blog);

            if($adminData2['coworker_'.$id])
            {
                // have already added
                $script->alertAndBack($GLOBALS['lang']['script']['alreadyadded']);
            }
            else
            {
                $newData['coworker_'.$id] = $id;
                if($adminData2['num_authors'] < 0) $adminData2['num_authors'] = 0;
                $newData['num_authors'] = $adminData2['num_authors'] + 1;
                $this->data->updateDataTableByBlog($newData, $blog);
                $script->addAuthorOK();
            }
        }

    }

    function _showAddAuthor()
    {
        $adminData2 = $this->data->getAdminData2ById($_GET['n']);
        $mainview = new Mainview();
        $cores = $this->data->getCoworkersByBlog($_GET['n']);
        $numAuthor = $mainview->getNumCoworker($cores->numRows());
        include "html/addauthor.html";
    }

    function _showAuthorEdit()
    {
        $mainview = new Mainview();
        $coResult = $this->data->getCoworkersByBlog($_GET['n']);
        include "html/authoredit.html";
    }

    /**
     * _showBlogList
     * 
     * @access private
    **/
    function _showBlogList()
    {
        $myBlogs = $this->data->getMyBlog($_SESSION['spg_user_name']);
        $myCoworkBlogs = $this->data->getCoworkBlog($_SESSION['spg_user_name']);
        $main = new Mainview();

        include "html/myblog.html";
    }

    /**
     * _uninstall
     * uninstall simplog
     * @access private
    **/
    function _uninstall()
    {
        // checking access level
        require_once dirname(dirname(__FILE__))."/_lib/login.inc";
        $login = new login();
        $login->accessByLevel(1, 2);

        // 0. change the level to 2
        $query = "UPDATE ".SPG_PREFIX."_admin".
            " SET level = 2".
            " WHERE level = 1";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        // 1. delete users DB and user folder
        $query = "SELECT user_name".
            " FROM ".SPG_PREFIX."_admin";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        while($dbData = $result->fetchRow())
        {
            // delete user db and folder
            $this->_delSimpler($dbData['user_name']);
        }
        
        // 2. drop admin table
        $query = "DROP TABLE ".SPG_PREFIX."_admin";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        // then drop other tables
        include dirname(dirname(__FILE__))."/_lib/schema.inc";
        
        // other tables
        unset($query);
        foreach ($simplerSchemaDrop as $query)
        {
            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__.$query);
            }
        }

        // 3. delete _data, _cache folders
        $library = new Library();
        $library->delDir(SPG_ROOT."/_data/");
        $library->delDir(SPG_ROOT."/_cache/");

        // 4. show success message
        echo $GLOBALS['lang']['admin']['uninstallok'];

    }

    /**
     * postSync
     *
    **/
    function postSync($postNo, $issync)
    {
        $result = $this->data->getItemsByNoByBlog($postNo, 3, $_GET['n']);
        $post = $result->fetchRow();

        // if display level is not opened then ignore
        if($post['no'])
        {
            require_once dirname(dirname(__FILE__))."/_lib/simplexml.inc";

            $simplexml = new SimpleXml();
            $library = new Library();

            $url = rawurlencode((SPG_URI)."/".$_GET['n']."/");

            $postData = "todo=sync&url=".$url."&post=".$postNo."&issync=".$issync;

            $syncResult = $library->getPostToHost("thesimplog.com", "/login/action.php", $postData, "80");
            
            // get response from a server with TB type
            $parseData = $library->parseTBResponse($syncResult);

            if (get_magic_quotes_gpc()) 
            {
                $parseData['body'] = stripslashes($parseData['body']);
            }
            $parseData['body'];

            $xmlParse = $simplexml->setInputString($parseData['body']);
            $xmlParse = $simplexml->parse();

            $xmlStruct = $simplexml->getStruct();
            
            // sync ok
            if (trim($xmlStruct['ERROR']) == "0")
            {
                $this->syncUpdate($postNo, 1, $_GET['n']);
            }
            // sync fail
            else
            {
                $this->syncUpdate($postNo, 0, $_GET['n']);
            }
        }
    }

    /**
     * syncUpdate()
     * sync update for the post
    **/
    function syncUpdate($postNo, $sync, $blog)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_posts".
            " SET is_sync = %s".
            " WHERE no = %s AND user_name=%s",            
            $this->data->quote_smart($sync),
            $this->data->quote_smart($postNo),
            $this->data->quote_smart($blog));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }        
    }

    /**
     * _addSimplerExe
     * from adding simpler form
    **/
    function _addSimplerExe($another = "0")
    {
        require_once dirname(dirname(__FILE__))."/_lib/login.inc";
        $login = new login();
        $login->accessByLevel(2, 2);

        $id = $_POST['simpler_id'];
        $pass = $_POST['simpler_pass'];
        $lang = $_POST['language'];

        $library = new Library();

        //// 0. check if there is same folder name
        if(is_dir(SPG_ROOT."/".$id))
        {
            $library->dieError($GLOBALS['lang']['admin']['cannotuseid'], 1, 1);
        }

        //// 1. make blog folder
        if(!is_dir(SPG_ROOT."/".$id))
        {
            if(!mkdir(SPG_ROOT."/".$id, 0707))
            {
                $library->dieError(__FILE__.__LINE__.": ".$GLOBALS['lang']['admin']['failcfolder'], 1, 1);
            }
			else
			{
				chmod(SPG_ROOT."/".$id, 0707);
			}
        }

        //// 2. generate index.php
        $index = SPG_ROOT."/_lib/index_copy.inc";
        if (!copy($index, SPG_ROOT."/".$id."/index.php")) 
        {
            // delete blog folder to initialise
            rmdir(SPG_ROOT."/".$id);
            $library->dieError(__FILE__.__LINE__.": ".$GLOBALS['lang']['admin']['problemblog'], 1, 1);
        }

        //// 3. make data folder under _data/
        if(!is_dir(SPG_ROOT."/_data/".$id))
        {
            if(!mkdir(SPG_ROOT."/_data/".$id, 0707))
            {
                $library->dieError(__FILE__.__LINE__.": ".$GLOBALS['lang']['admin']['failcfolder'], 1, 1);
            }
			else
			{
				chmod(SPG_ROOT."/_data/".$id, 0707);
			}
        }

        //// 4. add configuration data
        if($another == "1")
        {
            $password = "'".$_SESSION['spg_user_name']."'";
            $owner = $_SESSION['spg_user_name'];
            $level = 2;            
        }
        else if($another == "0")
        {
            $password = "password('".$pass."')";
            $owner = $id;
            $level = 2;
        }

        $query = sprintf("INSERT INTO ".SPG_PREFIX."_admin".
            " (user_name, password, owner, level, reg_date, language, is_use)".
            " VALUES".
            " (%s, %s, %s, %s, now(), %s, 1)",
            $this->data->quote_smart($id),
            $password,
            $this->data->quote_smart($owner),
            $this->data->quote_smart($level),
            $this->data->quote_smart($lang));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        // insert a default category
        $query = "INSERT INTO ".SPG_PREFIX."_category".
            " (category_id, category_name, open, user_name)".
            " VALUES".
            " (1, 'Category', '1', '".$id."')";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        // insert a default group for the link
        $query = "INSERT INTO ".SPG_PREFIX."_links_group".
            " (group_no, group_name, group_order, visible, user_name)".
            " VALUES".
            " (1, 'Bloggers', '1', '1', '".$id."')";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        // default setting
        $newData['admin_guest_num'] = 10;
        $newData['admin_guest_use1'] = 1;
        $newData['admin_cate_show_num'] = 1;
        $newData['admin_nowiam_title'] = "Notice";
        $newData['admin_numrelated'] = 5;
        $newData['admin_numtags'] = 20;

        $this->data->updateDataTableByBlog($newData, $id);
    }

    /**
     * _addGroup
     * add group for link
    **/
    function _addGroup($post)
    {
        $result = $this->data->getLinksGroupsByBlog($post['n']);

        $total = $result->numRows();
        $group_no = $this->data->getNextId("links_group", "group_no", $post['n']);

        $query = sprintf("INSERT INTO ".SPG_PREFIX."_links_group".
            " (group_no, group_name, visible, group_order, user_name)".
            " VALUES".
            " (%s, %s, %s, %s, %s)",
            $group_no,
            $this->data->quote_smart($post['group_name']),
            $this->data->quote_smart($post['visible']),
            $total+1,
            $this->data->quote_smart($post['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    /**
     * _modGroup
     * modify group for link
    **/
    function _modGroup($post)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_links_group".
            " SET group_name = %s, visible = %s".
            " WHERE group_no = %s AND user_name=%s",
            $this->data->quote_smart($post['group_name']),
            $this->data->quote_smart($post['visible']),
            $this->data->quote_smart($post['gno']),
            $this->data->quote_smart($post['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    /**
     * _addLink
     * add link
    **/
    function _addLink($post)
    {
        $result = $this->data->getLinksListByGroupByBlog($post['linkgroup'], $post['n']);
        $total = $result->numRows();
        $link_no = $this->data->getNextId("links", "link_no", $post['n']);

        $query = sprintf("INSERT INTO ".SPG_PREFIX."_links".
            " (link_no, link_url, group_no, link_name, link_desc, link_rss, link_order, user_name)".
            " VALUES".
            " (%s, %s, %s, %s, %s, %s, %s, %s)",
            $link_no,
            $this->data->quote_smart($post['url']),
            $this->data->quote_smart($post['linkgroup']),
            $this->data->quote_smart($post['link_name']),
            $this->data->quote_smart($post['link_desc']),
            $this->data->quote_smart($post['link_rss']),
            $total+1,
            $this->data->quote_smart($post['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        $this->_updateLinkGroup(1, $post['linkgroup'], $post['n']);
    }

    /**
     * _modLink
     * modify link
    **/
    function _modLink($post)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_links".
            " SET link_url = %s, group_no = %s, link_name = %s, link_desc = %s, link_rss = %s".            
            " WHERE link_no = %s AND user_name=%s",
            $this->data->quote_smart($post['url']),
            $this->data->quote_smart($post['linkgroup']),
            $this->data->quote_smart($post['link_name']),
            $this->data->quote_smart($post['link_desc']),
            $this->data->quote_smart($post['link_rss']),
            $this->data->quote_smart($post['lno']),
            $this->data->quote_smart($post['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }        
    }

    function _updateLinkGroup($num, $group, $blog)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_links_group".
            " SET num_links = num_links + %s".
            " WHERE group_no = '%s' AND user_name=%s",
            $num, $group,
            $this->data->quote_smart($blog));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    /**
     * _groupMove
     * @param int $how : -1 = up, 1 = down
     * @param int $group group number
     * @param int $order order number
    **/
    function _groupMove($how, $group, $order)
    {
        $result = $this->data->getLinksGroups();
        $total = $result->numRows();

        if(!(($how == -1 && $order == 1) || ($how == 1 && $order == $total)))
        {
            $order = $order + $how;

            $query = sprintf("UPDATE ".SPG_PREFIX."_links_group".
                " SET group_order = group_order - %s".
                " WHERE group_order = '%s' AND user_name=%s",
                $how, $order, $this->data->quote_smart($_GET['n']));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            $query = sprintf("UPDATE ".SPG_PREFIX."_links_group".
                " SET group_order = group_order + %s".
                " WHERE group_no = '%s' AND user_name=%s",
                $how, $group, $this->data->quote_smart($_GET['n']));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }            
        }
    }

    /**
     * _linkMove
     * @param int $how : -1 = up, 1 = down
     * @param int $linkNo link number
     * @param int $group group number
     * @param int $order order number
    **/
    function _linkMove($how, $linkNo, $group, $order)
    {
        $result = $this->data->getLinksListByGroup($group);
        $total = $result->numRows();

        if(!(($how == -1 && $order == 1) || ($how == 1 && $order == $total)))
        {
            $order = $order + $how;

            $query = sprintf("UPDATE ".SPG_PREFIX."_links".
                " SET link_order = link_order - %s".
                " WHERE link_order = '%s' AND group_no = %s AND user_name=%s",
                $how, $order, $group, $this->data->quote_smart($_GET['n']));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            $query = sprintf("UPDATE ".SPG_PREFIX."_links".
                " SET link_order = link_order + %s".
                " WHERE link_no = '%s' AND user_name=%s",
                $how, $linkNo, $this->data->quote_smart($_GET['n']));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }            
        }
    }

    function _linkVisibleToggle($lno, $visible)
    {
        if($visible == "1")
            $visible = "0";
        else $visible = "1";

        $query = sprintf("UPDATE ".SPG_PREFIX."_links".
                " SET visible = '%s'".
                " WHERE link_no = '%s' AND user_name=%s",
                $visible, $lno, $this->data->quote_smart($_GET['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function _groupVisibleToggle($gno, $visible)
    {
        if($visible == "1")
            $visible = "0";
        else $visible = "1";

        $query = sprintf("UPDATE ".SPG_PREFIX."_links_group".
                " SET visible = '%s'".
                " WHERE group_no = '%s' AND user_name=%s",
                $visible, $gno, $this->data->quote_smart($_GET['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function _linkGroupDel($gno)
    {
        if($gno == "1")
        {
            $library = new Library();
            $library->dieError($GLOBALS['lang']['admin']['cannotdelgroup']);
        }
        else
        {
            // 1. delete group row
            $query = sprintf("DELETE FROM ".SPG_PREFIX."_links_group".
                    " WHERE group_no = '%s' AND user_name=%ss",
                    $gno, $this->data->quote_smart($_GET['n']));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }       

            // 2. move related link to group no 1

            // get total number of post for group 1(default group)
            $result = $this->data->getLinksListByGroup(1);
            $topGroupNum = $result->numRows();

            $query = sprintf("UPDATE ".SPG_PREFIX."_links".
                    " SET group_no = '1', link_order = link_order + %s".
                    " WHERE group_no = '%s' AND user_name=%s",
                    $topGroupNum, $gno, $this->data->quote_smart($_GET['n']));

            $result = $GLOBALS['dbcon']->query($query);
            $updatedLinks = $GLOBALS['dbcon']->affectedRows();
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            // 3. increase the number of link for group no 1
            $this->_updateLinkGroup($updatedLinks, 1, $_GET['n']);
        }
    }

    function _linkLinkDel($lno, $gno, $or)
    {
        // 1. delete links
        $query = sprintf("DELETE FROM ".SPG_PREFIX."_links".
            " WHERE link_no = '%s' AND user_name=%s",
            $lno, $this->data->quote_smart($_GET['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }  

        // 2. make new order
        $query = sprintf("UPDATE ".SPG_PREFIX."_links".
            " SET link_order = link_order - 1".
            " WHERE link_order > '%s' AND group_no = '%s' AND user_name=%s",
            $or, $gno, $this->data->quote_smart($_GET['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        // 3. update a number of links for the group
        $query = sprintf("UPDATE ".SPG_PREFIX."_links_group".
            " SET num_links = num_links - 1".
            " WHERE group_no = '%s' AND user_name=%s",
            $gno, $this->data->quote_smart($_GET['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function listExe($post, $what)
    {
        require_once dirname(dirname(__FILE__))."/_lib/generatexml.inc";
        $rss = new GenerateXML();

        switch ($what)
        {           
            case "0":
            case "1":
            case "2":
            case "3":
                foreach($post as $value)
                {
                    $this->_changeDisLevel($value, $what);
                }
                $rss->makeRSSFile(dirname(dirname(__FILE__))."/".$GLOBALS['n']);
                goToPage("?n=".$GLOBALS['n']."&mode=list");
                break;
            case "del":
                foreach($post as $value)
                {
                    $this->_deletePost($value);
                }
                $rss->makeRSSFile(dirname(dirname(__FILE__))."/".$GLOBALS['n']);
                goToPage("?n=".$GLOBALS['n']."&mode=list");
                break;
        }
    }

    function commentExe($post)
    {     
        foreach($post as $value)
        {            
            $this->delComment($value, $GLOBALS['n']);
        }
        goToPage("?n=".$GLOBALS['n']."&mode=comment_list");
    }

    function commentNotifyExe($post)
    {     
        foreach($post as $value)
        {
            $this->delCommentNotify($value, $GLOBALS['n']);
        }
        goToPage("?n=".$GLOBALS['n']."&mode=comment_notify");
    }

    function neighbourExe($post, $what)
    {
        switch ($what)
        {
            case "1":
            case "2":
            case "3":
                foreach($post as $value)
                {
                    $this->_simpleChangeRelation($what, $value);
                }
                goToPage("?n=".$_GET['n']."&mode=usersetting");
                break;
            case "del":
                foreach($post as $value)
                {
                    $this->_delNeigh($value);
                }
                goToPage("?n=".$_GET['n']."&mode=usersetting");
                break;
        }
    }

    function _linkListsExe($link, $to)
    {
        foreach($link as $value)
        {
            // split link no and order
            $sep = explode("::", $value);
            $this->_linkMoveGroup($sep[0], $sep[1], $_POST['gno'], $to);           
        }
    }

    function _linkMoveGroup($link, $or, $from, $to)
    {
        // get total number of links for the target group
        $result = $this->data->getLinksListByGroup($to);
        $total = $result->numRows();

        // 1. change group number
        $query = sprintf("UPDATE ".SPG_PREFIX."_links".
            " SET group_no = '%s', link_order = '%s'".
            " WHERE link_no = '%s' AND user_name=%s",
            $to, $total + 1, $link, $this->data->quote_smart($_POST['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        // 2. change order for an original group
        $query = sprintf("UPDATE ".SPG_PREFIX."_links".
            " SET link_order = link_order - 1".
            " WHERE group_no = '%s' AND link_order > %s AND user_name=%s",
            $from, $or, $this->data->quote_smart($_POST['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
        
        // 3. change number of links for both groups
        $query = sprintf("UPDATE ".SPG_PREFIX."_links_group".
            " SET num_links = num_links - 1".
            " WHERE group_no = '%s' AND user_name=%s",
            $from, $this->data->quote_smart($_POST['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        $query = sprintf("UPDATE ".SPG_PREFIX."_links_group".
            " SET num_links = num_links + 1".
            " WHERE group_no = '%s' AND user_name=%s",
            $to, $this->data->quote_smart($_POST['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

    }

    function _simplerExe($post, $what)
    {
        // checking access level
        require_once dirname(dirname(__FILE__))."/_lib/login.inc";
        $login = new login();
        $login->accessByLevel(1, 2);

        switch ($what)
        {
            case "used":
                foreach($post as $value)
                {
                    $this->_changeUseSimpler(1, $value);
                }
                goToPage("?n=".$GLOBALS['n']."&mode=simplersetting");
                break;
            case "unused":            
                foreach($post as $value)
                {
                    $this->_changeUseSimpler(0, $value);
                }
                goToPage("?n=".$GLOBALS['n']."&mode=simplersetting");
                break;
            case "del":
                foreach($post as $value)
                {
                    $this->_delSimpler($value);
                }
                goToPage("?n=".$GLOBALS['n']."&mode=simplersetting");
                break;
        }
    }

    /**
     * _delSimpler
     * @param string $who : user name
    **/
    function _delSimpler($who)
    {
        $library = new Library();
        $adminData = $this->data->getAdminData($who);

        // check super admin
        if($adminData['level'] == 1)
        {
            $library->dieError($GLOBALS['lang']['admin']['delsuper']);
        }

        // del coworker data
        $query = sprintf("DELETE FROM ".SPG_PREFIX."_data".
            " WHERE value = %s",
            $this->data->quote_smart($who));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        //// 2. delete configuration data
        $query = sprintf("DELETE FROM ".SPG_PREFIX."_admin".
            " WHERE user_name = %s",
            $this->data->quote_smart($who));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        // delete all user data
        $tables = array("category", "comments", "count", "count_data", "count_log",
            "count_stat", "data", "files", "keywords", "links", "links_group", "members",
            "post_keywords", "posts", "trackback_sent", "trackbacks");
        
        foreach($tables as $table)
        {
            $newquery = sprintf("DELETE FROM ".SPG_PREFIX."_%s WHERE user_name=%s",
                $table, $this->data->quote_smart($who));

            $result = $GLOBALS['dbcon']->query($newquery);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__.$newquery);
            }
        }

        // delete linked table
        if(file_exists(dirname(dirname(__FILE__))."/_data/linked.php"))
        {
            $query = sprintf("DELETE FROM ".SPG_PREFIX."_boardlink".
            " WHERE simplog_user_id = %s",
            $this->data->quote_smart($who));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }
        }

        //// 3. delete blog folder
        if(is_dir(SPG_ROOT."/".$who))
        {
            $library->delDir(SPG_ROOT."/".$who);
        }
        
        //// 4. delete all data
        if(is_dir(SPG_ROOT."/_data/".$who))
        {
            $library->delDir(SPG_ROOT."/_data/".$who);
        }

    }

    /**
     * _changeUseSimpler
     * @param int $use : use => 1, unuse => 0
     * @param string $who : user name
    **/
    function _changeUseSimpler($use, $who)
    {
        $query = "UPDATE ".SPG_PREFIX."_admin".
            " SET is_use = '".$use."'".
            " WHERE user_name = '".$who."'";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function _showLinkSettingPage()
    {
        $main = new Mainview();

        $result = $this->data->getLinksGroups();

        include "html/link_setup.html";
    }

    function _showGroupForm($gno)
    {
        $main = new Mainview();

        $visible = "";
        $invisible = "";

        if($gno)
        {
            $result = $this->data->getLinksGroups($gno);
            $gData = $result->fetchRow();
            $action = "modaddgroupexe";            
            $title = $GLOBALS['lang']['admin']['modgroup'];
            $titleDesc = $GLOBALS['lang']['admin']['modgroupdesc'];
            
            if($gData['visible'] == 1)
                $visible = "checked";
            else
                $invisible = "checked";
        }
        else
        {
            $action = "addgroupexe";
            $title = $GLOBALS['lang']['admin']['addnewgroup'];
            $titleDesc = $GLOBALS['lang']['admin']['addnewgroupdesc'];
            $visible = "checked";
        }
        
        include "html/add_group.html";
    }

    function _showLinkForm($lno)
    {
        $main = new Mainview();
        
        if($lno)
        {
            $result = $this->data->getLinkByNo($lno);
            $lData = $result->fetchRow();

            $action = "modaddlinkexe";            
            $title = $GLOBALS['lang']['admin']['modaddlink'];
            $titleDesc = $GLOBALS['lang']['admin']['modaddlinkdesc'];
            
            if($lData['visible'] == 1)
                $visible = "checked";
            else
                $invisible = "checked";
        }
        else
        {
            $action = "addlinkexe";
            $title = $GLOBALS['lang']['admin']['addnewlink'];
            $titleDesc = $GLOBALS['lang']['admin']['addnewlinkdesc'];
            $visible = "checked";
        }

        $result = $this->data->getLinksGroups();
        include "html/add_link.html";
    }
    
    function _showLinkList($group)
    {
        $main = new Mainview();
        $library = new Library();
        
        $result = $this->data->getLinksGroups($group);
        $groupData = $result->fetchRow();

        $result = $this->data->getLinksListByGroup($group);
        include "html/link_list.html";
    }    

    function _showSimplerSettingPage()
    {
        $main = new Mainview();

        $totalSimplers = $this->data->getNumOfSimplers();
        $numSPage = 20;
        $pageNum = 10;
        $start = $main->getStartNumOfPage($_GET['p'], $numSPage);

        $this->queryArray['mode'] = "simplersetting";
        $this->queryArray['n'] = $_GET['n'];

        $result = $this->data->getSimplers($start, $numSPage);
        $simplerSetting = $this->data->getAdminData2();

        include "html/user_admin.html";
    }

    function _showUserSettingPage()
    {
        $main = new Mainview();
        $totalUsers = $this->getNumNeigh(0);
        $numUPage = 15;
        $pageNum = 10;
        $start = $main->getStartNumOfPage($_GET['p'], $numUPage);

        $this->queryArray['mode'] = "usersetting";
        $this->queryArray['n'] = $_GET['n'];

        $result = $this->data->getUsers($_GET['view'], $start, $numUPage);

        include "html/n_setup.html";
    }

    function _showSTB()
    {
        $main = new Mainview();
        include "html/stb.html";
        exit;
    }

    function getSentTB($postNo)
    {
        $query = sprintf(
            "SELECT no, post_no, towhere, date".
            " FROM ".SPG_PREFIX."_trackback_sent".
            " WHERE post_no = %s AND user_name=%s".
            " ORDER BY no DESC",
            $this->data->quote_smart($postNo),
            $this->data->quote_smart($_SESSION['spg_user_name']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }


    /**
     * to show option boxes in trackback send windows
    **/
    function printOptionEncode($default = "")
    {
        require_once dirname(dirname(__FILE__))."/_lang/language.inc";

        foreach($encodingList as $value)
        {
            if ($default == $value) $select = "selected";
            else $select = "";
            echo "<option value='".$value."' ".$select.">".$value."</option>";
        }
    }

    function getSkinList($adminData)
    {        
        $skinFolder = SPG_ROOT."/_skin";
        if(is_dir($skinFolder))
        {
            if($skinHandle = opendir($skinFolder))
            {
                while (($skinName = readdir($skinHandle)) !== false)
                {
                    if ($skinName != "." && $skinName != ".." && $skinName != "_default_" && $skinName != "_calendar_") 
                    {
                        if(is_dir($skinFolder."/".$skinName))
                        {
                            if($skinName == $adminData['skin'])
                                $select = "selected";
                            else
                                $select = "";

                            echo '<option value="'.$skinName.'" '.$select.'>'.$skinName.'</option>';
                        }
                    }                    
                }
                closedir($skinHandle);
            }
        }
    }

    function getCalSkinList($adminData)
    {        
        $skinFolder = SPG_ROOT."/_skin/_calendar_";
        if(is_dir($skinFolder))
        {
            if($skinHandle = opendir($skinFolder))
            {
                while (($skinName = readdir($skinHandle)) !== false)
                {
                    if ($skinName != "." && $skinName != "..") 
                    {
                        if(is_dir($skinFolder."/".$skinName))
                        {
                            if($skinName == $adminData['cal_name'])
                                $select = "selected";
                            else
                                $select = "";

                            echo '<option value="'.$skinName.'" '.$select.'>'.$skinName.'</option>';
                        }
                    }                    
                }
                closedir($skinHandle);
            }
        }
    }

    function getLangList($adminData)
    {        
        $langFolder = SPG_ROOT."/_lang";
        if(is_dir($langFolder))
        {
            if($langHandle = opendir($langFolder))
            {
                while (($langName = readdir($langHandle)) !== false)
                {
                    if ($langName != "." && $langName != "..") 
                    {
                        if(is_dir($langFolder."/".$langName))
                        {
                            if($langName == $adminData['language'])
                                $select = "selected";
                            else
                                $select = "";

                            echo '<option value="'.$langName.'" '.$select.'>'.$langName.'</option>';
                        }
                    }                    
                }
                closedir($langHandle);
            }
        }
    }
    
    /** only admin  **
     * _saveSettings
     * save general setting
     * @access private
     **/
    function _saveSettings()
    {
        //data process
        $inputData['user_name'] = $_POST['username'];
        $inputData['nick_name'] = $_POST['nickname'];
        $inputData['blog_name'] = $_POST['blog_name'];
        $inputData['password'] = $_POST['password'];
        $inputData['email'] = $_POST['email'];
        $inputData['num_page'] = $_POST['num_page'];
        $inputData['post_p_page'] = $_POST['post_p_page'];
        $inputData['blog_desc'] = $_POST['blog_desc'];
        $inputData['skin'] = $_POST['skin'];
        $inputData['language'] = $_POST['language'];

        $inputData['use_category'] = $_POST['usecate'];
        $inputData['use_calendar'] = $_POST['usecal'];
        $inputData['cal_name'] = $_POST['calskin'];
        $inputData['use_search'] = $_POST['usesearch'];
        $inputData['use_newpost_list'] = $_POST['newpostlist'];
        $inputData['newpost_cut'] = $_POST['newpost_cut'];
        $inputData['use_newcomment_list'] = $_POST['newcommentlist'];
        $inputData['newcomment_cut'] = $_POST['newcomment_cut'];
        $inputData['use_newtb_list'] = $_POST['newtblist'];
        $inputData['newtb_cut'] = $_POST['newtb_cut'];
        $inputData['use_archive_list'] = $_POST['newarchivelist'];
        $inputData['use_nowiam'] = $_POST['nowiam'];
        $inputData['nowiamcate'] = $_POST['category'];
        $inputData['rtbcharset'] = $_POST['enco'];
        $inputData['xml_num'] = $_POST['xml_num'];
        $inputData['xml_type_full'] = $_POST['xmlcont'];
        $inputData['owner'] = $_SESSION['spg_user_name'];

        $openCate = $_POST['opencatenum'];
        $openCateValue = $_POST['opencatevalue'];
        $closeCate = $_POST['closecatenum'];
        $closeCateValue = $_POST['closecatevalue'];
        

        // upload banner images
        $adminData = $this->data->getAdminData($_POST['username']);
        // banner1
        if($adminData['banner1'] && $_POST['banner1del'] == "1")
        {
            if(file_exists(SPG_ROOT."/".$_POST['username']."/".$adminData['banner1']))
                unlink(SPG_ROOT."/".$_POST['username']."/".$adminData['banner1']);
            $adminData['banner1'] = "";
        }

        if($_FILES['banner1']['name'] && $_FILES['banner1']['size'] != 0)
        {
            if($adminData['banner1'])
            {
                if(file_exists(SPG_ROOT."/".$_POST['username']."/".$adminData['banner1']))
                    unlink(SPG_ROOT."/".$_POST['username']."/".$adminData['banner1']);
            }
            $this->_upFile($_FILES, "banner1", SPG_ROOT."/".$_POST['username']."/");
            $inputData['banner1'] = $_FILES['banner1']['name'];
        }
        else
            $inputData['banner1'] = $adminData['banner1'];

        // banner2
        if($adminData['banner2'] && $_POST['banner2del'] == "1")
        {
            if(file_exists(SPG_ROOT."/".$_POST['username']."/".$adminData['banner2']))
                unlink(SPG_ROOT."/".$_POST['username']."/".$adminData['banner2']);
            $adminData['banner2'] = "";
        }
        if($_FILES['banner2']['name'] && $_FILES['banner2']['size'] != 0)
        {
            if($adminData['banner2'])
            {
                if(file_exists(SPG_ROOT."/".$_POST['username']."/".$adminData['banner2']))
                    unlink(SPG_ROOT."/".$_POST['username']."/".$adminData['banner2']);
            }
            
            $this->_upFile($_FILES, "banner2", SPG_ROOT."/".$_POST['username']."/");
            $inputData['banner2'] = $_FILES['banner2']['name'];
        }
        else
            $inputData['banner2'] = $adminData['banner2'];
        
        if($openCate)
        {
            $openCateArray = explode(",", $openCate);
            $openCateValueArray = explode(",", $openCateValue);
        }

        if($closeCate)
        {
            $closeCateArray = explode(",", $closeCate);
            $closeCateValueArray = explode(",", $closeCateValue);
        }

        //delete all lines
        $query = "DELETE FROM ".SPG_PREFIX."_category".
        " WHERE category_name = 'line' AND user_name='".$_POST['username']."'";
        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }        

        //for open category
        for($i = 0; $i < count($openCateArray); $i++)
        {
            $category_id = $this->data->getNextId("category", "category_id", $_POST['username']);
            if($openCateValueArray[$i] == "new")
            {
                //insert new cate
                $query = sprintf(
                "INSERT INTO ".SPG_PREFIX."_category".
                " (category_id, category_name, parent_id, open, user_name)".
                " VALUES".
                " (%s, '%s', '%s', '1', %s)",
                    $category_id,
                    $this->restoreComma($openCateArray[$i]),
                    $i,
                    $this->data->quote_smart($_POST['username']));
            }
            else if($openCateValueArray[$i] == "line")
            {
                $query = sprintf(
                "INSERT INTO ".SPG_PREFIX."_category".
                " (category_id, category_name, parent_id, open, user_name)".
                " VALUES".
                " (%s, 'line', '%s', '1', %s)",
                $category_id,
                $i, $this->data->quote_smart($_POST['username']));

            }
            else
            {
                //update cate
                $query = sprintf(
                "UPDATE ".SPG_PREFIX."_category".
                " SET".
                " category_name='%s', parent_id = '%s', open = '1'".
                " WHERE category_id = %s AND user_name=%s",
                    $this->restoreComma($openCateArray[$i]),
                    $i,
                    $openCateValueArray[$i], 
                    $this->data->quote_smart($_POST['username']));
            }

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

        }

        //for close category
        for($i = 0; $i < count($closeCateArray); $i++)
        {
            if($closeCateValueArray[$i] == "new")
            {
                $category_id = $this->data->getNextId("category", "category_id", $_POST['username']);

                //insert new cate
                $query = sprintf(
                "INSERT INTO ".SPG_PREFIX."_category".
                " (category_id, category_name, parent_id, open, user_name)".
                " VALUES".
                " (%s, '%s', '%s', '0', %s)",
                    $category_id,
                    $this->restoreComma($closeCateArray[$i]),
                    $i,
                    $this->data->quote_smart($_POST['username']));
            }
            else
            {
                //update cate
                $query = sprintf(
                "UPDATE ".SPG_PREFIX."_category".
                " SET".
                " category_name='%s', parent_id = '%s', open = '0'".
                " WHERE category_id = %s AND user_name=%s",
                    $this->restoreComma($closeCateArray[$i]),
                    $i,
                    $closeCateValueArray[$i],
                    $this->data->quote_smart($_POST['username']));
            }

            if($closeCateValueArray[$i] != "line")
            {
                $result = $GLOBALS['dbcon']->query($query);
                if (DB::isError($result))
                {
                    die ($result->getMessage().__FILE__.__LINE__);
                }
            }
        }

        $this->data->updateSettingData($inputData);

        // admin data2 
        unset($inputData);
        $inputData['admin_guest_use1'] = $_POST['guest_use1'];
        $inputData['admin_guest_num'] = $_POST['guest_num'];
        $inputData['admin_cate_show_num'] = $_POST['cate_show_num'];
        $inputData['admin_nowiam_title'] = $_POST['nowiamtitle'];
        $inputData['admin_defaultbanner'] = $_POST['default_banner'];
        $inputData['admin_numrelated'] = $_POST['numrelated'];
        $inputData['admin_numtags'] = $_POST['numtags'];

        // additional banner1
        $adminData2 = $this->data->getAdminData2($_POST['username']);
        if($adminData2['admin_additionalbanner1'] && $_POST['admin_additionalbanner1del'] == "1")
        {
            if(file_exists(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner1']))
                unlink(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner1']);
            $adminData2['admin_additionalbanner1'] = "";
        }

        if($_FILES['addbanner1']['name'] && $_FILES['addbanner1']['size'] != 0)
        {
            if($adminData2['admin_additionalbanner1'])
            {
                if(file_exists(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner1']))
                    unlink(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner1']);
            }
            $this->_upFile($_FILES, "addbanner1", SPG_ROOT."/".$_POST['username']."/");
            $inputData['admin_additionalbanner1'] = $_FILES['addbanner1']['name'];
        }
        else
            $inputData['admin_additionalbanner1'] = $adminData2['admin_additionalbanner1'];

        // banner2
        if($adminData2['admin_additionalbanner2'] && $_POST['admin_additionalbanner2del'] == "1")
        {
            if(file_exists(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner2']))
                unlink(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner2']);
            $adminData2['admin_additionalbanner2'] = "";
        }
        if($_FILES['addbanner2']['name'] && $_FILES['addbanner2']['size'] != 0)
        {
            if($adminData['admin_additionalbanner2'])
            {
                if(file_exists(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner2']))
                    unlink(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner2']);
            }
            
            $this->_upFile($_FILES, "addbanner2", SPG_ROOT."/".$_POST['username']."/");
            $inputData['admin_additionalbanner2'] = $_FILES['addbanner2']['name'];
        }
        else
            $inputData['admin_additionalbanner2'] = $adminData2['admin_additionalbanner2'];

        // banner2
        if($adminData2['admin_additionalbanner3'] && $_POST['admin_additionalbanner3del'] == "1")
        {
            if(file_exists(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner3']))
                unlink(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner3']);
            $adminData2['admin_additionalbanner3'] = "";
        }
        if($_FILES['addbanner3']['name'] && $_FILES['addbanner3']['size'] != 0)
        {
            if($adminData['admin_additionalbanner3'])
            {
                if(file_exists(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner3']))
                    unlink(SPG_ROOT."/".$_POST['username']."/".$adminData2['admin_additionalbanner3']);
            }
            
            $this->_upFile($_FILES, "addbanner3", SPG_ROOT."/".$_POST['username']."/");
            $inputData['admin_additionalbanner3'] = $_FILES['addbanner3']['name'];
        }
        else
            $inputData['admin_additionalbanner3'] = $adminData2['admin_additionalbanner3'];

        // only for linked function
        if(IS_LINKED && $_SESSION['spg_level'] == 1)
        {
            $inputData['admin_board_url'] = $_POST['board_url'];
        }

        $this->data->updateDataTableByBlog($inputData, $_POST['username']);
    }

    function _bannerExists($banner)
    {
        $adminData = $this->data->getAdminData($_GET['n']);
        if($adminData[$banner])
        {
            $img = '<a href="#" onclick="viewImage(\''.(SPG_URI)."/".$_GET['n']."/".$adminData[$banner].'\');">'.$adminData[$banner].'</a>';
            printf($GLOBALS['lang']['admin']['bannerexist'], $img);
            echo ', <input type="checkbox" name="'.$banner.'del" value="1" \>'.$GLOBALS['lang']['admin']['bannerdel'];
            echo "<br />";
        }
    }

    function _bannerExists2($banner)
    {
        $adminData2 = $this->data->getAdminData2($_GET['n']);
        if($adminData2[$banner])
        {
            $img = '<a href="#" onclick="viewImage(\''.(SPG_URI)."/".$_GET['n']."/".$adminData2[$banner].'\');">'.$adminData2[$banner].'</a>';
            printf($GLOBALS['lang']['admin']['bannerexist'], $img);
            echo ', <input type="checkbox" name="'.$banner.'del" value="1" \>'.$GLOBALS['lang']['admin']['bannerdel'];
            echo "<br />";
        }
    }

    function _saveSecSettings()
    {
        //data process
        $inputData['ips'] = $_POST['block_ips'];
        $inputData['words'] = $_POST['block_words'];
        $inputData['user_name'] = $_POST['username'];

        $this->data->updateSecSettingData($inputData);
        goToPage("?n=".$GLOBALS['n']."&mode=secsetting");
    }

    function printOpenCate()
    {
        $result = $this->data->getCategoryInfoByBlog("OPEN", $_GET['n']);

        while($data = $result->fetchRow())
        {
            if($data['category_name'] == "line")
            {
                $cate_id = "line";
                $cate_name = "---------------------------------";
            }
            else
            {
                $cate_id = $data['category_id'];
                $cate_name = $data['category_name'];
            }

            echo '<option value="'.$cate_id.'">'.$cate_name.'</option>';
        }
    }

    function printCloseCate()
    {
        $result = $this->data->getCategoryInfoByBlog("CLOSE", $_GET['n']);

        while($data = $result->fetchRow())
        {
            echo '<option value="'.$data['category_id'].'">'.$data['category_name'].'</option>';
        }
    }

    /**
     * 
     * re-change /+/ to ,(Comma)
     **/
    function restoreComma($data)
    {
        $data = str_replace("/+/", ",", $data);

        return $data;
    }

    // make a post everone can see
    function _openPost()
    {
        $this->data->openPost();
    }

    function _closePost()
    {
        $this->data->closePost();
    }    
    
    /**
     * _deletePost
    **/
    function _deletePost($no)
    {
        if ($_GET['mode'] == "delete" || $_POST['todo'] == "listexe")
        {
            if (!$no)
            {
                echo __FILE__;
                exit;
            }

            // delete post
            $query =
            "DELETE FROM ".SPG_PREFIX."_posts".
            " WHERE no = '".$no."' AND user_name='".$_GET['n']."'";

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            // delete comment
            $query =
            "DELETE FROM ".SPG_PREFIX."_comments".
            " WHERE parent_no = '".$no."' AND user_name='".$_GET['n']."'";

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            // delete keywords
            $query =
            "DELETE FROM ".SPG_PREFIX."_post_keywords".
            " WHERE post_no = '".$no."' AND user_name='".$_GET['n']."'";

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            // delete trackback sent
            $query =
            "DELETE FROM ".SPG_PREFIX."_trackback_sent".
            " WHERE post_no = '".$no."' AND user_name='".$_GET['n']."'";

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            // delete trackback
            $query =
            "DELETE FROM ".SPG_PREFIX."_trackbacks".
            " WHERE post_no = '".$no."' AND user_name='".$_GET['n']."'";

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            // delete files
            $query =
            "SELECT no FROM ".SPG_PREFIX."_files".
            " WHERE post_no = '".$no."' AND file_type='data' AND user_name='".$_GET['n']."'";

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }
            
            while($fileData = $result->fetchRow())
            {
                $this->delAFile($fileData['no']);
            }
        }
    }

    /**
     * _delNeigh
    **/
    function _delNeigh($id)
    {
        if ($_GET['mode'] == "deluser" || $_POST['todo'] == "neighexe")
        {
            if (!$id)
            {
                echo "ERROR".__FILE__;
                exit;
            }
            
            $query =
            "DELETE FROM ".SPG_PREFIX."_members".
            " WHERE member_no = '".$id."' AND user_name='".$_SESSION['spg_user_name']."'";

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }
        }
    }

    /**
     * _delCate
    **/
    function _delCate($no)
    {
        if($_GET['mode'] == "delcate" && $no != "1")
        {
            $query =
            "DELETE FROM ".SPG_PREFIX."_category".
            " WHERE category_id = '".$no."' AND user_name='".$_SESSION['spg_user_name']."'";

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            $query = sprintf("UPDATE ".SPG_PREFIX."_posts".
                " SET category_id = '1', display_level = '0'".
                " WHERE category_id = %s AND user_name='%s'",
                $no, $_SESSION['spg_user_name']);

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }            
        }
    }

    /**
     * _changeDisLevel
    **/
    function _changeDisLevel($postNo, $toWhat)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_posts".
            " SET display_level = '%s'".
            " WHERE no = '%s' AND user_name=%s",
            $toWhat,
            $postNo,
            $this->data->quote_smart($_SESSION['spg_user_name']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    /**
     * private
     * _changeRelation()    
     * @param int $toWhat : level number
     * @return void
     **/
    function _changeRelation($toWhat)
    {
        if ($_GET['mode'] == "chrel")
        {
            if (!$_GET['who'])
            {
                echo __FILE__;
                exit;
            }
            
            $query = sprintf(
                "UPDATE ".SPG_PREFIX."_members".
                " SET".
                " relationship='%s'".
                " WHERE member_no = '%s' AND user_name=%s",
                    $toWhat,
                    $_GET['who'], 
                    $this->data->quote_smart($_SESSION['spg_user_name']));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            $query = sprintf(
                "SELECT blog_url FROM ".SPG_PREFIX."_members".
                " WHERE member_no = '%s' AND user_name=%s",
                    $_GET['who'], 
                    $this->data->quote_smart($_SESSION['spg_user_name']));

            $blog_url = $GLOBALS['dbcon']->getOne($query);

            $myblogURL = rawurlencode((SPG_URI)."/".$_GET['n']);
            $library = new Library();
            $blog_url_a = parse_url($blog_url);
            $library->getHost($blog_url_a['host'], $blog_url_a['path']."/?mode=send_action&what=get_relationship&blog=".$myblogURL);
        }

        exit;

        //goToPage("?n=".$GLOBALS['n']."&mode=usersetting");
    }

    /**
     * private
     * _simpleChangeRelation()
     * @param int $toWhat : level number
     * @return void
     **/
    function _simpleChangeRelation($toWhat, $who)
    {
        if ($_POST['todo'] == "neighexe")
        {            
            $query = sprintf(
                "UPDATE ".SPG_PREFIX."_members".
                " SET".
                " relationship='%s'".
                " WHERE member_no = '%s' AND user_name=%s",
                    $toWhat,
                    $who,
                    $this->data->quote_smart($_SESSION['spg_user_name']));

            $result = $GLOBALS['dbcon']->query($query);
            
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }
        }
    }

    /**
     * public
     * getNumNeigh()    
     * @param int $level : level number
     * @return int : total number of members of which relationship
     **/
    function getNumNeigh($level)
    {
        if($level != 0)
        {
            $query = sprintf("SELECT count(member_no)".
                " FROM ".SPG_PREFIX."_members".
                " WHERE relationship='%s' AND user_name=%s",
                $this->data->quote_smart($level),
                $this->data->quote_smart($_SESSION['spg_user_name']));
        }
        else
        {
            $query = "SELECT count(member_no)".
                " FROM ".SPG_PREFIX."_members".
                " WHERE user_name = '".$_SESSION['spg_user_name']."'";
        }

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function listPosts()
    {
        $main = new Mainview();

        $this->queryArray['mode'] = "list";
        $this->queryArray['n'] = $_GET['n'];

        $numPPage = 15;
        $pageNum = 10;
        $totalArticle = $this->data->getTotalNumPosts();
        $start = $main->getStartNumOfPage($_GET['p'], $numPPage);
        $adminData = $this->data->getAdminData($_GET['n']);
        
        if($_GET['n'])
        {
            $query = 
            "SELECT *".
            " FROM ".SPG_PREFIX."_posts post, ".SPG_PREFIX."_admin admin".
            " WHERE post.author = admin.user_name AND post.user_name='".$_GET['n']."'".
            " ORDER BY no DESC".
            " LIMIT $start, $numPPage";

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            include "html/list.html";
        }
        else
        {
            echo "Error:".__FILE__.__LINE__;
        }
    }

    function delTempFiles()
    {
        $now = date("Y-m-d H:i:s");
        $files = $this->data->delTempFiles($now);

        while($fileData = $files->fetchRow())
        {
            $dir = SPG_DATA."/".$_GET['n']."/".$fileData['file_type']."/".$fileData['dir'];
            $fileLoc = $dir."/".$fileData['file_name'];

            unlink($fileLoc);
            // delete folder if empty
            @rmdir($dir);
        }
    }

    function _showWriteForm()
    {
        $category = new Category();

        $postArray = array();
        $library = new Library();

        $data = "";

        // delete temporary files
        $this->delTempFiles();

        if ($_GET['mode'] == "modify")
        {
            if (!$_GET['post'])
            {
                $library = new Library();
                $library->dieError(__FILE__.__LINE__.$GLOBALS['lang']['admin']['denyaccess']);
            }

            $data = $this->data->getAPost($_GET['post']);
            $lv0= "";
            $lv1= "";
            $lv2= "";
            $lv3= "";
            
            switch ($data['display_level'])
            {                
                case "0";
                    $lv0 = "checked";
                    break;
                case "1";
                    $lv1 = "checked";
                    break;
                case "2";
                    $lv2 = "checked";
                    break;
                case "3";
                    $lv3 = "checked";
                    break;
            }

            if($data['is_sync'])
                $sync = "checked";
            else
                $sync = "";

            if($data['dis_comment'])
                $dis_comment = "checked";
            else
                $dis_comment = "";

            if($data['dis_tb'])
                $dis_tb = "checked";
            else
                $dis_tb = "";

            $data['contents'] = str_replace("&", "&amp;", $data['contents']);
        }
        else
        {
            $lv3 = "checked";
        }

        include "html/writeform.html";
    }

    function _showFileOption($postNo)
    {
        $result = $this->data->getFileByPostNoByBlog($postNo, $_GET['n']);

        while($fileData = $result->fetchRow())
        {
            echo '<option value="'.$fileData['no'].'">'.$fileData['file_name'].' ('.$fileData['file_size'].'Bytes)</option>';
        }
    }

    function totalFileSize($postNo)
    {
        $size = $this->data->getTotalFileSize($postNo);

        if(!$size)  $size = 0;

        return $size;        
    }

    function _showNewSimplerForm($adminData)
    {
        include "html/newuser_form.html";
    }

    function _showSecuritySetting($adminData)
    {
        include "html/security_admin.html";
    }

    function _showSettingPage($adminData)
    {
        $category = new Category();
        $adminData2 = $this->data->getAdminData2ById($_GET['n']);
        include "html/g_setup.html";
    }

    /**
     * _upFile
     * @param Array $file 
     * @param String $inputname 
     * @param String $savedFolder
    **/
    function _upFile($file, $inputname, $savedFolder)
    {
        if($file[$inputname]['size'] != 0)
        {
            if (is_uploaded_file($file[$inputname]['tmp_name'])) 
            {
                $savefile = $savedFolder.$file[$inputname]['name'];

                if (move_uploaded_file($file[$inputname]['tmp_name'], $savefile)) 
                {
                    chmod($savefile, 0707);
                }
            } 
            else 
            {
                echo "Error : ";
                switch($file[$inputname]['error']) {
                    case 0: //no error; possible file attack!
                        echo $GLOBALS['lang']['admin']['uploaderror'];
                        break;
                    case 1: //uploaded file exceeds the upload_max_filesize directive in php.ini
                        echo $GLOBALS['lang']['admin']['toobig'];
                        break;
                    case 2: //uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the html form
                        echo $GLOBALS['lang']['admin']['toobig'];
                        break;
                    case 3: //uploaded file was only partially uploaded
                        echo $GLOBALS['lang']['admin']['uploaderror'];
                        break;
                    case 4: //no file was uploaded
                        echo $GLOBALS['lang']['admin']['nofile'];
                        break;
                    default: //a default error, just in case!  :)
                        echo $GLOBALS['lang']['admin']['unexpect'];
                        break;
                }
            }
        }
    }

    function uploadFile()
    {
        $timestamp = date("Ymd");

        // Init var :
        $id = $_POST['n'];

        if(!is_dir("../_data/".$id)) 
        { 
            @mkdir("../_data/".$id, 0707);
            @chmod("../_data/".$id, 0707);
        }

        if(!is_dir("../_data/".$id."/data")) 
        {
            @mkdir("../_data/".$id."/data", 0707);
            @chmod("../_data/".$id."/data", 0707);
        }

        if(!is_dir("../_data/".$id."/data"."/".$timestamp)) 
        {
            @mkdir("../_data/".$id."/data"."/".$timestamp, 0707);
            @chmod("../_data/".$id."/data"."/".$timestamp, 0707);
        }

        $UPLOAD_BASE_URL = (SPG_URI)."/_data/".$id."/data"."/".$timestamp."/";
        $UPLOAD_BASE_DIR = "../_data/".$id."/data"."/".$timestamp."/";

        // End int var

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>SIMPLOG FILE UP</TITLE>
        <script language="JavaScript" type="text/javascript" src="html/js/fileup.php?script=<?php echo $id;?>"></script>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	</HEAD>
	<BODY>
    <form name="fileup" method="post" action="">
		<TABLE height="100%" width="100%">
			<TR>
				<TD align="center" valign="middle"><b>
					Upload in progress...</b>
<font color='red'><BR><BR>
<?php 
$totalSize = $this->data->getAllFileSizeByBlog($id);
$adminData2 = $this->data->getAdminData2ById($id);
if(!$adminData2['admin_simpler_blog_size'])
{
    $superAdminData2 = $this->data->getAdminData2ById($GLOBALS['GSetup']['ROOT']);
    $allowedSize = $superAdminData2['admin_simpler_blog_size'];
}
else
{
    $allowedSize = $adminData2['admin_simpler_blog_size'];
}
$allowedSize = $allowedSize * 1024 * 1024;

if (file_exists($UPLOAD_BASE_DIR.$_FILES['filen']['name'])) 
{
	echo "Error : ".$GLOBALS['lang']['admin']['samefile'];
	echo '<BR><BR><INPUT name="close" type="button" value=" Close " onclick="self.close();">';
}
else if($allowedSize < $totalSize + $_FILES['filen']['size'])
{
    echo "Error : ".$GLOBALS['lang']['admin']['bloglimit'];
	echo '<BR /><BR /><INPUT type="button" value=" Cancel " onclick="window.close()" />';
}
else 
{
	if (is_uploaded_file($_FILES['filen']['tmp_name'])) 
    {
		$savefile = $_FILES['filen']['name'];
        $extpos = strrpos($savefile, ".");

        $filename = substr($savefile, 0, $extpos);
        $library = new Library();
        if(!$library->isEnglish($filename))
        {
            $filename = time();
        }

        $fileext = substr($savefile, $extpos);
        $changedFilename = $filename.$fileext;

        $savefile = $UPLOAD_BASE_DIR.$changedFilename;

		if (move_uploaded_file($_FILES['filen']['tmp_name'], $savefile)) 
        {
			chmod($savefile, 0707);
            // save into DB            
            $fileNo = $this->data->saveFile($changedFilename, $_FILES['filen']['size'], "data", $_FILES['filen']['name']);
?>
<script language="javascript" type="text/javascript">
<!--
    window.opener.document.frmWrite.tfilesize.value = parseInt(window.opener.document.frmWrite.tfilesize.value) + <?php echo $_FILES['filen']['size']; ?>;

    var filelist = window.opener.document.frmWrite.list_files;
    num = filelist.length;
    window.opener.process.location.href = "start.php?n=<?php echo $id; ?>&mode=processfileup&name=<?php echo $_FILES['filen']['name']; ?>&size=<?php echo $_FILES['filen']['size']; ?>&fno=<?php echo $fileNo; ?>";
    self.close();
-->
</script>
<?php
		}
	} 
    else 
    {
		echo "Error : ";
		switch($_FILES['filen']['error']) {
			case 0: //no error; possible file attack!
				echo $GLOBALS['lang']['admin']['uploaderror'];
				break;
			case 1: //uploaded file exceeds the upload_max_filesize directive in php.ini
				echo $GLOBALS['lang']['admin']['toobig'];
				break;
			case 2: //uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the html form
				echo $GLOBALS['lang']['admin']['toobig'];
				break;
			case 3: //uploaded file was only partially uploaded
				echo $GLOBALS['lang']['admin']['uploaderror'];
				break;
			case 4: //no file was uploaded
				echo $GLOBALS['lang']['admin']['nofile'];
				break;
			default: //a default error, just in case!  :)
				echo $GLOBALS['lang']['admin']['unexpect'];
				break;
		}
	}
	echo '<BR><BR><INPUT name="close" type="button" value=" Cancel " onclick="self.close();">';
} ?>
				</font></TD>
			</TR>
		</TABLE>
	</form>
    </BODY>
</HTML>

<?php
    }

    function uploadMultimedia()
    {
        $timestamp = date("Ymd");

        // Init var :
        $id = $_POST['n'];

        if(!is_dir("../_data/".$id)) 
        { 
            @mkdir("../_data/".$id, 0707);
            @chmod("../_data/".$id, 0707);
        }

        if(!is_dir("../_data/".$id."/media")) 
        {
            @mkdir("../_data/".$id."/media", 0707);
            @chmod("../_data/".$id."/media", 0707);
        }

        if(!is_dir("../_data/".$id."/media"."/".$timestamp)) 
        {
            @mkdir("../_data/".$id."/media"."/".$timestamp, 0707);
            @chmod("../_data/".$id."/media"."/".$timestamp, 0707);
        }

        $UPLOAD_BASE_URL = (SPG_URI)."/_data/".$id."/media"."/".$timestamp."/";
        $UPLOAD_BASE_DIR = "../_data/".$id."/media"."/".$timestamp."/";

        // End int var

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
	<head>
		<title>SIMPLOG FILE UP</title>
        <script language="javascript" type="text/javascript" src="html/js/multiup.php?script=<?php echo $id;?>"></script>
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
	</head>
	<body>
    <form name="fileup" method="post" action="">
		<table height="100%" width="100%">
			<tr>
				<td align="center" valign="middle"><b>
					Upload in progress...</b>
<font color='red'><BR><BR>
<?php
$totalSize = $this->data->getAllFileSizeByBlog($id);
$adminData2 = $this->data->getAdminData2ById($id);
if(!$adminData2['admin_simpler_blog_size'])
{
    $superAdminData2 = $this->data->getAdminData2ById($GLOBALS['GSetup']['ROOT']);
    $allowedSize = $superAdminData2['admin_simpler_blog_size'];
}
else
{
    $allowedSize = $adminData2['admin_simpler_blog_size'];
}
$allowedSize = $allowedSize * 1024 * 1024;

if (file_exists($UPLOAD_BASE_DIR.$_FILES['multi']['name'])) 
{
	echo "Error : ".$GLOBALS['lang']['admin']['samefile'];
	echo '<BR><BR><INPUT name="close" type="button" value=" Close " onclick="self.close();">';
}
else if($allowedSize < $totalSize + $_FILES['multi']['size'])
{
    echo "Error : ".$GLOBALS['lang']['admin']['bloglimit'];
	echo '<BR /><BR /><INPUT type="button" value=" Cancel " onclick="window.close()" />';
}
else 
{
	if (is_uploaded_file($_FILES['multi']['tmp_name'])) 
    {
		$savefile = $_FILES['multi']['name'];
        $extpos = strrpos($savefile, ".");

        $filename = substr($savefile, 0, $extpos);
        $library = new Library();
        if(!$library->isEnglish($filename))
        {
            $filename = time();
        }

        $fileext = substr($savefile, $extpos);
        $changedFilename = $filename.$fileext;

        $savefile = $UPLOAD_BASE_DIR.$changedFilename;

		if (move_uploaded_file($_FILES['multi']['tmp_name'], $savefile)) 
        {
			chmod($savefile, 0707);
            // save into DB            
            $fileNo = $this->data->saveFile($changedFilename, $_FILES['multi']['size'], "media", $_FILES['multi']['name']);
?>
<script language="javascript" type="text/javascript">
<!--
    insertFile('<?php echo $UPLOAD_BASE_URL.$changedFilename; ?>'); 
-->
</script>
<?php
		}
	} 
    else 
    {
		echo "Error : ";
		switch($_FILES['multi']['error']) {
			case 0: //no error; possible file attack!
				echo $GLOBALS['lang']['admin']['uploaderror'];
				break;
			case 1: //uploaded file exceeds the upload_max_filesize directive in php.ini
				echo $GLOBALS['lang']['admin']['toobig'];
				break;
			case 2: //uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the html form
				echo $GLOBALS['lang']['admin']['toobig'];
				break;
			case 3: //uploaded file was only partially uploaded
				echo $GLOBALS['lang']['admin']['uploaderror'];
				break;
			case 4: //no file was uploaded
				echo $GLOBALS['lang']['admin']['nofile'];
				break;
			default: //a default error, just in case!  :)
				echo $GLOBALS['lang']['admin']['unexpect'];
				break;
		}
	}
	echo '<BR><BR><INPUT name="close" type="button" value=" Cancel " onclick="self.close();">';
} ?>
				</font></td>
			</tr>
		</table>
	</form>
    </body>
</html>
<?php
    }

    function delAFile($fno)
    {
        $dFile = $this->data->delAFile($fno);
        
        if($dFile['file_type'])
            $type = $dFile['file_type'];
        else $type = "data";

        $fileLoc = SPG_DATA."/".$_GET['n']."/".$type."/".$dFile['dir']."/".$dFile['file_name'];
        if(file_exists($fileLoc))
        {
            unlink($fileLoc);
            @rmdir(dirname($fileLoc));
            return $dFile;
        }
        else
            return false;

    }

//////////// FILE SYSTEM /////////////////

    function _deletePostFile()
    {
        if ($GLOBALS['mode'] == "delete")
        {
            if (!$GLOBALS['post'])
            {
                echo __FILE__;
                exit;
            }
            $folder = date("Ym", $GLOBALS['post']);
            $fileName = SPG_DATA.'/'.$GLOBALS['n'].'/'.$folder.'/'.$GLOBALS['post'].".php";

            if(file_exists($fileName))
            {
                unlink($fileName);
            }
            else
            {
                echo "file is not exists";
            }
        }
    }

    function _showWriteFormFile()
    {
        $category = new Category();
        $data = new Data();

        $postArray = array();

        if ($GLOBALS['mode'] == "modify")
        {
            if (!$GLOBALS['post'])
            {
                echo __FILE__;
                exit;
            }
            $folder = date("Ym", $GLOBALS['post']);
            $fileName = SPG_DATA.'/'.$GLOBALS['n'].'/'.$folder.'/'.$GLOBALS['post'].".php";
            $postArray = $data->getArrayWithKey($data->getRidTag($data->spgReadFile($fileName)));
        }

        include "html/writeform.html";
    }

    function listPostsFile()
    {
        $main = new Mainview();
        $data = new Data();
        $posts = $this->_getPostsArray();
        $postArray = array();
        
        for ($i = 0; $i < count($posts); $i++)
        {
            $fileName = SPG_DATA.'/'.$GLOBALS['n'].'/'.$posts[$i]['yearmonth'].'/'.$posts[$i]['filename'];
            $postArray[$i] = $data->getArrayWithKey($data->getRidTag($data->spgReadFile($fileName)));            
        }

        include "html/list.html";
        

    }

    function _getPostsArray()
    {
        // db system
        if($GLOBALS['usedb'])
        {
        }
        // file system
        else
        {
            $posts = array();

            $dir = SPG_ROOT.'/_data/'.$GLOBALS['n'].'/';
            $i = 0;
		
            // year & month
            if (is_dir($dir)) 
            {
                if ($yearMonthDirHandle = @opendir($dir))
                {
                    while (($yearMonthDir = readdir($yearMonthDirHandle)) !== false) 
                    {
                        if(is_dir($dir.$yearMonthDir))
                        {
                            if ($yearMonthDir != '.' && $yearMonthDir != '..' && $yearMonthDir != 'upload')
                            {
                                // post
                                $postDir = $dir.$yearMonthDir.'/';
                                if ($postHandle = @opendir($postDir))
                                {
                                    while (($post = readdir($postHandle)) !== false)
                                    {
                                        if (is_file($postDir.$post))
                                        {
                                            $posts[$i]['filename'] = $post;
                                            $posts[$i]['yearmonth'] = $yearMonthDir;
                                            $i++;
                                        }
                                    }   // End while
                                }
                            }   // End if
                        }   // End if

                    }   // End while
                   
                }   // End if
            }   // End if
            
            return array_reverse($posts);

        }
    }

    function get2StepDirFrom($dir)
    {
        if ($dirHandle = @opendir($dir))
        {
            $file = readdir($dirHandle);

                if($file == false)
                {
                    echo $file;
                }
                else
                {
                    if ($file != '.' && $file != '..' && $file != 'upload')
                    {
                        $this->get2StepDirFrom($file);
                    }   // End if
                }


        }   // End if

    }

    function getNoticeFromServer()
    {
        // 1 day
        $age = 24 * 1;

        $library = new Library();
        $rss = $library->parseRSSWithCache("http://thesimplog.com/blog/rss.xml", $this->data, $age);
        $item = $rss->getItems();
        echo '['.date("m/d H:i:s", strtotime($item[0]['pubdate'])).'] <a href="'.$item[0]['link'].'" target="_blank">'.$item[0]['title'].'</a>';
        echo "<br />";
        echo '['.date("m/d H:i:s", strtotime($item[1]['pubdate'])).'] <a href="'.$item[1]['link'].'" target="_blank">'.$item[1]['title'].'</a>';

    }

    function checkRegisterFromServer()
    {
        $adminData2 = $this->data->getAdminData2();

        if($adminData2['admin_simplog_register'])
            return true;
        else
        {
            $now = time();
            // 1 days
            $checkDay = 86400 * 1;

            if($adminData2['admin_check_from_server'] <= $now - $checkDay)
            {
                require_once dirname(dirname(__FILE__))."/_lib/simplexml.inc";

                $simplexml = new SimpleXml();
                $library = new Library();

                $blogURL = rawurlencode((SPG_URI)."/".$GLOBALS['n']);

                $sendResult = $library->getHost("thesimplog.com", "/login/action.php?todo=checkreg&blog=".$blogURL);

                // get response from a server with TB type
                $parseData = $library->parseTBResponse($sendResult);

                if (get_magic_quotes_gpc()) 
                {
                    $parseData['body'] = stripslashes($parseData['body']);
                }

                $simplexml->setInputString($parseData['body']);
                $simplexml->parse();
                $xmlStruct = $simplexml->getStruct();

                //print_r($xmlStruct);

                // ok
                if (trim($xmlStruct['ERROR']) == "0")
                {
                    $newData['admin_simplog_register'] = 1;
                    $newData['admin_check_from_server'] = $now;
                    $this->data->updateDataTableByBlog($newData, $GLOBALS['blog']);
                    return true;
                }
                else
                {
                    $newData['admin_check_from_server'] = $now;
                    $this->data->updateDataTableByBlog($newData, $GLOBALS['blog']);
                    return false;
                }
            }
            else
            {
                return false;
            }
        }
    }

    function getRssPubDate($uri)
    {
        $library = new Library();
        $rss = $library->parseRSSWithCache($uri, $this->data, 3); 
        $item = $rss->getItems();

        if($item[0]['pubdate'])
            return $item[0]['pubdate'];
        else if($item[0]['dc:date'])
            return $item[0]['dc:date'];

    }

    function _showMonthStat()
    {
        $data = new Data();
        $result = $data->getMonthStat();

        include "html/stat_month.html";
    }

    function _showDayStat()
    {
        $data = new Data();
        $result = $data->getDayStat($_GET['when']);
        include "html/stat_day.html";
    }

    function _showTimeStat()
    {
        $data = new Data();
        $result = $data->getTimeStat($_GET['when']);
        $timeData = $result->fetchRow();

        $visit = explode(",", $timeData['visit']);
        $page = explode(",", $timeData['page']);
        include "html/stat_time.html";
    }

    function _showCoungLog()
    {
        $data = new Data();
        if($_GET['view'] == "all")
            $result = $data->getAllCountData();
        else
            $result = $data->getAllCountData(20);

        include "html/count_log.html";

    }

    function _showCoungLog2()
    {
        $data = new Data();
        if($_GET['w'] == "referer")
        {
            $title = $GLOBALS['lang']['admin']['refererlog'];
            if($_GET['view'] == "all")
                $desc = $GLOBALS['lang']['admin']['refererlogalldesc'];
            else
                $desc = $GLOBALS['lang']['admin']['refererlogdesc'];
            $which = $GLOBALS['lang']['admin']['referer'];
            $type = "R";
        }
        else if($_GET['w'] == "agent")
        {
            $title = $GLOBALS['lang']['admin']['agentlog'];
            if($_GET['view'] == "all")
                $desc = $GLOBALS['lang']['admin']['agentlogalldesc'];
            else                
                $desc = $GLOBALS['lang']['admin']['agentlogdesc'];
            $which = $GLOBALS['lang']['admin']['agent'];
            $type = "B";
        }
        else 
        {
            $title = "";
            $desc = "";
            $which = "";
            $type = "";
        }

        if($_GET['view'] == "all")
            $result = $data->getAllCountLog($type);
        else
            $result = $data->getAllCountLog($type, 20);

        include "html/count_log2.html";

    }

    /** unused from 0.7.1
     * getFileList
    **/
    function getFileList($blog, $dir = "", $type = "images")
    {
        $path = SPG_ROOT."/_data/".$blog."/".$type."/";

        if(is_dir($path))
        {
            if ($dir == ".") $dir = "";
            $UPLOAD_BASE_URL = dirname(SPG_URI)."/_data/".$blog."/images/".$dir."/";
            if ($dir)
            {
                echo '<a href="?script='.$blog.'&amp;dir='.dirname($dir).'">'.".." .$GLOBALS['lang']['admin']['wimgup'].'</a>';
                echo "<br />";
            }

            $dir2 = $dir."/";
            $dir = $path.$dir;
            $handle = opendir($dir);
            while (false !== ($file = readdir($handle)))
            {
                if ($file != "." && $file != "..")
                {
                    if(is_dir($dir.$file))   echo '<a href="?script='.$blog.'&amp;dir='.$file.'">'.$file."</a> [DIR]";
                    else    echo $file.' <a href="#" onclick="imageDel(\''.$dir2.$file.'\', \''.$_GET['script'].'\')">['.$GLOBALS['lang']['admin']['wimgdel'].']</a><a href="#" onclick="insertImage(\''.$UPLOAD_BASE_URL.$file.'\', \'Image\')">['.$GLOBALS['lang']['admin']['wimginsert'].']</a><a href="#" onclick="viewImage(\''.$UPLOAD_BASE_URL.$file.'\');">['.$GLOBALS['lang']['admin']['wimgpreview'].']</a>';
                    echo "<br />";
                }
            }

            closedir($handle);
        }
    }

    function autoGetRss($uri)
    {
        $library = new Library();
        $rss = $library->parseRSSWithCache($uri, $this->data, 3);

        $channel = $rss->getChannelInfo();

        require_once dirname(dirname(__FILE__))."/_lib/script.inc";
        $script = new Script();
        $script->autoSetRss($channel);
    }
}   // End Class

?>