<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS <thesimplog@gmail.com>                                 |
// | Last Modified date: 16/Jan/2006 01:33                                |
// +----------------------------------------------------------------------+
//
// $Id comment.inc$
require_once dirname(dirname(__FILE__))."/_lib/script.inc";

class Comment
{
    function Comment()
    {
    }

    function submitComment($post)
    {
        if(!session_id()) session_start();
        $data = new Data();
        $script = new Script();

        $member_id = "";

        // check input data
        $name = $data->validInput($post['name']);
        $memo = $data->validInput($post['content']);
        $homepage = $data->validInput($post['homepage']);
        $password = $data->validInput($post['password']);

        if(isset($_SESSION['spg_user_name']) && !($_SESSION['zb_logged_no'] || $_SESSION['ss_mb_id']))
        {
            if(!$name || !$memo) die($script->alert($GLOBALS['lang']['comment']['submitfail']));
            // get admin data
            $ownerInfo = $data->getAdminData($_SESSION['spg_user_name']);
            $noPassword = "1";
            $password = $ownerInfo['password'];
        }
        else if(IS_LINKED && ($_SESSION['zb_logged_no'] || $_SESSION['ss_mb_id']))
        {
            if(!$name || !$memo) die($script->alert($GLOBALS['lang']['comment']['submitfail']));
            $noPassword = "1";

            require_once dirname(dirname(__FILE__))."/_linked/link.inc";
            $linked = new Linked();
           
            switch(LINK_BOARD)
            {
                case 'zero':
                    if(isset($_SESSION['zb_logged_no']))
                    {
                        $linkBoardMember = $linked->getBoardUser($_SESSION['zb_logged_no']);
                    }
                    if($linkBoardMember['name'])
                    {
                        $password = $linkBoardMember['password'];
                        $member_id = $linkBoardMember['no'];
                    }
                    break;
                case 'gnu4':
                    // auto login
                    if(isset($_SESSION['ss_mb_id']))
                    {
                        $linkBoardMember = $linked->getBoardUser($_SESSION['ss_mb_id']);
                    }
                    if($linkBoardMember['mb_nick'])
                    {
                        $password = $linkBoardMember['mb_password'];
                        $member_id = $linkBoardMember['mb_id'];
                    }
                    break;
                default:
                    break;
            }
        }
        else
        {
            if(!$name || !$memo || !$password) die($script->alert($GLOBALS['lang']['comment']['submitfail']));
            $noPassword = "0";
        }
        
        if($post['act'] == "comment")
        {
            $childNo = "0";
            $seq = $data->getMaxSeqComment($post['num']);
            if(!$seq) $seq = 0;
            $seq++;
        }
        else if($post['act'] == "guest")
        {
            $childNo = "0";
            $seq = $data->getMaxSeqComment($post['num']);
            if(!$seq) $seq = 0;
            $seq++;
        }
        else if($post['act'] == "replyguest")
        {
            $childNo = $post['child'];
            $seq = $data->getMaxSeqReplyComment($post['num'], $post['child']);
            if(!$seq) $seq = $post['seq'];
            $data->upSeqReplyComment($post['num'], $seq);
            $seq++;            
        }
        else if($post['act'] == "replycomment")
        {
            $childNo = $post['child'];
            $seq = $data->getMaxSeqReplyComment($post['num'], $post['child']);
            if(!$seq) $seq = $post['seq'];
            $data->upSeqReplyComment($post['num'], $seq);
            $seq++;
        }

        $input = array("num"=>$post['num'], "name"=>$name, "password"=>$password, "content"=>$memo, "homepage"=>$homepage, "secret"=>$post['secret'], "seq"=>$seq, "child"=>$childNo, "ip"=>$_SERVER['REMOTE_ADDR'], "member_id"=>$member_id);
        
        $commentId = $data->insertComment($input, $noPassword);

        // add comment queue for replier
        if($childNo > 0)
            $data->addCommentQueue($childNo, $commentId, $GLOBALS['n']);

        // add comment queue for writer self
        $data->addCommentQueue($commentId, $commentId, $GLOBALS['n']);        
    }

    function deleteComment($comNo, $pass, $num, $child)
    {
        $data = new Data();
        $script = new Script();

        //check pass
        $isPass = $data->checkCommentPass($comNo, $pass);

        if(!session_id()) session_start();

        if($isPass == 1 || (isset($_SESSION['spg_user_name']) && $_SESSION['spg_user_name'] == $GLOBALS['n']))
        {
            //get number of replies
            $numRe = $data->getNumChildComments($comNo);

            // if this is child comment
            if($child != 0) 
            {
                // get replies of top comment
                $topCom = $data->getNumChildComments($child);

                // top comment has less than one comment
                if($topCom <= 1)
                {
                    // get parent data
                     $topDeleted = $data->checkLastComment($child);
                }

                // if top comment was deleted, then delete top comment
                if($topDeleted['is_secret'] == "3")
                {
                    $data->delComment($child, "", 1);
                }
            }            

            // there is no reply
            if($numRe == 0)
            {
                if(isset($_SESSION['spg_user_name']) && $_SESSION['spg_user_name'] == $GLOBALS['n'])
                {
                    $data->delComment($comNo, $pass, 1);
                }
                else
                {
                    $data->delComment($comNo, $pass);
                }
            }
            // has replies then remove contents and change contents
            // actually, it's not deleted from DB
            else
            {
                $post['name'] = "Deleted";
                $post['homepage'] = "Deleted";
                $post['content'] = "Deleted";
                $post['secret'] = "3";
                $post['child'] = $comNo;
                $data->modifyComment($post);
            }

            // print message box : ok
            $script->deleteOkClose($num, $_POST['m']);
        }
        else if($isPass == 2)
        {
            // print message box : not exists
            $script->wrongPassword($GLOBALS['lang']['comment']['notexist']);
        }
        else
        {
            // print message box : fail
            $script->wrongPassword($GLOBALS['lang']['comment']['wongpass']);
        }
    }

    function modifyComment($post)
    {
        if(!session_id()) session_start();
        
        $data = new Data();
        $script = new Script();
        
        // first check password
        $result = $data->checkCommentPass($post['child'], $post['password']);

        if($result || isset($_SESSION['spg_user_name']))
        {
            // check input data
            $post['name'] = $data->validInput($post['name']);
            $post['content'] = $data->validInput($post['content']);
            $post['homepage'] = $data->validInput($post['homepage']);
            $post['password'] = $data->validInput($post['password']);

            if(!isset($_SESSION['spg_user_name']))
            {
                if(!$post['name'] || !$post['content'] || !$post['password']) die($script->alert($GLOBALS['lang']['comment']['submitfail']));
            }
            else
            {
                if(!$post['name'] || !$post['content']) die($script->alert($GLOBALS['lang']['comment']['submitfail']));
            }

            $data->modifyComment($post);
            $data->addCommentQueue($post['child'], $post['child'], $GLOBALS['n']);
        }
        else
        {
            require_once dirname(dirname(__FILE__))."/_lib/script.inc";
            $script = new Script();
            $script->commentWrongPass();

            // stop refreshing
            exit;
        }
    }

    /**
     * notifyComment
     * send POST data to replier and delete one queue.
    **/
    function notifyComment()
    {
        $data = new Data();

        $blogURL = SPG_URI."/".$GLOBALS['n'];

        // get one comment notify queue
        $result = $data->getCommentQueue(1, $GLOBALS['n']);
        $comment = $result->fetchRow();        

        // get data from_comment
        if($comment['to_comment_id'] != $comment['from_comment_id'])
        {
            $fromComm = $data->getOneComment2($comment['from_comment_id']);
            if(!$fromComm['no'])
            {
                $data->delCommentQueue($comment['to_comment_id'], $comment['from_comment_id'], $GLOBALS['n']);
                return false;
            }            
        }
        else
        {
            $fromComm = "";

            // if this is a reply of a comment, then get parent comment as well
            if($comment['child_no'] > 0)
            {
                // get a parent comment
                $fromComm = $data->getOneComment2($comment['child_no']);
                // change position
                $temp = $comment;
                $comment = $fromComm;
                $fromComm = $temp;
                // however, homepage to be sent is original one. BE CAREFUL
                $comment['homepage'] = $fromComm['homepage'];
                $comment['to_comment_id'] = $fromComm['to_comment_id'];
                $comment['from_comment_id'] = $fromComm['from_comment_id'];
            }
        }        

        $blog = $data->getAdminData($GLOBALS['n']);

        // item data
        $result = $data->getItemsByNo($comment['parent_no'], 0);
        $entry = $result->fetchRow();

        // check validation
        if(!$comment['homepage'])
        {
            $data->delCommentQueue($comment['to_comment_id'], $comment['from_comment_id'], $GLOBALS['n']);
            return false;
        }
        if(!$comment['no'])
        {
            $data->delCommentQueue($comment['to_comment_id'], $comment['from_comment_id'], $GLOBALS['n']);
            return false;
        }        
        if(!$entry['no'])
        {
            $data->delCommentQueue($comment['to_comment_id'], $comment['from_comment_id'], $GLOBALS['n']);
            return false;
        }

            $dataQuery="url=".rawurlencode($blogURL)."&mode=fb"."&s_home_title=".rawurlencode($blog['blog_name'])."&s_post_title=".rawurlencode($entry['subject'])."&s_name=".rawurlencode($blog['owner'])."&s_no=".rawurlencode($entry['no'])."&s_url=".rawurlencode("$blogURL/?post=".$entry['no'])."&r1_name=".rawurlencode($comment['name'])."&r1_no=".rawurlencode($comment['no'])."&r1_pno=".rawurlencode($comment['parent_no'])."&r1_rno=".rawurlencode($comment['child_no'])."&r1_homepage=".rawurlencode($comment['homepage'])."&r1_regdate=".rawurlencode($comment['date'])."&r1_url=".rawurlencode("$blogURL/?post=".$entry['no']."#com".$comment['no'])."&r2_name=".rawurlencode($fromComm['name'])."&r2_no=".rawurlencode($fromComm['no'])."&r2_pno=".rawurlencode($fromComm['parent_no'])."&r2_rno=".rawurlencode($fromComm['child_no'])."&r2_homepage=".rawurlencode($fromComm['homepage'])."&r2_regdate=".rawurlencode($fromComm['date'])."&r2_url=".rawurlencode("$blogURL/?post=".$entry['no']."#com".$fromComm['no'])."&r1_body=".rawurlencode($comment['memo'])."&r2_body=".rawurlencode($fromComm['memo']);


        if(strpos($comment['homepage'],"http://")===false){
            $homepage='http://'.$comment['homepage'];
        }else{
            $homepage=$comment['homepage'];
        }

        $library = new Library();
        require_once dirname(dirname(__FILE__))."/_lib/simplexml.inc";
        $simplexml = new SimpleXml();

        $host = @parse_url($homepage);
        $request = $library->getPostToHost($host['host'], $host['path'], $dataQuery);
        if($request === false)
        {
            $data->delCommentQueue($comment['to_comment_id'], $comment['from_comment_id'], $GLOBALS['n']);
            return false;
        }

        $parseData = $library->parseTBResponse($request);
        if (get_magic_quotes_gpc()) 
        {
            $parseData['body'] = stripslashes($parseData['body']);
        }
        $xmlParse = $simplexml->setInputString($parseData['body']);
        $xmlParse = $simplexml->parse();
        $xmlStruct = $simplexml->getStruct();
        if (trim($xmlStruct['ERROR']) != "1" && trim($xmlStruct['ERROR']) != "0")
        {            
            $homepage=rtrim($homepage,'/').'/index.php';
            $host = parse_url($homepage);
            $request = $library->getPostToHost($host['host'], $host['path'], $dataQuery);
        }

        $data->delCommentQueue($comment['to_comment_id'], $comment['from_comment_id'], $GLOBALS['n']);

        return true;
    }

    /**
     * from tattertools to be compatible with 
     * receiveNotifiedComment
     * @param array $post : $_POST
     * @return error number
    **/
    function receiveNotifiedComments($post)
    {
        $data = new Data();

        if(empty($post['mode'])||$post['mode']!='fb')
            return 1;

        $blog['blog_name']=mysql_real_escape_string($post['s_home_title']);
        $blog['blog_author']=mysql_real_escape_string($post['s_name']);        
        $blog['homepage']=mysql_real_escape_string($post['url']);

        $parent['post_id']=mysql_real_escape_string($post['s_no']);
        $parent['item_url']=mysql_real_escape_string($post['s_url']);
        $parent['item_title']=mysql_real_escape_string($post['s_post_title']);

        $parent['comm_no']=$post['r1_no'];
        $parent['parent_id']=$post['r1_rno'];
        $parent['parent_name']=mysql_real_escape_string($post['r1_name']);        
        $parent['parent_home']=mysql_real_escape_string($post['r1_homepage']);
        $parent['parent_date']=$post['r1_regdate'];
        $parent['comment']=mysql_real_escape_string($post['r1_body']);
        $parent['comm_url']=mysql_real_escape_string($post['r1_url']);

        $child['comm_no']=$post['r2_no'];
        $child['child_name']=mysql_real_escape_string($post['r2_name']);
        $child['parent_id']=$post['r2_rno'];
        $child['child_home']=mysql_real_escape_string($post['r2_homepage']);
        $child['child_date']=$post['r2_regdate'];
        $child['comment']=mysql_real_escape_string($post['r2_body']);
        $child['comm_url']=mysql_real_escape_string($post['r2_url']);

        // add blog info
        $parent['blog_id'] = $data->addCommentNotifyBlog($blog);

        $data->addCommentNotify($parent, $child, $GLOBALS['n']);

        return 0;
    }
}
?>