<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name : The Simplog                                           |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// | All database related functions are here eg> db queries               |
// | data input output processes for file system                          |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS <thesimplog@gmail.com>                                 |
// | Last Modified date: 25/Jan/2006 00:16                                |
// +----------------------------------------------------------------------+
//
// $Id data.inc$

class Data
{

    function Data()
    {

    }

    //****
    // Mysql related functions
    //

    /**
     * updateSettingData()
     * update blog setting data
     * @access public
    **/
    function updateSettingData($data)
    {
        if($data['password']) $query2 = ", password = password('".$data['password']."')";
        else    $query2 = "";

        $query = sprintf("UPDATE ".SPG_PREFIX."_admin".
            " SET nick_name = %s, owner = %s, email = %s, num_page = %s, post_p_page = %s, blog_name = %s, blog_desc = %s, skin = %s, language = %s, use_category = %s, use_newpost_list = %s, newpost_cut = %s, use_newcomment_list = %s, newcomment_cut = %s, use_newtb_list = %s, newtb_cut = %s, use_calendar = %s, cal_name = %s, use_archive_list = %s, use_search = %s, use_nowiam = %s, nowiamcate = %s, rtbcharset = %s, xml_num = %s, xml_type_full = %s, banner1 = %s, banner2 = %s  %s".
            " WHERE user_name = %s",
            $this->quote_smart($data['nick_name']),
            $this->quote_smart($data['owner']),
            $this->quote_smart($data['email']),
            $this->quote_smart($data['num_page']),
            $this->quote_smart($data['post_p_page']),
            $this->quote_smart($data['blog_name']),
            $this->quote_smart($data['blog_desc']),
            $this->quote_smart($data['skin']),
            $this->quote_smart($data['language']),
            $this->quote_smart($data['use_category']),
            $this->quote_smart($data['use_newpost_list']),
            $this->quote_smart($data['newpost_cut']),
            $this->quote_smart($data['use_newcomment_list']),
            $this->quote_smart($data['newcomment_cut']),
            $this->quote_smart($data['use_newtb_list']),
            $this->quote_smart($data['newtb_cut']),
            $this->quote_smart($data['use_calendar']),
            $this->quote_smart($data['cal_name']),
            $this->quote_smart($data['use_archive_list']),
            $this->quote_smart($data['use_search']),
            $this->quote_smart($data['use_nowiam']),
            $this->quote_smart($data['nowiamcate']),
            $this->quote_smart($data['rtbcharset']),
            $this->quote_smart($data['xml_num']),
            $this->quote_smart($data['xml_type_full']),
            $this->quote_smart($data['banner1']),
            $this->quote_smart($data['banner2']),
            $query2,
            $this->quote_smart($data['user_name']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

    }

	function isThereBlog($userName)
    {
        $query = "SELECT user_name FROM ".SPG_PREFIX."_admin WHERE user_name='".$userName."'";
        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

		$num = $result->numRows();
		if($num >= 1)
			return true;
		else
			return false;
    }

    /**
     * getMyBlog()
     * get all blogs of username
     * @access public
    **/
    function getMyBlog($userName)
    {
        $query = "SELECT user_name FROM ".SPG_PREFIX."_admin WHERE password='".$userName."' AND owner='".$userName."'";
        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        $blog = array($userName);

        while($adminData = $result->fetchRow())
        {
            array_push($blog, $adminData['user_name']);
        }

        return $blog;
    }

    /**
     * getCoworkBlog()
     * get all blogs that I join
     * @access public
    **/
    function getCoworkBlog($userName)
    {

        $query = "SELECT user_name FROM ".SPG_PREFIX."_admin";
        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        $blog = array();

        while($adminData = $result->fetchRow())
        {
            $query = sprintf("SELECT value FROM ".SPG_PREFIX."_data".
            " WHERE user_name=%s AND name LIKE 'coworker_%s' AND value = %s",
			$this->quote_smart($adminData['user_name']),
            $userName,
            $this->quote_smart($userName));

            $ownerResult = $GLOBALS['dbcon']->getOne($query);
            if (DB::isError($ownerResult))
            {
                die ($ownerResult->getMessage().__FILE__.__LINE__);
            }

            if($ownerResult == $userName)
            {
                array_push($blog, $adminData['user_name']);
            }
        }

        return $blog;
    }

    function getCoworkersByBlog($id)
    {
        $query = "SELECT d.value value, admin.nick_name nick_name FROM ".SPG_PREFIX."_data d, ".SPG_PREFIX."_admin admin".
        " WHERE d.user_name = '".$id."' AND d.name LIKE 'coworker_%' AND admin.user_name = d.value";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;

    }


    /**
     * updateDataTable()
     * update _data table
     * @access public
    **/
    function updateDataTable($data)
    {
        foreach($data as $key => $value)
        {
            $query = sprintf("UPDATE ".SPG_PREFIX."_data".
            " SET value=%s".
            " WHERE user_name = %s AND name=%s",
			$this->quote_smart($value),
			$this->quote_smart($GLOBALS['n']),
            $this->quote_smart($key));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            if($GLOBALS['dbcon']->affectedRows() == 0)
            {
                $query = sprintf("SELECT count(*) FROM ".SPG_PREFIX."_data".
                " WHERE user_name=%s AND name=%s",
				$this->quote_smart($GLOBALS['n']),
                $this->quote_smart($key));

                $row = $GLOBALS['dbcon']->getOne($query);
                if (DB::isError($row))
                {
                    die ($row->getMessage().__FILE__.__LINE__);
                }

                if($row == 0)
                {
                    $query = sprintf("INSERT INTO ".SPG_PREFIX."_data".
                    " (name, value, user_name) VALUES".
                    " (%s, %s, %s)",
                    $this->quote_smart($key),
                    $this->quote_smart($value),
					$this->quote_smart($GLOBALS['n']));

                    $result = $GLOBALS['dbcon']->query($query);
                    if (DB::isError($result))
                    {
                        die ($result->getMessage().__FILE__.__LINE__);
                    }
                }   // end if
            }   // end if
        }
    }

    /**
     * updateDataTableByBlog()
     * update _data table according to blog
     * @access public
    **/
    function updateDataTableByBlog($data, $blog)
    {
        foreach($data as $key => $value)
        {
            $query = sprintf("UPDATE ".SPG_PREFIX."_data".
            " SET value=%s".
            " WHERE user_name=%s AND name=%s",
            $this->quote_smart($value),
			$this->quote_smart($blog),
            $this->quote_smart($key));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            if($GLOBALS['dbcon']->affectedRows() == 0)
            {
                $query = sprintf("SELECT count(*) FROM ".SPG_PREFIX."_data".
                " WHERE user_name=%s AND name=%s",
                $this->quote_smart($blog),
                $this->quote_smart($key));

                $row = $GLOBALS['dbcon']->getOne($query);
                if (DB::isError($row))
                {
                    die ($row->getMessage());
                }

                if($row == 0)
                {
                    $query = sprintf("INSERT INTO ".SPG_PREFIX."_data".
                    " (name, value, user_name) VALUES".
                    " (%s, %s, %s)",
                    $this->quote_smart($key),
                    $this->quote_smart($value),
                    $this->quote_smart($blog));

                    $result = $GLOBALS['dbcon']->query($query);
                    if (DB::isError($result))
                    {
                        die ($result->getMessage().__FILE__.__LINE__);
                    }
                }   // end if
            }   // end if
        }
    }

    function updateRssDataTable($data)
    {
        foreach($data as $key => $value)
        {
            $query = sprintf("UPDATE ".SPG_PREFIX."_data".
            " SET value=%s".
            " WHERE name=%s",
			$this->quote_smart($value),
            $this->quote_smart($key));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            if($GLOBALS['dbcon']->affectedRows() == 0)
            {
                $query = sprintf("SELECT count(*) FROM ".SPG_PREFIX."_data".
                " WHERE name=%s",
                $this->quote_smart($key));

                $row = $GLOBALS['dbcon']->getOne($query);
                if (DB::isError($row))
                {
                    die ($row->getMessage().__FILE__.__LINE__);
                }

                if($row == 0)
                {
                    $query = sprintf("INSERT INTO ".SPG_PREFIX."_data".
                    " (name, value, user_name) VALUES".
                    " (%s, %s, '')",
                    $this->quote_smart($key),
                    $this->quote_smart($value));

                    $result = $GLOBALS['dbcon']->query($query);
                    if (DB::isError($result))
                    {
                        die ($result->getMessage().__FILE__.__LINE__);
                    }
                }   // end if
            }   // end if
        }
    }

    /**
     * updateSecSettingData()
     *
    **/
    function updateSecSettingData($data)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_admin".
            " SET ip_filter = %s, words_filter = %s".
            " WHERE user_name = %s",
            $this->quote_smart($data['ips']),
            $this->quote_smart($data['words']),
            $this->quote_smart($data['user_name']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

    }


    /**
     * getTotalNumPostsByUserLevel()
     *
    **/
    function getTotalNumPostsByUserLevel($userLevel, $cate = 0)
    {
        $query = 
            sprintf("SELECT count(no) ".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category c".
            " WHERE p.user_name=%s AND p.category_id = c.category_id AND display_level >= %s AND c.open = 1 AND c.user_name=%s",
            $this->quote_smart($GLOBALS['n']),
            $this->quote_smart($userLevel),
            $this->quote_smart($GLOBALS['n']));

        if($cate != 0)
        {
            $query .= " AND p.category_id = '".$cate."'";
        }

        $query .= " ORDER BY no DESC";

        $result = $GLOBALS['dbcon']->getOne($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function saveFile($changed, $fileSize, $type = "data", $original)
    {
        $file_no = $this->getNextId("files", "no", $_POST['n']);

        if($type != "data")
        {
            $query = 
                sprintf("INSERT INTO ".SPG_PREFIX."_files".
                " (no, post_no, file_name, original_file_name, file_size, date, author, file_type, user_name)".
                " VALUES".
                " (%s, 4294967295, %s, %s, %s, now(), %s, %s, %s)",
                $file_no,
                $this->quote_smart($changed),
                $this->quote_smart($original),
                $this->quote_smart($fileSize),
                $this->quote_smart($_SESSION['spg_user_name']),
                $this->quote_smart($type),
                $this->quote_smart($_POST['n']));
        }
        else
        {
            $query = 
                sprintf("INSERT INTO ".SPG_PREFIX."_files".
                " (no, file_name, original_file_name, file_size, date, author, file_type, user_name)".
                " VALUES".
                " (%s, %s, %s, %s, now(), %s, %s, %s)",
                $file_no,
                $this->quote_smart($changed),
                $this->quote_smart($original),
                $this->quote_smart($fileSize),
                $this->quote_smart($_SESSION['spg_user_name']),
                $this->quote_smart($type),
                $this->quote_smart($_POST['n']));
        }

        $result = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        $query = 
            sprintf("SELECT no".
            " FROM ".SPG_PREFIX."_files".
            " WHERE file_name = %s AND file_size = %s AND author = %s AND file_type = %s AND user_name=%s",
            $this->quote_smart($changed),
            $this->quote_smart($fileSize),
            $this->quote_smart($_SESSION['spg_user_name']),
            $this->quote_smart($type),
            $this->quote_smart($_POST['n']));

        $result = $GLOBALS['dbcon']->getOne($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function getFileInfo($blog, $fileno)
    {
        $query = 
            sprintf("SELECT no, author, DATE_FORMAT(date, '%%Y%%m%%d') as dir".
            " FROM ".SPG_PREFIX."_files".
            " WHERE no = %s AND user_name=%s",
            $this->quote_smart($fileno),
            $this->quote_smart($blog));

        $result = $GLOBALS['dbcon']->getRow($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function delTempFiles()
    {
        $query = "SELECT DATE_FORMAT(date, '%Y%m%d') as dir, file_name, file_type".
            " FROM ".SPG_PREFIX."_files".
            " WHERE post_no = 0 AND author = '".$_SESSION['spg_user_name']."' AND user_name='".$_GET['n']."'";

        $files = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($files))
        {
            die ($files->getMessage());
        }

        $query = 
            sprintf("DELETE FROM ".SPG_PREFIX."_files".
            " WHERE post_no = 0 AND author = '".$_SESSION['spg_user_name']."' AND user_name='".$_GET['n']."'");

        $result = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $files;
    }

    function delAFile($no)
    {
        $query = "SELECT DATE_FORMAT(date, '%Y%m%d') as dir, file_name, file_type, file_size, author".
            " FROM ".SPG_PREFIX."_files".
            " WHERE no  = '".$no."' AND user_name = '".$_GET['n']."'";

        $files = $GLOBALS['dbcon']->getRow($query);
        
        if (DB::isError($files))
        {
            die ($files->getMessage().__FILE__.__LINE__);
        }

        $query = 
            sprintf("DELETE FROM ".SPG_PREFIX."_files".
            " WHERE no = '%s'", $no);

        $result = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $files;
    }

    function linkFile($fileNo, $postNo)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_files".
            " SET post_no = %s".
            " WHERE no = %s",
            $this->quote_smart($postNo),
            $this->quote_smart($fileNo));

        $files = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($files))
        {
            die ($files->getMessage().__FILE__.__LINE__);
        }
    }

    function getFileByPostNo($postNo)
    {
        $query = "SELECT no, file_name, original_file_name, file_size, DATE_FORMAT(date, '%Y%m%d') as dir".
            " FROM ".SPG_PREFIX."_files".
            " WHERE post_no = '".$postNo."' AND user_name = '".$GLOBALS['n']."'";

        $files = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($files))
        {
            die ($files->getMessage().__FILE__.__LINE__);
        }

        return $files;

    }

    function getFileByPostNoByBlog($postNo, $blog)
    {
        $query = "SELECT no, file_name, file_size, DATE_FORMAT(date, '%Y%m%d') as dir".
            " FROM ".SPG_PREFIX."_files".
            " WHERE post_no = '".$postNo."' AND user_name = '".$blog."'";

        $files = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($files))
        {
            die ($files->getMessage().__FILE__.__LINE__);
        }

        return $files;

    }

    function getTotalFileSize($postNo)
    {
        $query = "SELECT SUM(file_size)".
            " FROM ".SPG_PREFIX."_files".
            " WHERE post_no = '".$postNo."' AND user_name = '".$_GET['n']."'";

        $size = $GLOBALS['dbcon']->getOne($query);
        
        if (DB::isError($size))
        {
            die ($size->getMessage().__FILE__.__LINE__);
        }

        return $size;
    }

    function getAllFileSizeByBlog($blog)
    {
        $query = "SELECT SUM(file_size)".
            " FROM ".SPG_PREFIX."_files".
            " WHERE user_name = '".$blog."'";

        $size = $GLOBALS['dbcon']->getOne($query);
        
        if (DB::isError($size))
        {
            die ($size->getMessage().__FILE__.__LINE__);
        }

        return $size;
    }

    function getTotalNumPosts()
    {
        $query = 
            sprintf("SELECT count(no) ".
            " FROM ".SPG_PREFIX."_posts".
            " WHERE user_name='".$GLOBALS['n']."'");

        $result = $GLOBALS['dbcon']->getOne($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;

    }

    function checkLogin($username, $password)
    {
        $query = sprintf("SELECT user_name, level, is_use".
        " FROM ".SPG_PREFIX."_admin".
        " WHERE user_name=%s AND password = PASSWORD(%s)",
        $this->quote_smart($username),
        $this->quote_smart($password));        

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;

    }

    function getArchive($level)
    {
        $query = sprintf("SELECT FROM_UNIXTIME(post_time, '%%Y') as year, FROM_UNIXTIME(post_time, '%%m') as month, count(*) as num".
        " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category c".
        " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = '1' AND p.user_name=%s AND c.user_name=%s".
        " GROUP BY FROM_UNIXTIME(post_time,'%%Y-%%m')".
        " ORDER BY post_time desc",
        $this->quote_smart($level),
        $this->quote_smart($GLOBALS['n']),
        $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * insertTB
    **/
    function insertTB($tbData)
    {
        $tb_no = $this->getNextId("trackbacks", "no", $GLOBALS['n']);

        $query = sprintf("INSERT INTO ".SPG_PREFIX."_trackbacks".
            " (no, post_no, site_name, p_link, title, contents, date, user_name)".
            " VALUES".
            " (%s, %s, %s, %s, %s, %s, %s, %s)",
            $tb_no,
            $this->quote_smart($tbData['postNo']),
            $this->quote_smart($tbData['blog_name']),
            $this->quote_smart($tbData['url']),
            $this->quote_smart($tbData['title']),
            $this->quote_smart($tbData['excerpt']),
            $this->quote_smart(time()),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    /**
     * insertTBSent
    **/
    function insertTBSent($postNo, $towhere)
    {
        $tb_no = $this->getNextId("trackback_sent", "no", $GLOBALS['blog']);

        $query = sprintf("INSERT INTO ".SPG_PREFIX."_trackback_sent".
            " (no, post_no, towhere, date, user_name)".
            " VALUES".
            " (%s, %s, %s, %s, %s)",
            $tb_no,
            $this->quote_smart($postNo),
            $this->quote_smart($towhere),
            $this->quote_smart(time()),
            $this->quote_smart($GLOBALS['blog']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    /**
     * checkTB
    **/
    function checkTB($tbData)
    {
        $query = sprintf("SELECT count(no) ".
            " FROM ".SPG_PREFIX."_trackbacks".
            " WHERE post_no = %s AND p_link = %s AND user_name=%s",
            $this->quote_smart($tbData['postNo']),
            $this->quote_smart($tbData['url']),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getAdminData()
     * get all configuration data 
     * @access public
     * @param string $who :: user id
     * @return array $result :: all configuration data
    **/
    function getAdminData($who)
    {
        $query = 
            "SELECT * ".
            " FROM ".SPG_PREFIX."_admin".
            " WHERE user_name = '". $who ."'";

        $result = $GLOBALS['dbcon']->getRow($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        if(!$result['user_name'])
        {
            require_once dirname(dirname(__FILE__))."/_lib/library.inc";
            $library = new Library();
            $library->dieError(__FILE__.__LINE__.": ".$GLOBALS['lang']['admin']['wrongblogname']);
        }

        return $result;
    }

    function getUser($who)
    {
        $query = sprintf("SELECT owner, nick_name ".
            " FROM ".SPG_PREFIX."_admin".
            " WHERE nick_name = %s OR owner= %s".
            " GROUP BY owner",
            $this->quote_smart($who),
            $this->quote_smart($who));

        $result = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getAdminData2()
     * get configuration data 
     * @access public
     * @return array $adminData :: configuration data
    **/
    function getAdminData2()
    {
        $query = 
            "SELECT name, value".
            " FROM ".SPG_PREFIX."_data".
            " WHERE user_name='".$GLOBALS['n']."'";

        $adminData = $GLOBALS['dbcon']->getAssoc($query);
        
        if (DB::isError($adminData))
        {
            die ($adminData->getMessage());
        }

        return $adminData;
    }

    function getAdminData2ById($id)
    {
        $query = 
            "SELECT name, value".
            " FROM ".SPG_PREFIX."_data".
            " WHERE user_name='".$id."'";

        $adminData = $GLOBALS['dbcon']->getAssoc($query);

        if (DB::isError($adminData))
        {
            die ($adminData->getMessage());
        }

        return $adminData;
    }

    function getAdminDataBoardURL()
    {
        $query = 
            "SELECT value".
            " FROM ".SPG_PREFIX."_data".
            " WHERE name='admin_board_url'";

        $adminData = $GLOBALS['dbcon']->getOne($query);

        if (DB::isError($adminData))
        {
            die ($adminData->getMessage());
        }

        return $adminData;
    }

    function getAdminRssById($id = '')
    {
        $query = 
            "SELECT name, value".
            " FROM ".SPG_PREFIX."_data".
            " WHERE user_name=''";

        $adminData = $GLOBALS['dbcon']->getAssoc($query);
        
        if (DB::isError($adminData))
        {
            die ($adminData->getMessage());
        }

        return $adminData;
    }

    /**
     * getLinksGroups
    **/
    function getLinksGroups($groupNo = "")
    {
        $query = 
            "SELECT * ".
            " FROM ".SPG_PREFIX."_links_group".
            " WHERE user_name='".$GLOBALS['n']."'";

        if($groupNo != "")
            $query .= " AND group_no = '".$groupNo."'";
        
        $query .= " ORDER BY group_order";

        $result = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getLinksGroupsByBlog
    **/
    function getLinksGroupsByBlog($blog, $groupNo = "")
    {
        $query = 
            "SELECT * ".
            " FROM ".SPG_PREFIX."_links_group".
            " WHERE user_name='".$blog."'";

        if($groupNo != "")
            $query .= " AND group_no = '".$groupNo."'";
        
        $query .= " ORDER BY group_order";

        $result = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }
    
    /**
     * getLinksListByGroup
    **/
    function getLinksListByGroup($group)
    {
        $query = 
            "SELECT * ".
            " FROM ".SPG_PREFIX."_links".
            " WHERE group_no = '".$group."' AND user_name = '".$GLOBALS['n']."'".
            " ORDER BY link_order";

        $result = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getLinksListByGroupByBlog
    **/
    function getLinksListByGroupByBlog($group, $blog)
    {
        $query = 
            "SELECT * ".
            " FROM ".SPG_PREFIX."_links".
            " WHERE group_no = '".$group."' AND user_name = '".$blog."'".
            " ORDER BY link_order";

        $result = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getLinkByNo
    **/
    function getLinkByNo($lno)
    {
        $query = 
            "SELECT * ".
            " FROM ".SPG_PREFIX."_links".
            " WHERE link_no = '".$lno."' AND user_name = '".$_GET['n']."'".
            " ORDER BY link_order";

        $result = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getAllLinks
    **/
    function getAllLinks()
    {
        $query = 
            "SELECT * ".
            " FROM ".SPG_PREFIX."_links".
            " WHERE user_name='".$GLOBALS['n']."'";

        $result = $GLOBALS['dbcon']->query($query);
        
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * quote_smart()
     * Quote variable to make safe
     *
    **/
    function quote_smart($value)
    {
        // Stripslashes
        if (get_magic_quotes_gpc()) 
        {
            $value = stripslashes($value);
        }
        // Quote if not integer
        if (!is_numeric($value) || !$value) 
        {
            $value = "'" . addslashes($value) . "'";
        }
        return $value;
    }

    /**
     * validInput
     * convert user input to data can be used in DB
     * @param String $value
     * @return String
    **/
    function validInput($value)
    {
        $value = trim($value);
        $value = htmlspecialchars($value, ENT_QUOTES);

        return $value;
    }

    /**
     * getRecentCommentByPost()
     * get one recent comment
     * 
    **/
    function getRecentCommentByPost($post)
    {
        $query = sprintf("SELECT * ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE parent_no=%s AND user_name=%s".
        " ORDER BY date DESC LIMIT 0, 1",
        $this->quote_smart($post),
        $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    /**
     * getAllTopComments()
     * :: get all top comments data
     * :: Post article = parent, comments = child, comment reply = reply
    **/
    function getAllTopComments($num)
    {
        $query = sprintf("SELECT * ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE parent_no=%s AND child_no = 0 AND user_name=%s".
        " ORDER BY seq ASC",
        $this->quote_smart($num),
        $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    /**
     * getAllTopGuest()
     * :: get all top comments data for guest bbs
     * :: Post article = parent, comments = child, comment reply = reply
    **/
    function getAllTopGuest($pNum, $start, $num)
    {
        $query = sprintf("SELECT * ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE parent_no=%s AND child_no = 0 AND user_name=%s".
        " ORDER BY seq DESC".
        " LIMIT %s, %s",
        $this->quote_smart($pNum),
        $this->quote_smart($GLOBALS['n']),
        $start, $num);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getTotalTopGuest()
    {
        $query = "SELECT count(*) ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE parent_no=0 AND child_no = 0 AND user_name='".$GLOBALS['n']."'".
        " ORDER BY seq DESC";

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getTrackBack()
     * :: get all tb data
    **/
    function getTrackBack($num)
    {
        $query = sprintf("SELECT * ".
        " FROM ".SPG_PREFIX."_trackbacks".
        " WHERE post_no=%s AND user_name=%s".
        " ORDER BY no ASC",
        $this->quote_smart($num),
        $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    /**
     * getAllReplyComments($child)
     * :: get all top comments data
     * @param int $child :: top comment number
    **/
    function getAllReplyComments($num, $child)
    {
        $query = sprintf("SELECT * ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE parent_no=%s AND child_no = %s AND user_name=%s".
        " ORDER BY seq ASC",
        $this->quote_smart($num),
        $this->quote_smart($child),
        $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    /**
     * getOneComment()
     * :: get one comment data to reply
    **/
    function getOneComment($cNum)
    {
        $query = sprintf("SELECT * ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE no=%s AND is_secret = '' AND user_name=%s",
        $this->quote_smart($cNum),
        $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getOneComment2($cNum)
    {
        $query = sprintf("SELECT * ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE no=%s AND user_name=%s",
        $this->quote_smart($cNum),
        $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    // check password
    function checkCommentPass($no, $pass)
    {
        $query = sprintf("SELECT password, PASSWORD(%s) as inputpass ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE no=%s AND user_name=%s",
        $this->quote_smart($pass),
        $this->quote_smart($no),
        $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        if($result && $result['password'] == $result['inputpass'])
        {
            return 1;
        }
        else if($result && $result['password'] != $result['inputpass'])
        {
            return 0;
        }
        else
        {
            return 2;
        }
    }

    /**
     *
     * if a top comment was deleted and when a last child comment is deleted
     * then it should delete a top comment as well
    **/
    function checkLastComment($no)
    {
        $query = sprintf("SELECT * ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE no=%s AND user_name=%s",
        $this->quote_smart($no),
        $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }


    /**
     * delComment()
     * :: delete comment 
    **/
    function delComment($no, $pass, $isAdmin = 0)
    {
        if($isAdmin == 1)
        {
            $query = sprintf("DELETE ".
            " FROM ".SPG_PREFIX."_comments".
            " WHERE no=%s AND user_name=%s",
            $this->quote_smart($no),
            $this->quote_smart($GLOBALS['n']));
        }
        else
        {
            $query = sprintf("DELETE ".
            " FROM ".SPG_PREFIX."_comments".
            " WHERE no=%s AND password=password(%s) AND user_name=%s",
            $this->quote_smart($no),
            $this->quote_smart($pass),
            $this->quote_smart($GLOBALS['n']));
        }

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getNumChildComments
     * get number of replies of comment ($no)
     * @param int $no : comment number
     * @return int : number replies of comment
    **/
    function getNumChildComments($no)
    {
        $query = sprintf("SELECT count(no) ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE child_no=%s AND user_name=%s",
        $this->quote_smart($no),
        $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * insertComment()
     * :: insert top comment into db
    **/
    function insertComment($post, $noPassword)
    {
        // get current unix timestamp
        $now = time();

        if($noPassword == "0")
            $password = sprintf("password(%s)", $this->quote_smart($post['password']));
        else
            $password = sprintf("%s", $this->quote_smart($post['password']));

        $tb_no = $this->getNextId("comments", "no", $GLOBALS['n']);

        $query = sprintf("INSERT INTO ".SPG_PREFIX."_comments".
            " (no, parent_no, child_no, seq, name, password, homepage, memo, date, is_secret, ip, user_name, member_id)".
            " VALUES".
            " (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
            $tb_no, 
            $this->quote_smart($post['num']),
            $this->quote_smart($post['child']),
            $this->quote_smart($post['seq']),
            $this->quote_smart($post['name']),
            $password,
            $this->quote_smart($post['homepage']),
            $this->quote_smart($post['content']),
            $this->quote_smart($now),
            $this->quote_smart($post['secret']),
            $this->quote_smart($post['ip']),
            $this->quote_smart($GLOBALS['n']),
            $this->quote_smart($post['member_id']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $tb_no;
    }

    /**
     * modifyComment()
     * :: modify
    **/
    function modifyComment($post)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_comments".
            " SET".
            " name=%s, homepage=%s, memo=%s, is_secret=%s".
            " WHERE no=%s AND user_name=%s",
            $this->quote_smart($post['name']),
            $this->quote_smart($post['homepage']),
            $this->quote_smart($post['content']),
            $this->quote_smart($post['secret']),
            $this->quote_smart($post['child']),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    /**
     * getMaxSeqComment()
     * :: get largest seq number in same parent_no
    **/
    function getMaxSeqComment($parent)
    {
        $query = sprintf("SELECT max(seq) ".
            " FROM ".SPG_PREFIX."_comments".
            " WHERE parent_no=%s AND user_name=%s",
            $this->quote_smart($parent),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getMaxSeqReplyComment()
     * :: get largest seq number of replys in same parent_no
    **/
    function getMaxSeqReplyComment($parent, $child)
    {
        $query = sprintf("SELECT max(seq) ".
            " FROM ".SPG_PREFIX."_comments".
            " WHERE parent_no=%s AND child_no=%s AND user_name=%s",
            $this->quote_smart($parent),
            $this->quote_smart($child),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getNumCommentByPost()
     * :: 
    **/
    function getNumCommentByPost($postNo)
    {
        $query = sprintf("SELECT count(*) ".
            " FROM ".SPG_PREFIX."_comments".
            " WHERE parent_no=%s AND user_name=%s",
            $this->quote_smart($postNo),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * getNumTBByPost()
     * :: 
    **/
    function getNumTBByPost($postNo)
    {
        $query = sprintf("SELECT count(no) ".
            " FROM ".SPG_PREFIX."_trackbacks".
            " WHERE post_no=%s AND user_name=%s",
            $this->quote_smart($postNo),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /**
     * upSeqComment()
     * :: add 1 on comments that has higher seq number than this
    **/
    function upSeqReplyComment($parent, $seq)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_comments".
            " SET seq=seq+1".
            " WHERE parent_no=%s AND seq>%s AND user_name=%s",
            $this->quote_smart($parent),
            $this->quote_smart($seq),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }       
    }

    /**
     * getNewPostList()
    **/
    function getNewPostList($level)
    {
        $adminData = $this->getAdminData($GLOBALS['n']);

        $query = 
            "SELECT p.*, a.nick_name ".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_admin a".
            " WHERE p.display_level >= '".$level."' AND p.author=a.user_name AND p.user_name='".$GLOBALS['n']."'".
            " ORDER BY p.post_time DESC".
            " LIMIT 0 , ".$adminData['use_newpost_list'];

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    /**
     * getNewCommentList()
    **/
    function getNewCommentList($level)
    {
        $adminData = $this->getAdminData($GLOBALS['n']);

        $query = 
            "SELECT p.*, c.* ".
            " FROM ".SPG_PREFIX."_comments c, ".SPG_PREFIX."_posts p".
            " WHERE c.is_secret = '' AND c.parent_no = p.no AND p.display_level >= '".$level."' AND c.user_name='".$GLOBALS['n']."' AND p.user_name='".$GLOBALS['n']."'".
            " ORDER BY `date` DESC".
            " LIMIT 0 , ".$adminData['use_newcomment_list'];

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    /**
     * getNewTBList()
    **/
    function getNewTBList($level)
    {
        $adminData = $this->getAdminData($GLOBALS['n']);

        $query = 
            "SELECT * ".
            " FROM ".SPG_PREFIX."_trackbacks c, ".SPG_PREFIX."_posts p".
            " WHERE c.post_no = p.no AND p.display_level >= '".$level."' AND c.user_name='".$GLOBALS['n']."' AND p.user_name='".$GLOBALS['n']."'".
            " ORDER BY `date` DESC".
            " LIMIT 0 , ".$adminData['use_newtb_list'];

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getItems($start, $num, $level, $cate = 0)
    {
        $query = 
            sprintf("SELECT * ".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category c".
            " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = 1 AND p.user_name='".$GLOBALS['n']."' AND c.user_name='".$GLOBALS['n']."'",
            $this->quote_smart($level));
            

        if($cate != 0)
        {
            $query .= " AND p.category_id = '".$cate."'";
        }

        $query .= sprintf(
            " ORDER BY no DESC".
            " LIMIT %s, %s",
            $start,
            $num);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getItemsByBlog($start, $num, $level, $cate = 0, $blog)
    {
        $query = 
            sprintf("SELECT * ".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category c".
            " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = 1 AND p.user_name='".$blog."' AND c.user_name='".$blog."'",
            $this->quote_smart($level));
            

        if($cate != 0)
        {
            $query .= " AND p.category_id = '".$cate."'";
        }

        $query .= sprintf(
            " ORDER BY no DESC".
            " LIMIT %s, %s",
            $start,
            $num);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getItemsByTag($start, $num, $level, $tag)
    {
        $query = 
            sprintf("SELECT * ".
            " FROM ".
                SPG_PREFIX."_posts p, ".
                SPG_PREFIX."_category c, ".
                SPG_PREFIX."_post_keywords t".
            " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = 1 AND p.user_name='".$GLOBALS['n']."' AND c.user_name='".$GLOBALS['n']."'".
            " AND t.keywords=%s AND t.post_no = p.no AND t.user_name='".$GLOBALS['n']."'",
                $this->quote_smart($level),
                $this->quote_smart($tag));

        $query .= sprintf(
            " ORDER BY no DESC".
            " LIMIT %s, %s",
            $start,
            $num);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getNumberItemsByTag($level, $tag)
    {
        $query = 
            sprintf("SELECT count(*) ".
            " FROM ".
                SPG_PREFIX."_posts p, ".
                SPG_PREFIX."_category c, ".
                SPG_PREFIX."_post_keywords t".
            " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = 1 AND p.user_name='".$GLOBALS['n']."' AND c.user_name='".$GLOBALS['n']."'".
            " AND t.keywords=%s AND t.post_no = p.no AND t.user_name='".$GLOBALS['n']."'",
                $this->quote_smart($level),
                $this->quote_smart($tag));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getItemByAuthor($blog, $author)
    {
        $query = sprintf("SELECT * ".
        " FROM ".SPG_PREFIX."_posts".
        " WHERE author = %s AND user_name=%s".
        " LIMIT 0, 1",
        $this->quote_smart($author),
        $this->quote_smart($blog));
            
        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getItemsByKey($start, $num, $level, $key)
    {
        $query = 
            sprintf("SELECT * ".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category c".
            " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = 1".
            " AND (p.subject LIKE '%%%s%%' OR p.contents LIKE '%%%s%%') AND p.user_name=%s AND c.user_name=%s",
            $this->quote_smart($level),
            $key,
            $key,
            $this->quote_smart($GLOBALS['n']),
            $this->quote_smart($GLOBALS['n']));

       $query .= sprintf(
            " ORDER BY p.no DESC".
            " LIMIT %s, %s",
            $start,
            $num);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getTotalItemsByKey($level, $key)
    {
        $query = 
            sprintf("SELECT count(*) ".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category c ".
            " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = 1".
            " AND (p.subject LIKE '%%%s%%' OR p.contents LIKE '%%%s%%') AND p.user_name=%s AND c.user_name=%s",
            $this->quote_smart($level),
            $key,
            $key,
            $this->quote_smart($GLOBALS['n']),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getItemsByNo($no, $level)
    {
        $query = 
            sprintf("SELECT * ".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category c".
            " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = 1 AND p.no = %s AND p.user_name=%s AND c.user_name=%s",
            $this->quote_smart($level),
            $this->quote_smart($no),
            $this->quote_smart($GLOBALS['n']),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getItemsByNoByBlog($no, $level, $blog)
    {
        $query = 
            sprintf("SELECT * ".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category c".
            " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = 1 AND p.no = %s AND p.user_name=%s AND c.user_name=%s",
            $this->quote_smart($level),
            $this->quote_smart($no),
            $this->quote_smart($blog),
            $this->quote_smart($blog));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    /**
     * getItemsByDate
     * @param int $year
     * @param int $month
     * @param int $day
     * @param String $period : eg> m2 -> 2 months
     * @param int $level
    **/
    function getItemsByDate($year, $month, $day, $period, $start, $num, $level)
    {
        $which = substr($period, 0, 1);
        $durat = substr($period, 1);
        
        // get unix timestamp
        $tstamp1 = mktime(0, 0, 0, $month, $day, $year);
        if($day == "00") $day = 1;

        switch ($which)
        {
            case "y":
                $tstamp2 = mktime(0, 0, 0, $month, $day, $year + $durat);
                break;
            case "m":
                $tstamp2 = mktime(0, 0, 0, $month + $durat, $day, $year);
                break;
            case "d":
                $tstamp2 = mktime(0, 0, 0, $month, $day + $durat, $year);
                break;
            default:
                break;
        }

        $query = 
             sprintf("SELECT * ".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category c".
            " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = 1 AND p.post_time BETWEEN %s AND %s AND p.user_name=%s AND c.user_name=%s".
            " ORDER BY no DESC",
            $this->quote_smart($level),            
            $this->quote_smart($tstamp1),
            $this->quote_smart($tstamp2),
            $this->quote_smart($GLOBALS['n']),
            $this->quote_smart($GLOBALS['n']));

        if($num > 0)
            $query .= sprintf(
            " LIMIT %s, %s",
            $start,
            $num);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getOneItemByBlog($blog)
    {
        $query = "SELECT * FROM ".SPG_PREFIX."_posts".
            " WHERE user_name='".$blog."'".
            " ORDER BY post_time DESC".
            " LIMIT 0, 1";

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;

    }

    function getNickByUserName($post, $owner)
    {
        if(!$post)
        {
            return false;
        }
        else if(!$post['author'])
        {
            $query = sprintf("SELECT nick_name FROM ".SPG_PREFIX."_admin".
            " WHERE user_name = %s",
            $this->quote_smart($owner));
        }
        else
        {
            $query = sprintf("SELECT nick_name FROM ".SPG_PREFIX."_admin".
            " WHERE user_name = %s",
            $this->quote_smart($post['author']));
        }

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function getItemsPosition($no, $level)
    {
        $query = 
            sprintf("SELECT count(*) ".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category c".
            " WHERE p.category_id = c.category_id AND display_level >= %s AND c.open = 1 AND p.no >= %s AND p.user_name=%s AND c.user_name=%s",
            $this->quote_smart($level),
            $this->quote_smart($no),
            $this->quote_smart($GLOBALS['n']),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    /*
     * getSimplers
     */
    function getSimplers($start, $num)
    {       
        $query = "SELECT *".
        " FROM ".SPG_PREFIX."_admin".
        " LIMIT $start, $num";
        
        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /*
     * getNumOfSimplers
     */
    function getNumOfSimplers()
    {       
        $query = "SELECT count(user_name) ".
        " FROM ".SPG_PREFIX."_admin";
        
        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    /*
     * getUsers
     */
    function getUsers($level, $start, $num)
    {
        if($level == 0)
        {
            $query = "SELECT member_no, nick_name, relationship, relationship_from, blog_url, last_visit, first_date, num_visit ".
            " FROM ".SPG_PREFIX."_members".
            " WHERE user_name='".$GLOBALS['n']."'".
            " ORDER BY member_no";
        }
        else
        {
            $query = sprintf("SELECT member_no, nick_name, relationship, relationship_from, blog_url, last_visit, first_date, num_visit ".
            " FROM ".SPG_PREFIX."_members".
            " WHERE relationship = %s AND user_name=%s".
            " ORDER BY member_no",
                $this->quote_smart($level),
                $this->quote_smart($GLOBALS['n']));
        }

        if($num > 0)
        {
            $query .= " LIMIT $start, $num";
        }

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    /*
     * insert keywords and post number in to key_post table
     * can get link related a post
     */
    function linkKeyPost($id, $data)
    {
        foreach ($data as $value)
        {
            if(trim($value))
            {
                $query = 
                "INSERT INTO ".SPG_PREFIX."_post_keywords".
                " (post_no, keywords, user_name)".
                " VALUES".
                " ('".$id."','".trim($value)."', '".$GLOBALS['blog']."')";

                $result = $GLOBALS['dbcon']->query($query);
                if (DB::isError($result))
                {
                    die ($result->getMessage().__FILE__.__LINE__);
                } 
            }
        }        
    }

    /*
     * insert keywords from array $data to keyword table
     * @param array $data :contained keywords
     */
    function insertKeywords($data)
    {
        $data = $this->checkKeyExist($data);

        for ($i = 0; $i < count($data); $i++)
        {
            $query = 
            "INSERT INTO ".SPG_PREFIX."_keywords".
            " (keywords, user_name)".
            " VALUES".
            " ('".trim($data[$i])."', '".$_POST['n']."')";

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            } 
        }
    }

    /**
     * modify keywords from array $data to keyword table
     * @param array $data :contained keywords
    **/
    function modifyKeywords($id, $data)
    {
        //key original keywords
        $keywords = trim($this->getKeywordsByPostByBlog($id, $_POST['n']));
        $keys = explode(",", $keywords);
        $keys = array_unique($keys);

        // delete all related keywords first
        $query = sprintf("DELETE ".
            " FROM ".SPG_PREFIX."_post_keywords".
            " WHERE post_no = %s AND user_name=%s",
            $this->quote_smart($id),
            $this->quote_smart($_POST['n']));


        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }       
        
        // now insert keywords again
        $this->insertKeywords($data);
    }

    function checkKeyExist($keys)
    {
        $newKeys = array();        

        foreach ($keys as $value)
        {
            if(trim($value))
            {
                $query = 
                "SELECT count(*) c".
                " FROM ".SPG_PREFIX."_keywords".
                " WHERE keywords='".trim($value)."' AND user_name='".$GLOBALS['blog']."'";

                $result = $GLOBALS['dbcon']->getRow($query);
                if (DB::isError($result))
                {
                    die ($result->getMessage().__FILE__.__LINE__);
                }

                if($result['c'] == 0)
                {
                    array_push($newKeys, $value);                    
                }
            }
        }

        return $newKeys;
    }    

    /**
     * getCategoryInfo
     * get category infomation 
     * ALL => get all cetegories , OPEN => get only opened categories
     * CLOSE => get only closed one
     * @param String : ALL, OPEN, CLOSE
    **/
    function getCategoryInfo($isAll)
    {
        $query = 
            "SELECT * ".
            " FROM ".SPG_PREFIX."_category".
            " WHERE user_name='".$GLOBALS['n']."'";

        if($isAll == "OPEN")
        {
            $query .= " AND open = '1'";
        }
        else if($isAll == "CLOSE")
        {
            $query .= " AND open = '0'";
        }
        else if($isAll == "ALL")
        {
            $query .="";
        }

        $query .= " ORDER BY parent_id ASC";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }             

        return $result;
    }

    function getCategoryInfoByBlog($isAll, $blog)
    {
        $query = 
            "SELECT * ".
            " FROM ".SPG_PREFIX."_category".
            " WHERE user_name='".$blog."'";

        if($isAll == "OPEN")
        {
            $query .= " AND open = '1'";
        }
        else if($isAll == "CLOSE")
        {
            $query .= " AND open = '0'";
        }
        else if($isAll == "ALL")
        {
            $query .="";
        }

        $query .= " ORDER BY parent_id ASC";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }             

        return $result;
    }

    function getCateNameById($id)
    {
        $query = sprintf("SELECT category_name, open".
            " FROM ".SPG_PREFIX."_category".
            " WHERE category_id = %s AND user_name=%s",
            $this->quote_smart($id),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }             

        return $result;
    }

    function getCateNameByIdByBlog($id, $blog)
    {
        $query = sprintf("SELECT category_name, open".
            " FROM ".SPG_PREFIX."_category".
            " WHERE category_id = %s AND user_name=%s",
            $this->quote_smart($id),
            $this->quote_smart($blog));

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }             

        return $result;
    }

    function getNumPostByCate($level)
    {
        $query = sprintf("SELECT p.category_id, count(p.category_id)".
            " FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_category cate".
            " WHERE cate.category_id = p.category_id AND cate.open = 1 AND display_level >= %s AND p.user_name='".$GLOBALS['n']."' AND cate.user_name='".$GLOBALS['n']."'".
            " GROUP BY p.category_id", $level);

        $result = $GLOBALS['dbcon']->getAssoc($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function openPost()
    {
        $query =
            "UPDATE ".SPG_PREFIX."_posts".
            " SET".
            " is_display='1'".
            " WHERE username='".$GLOBALS['blog']."' AND no = ".$_GET['post'];

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

    }

    function closePost()
    {
        $query =
            "UPDATE ".SPG_PREFIX."_posts".
            " SET".
            " is_display='0'".
            " WHERE user_name='".$GLOBALS['blog']."' AND no = ".$_GET['post'];

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

    }

    // get only one post
    function getAPost($no)
    {
        $query = 
        "SELECT *".
        " FROM ".SPG_PREFIX."_posts".
        " WHERE no = '".$no."' AND user_name='".$_GET['n']."'";

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    /*
     * getKeywordsByPost()
     */
    function getKeywordsByPost($postno)
    {
        $keys = array();

        $query = 
        "SELECT keywords".
        " FROM ".SPG_PREFIX."_post_keywords".
        " WHERE post_no = '".$postno."' AND user_name='".$GLOBALS['n']."'";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        while ($data = $result->fetchRow()) 
			array_unshift($keys, $data['keywords']);

        return implode(",", ($keys));
    }

    function getKeywordsByPostByBlog($postno, $blog)
    {
        $keys = array();

        $query = 
        "SELECT keywords".
        " FROM ".SPG_PREFIX."_post_keywords".
        " WHERE post_no = '".$postno."' AND user_name='".$blog."'";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }        

        while ($data = $result->fetchRow()) 
			array_unshift($keys, $data['keywords']);

        return implode(",", ($keys));
    }

    function getKeywordsByPostResult($postno, $blog)
    {
        $query = 
        "SELECT keywords".
        " FROM ".SPG_PREFIX."_post_keywords".
        " WHERE post_no = '".$postno."' AND user_name='".$blog."'";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;     
    }

    function getRelatedPost($postNo)
    {
        $query = 
        "SELECT keywords".
        " FROM ".SPG_PREFIX."_post_keywords".
        " WHERE post_no = '".$postNo."' AND user_name='".$GLOBALS['n']."'";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        $keys = "";

        $i = 0;

        $keysQuery = "";
        while($keyData = $result->fetchRow())
        {
            if($i == 0)            
                $keysQuery = "(k.keywords = '".$keyData['keywords']."'";
            else
                $keysQuery .= " OR k.keywords = '".$keyData['keywords']."'";
            $i++;
        }
        if($keysQuery)
            $keysQuery .= ")";

        $reData = array();
       
        $query = sprintf(
        "SELECT p.no, p.subject".
        " FROM ".SPG_PREFIX."_post_keywords k, ".SPG_PREFIX."_posts p".
        " WHERE %s AND k.post_no = p.no AND p.no <> %s AND k.user_name=%s AND p.user_name=%s".
        " GROUP BY p.no".
        " ORDER BY post_no DESC",
            $keysQuery, $postNo,
            $this->quote_smart($GLOBALS['n']),
            $this->quote_smart($GLOBALS['n']));

        $result2 = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result2))
        {
            die ($result2->getMessage().__FILE__.__LINE__);
        }       
       
        return $result2;
    }

    /**
     * insertPost
     * @param array $data
     * @param string $mode 1 = postnow , 2 = save temporary
     * @access public
     * @return timestamp as a key of the post
    **/
    function insertPost($data)
    {
        $now = time();

        $post_no = $this->getNextId("posts", "no", $_POST['n']);

        $query =
            sprintf("INSERT INTO ".SPG_PREFIX."_posts".
            " (no, subject, category_id, author, contents, post_time, display_level, dis_comment, dis_tb, user_name)".
            " VALUES".
            " (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
                $post_no,
                $this->quote_smart($data['subject']),
                $this->quote_smart($data['category']),
                $this->quote_smart($_SESSION['spg_user_name']),
                $this->quote_smart($data['contents']),
                $this->quote_smart($now),
                $this->quote_smart($data['dis_level']),
                $this->quote_smart($data['dis_comment']),
                $this->quote_smart($data['dis_tb']),
                $this->quote_smart($_POST['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $post_no;
    }

    /*
     * @param array
     */
    function modifyPost($data)
    {
        //$now = time();
        $query = sprintf("UPDATE ".SPG_PREFIX."_posts".
            " SET".
            " subject=%s, contents=%s, author=%s, display_level=%s, category_id=%s, dis_comment = %s, dis_tb = %s".
            " WHERE no = %s AND user_name=%s",
                $this->quote_smart($data['subject']),
                $this->quote_smart($data['contents']),
                $this->quote_smart($_SESSION['spg_user_name']),
                $this->quote_smart($data['dis_level']),
                $this->quote_smart($data['category']),
                $this->quote_smart($data['dis_comment']),
                $this->quote_smart($data['dis_tb']),
                $this->quote_smart($data['post']),
                $this->quote_smart($data['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function checkNeighBlog($userId)
    {
        $query = sprintf("SELECT member_no, nick_name, relationship, relationship_from, blog_url, num_visit".
            " FROM ".SPG_PREFIX."_members".
            " WHERE member_no = %s AND user_name=%s",
            $this->quote_smart($userId),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function UpdateNeighBlog($userId)
    {
        $now = time();
        $query = sprintf("UPDATE ".SPG_PREFIX."_members".
            " SET".
            " last_visit = %s, num_visit = num_visit + 1".
            " WHERE member_no = %s AND user_name=%s",
            $this->quote_smart($now),
            $this->quote_smart($userId),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function addNewNeighBlog($userData)
    {
        $now = time();
        
        $query = sprintf("INSERT INTO ".SPG_PREFIX."_members".
            " (member_no, nick_name, relationship, blog_url, last_visit, first_date, num_visit, user_name)".
            " VALUES".
            " (%s, %s, '3', %s, %s, %s, '1', %s)",
            $this->quote_smart($userData['spg_neigh_user_id']),
            $this->quote_smart($userData['spg_neigh_nick']),
            $this->quote_smart($userData['spg_neigh_blog']),
            $this->quote_smart($now),
            $this->quote_smart($now),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function joinBlog($id)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_members".
            " SET relationship = '9'".
            " WHERE member_no = %s AND user_name=%s",
            $this->quote_smart($id),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function updateCountLog($what, $type)
    {
        $query = sprintf("UPDATE ".SPG_PREFIX."_count_log".
            " SET count = count + 1".
            " WHERE what = %s AND type = %s AND user_name=%s",
            $this->quote_smart($what),
            $this->quote_smart($type),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $GLOBALS['dbcon']->affectedRows();
    }

    function deleteLogData()
    {
        $query = "DELETE FROM ".SPG_PREFIX."_count_data WHERE user_name='".$GLOBALS['n']."'";
        $result = $GLOBALS['dbcon']->query($query);

        $query = "DELETE FROM ".SPG_PREFIX."_count WHERE user_name='".$GLOBALS['n']."'";
        $result = $GLOBALS['dbcon']->query($query);
    }

    function insertCountLog($what, $type)
    {
        $log_no = $this->getNextId("count_log", "no", $GLOBALS['n']);

        $query = sprintf("INSERT INTO ".SPG_PREFIX."_count_log".
            " (no, what, type, count, user_name)".
            " VALUES".
            " (%s, %s, %s, 1, %s)",
            $log_no,
            $this->quote_smart($what),
            $this->quote_smart($type),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function checkCountStatDate()
    {
        $query = "SELECT date ".
            " FROM ".SPG_PREFIX."_count_stat WHERE user_name='".$GLOBALS['n']."' ORDER BY date DESC LIMIT 0, 1";

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function getCountByTime($date)
    {
        $query = "SELECT DATE_FORMAT(date, '%k') time, count(*) num ".
            " FROM ".SPG_PREFIX."_count".
            " WHERE DATE_FORMAT(date, '%Y%m%d') = '".$date."' AND user_name='".$GLOBALS['n']."'".
            " GROUP BY DATE_FORMAT(date, '%Y%m%d%H')".
            " ORDER BY DATE_FORMAT(date, '%k') DESC";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;

    }

    function getPageViewByTime($date)
    {
        $query = "SELECT DATE_FORMAT(date, '%k') time, count(*) num ".
            " FROM ".SPG_PREFIX."_count_data".
            " WHERE DATE_FORMAT(date, '%Y%m%d') = '".$date."' AND user_name='".$GLOBALS['n']."'".
            " GROUP BY DATE_FORMAT(date, '%Y%m%d%H')".
            " ORDER BY DATE_FORMAT(date, '%k') DESC";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;

    }

    function insertCountStat($date, $totalCount, $totalPageview, $countByTime, $pageviewByTime)
    {
        $query = sprintf("INSERT INTO ".SPG_PREFIX."_count_stat".
            " (date, total_count, total_page_view, count_by_time, page_view_by_time, user_name)".
            " VALUES".
            " (%s, %s, %s, %s, %s, %s)",
            $this->quote_smart($date),
            $this->quote_smart($totalCount),
            $this->quote_smart($totalPageview),
            $this->quote_smart($countByTime),
            $this->quote_smart($pageviewByTime),
            $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);        
    }

    function checkFirstCountDate()
    {
        $query = "SELECT DATE_FORMAT(date, '%Y%m%d') date, DATE_FORMAT(DATE_SUB(date, INTERVAL 1 DAY), '%Y%m%d') p_date".
            " FROM ".SPG_PREFIX."_count WHERE user_name='".$GLOBALS['n']."' ORDER BY date ASC LIMIT 0, 1";

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function getCountYesterday()
    {
        $query = "SELECT total_count, total_page_view ".
            " FROM ".SPG_PREFIX."_count_stat ".
            " WHERE date = DATE_SUB(DATE_FORMAT(NOW(), '%Y%m%d'), INTERVAL 1 DAY) AND user_name='".$GLOBALS['n']."'".
            " LIMIT 0, 1";

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function getCountToday()
    {
        $query = "SELECT count(*) total ".
            " FROM ".SPG_PREFIX."_count".
            " WHERE DATE_FORMAT(date, '%Y%m%d') = DATE_FORMAT(NOW(), '%Y%m%d') AND user_name='".$GLOBALS['n']."'";

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function getCountTotal()
    {
        $query = "SELECT SUM(total_count) total_count".
            " FROM ".SPG_PREFIX."_count_stat ".
            " WHERE user_name='".$GLOBALS['n']."'";

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        $today = $this->getCountToday();

        return $result['total_count'] + $today['total'];        
    }

    function getMonthStat()
    {
        $query = "SELECT DATE_FORMAT(date, '%Y/%m') date, DATE_FORMAT(date, '%Y%m') date2, SUM(total_count) visit, SUM(total_page_view) page".
            " FROM ".SPG_PREFIX."_count_stat".
            " WHERE user_name='".$GLOBALS['n']."'".
            " GROUP BY DATE_FORMAT(date, '%Y%m')".
            " ORDER BY date DESC";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
        
        return $result;
    }

    function getDayStat($yearmonth)
    {
        $query = sprintf(
            "SELECT DATE_FORMAT(date, '%%d') date, DATE_FORMAT(date, '%%Y%%m%%d') date2, total_count visit, total_page_view page".
            " FROM ".SPG_PREFIX."_count_stat".
            " WHERE DATE_FORMAT(date, '%%Y%%m') = '%s' AND user_name='".$GLOBALS['n']."'".
            " ORDER BY date ASC",
                $yearmonth);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
        
        return $result;
    }

    function getTimeStat($yearmonthday)
    {
        $query = sprintf(
            "SELECT count_by_time visit, page_view_by_time page".
            " FROM ".SPG_PREFIX."_count_stat".
            " WHERE DATE_FORMAT(date, '%%Y%%m%%d') = '%s' AND user_name=%s".
            " ORDER BY date ASC",
                $yearmonthday,
                $this->quote_smart($GLOBALS['n']));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
        
        return $result;
    }

    function getAllCountData($limit = "0")
    {
        $query = "SELECT DATE_FORMAT(date, '%Y/%m/%d %H:%i:%s') date, request_uri_query query, referer, ip, agent".
            " FROM ".SPG_PREFIX."_count_data".
            " WHERE user_name='".$GLOBALS['n']."'";

        if($limit) $query .= " LIMIT 0, ".$limit;

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
        
        return $result;
    }

    function getAllCountLog($type, $limit = "0")
    {
        $query = "SELECT what, count".
            " FROM ".SPG_PREFIX."_count_log".
            " WHERE type = '".$type."' AND user_name='".$_GET['n']."'".
            " ORDER by count DESC";

        if($limit) $query .= " LIMIT 0, ".$limit;

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
        
        return $result;
    }

    function get_relationship($member_url, $n)
    {
        $query = "SELECT *".
            " FROM ".SPG_PREFIX."_members".
            " WHERE blog_url = '".$member_url."' AND user_name='".$n."'";

        $result = $GLOBALS['dbcon']->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
        
        return $result;
    }
    
    function spgReadFile($fileName)
    {        
        $contents = NULL;
        if (file_exists($fileName)) 
        {
            $fd = @fopen($fileName, 'r');

            if ($fd) 
            {
                // lock a file for read
                flock($fd, LOCK_SH);
                $contents = fread($fd, filesize($fileName));
                // release a lock
                flock($fd, LOCK_UN);
                fclose($fd);
            }
        }
        else
        {
            // print error message
            echo "File is not exists".__FILE__.":".__LINE__;
        }

		return($contents);

    }   // End Function

    function spgWriteFile($file, $contents)
    {		
        $result = false;
        $fd = @fopen($file, 'w');

        if ($fd) 
        {
            flock( $fd, LOCK_EX );
            $result = fwrite($fd, "<?php\n");
            $result = fwrite($fd, $contents);
            $result = fwrite($fd, "\n?>");
            flock($fd, LOCK_UN);
            if($result) chmod($file, 0707);
            fclose($fd);
        }
		
		return($result);
    }

    /**
     * getArrayWithKey()
     * get a array from a file that has key/value pair
     *
     * @access public
     * @param string $contents
     * @return array
    **/
    function getArrayWithKey($contents) 
    {
        $output = array();
     
        if (is_array($contents)) 
        {
            $array = $contents;
        }
        else 
        {
            $array = explode('|', $contents);
        }
        
        for ($i = 0; $i < count($array); $i = $i + 2) 
        {
            $key = $array[$i];
            $output[$key] = $array[$i+1];
        }
        
        return ($output);
    }

    // get rid of php tags
    function getRidTag($str)
    {
        if($str) 
        {
			$str = str_replace("<?php", "", $str);
			$str = str_replace("?>", "", $str);
            $str = trim($str);
        }

        return $str;
    }

    function getNextId($table, $key, $username)
    {
        $query = sprintf("SELECT MAX(%s) FROM ".SPG_PREFIX."_%s WHERE user_name=%s LIMIT 0, 1",
            $key, $table, $this->quote_smart($username));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        $result++;

        return $result;
    }

    function change_relationship_from($url, $toWhat, $n)
    {     
        $query = sprintf("UPDATE ".SPG_PREFIX."_members".
            " SET relationship_from = '%s'".
            " WHERE blog_url = %s AND user_name=%s",
            $this->quote_smart($toWhat),
            $this->quote_smart($url),
            $this->quote_smart($n));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function is_member_exists($url, $n)
    {
        $query = sprintf("SELECT member_no FROM ".SPG_PREFIX."_members".
            " WHERE blog_url = %s AND user_name=%s",
            $this->quote_smart($url),
            $this->quote_smart($n));

        $member_no = $GLOBALS['dbcon']->getOne($query);

        return $member_no;
    }

    function insert_my_neighbour($member_no, $nick, $rel, $url, $n)
    {
         $query = sprintf("INSERT INTO ".SPG_PREFIX."_members".
            " (member_no, nick_name, relationship_from, blog_url, user_name)".
            " VALUES (%s, %s, %s, %s, %s)",
            $this->quote_smart($member_no),
            $this->quote_smart($nick),
            $this->quote_smart($rel),
            $this->quote_smart($url),
            $this->quote_smart($n));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function deleteTb($no, $n)
    {
        $query = sprintf("DELETE FROM ".SPG_PREFIX."_trackbacks".
            " WHERE no = %s AND user_name = %s",
            $this->quote_smart($no),
            $this->quote_smart($n));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function addCommentQueue($toCommentId, $fromCommentId, $n)
    {
        $query = sprintf("INSERT INTO ".SPG_PREFIX."_comm_notify_queue".
            " (to_comment_id, from_comment_id, user_name)".
            " VALUES".
            " (%s, %s, %s)",
            $this->quote_smart($toCommentId),
            $this->quote_smart($fromCommentId),
            $this->quote_smart($n));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            //die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function delCommentQueue($toCommentId, $fromCommentId, $n)
    {
        $query = sprintf("DELETE FROM ".SPG_PREFIX."_comm_notify_queue".
            " WHERE to_comment_id = %s AND from_comment_id = %s AND user_name = %s",
            $this->quote_smart($toCommentId),
            $this->quote_smart($fromCommentId),
            $this->quote_smart($n));

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }
    }

    function getCommentQueue($num, $n)
    {
        $query = sprintf("SELECT * ".
            " FROM ".SPG_PREFIX."_comm_notify_queue q LEFT JOIN ".SPG_PREFIX."_comments c".
            " ON q.user_name=%s AND q.to_comment_id = c.no AND c.user_name = %s".
            " ORDER by q.to_comment_id".
            " LIMIT 0, %s",
            $this->quote_smart($n),
            $this->quote_smart($n),
            $num);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        return $result;
    }

    function addCommentNotifyBlog($blog)
    {
        $query = sprintf("SELECT blog_id, blog_name, blog_author FROM ".SPG_PREFIX."_comm_notify_blogs".
            " WHERE blog_url = %s",
            $this->quote_smart($blog['homepage']));

        $blogExists = $GLOBALS['dbcon']->getRow($query);

        if(!$blogExists['blog_id'])
        {
            $query = sprintf("INSERT INTO ".SPG_PREFIX."_comm_notify_blogs".
                " (blog_url, modified, blog_name, blog_author)".
                " VALUES".
                " (%s, UNIX_TIMESTAMP(), %s, %s)",
                $this->quote_smart($blog['homepage']),
                $this->quote_smart($blog['blog_name']),
                $this->quote_smart($blog['blog_author']));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                //die ($result->getMessage().__FILE__.__LINE__);
            }

             $query = sprintf("SELECT blog_id, blog_name, blog_author FROM ".SPG_PREFIX."_comm_notify_blogs".
                " WHERE blog_url = %s",
                $this->quote_smart($blog['homepage']));

            $blogExists = $GLOBALS['dbcon']->getRow($query);
        }

        if($blog['blog_name'] != $blogExists['blog_name'] || $blog['blog_author'] != $blogExists['blog_author'])
        {
            $query = sprintf("UPDATE ".SPG_PREFIX."_comm_notify_blogs".
                " set ".
                " (blog_url=%s, modified=UNIX_TIMESTAMP(), blog_name=%s, blog_author=%s)".
                " WHERE blod_id =%s",
                $this->quote_smart($blog['homepage']),
                $this->quote_smart($blog['blog_name']),
                $this->quote_smart($blog['blog_author']),
                $this->quote_smart($blogExists['blog_id']));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                //die ($result->getMessage().__FILE__.__LINE__);
            }
        }

        return $blogExists['blog_id'];
    }

    function addCommentNotify($parent, $child, $n)
    {
        $query = sprintf("SELECT * FROM ".SPG_PREFIX."_comm_notify".
            " WHERE post_id=%s AND blog_id=%s AND comm_no=%s AND user_name=%s",
            $this->quote_smart($parent['post_id']), 
            $this->quote_smart($parent['blog_id']),
            $this->quote_smart($parent['comm_no']),
            $this->quote_smart($n));

        $commExists = $GLOBALS['dbcon']->getRow($query);

        if(!$commExists['id'])
        {
            $query = sprintf("INSERT INTO ".SPG_PREFIX."_comm_notify".
                " (post_id, parent, comm_no, name, homepage, secret, comment, ip, regdate, modified, blog_id, comm_url, item_url, item_title, user_name)".
                " VALUES".
                " (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
                $this->quote_smart($parent['post_id']),
                $this->quote_smart($parent['parent_id']),
                $this->quote_smart($parent['comm_no']),
                $this->quote_smart($parent['parent_name']),
                $this->quote_smart($parent['parent_home']),
                $this->quote_smart(''),
                $this->quote_smart($parent['comment']),
                $this->quote_smart($_SERVER['REMOTE_ADDR']),
                $this->quote_smart($parent['parent_date']),
                $this->quote_smart($parent['parent_date']),
                $this->quote_smart($parent['blog_id']),
                $this->quote_smart($parent['comm_url']),
                $this->quote_smart($parent['item_url']),
                $this->quote_smart($parent['item_title']),
                $this->quote_smart($n));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                die ($result->getMessage().__FILE__.__LINE__);
            }

            $query = sprintf("SELECT * FROM ".SPG_PREFIX."_comm_notify".
                " WHERE post_id=%s AND blog_id=%s AND comm_no=%s AND user_name=%s",
                $this->quote_smart($parent['post_id']), 
                $this->quote_smart($parent['blog_id']),
                $this->quote_smart($parent['comm_no']),
                $this->quote_smart($n));

            $commExists = $GLOBALS['dbcon']->getRow($query);
        }

        if($parent['parent_name'] != $commExists['name'] || $parent['parent_comment'] != $commExists['comment'] || $parent['item_title'] != $commExists['item_title'])
        {
            $query = sprintf("UPDATE ".SPG_PREFIX."_comm_notify".
                " set ".
                " (name=%s, modified=%s, comment=%s, item_title=%s)".
                " WHERE id = %s",
                $this->quote_smart($parent['parent_name']),
                $this->quote_smart($parent['parent_date']),
                $this->quote_smart($parent['comment']),
                $this->quote_smart($parent['item_title']),
                $this->quote_smart($commExists['id']));

            $result = $GLOBALS['dbcon']->query($query);
            if (DB::isError($result))
            {
                //die ($result->getMessage().__FILE__.__LINE__);
            }
        }

        if($child['parent_id'])
        {
            $query = sprintf("SELECT * FROM ".SPG_PREFIX."_comm_notify".
                " WHERE post_id=%s AND blog_id=%s AND comm_no=%s AND user_name=%s",
                $this->quote_smart($parent['post_id']), 
                $this->quote_smart($parent['blog_id']),
                $this->quote_smart($child['comm_no']),
                $this->quote_smart($n));

            $commExists = $GLOBALS['dbcon']->getRow($query);

            if(!$commExists['id'])
            {
                $query = sprintf("INSERT INTO ".SPG_PREFIX."_comm_notify".
                    " (post_id, parent, comm_no, name, homepage, secret, comment, ip, regdate, modified, blog_id, comm_url, item_url, item_title, user_name)".
                    " VALUES".
                    " (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
                    $this->quote_smart($parent['post_id']),
                    $this->quote_smart($child['parent_id']),
                    $this->quote_smart($child['comm_no']),
                    $this->quote_smart($child['child_name']),
                    $this->quote_smart($child['child_home']),
                    $this->quote_smart(''),
                    $this->quote_smart($child['comment']),
                    $this->quote_smart($_SERVER['REMOTE_ADDR']),
                    $this->quote_smart($child['child_date']),
                    $this->quote_smart($child['child_date']),
                    $this->quote_smart($parent['blog_id']),
                    $this->quote_smart($child['comm_url']),
                    $this->quote_smart($parent['item_url']),
                    $this->quote_smart($parent['item_title']),
                    $this->quote_smart($n));

                $result = $GLOBALS['dbcon']->query($query);
                if (DB::isError($result))
                {
                    //die ($result->getMessage().__FILE__.__LINE__);
                }

                $query = sprintf("SELECT * FROM ".SPG_PREFIX."_comm_notify".
                    " WHERE post_id=%s AND blog_id=%s AND comm_no=%s AND user_name=%s",
                    $this->quote_smart($parent['post_id']), 
                    $this->quote_smart($parent['blog_id']),
                    $this->quote_smart($child['comm_no']),
                    $this->quote_smart($n));

                $commExists = $GLOBALS['dbcon']->getRow($query);
            }

            if($child['child_name'] != $commExists['name'] || $child['child_comment'] != $commExists['comment'] || $parent['item_title'] != $commExists['item_title'])
            {
                $query = sprintf("UPDATE ".SPG_PREFIX."_comm_notify".
                    " set ".
                    " (name=%s, modified=%s, comment=%s, item_title=%s)".
                    " WHERE id = %s",
                    $this->quote_smart($child['child_name']),
                    $this->quote_smart($child['child_date']),
                    $this->quote_smart($child['comment']),                    
                    $this->quote_smart($parent['item_title']),
                    $this->quote_smart($commExists['id']));

                $result = $GLOBALS['dbcon']->query($query);
                if (DB::isError($result))
                {
                    //die ($result->getMessage().__FILE__.__LINE__);
                }
            }
        }
    }

    function getAllNumberComment($n)
    {
        $query = sprintf("SELECT count(*) ".
        " FROM ".SPG_PREFIX."_comments".
        " WHERE user_name=%s",
        $this->quote_smart($n));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getTagsWithNum($blog)
    {
        $query = "SELECT keywords, count(*) cnt".
            " FROM `".SPG_PREFIX."_post_keywords`".
            " WHERE user_name='$blog'".
            " GROUP BY keywords";

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getFilesByType($type, $blog, $start, $num)
    {
        $query = sprintf("SELECT *, DATE_FORMAT(date, '%%Y%%m%%d') as dir ".
        " FROM ".SPG_PREFIX."_files".
        " WHERE user_name=%s AND file_type=%s".
        " ORDER by no desc".
        " LIMIT %s, %s",
            $this->quote_smart($blog),
            $this->quote_smart($type),
            $start, $num);

        $result = $GLOBALS['dbcon']->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }

    function getCountFilesByType($type, $blog)
    {
        $query = sprintf("SELECT count(*) ".
        " FROM ".SPG_PREFIX."_files".
        " WHERE user_name=%s AND file_type=%s",
            $this->quote_smart($blog),
            $this->quote_smart($type));

        $result = $GLOBALS['dbcon']->getOne($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        } 

        return $result;
    }


    
} // End of Class Data

?>