<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version The Simplog                                     |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// | Initial file to load Simplog                                         |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 03/Feb/2006 00:12                                |
// +----------------------------------------------------------------------+
//
// $Id init.inc, v0.4, 03/Feb/2006 00:12, theSimplog Exp$

require_once dirname(dirname(__FILE__))."/_lib/setup.inc";
// set error report level
error_reporting(E_ALL ^ E_NOTICE);

// blog identification
$n = "";

$setup = new Setup();
$GSetup = $setup->getGlobalSetting();

// get linked setting, if a setting file exists
if(file_exists(dirname(dirname(__FILE__))."/_data/linked.php"))
{
    define("IS_LINKED", true);
    $linkSetup = $setup->getLinkedSetting();
    define("LINK_BOARD", $linkSetup['BOARDTYPE']);
}
else
{
    define("IS_LINKED", false);
}


//user defined value
$prefix = $GSetup['PREFIX'];
$dbms = $GSetup['DATATYPE'];

$language = "korean";
///////////////////////////////////////////////////
// check which database type is using : FILE | MYSQL

if($GSetup['DATATYPE'] == "FILE")
    $usedb = 0;
else
    $usedb = 1;

if($usedb)
{
    // Pear DB road.
    require_once dirname(__FILE__)."/DB.php";
}

/**
 * version info
**/
define("SPG_VERSION", "0.7.1.3");

/**
 * Data table prefix
**/
define("SPG_PREFIX", "spg_".$prefix);
define("SPG_ROOT", dirname(dirname(__FILE__)));
define("SPG_DATA", SPG_ROOT."/_data");
define("SIMPLOG", basename(dirname(dirname(__FILE__))));

/**
 * Database related initial 
**/
if($usedb)
{
    $dsn = "mysql://".$GSetup['DBUSER'].":".$GSetup['DBPASS']."@".$GSetup['DBHOST']."/".$GSetup['DBNAME'];

    $dbcon = DB::connect($dsn);
    if (DB::isError($dbcon)) 
    {
        die ($dbcon->getMessage());
    }


    //// this will set a default fetchmode for this Pear DB instance
    //// (for all queries)
    $dbcon->setFetchMode(DB_FETCHMODE_ASSOC);

    // SET charater set
    $dbcon->query("SET NAMES 'utf8'");
    $dbcon->query("SET CHARACTER SET 'utf8'");
}
/* End : Database related initial */

/** Session set **/
if(IS_LINKED)
    @session_save_path($linkSetup['SESLOC']);
else
    @session_save_path(SPG_ROOT."/_cache");

@session_cache_limiter('nocache, must-revalidate');
session_set_cookie_params(0,"/");
session_start();
/** End session set **/

// set linked
if(IS_LINKED)
{
    require_once dirname(dirname(__FILE__))."/_linked/link.inc";
    $linked = new Linked();
    switch($linkSetup['BOARDTYPE'])
    {
        case 'zero':
            if(isset($_SESSION['zb_logged_no']))
            {
                $linkBoardMember = $linked->getBoardUser($_SESSION['zb_logged_no']);
                $linkMember = $linked->getLinkedIdByBoardId($linkBoardMember['user_id']);
            }
            break;
        case 'gnu4':
            // auto login
            if(isset($_SESSION['ss_mb_id']))
            {
                $linkMember = $linked->getLinkedIdByBoardId($_SESSION['ss_mb_id']);
            }
            break;
        default:
            break;
    }

    if($linkMember['user_name'])
    {
        $_SESSION['spg_user_name'] = $linkMember['user_name'];
        $_SESSION['spg_level'] = $linkMember['level'];
    }
}


//// need to check if blog name is existed
if(strpos($_SERVER['PHP_SELF'], "index.php") !== false)
{
    eregi("(.*)\/([^\/]*)\/index\.php", $_SERVER['PHP_SELF'], $arr);
    $blogID = $arr[2];
    $blogPath = $arr[1];
}
else
{
    $blogID = substr(strrchr(dirname($_SERVER['PHP_SELF']), "/"), 1);
    $blogPath = explode("/".$blogID, $_SERVER['PHP_SELF']);
    $blogPath = $blogPath[0];
}

if($blogID == "_admin" || $blogID == "_patch" || $blogID == "_linked" || $blogID == "_plugin")
{
    if(isset($_SESSION['spg_user_name']))
        $n = $_SESSION['spg_user_name'];
    else
        $n = $GSetup['ROOT'];
}
else
{    
    $n = $blogID;

    if($_GET['script']) $n = $_GET['script'];
    else if($script) $n = $script;
}

define("SPG_URI", "http://".$_SERVER['HTTP_HOST'].$blogPath);
define("SPG_BLOG", SPG_PREFIX."_".$n);

//// Get Language pack
$data = new Data();
$adminData = $data->getAdminData($n);
require_once SPG_ROOT."/_lang/".$adminData['language']."/lang.inc";

// free values
unset($adminData);
unset($data);
unset($arr);
?>