<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version The Simplog                                     |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 05/Jan/2006 14:14                                |
// +----------------------------------------------------------------------+
//
// $Id login.inc$


class Login
{

    function Login()
    {
    }

    function authorise()
    {
        $data = new Data();
        $library = new Library();

        $username = $library->dataValidation($_POST['user_name']);
        $password = $library->dataValidation($_POST['pass']);

        $userData = $data->checkLogin($username, $password);
    
        // successful
        if($userData['user_name'])
        {
            @session_start();
            //session register
            $_SESSION['spg_level'] = $userData['level'];
            $_SESSION['spg_user_name'] = $userData['user_name'];

            // for linked
            if(IS_LINKED)
            {
                require_once dirname(dirname(__FILE__))."/_linked/link.inc";
                $linked = new Linked();
                switch($GLOBALS['linkSetup']['BOARDTYPE'])
                {
                    case 'zero':
                        $linkMember = $linked->getLinkedIdBySimplogId($userData['user_name']);
                        $linkMember2 = $linked->getBoardUserByKey("user_id", $linkMember['board_user_id']);
                        $_SESSION['zb_logged_no'] = $linkMember2['no'];
                        $_SESSION['zb_logged_time'] = time();
                        $_SESSION['zb_logged_ip'] = $_SERVER['REMOTE_ADDR'];
                        $_SESSION['zb_last_connect_check'] = 0;
                        break;
                    case 'gnu4':
                        // auto login
                        $linkMember = $linked->getLinkedIdBySimplogId($userData['user_name']);
                        $_SESSION['ss_mb_id'] = $linkMember['board_user_id'];
                        break;
                    default:
                        break;
                }
            }

            return true;
        }
        else
        {
            return false;
        }

    }

    function is_authorised()
    {
        @session_start();

        if(isset($_SESSION['spg_user_name']))
        {        
            return true;
        }
        else
        {
            goToPage("?mode=login&url=".urlencode($_SERVER['REQUEST_URI']));
            return false;
        }
    }

    function accessByLevel($level, $where = 1)
    {
        @session_start();

        if(!isset($_SESSION['spg_level']) || $_SESSION['spg_level'] > $level)
        {
            require_once dirname(dirname(__FILE__))."/_lib/library.inc";
            $library = new Library();
            $library->dieError($GLOBALS['lang']['login']['deny'], $where);
        }
    }

    function showLoginPage()
    {
        include SPG_ROOT."/_admin/html/login.html";
    }

    function showJoinPage()
    {
        include SPG_ROOT."/_skin/_default_/join.html";
    }

    function doJoin()
    {
        $id = $_SESSION['spg_neigh_user_id'];

        $data = new Data();
        $NeighData = $data->checkNeighBlog($id);
        
        if($NeighData['relationship'] < 3)
        {
            require_once dirname(dirname(__FILE__))."/_lib/library.inc";
            $library = new Library();
            $library->dieError($GLOBALS['lang']['login']['alreadyneigh']);
        }
        else if($NeighData['relationship'] == 9)
        {
            require_once dirname(dirname(__FILE__))."/_lib/library.inc";
            $library = new Library();
            $library->dieError($GLOBALS['lang']['login']['alreadyjoin']);
        }

        $data->joinBlog($id);
        
        require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";

        $mainview = new Mainview();
        $blog = $NeighData['blog_url'];
        $mainview->send_action("be_relation", $blog);

        require_once dirname(dirname(__FILE__))."/_lib/script.inc";
        $script = new Script();
        $script->alert($GLOBALS['lang']['login']['okneigh']);
        $script->closeWin();
    }

    function logout()
    {
        @session_start();
        unset($_SESSION['spg_level']);
        unset($_SESSION['spg_user_name']);
        session_destroy();

        goToPage(SPG_URI."/".$GLOBALS['n']."/index.php");
    }

    function simplogin($key, $ip)
    {
        $uid = md5(uniqid(rand(), true));

        $rss = "";
        $rss .= '<?xml version="1.0" ?>'."\r\n";
		$rss .= '<simplog version="0.5">'."\r\n";
        $rss .= '<key>'.$key.'</key>'."\r\n";
        $rss .= '<uid>'.$uid.'</uid>'."\r\n";
        $rss .= '<ip>'.$ip.'</ip>'."\r\n";
		$rss .= '</simplog>';

        //echo $rss;

        $postData = "todo=handshake&rss=".rawurlencode($rss);

        $library = new Library();
        $result = $library->getPostToHost("thesimplog.com", "/login/action.php", $postData);

        $parseData = $library->parseHost($result);

        require_once dirname(dirname(__FILE__))."/_lib/simplexml.inc";

        $simplexml = new SimpleXml();

        if (get_magic_quotes_gpc()) 
        {
            $parseData['body'] = stripslashes($parseData['body']);
        }

        $simplexml->setInputString($parseData['body']);
        $simplexml->parse();

        $xmlStruct = $simplexml->getStruct();

        // same id message
        if($uid == trim($xmlStruct['UID']))
        {
            // get result: status
            if(trim($xmlStruct['STATUS']) == "FAIL")
            {
                echo "fail to XLOG";
            }
            else
            {
                // register session for neighbours, blog
                session_start();
                $_SESSION['spg_neigh_user_id'] = trim($xmlStruct['USERID']);
                $_SESSION['spg_neigh_nick'] = trim($xmlStruct['NICK']);
                $_SESSION['spg_neigh_blog'] = trim($xmlStruct['BLOG']);

                //add db
                $this->queryNeighbourBlog();

                // refresh current page                
                require_once dirname(dirname(__FILE__))."/_lib/script.inc";
                $script = new Script();
                $script->refreshPage();
            }
        }
        else
        {
            echo "fail to XLOG";
            die(__FILE__);
        }
    }

    function queryNeighbourBlog()
    {
        session_start();

        $data = new Data();

        $memberData = $data->checkNeighBlog($_SESSION['spg_neigh_user_id']);

        // second visit
        if($memberData['member_no'])
        {
            $data->UpdateNeighBlog($_SESSION['spg_neigh_user_id']);
        }
        // first visit
        else
        {
            $data->addNewNeighBlog($_SESSION);
        }
    }
}
?>