<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005 theSimplog.com                                    |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS <jins@jinsnet.com>                                     |
// | Last Modified date: 09/Dec/2005 14:48                                |
// +----------------------------------------------------------------------+
//
// $Id simplexml.inc$

require_once dirname(__FILE__)."/XML/Parser.php";

class SimpleXml extends XML_Parser
{

    // simlog xml structure
    var $struct = array();

    var $i = 0;

    // TAG name
    var $name;

    function SimpleXml()
    {
        $this->XML_Parser();
    }

    /**
     * handle start element
     *
     * @access private
     * @param  resource  xml parser resource
     * @param  string    name of the element
     * @param  array     attributes
     */
    function startHandler($xp, $name, $attribs)
    {
        $this->struct[$name] = "";
        $this->name = $name;
    }

    /**
     * handle start element
     *
     * @access private
     * @param  resource  xml parser resource
     * @param  string    name of the element
     */
    function endHandler($xp, $name)
    {
        $this->i++;
    }

    /**
     * handle character data
     *
     * @access private
     * @param  resource  xml parser resource
     * @param  string    character data
     */
    function cdataHandler($xp, $cdata)
    {
        $this->struct[$this->name] .= $cdata;
    }

    function defaultHandler($xp, $cdata) 
    {

    }

    function getStruct()
    {
        return $this->struct;
    }
}
?>