<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name The Simplog                                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005                                                   |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// | initial jobs to get RSS and something else                           |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 21/Dec/2005 12:53                                |
// +----------------------------------------------------------------------+
//
// $Id simplog.php$

require_once "init.inc";
require_once "data.inc";
require_once "library.inc";
require_once dirname(dirname(__FILE__))."/_lib/XML/RSS.php";

class SimplogInit
{
    /*
     * object DataBase
     */
    var $data;
    
    /*
     * Array 
     */
    var $adminData2;

    function SimplogInit()
    {
        $this->data = new Data();
        $this->adminData2 = $this->data->getAdminData2();
    }

    function checkServerData()
    {
        $now = time();
        // 3 hours
        $age = 3600 * 3;

        $library = new Library();

        $rss = $library->parseRSSWithCache("http://thesimplog.com/blog/rss.xml", $this->data, $age);
/*
        if(($now - $this->adminData2['admin_notice_from_server']) >= $age)
        {
            $rss = & new XML_RSS("http://thesimplog.com/blog/?mode=rss");
            $rss->parse();
            $item = $rss->getItems();
            $newData['admin_notice_from_server'] = $now;
            $newData['admin_notice_from_server_title'] = $item[0]['title'];
            $newData['admin_notice_from_server_link'] = $item[0]['link'];
            $this->data->updateDataTable($newData);
        }
        */
    }

    function checkSimplogRegister()
    {
        $now = time();
        // 3 hours
        $age = 3600 * 3;

        if($now - $this->adminData2['admin_check_from_server'] >= $age)
        {
            require_once dirname(dirname(__FILE__))."/_lib/simplexml.inc";

            $simplexml = new SimpleXml();
            $library = new Library();

            $blogURL = rawurlencode((SPG_URI)."/".$GLOBALS['n']);

            $sendResult = $library->getHost("thesimplog.com", "/login/action.php?todo=checkreg&blog=".$blogURL);

            // get response from a server with TB type
            $parseData = $library->parseTBResponse($sendResult);

            if (get_magic_quotes_gpc()) 
            {
                $parseData['body'] = stripslashes($parseData['body']);
            }

            $simplexml->setInputString($parseData['body']);
            $simplexml->parse();
            $xmlStruct = $simplexml->getStruct();

            // ok
            if (trim($xmlStruct['ERROR']) == "0")
            {
                $newData['admin_simplog_register'] = 1;
                $newData['admin_check_from_server'] = $now;
                $this->data->updateDataTable($newData);
            }
            else
            {
                $newData['admin_check_from_server'] = $now;
                $this->data->updateDataTable($newData);
            }
        }
    }   // end checkSimplogRegister()

    function checkLinkSites()
    {
        $linkResult = $this->data->getAllLinks();
        $library = new Library();
        // 1 hour
        $age = 1;

        while($linkData = $linkResult->fetchRow())
        {
            if($linkData['link_rss'])
            {
                $rss = $library->parseRSSWithCache($linkData['link_rss'], $this->data, $age);
            }
        }
    }
}
?>