<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2006 theSimplog.com                                    |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 25/Jan/2006 00:30                                |
// +----------------------------------------------------------------------+
//
// $Id linklib.inc$

require_once dirname(dirname(__FILE__))."/_lib/DB.php";
require_once dirname(dirname(__FILE__))."/_linked/link.inc";
require_once dirname(dirname(__FILE__))."/_lib/data.inc";
require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";

function isThereBlog()
{
    $linked = new Linked();
    $linkedData = $linked->getLinkedSetting();
    
    // session start again
    @session_save_path($linkedData['SESLOC']);
    @session_start();

    if(isset($_SESSION[$linkedData['SESSION']]))
    {
        $boardUser = $linked->getBoardUser($_SESSION[$linkedData['SESSION']]);
        $boardid = $boardUser[$linkedData['ID']];
        $simdbcon = connectSimplogDB();

        $query = sprintf("SELECT * FROM ".SPG_PREFIX."_boardlink WHERE board_user_id = '%s'",
            $boardid);
        $result = $simdbcon->getRow($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        if($result['board_user_id'] == $boardid)
            return true;
        else return false;
    }
    else
    {
        return false;
    }
}

function getMyBlog($boardid)
{
    $simdbcon = connectSimplogDB();
    $query = sprintf("SELECT * FROM ".SPG_PREFIX."_boardlink WHERE board_user_id = '%s'",
            $boardid);
    $result = $simdbcon->getRow($query);
    if (DB::isError($result))
    {
        die ($result->getMessage().__FILE__.__LINE__);
    }

    return $result['simplog_user_id'];
}

function printRecentPosts($skinName, $title, $numPost = 10)
{
    $data = new Data();
    $mainview = new Mainview();
    $simUri = $GLOBALS['simplog_url'];

    // get skin file
    $file = dirname(__FILE__)."/skin/".$skinName."/index.html";
    $simdbcon = connectSimplogDB();

    if(substr($simUri, -1) != "/")
        $simUri = $simUri."/";

    if(file_exists($file))
    {
        $skin = file($file);
        $skin = str_replace("./", $simUri.'_linked/skin/'.$skinName.'/', join('', $skin));

        $skin = str_replace('[SIMPLOG::TITLE]', $title, $skin);

        $query = "SELECT p.*, a.nick_name FROM ".SPG_PREFIX."_posts p, ".SPG_PREFIX."_admin a WHERE p.author = a.user_name ORDER BY post_time DESC LIMIT 0, $numPost";
        $result = $simdbcon->query($query);
        if (DB::isError($result))
        {
            die ($result->getMessage().__FILE__.__LINE__);
        }

        preg_match('|<SIMPLOG::LOOP>(.+)</SIMPLOG::LOOP>|s', $skin, $contents);

        $printContents = "";
        while($allData = $result->fetchRow())
        {
            $contents2 = $contents[1];
            // 변수 치환
            preg_match("/\[SIMPLOG::BLOGNAME=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::BLOGNAME=\"([0-9]+)\"\]/", $mainview->strCut($allData['blog_name'], $cut[1]), $contents2);
            preg_match("/\[SIMPLOG::SUBJECT=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::SUBJECT=\"([0-9]+)\"\]/", '<a href="'.$simUri.$allData['user_name'].'/?post='.$allData['no'].'">'.$mainview->strCut($allData['subject'], $cut[1]).'</a>', $contents2);
            preg_match("/\[SIMPLOG::NAME=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::NAME=\"([0-9]+)\"\]/", $mainview->strCut($allData['nick_name'], $cut[1]), $contents2);
            preg_match("/\[SIMPLOG::CATEGORY=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::CATEGORY=\"([0-9]+)\"\]/", $mainview->strCut($allData['category_name'], $cut[1]), $contents2);

            preg_match("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", date($cut[1], $allData['post_time']), $contents2);

            $printContents .= $contents2;
        }
        $skin = preg_replace('|<SIMPLOG::LOOP>(.+)</SIMPLOG::LOOP>|s', $printContents, $skin);

        echo $skin;
    }
    else
    {
        echo "스킨 경로 설정이 잘못 되었습니다.";
    }
}

function printRecentBlogs($skinName, $title, $numBlog = 10)
{
    $data = new Data();
    $mainview = new Mainview();
    $simUri = $GLOBALS['simplog_url'];

    // get skin file
    $file = dirname(__FILE__)."/skin/".$skinName."/index.html";
    $simdbcon = connectSimplogDB();

    if(substr($simUri, -1) != "/")
        $simUri = $simUri."/";

    if(file_exists($file))
    {
        $skin = file($file);
        $skin = str_replace("./", $simUri.'_linked/skin/'.$skinName.'/', join('', $skin));

        $skin = str_replace('[SIMPLOG::TITLE]', $title, $skin);

        $query = "SELECT * FROM ".SPG_PREFIX."_admin WHERE is_use = 1 ORDER BY reg_date DESC";
        $adminResult = $simdbcon->query($query);
        if (DB::isError($adminResult))
        {
            die ($adminResult->getMessage().__FILE__.__LINE__);
        }

        preg_match('|<SIMPLOG::LOOP>(.+)</SIMPLOG::LOOP>|s', $skin, $contents);

        $printContents = "";
        while($allData = $adminResult->fetchRow())
        {
            $contents2 = $contents[1];
            // 변수 치환
            $contents2 = preg_replace("/\[SIMPLOG::BLOGURL\]/", $simUri.$allData['user_name'], $contents2);
            preg_match("/\[SIMPLOG::BLOGNAME=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::BLOGNAME=\"([0-9]+)\"\]/", '<a href="'.$simUri.$allData['user_name'].'">'.$mainview->strCut($allData['blog_name'], $cut[1]).'</a>', $contents2);
            preg_match("/\[SIMPLOG::BLOGDESC=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::BLOGDESC=\"([0-9]+)\"\]/", $mainview->strCut($allData['blog_desc'], $cut[1]), $contents2);
            preg_match("/\[SIMPLOG::NAME=\"([0-9]+)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::NAME=\"([0-9]+)\"\]/", $mainview->strCut($allData['nick_name'], $cut[1]), $contents2);
            preg_match("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", $contents2, $cut);
            $contents2 = preg_replace("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", date($cut[1], strtotime ($allData['reg_date'])), $contents2);
            // blog banner
            $adminData2 = getAdminData2($allData['user_name']);
            if($allData['banner1'] && $adminData2['admin_defaultbanner'] == "banner1")
            {
                $banner = $simUri.$allData['user_name'].'/'.$allData['banner1'];
            }
            else if($allData['banner2'] && $adminData2['admin_defaultbanner'] == "banner2")
            {
                $banner = $simUri.$allData['user_name'].'/'.$allData['banner2'];
            }
            else
            {
                $banner = $simUri.'_linked/skin/'.$skinName."/images/noimage.gif";
            }
            $contents2 = preg_replace("/\[SIMPLOG::BANNER\]/", $banner, $contents2);

            $printContents .= $contents2;
        }
        $skin = preg_replace('|<SIMPLOG::LOOP>(.+)</SIMPLOG::LOOP>|s', $printContents, $skin);

        echo $skin;
    }
    else
    {
        echo "스킨 경로 설정이 잘못 되었습니다.";
    }

}


function printRecentPosts_euckr($skinName, $title, $numPost = 10)
{   
    ob_start();
    if(function_exists("mb_convert_encoding"))
        $title = mb_convert_encoding($title, "utf-8", "euc-kr");    
    else if(function_exists("iconv"))
        $title = iconv("euc-kr", "utf-8", $title);

    printRecentPosts($skinName, $title, $numPost);
    $out = ob_get_contents();
    ob_end_clean();

    if(function_exists("mb_convert_encoding"))
        echo mb_convert_encoding($out, "euc-kr", "utf-8");    
    else if(function_exists("iconv"))
        echo iconv("utf-8", "euc-kr", $out);
    else    echo "Please install mb_string or iconv";
}

function printRecentBlogs_euckr($skinName, $title, $numPost = 10)
{   
    ob_start();
    if(function_exists("mb_convert_encoding"))
        $title = mb_convert_encoding($title, "utf-8", "euc-kr");    
    else if(function_exists("iconv"))
        $title = iconv("euc-kr", "utf-8", $title);

    printRecentBlogs($skinName, $title, $numPost);
    $out = ob_get_contents();
    ob_end_clean();

    if(function_exists("mb_convert_encoding"))
        echo mb_convert_encoding($out, "euc-kr", "utf-8");    
    else if(function_exists("iconv"))
        echo iconv("utf-8", "euc-kr", $out);
    else    echo "Please install mb_string or iconv";
}



//**** Library *****//

function connectSimplogDB()
{
    require_once dirname(dirname(__FILE__))."/_lib/setup.inc";

    $setup = new Setup();
    $GSetup = $setup->getGlobalSetting();
    define("SPG_PREFIX", "spg_".$GSetup['PREFIX']);

    $dsn = "mysql://".$GSetup['DBUSER'].":".$GSetup['DBPASS']."@".$GSetup['DBHOST']."/".$GSetup['DBNAME'];

    $simdbcon = DB::connect($dsn);
    if (DB::isError($simdbcon)) 
    {
        die ($simdbcon->getMessage());
    }
    $simdbcon->setFetchMode(DB_FETCHMODE_ASSOC);

    return $simdbcon;
}

function getAdminData2($n)
{
    $simdbcon = connectSimplogDB();

    $query = 
        "SELECT name, value".
        " FROM ".SPG_PREFIX."_data".
        " WHERE user_name='".$n."'";

    $adminData = $simdbcon->getAssoc($query);
    
    if (DB::isError($adminData))
    {
        die ($adminData->getMessage());
    }

    return $adminData;
}

?>