<?php
/* vim: set expandtab tabstop=4  shiftwidth=4 */
// +----------------------------------------------------------------------+
// | Program Name version                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2005-2006 theSimplog.com                               |
// +----------------------------------------------------------------------+
// | File Description                                                     |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Change History                                                       |
// |                                                                      |
// |                                                                      |
// +----------------------------------------------------------------------+
// | Authors: JinS                                                        |
// | Last Modified date: 03/Feb/2006 22:51                                |
// +----------------------------------------------------------------------+
//
// $Id skin.inc$

class Skin
{
    var $header;
    var $list;
    var $footer;

    var $totalNum;
    var $numPPage;
    var $noPageNum = 0;

    var $level;

    var $queryArray = array();

    var $skinSetup = array();

    function Skin()
    {
        // get skin name by bbs_name
        $skinName = $this->getSkinName();

        define("SPG_SKIN_DIR", SPG_ROOT."/_skin/".$skinName);
        define("SPG_SKIN_CACHE_DIR", SPG_ROOT."/_cache/".$skinName);
    }

    /****************
     *  Actual Printing here
    **/
    function printBlog()
    {
        global $mode, $arr;       

        require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";

        // for g4
        global $config, $member, $g4, $urlencode, $is_admin;        

        $data = new Data();
        $library = new Library();
        $mainview = new Mainview();

        // start time
        $STARTTIME = $library->getMicroTime();

        // get page number
        $nowPage = $_GET['p'];

        //get querystring 
        $queryString = $_SERVER['QUERY_STRING'];
        parse_str($queryString, $this->queryArray);

        // file does not exist
        if(!file_exists(SPG_SKIN_CACHE_DIR."/main_header.php"))
        {
            $this->_applyTemplate();
        }
        // or index.html has modified
        else if(filemtime(SPG_SKIN_CACHE_DIR."/main_header.php") < filemtime(SPG_SKIN_DIR."/index.html"))
        {
            $this->_applyTemplate();
        }
        // or if skin.inc file is changed then applyTemplate
        else if(filemtime(SPG_SKIN_CACHE_DIR."/main_header.php") < filemtime(dirname(dirname(__FILE__))."/_lib/skin.inc"))
        {
            $this->_applyTemplate();            
        }

        // admin configuration data
        $adminData = $data->getAdminData($GLOBALS['n']);
        $adminData2 = $data->getAdminData2();
        
        session_start();
        $this->level = $this->checkLevel($_SESSION);

        // print list of posts
        if($mode == "list")
        {            
            $list = "y";
            array_shift ($arr);
            $mode = $arr[1];

            // if tag list then just show tag cloud
            if($mode == "tag" && !$arr[2])
                goToPage(SPG_URI."/".$GLOBALS['n']."/index.php/tag");
        }
        
        if(isset($list) && $list == "y")
            $isList = 1;
        else
            $isList = 0;

        //get number of post per page
        $isList ? $this->numPPage = 20 : $this->numPPage = $adminData['post_p_page'];

        // permanent link
        if($mode == "post") $post = $arr[2];
        if($_GET['post']) $post = $_GET['post'];
        if($post)
        {
            $no = $post;
            // permanent link
            $this->queryArray['mode'] = 'perm';
            $this->numPPage = 1;
            $nowPage = $data->getItemsPosition($no, $this->level);

            // show comments
            require_once dirname(dirname(__FILE__))."/_lib/action.inc";
            $action = new Action();

            global $m, $num, $where, $chile, $seq, $page;
            $m = "comment";
            $num = $no;
            $where = "pcomment_".$no;           
            $commentData = $action->printContents($m, $num, 'n');
        }
        else if ($mode == "guest")
        {
            $this->numPPage = $adminData2['admin_guest_num'];
            if(!$this->numPPage)
                $this->numPPage = 1;
        }
        
        if($mode == "date")
        {            
            $durat = "";

            if($arr[2])
            {
                $year = $arr[2];
                $durat = "y1";
            }
            else $year = "00";

            if($arr[3])
            {
                $month = $arr[3];
                $durat = "m1";
            }
            else $month = "00";

            if($arr[4])
            {
                $day = $arr[4];
                $durat = "d1";
            }
            else $day = "00";
        }

        // get start point of posts
        $start = $mainview->getStartNumOfPage($nowPage, $this->numPPage);

        // get item according to level, page number and its function
        if($no)
        {
            $res = $data->getItemsByNo($no, $this->level);
            //get total number 
            $this->totalNum = $data->getTotalNumPostsByUserLevel($this->level); 
        }
        else if($year)
        {
            $res = $data->getItemsByDate($year, $month, $day, $durat, $start, $this->numPPage, $this->level);
            //get total number
            $totalP = $data->getItemsByDate($year, $month, $day, $durat, "0", "0", $this->level);
            $this->totalNum = $totalP->numRows();
        }
        else if($mode == "search")
        {
            if($arr[2]) $key = $arr[2];

            $res = $data->getItemsByKey($start, $this->numPPage, $this->level, $key);

            //get total number 
            $this->totalNum = $data->getTotalItemsByKey($this->level, $key);
        }
        else if(isset($_GET['key']))
        {
            if($_GET['key']) $key = $_GET['key'];

            $res = $data->getItemsByKey($start, $this->numPPage, $this->level, $key);

            //get total number 
            $this->totalNum = $data->getTotalItemsByKey($this->level, $key);
        }
        else if($mode == "guest")
        {
            $this->totalNum = $data->getTotalTopGuest();
        }
        else if($mode == "tag")
        {
            if($mode == "tag") $tag = $arr[2];

            if(!$tag)
            {
                $isList = 0;
                $this->noPageNum = 1;
            }

            if($tag)
            {
                $res = $data->getItemsByTag($start, $this->numPPage, $this->level, $tag);
                //get total number 
                $this->totalNum = $data->getNumberItemsByTag($this->level, $tag); 
            }
        }
        else 
        {
            if($mode == "category") $cate = $arr[2];
            $res = $data->getItems($start, $this->numPPage, $this->level, $cate);
            //get total number 
            $this->totalNum = $data->getTotalNumPostsByUserLevel($this->level, $cate); 
        }

        //get total page number
        $totalPage = ceil($this->totalNum / $this->numPPage);

        // page number adjust
        if($nowPage >= $totalPage) $nowPage = $totalPage;
        if($nowPage <= 0) $nowPage = 1;

        // data generate

        $this->getSkinSetup();

        // end time
        $ENDTIME = $library->getMicroTime(); 

        /************** actual printing  ******************/
        // send document type and encoding charset
        @header('Content-type: text/html; charset=UTF-8');

        //print_r($_SESSION);
        // header file printing
        include SPG_SKIN_CACHE_DIR."/main_header.php";

        if($mode == "guest")
        {
            // print guest book
        }
        else if($mode == "tag" && !$tag)
        {
            // print tag book
        }
        else if(!$isList)
        {
            while($data = $res->fetchRow())
            {
                include SPG_SKIN_CACHE_DIR."/main_item.php";
            }
        }               

        //footer printing
        include SPG_SKIN_CACHE_DIR."/main_footer.php";

        if(isset($_SESSION['spg_user_name']) && $_SESSION['spg_user_name'] == $GLOBALS['n'])
            echo '<!-- Process time: '.($ENDTIME-$STARTTIME).'-->';
    }

    function printLicence()
    {
        echo "\n<!--/////////////////////////////////////////////////////////////////";
        echo "\n     The Simplog v0.7.1.5 OR (http://thesimplog.com)   ";
        echo "\n///////////////////////////////////////////////////////////////////-->\n";
    }

    /**
     * getSkinSetup()
     * : get skin's value
    **/
    function getSkinSetup()
    {
        if(file_exists(SPG_SKIN_DIR."/setup.php"))
        {
            include SPG_SKIN_DIR."/setup.php";
            $this->skinSetup = $skinSetup;
        }

        return $skinSetup;        
    }

    /**
     * printGuest()
     * : print guest book
    **/
    function printGuest()
    {
        echo "<form name='frm_com_0' action='' method='post'><input type='hidden' name='comment_0' id='comment_0' value='0' /></form><div id='pcomment_0' style='display:none'></div>";
    }

    /**
     * printCategory()
    **/
    function printCategory()
    {
        $data = new Data();
        $result = $data->getCategoryInfo("OPEN");
        $adminData2 = $data->getAdminData2();
        if($adminData2['admin_cate_show_num'])
        {
            $numPost = $data->getNumPostByCate($this->level);
            $numTotal = array_sum($numPost);
        }

        include SPG_ROOT."/_skin/_default_/category.html";
    }

    function getPostNum($num)
    {
        if(!$num) $num = 0;
        return $num;
    }

    /**
     * printCateName()
    **/
    function printCateName($name)
    {
        $library = new Library();
        $name = $library->simHtmlentities($name);
        echo $name;
    }

    /**
     * printTitle()
    **/
    function printTitle($data)
    {
        $library = new Library();
        //some validate process here to add
        $data['subject'] = $library->simHtmlentities($data['subject']);
        $title = '<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/post/'.$data['no'].'" class="POSTTITLE">'.$data['subject'].'</a>';

        return $title;
    }

    /**
     * printName()
    **/
    function printName($data)
    {
        $dataDB = new Data();
        $library = new Library();
        if(!$data['author'])
            $adminData = $dataDB->getAdminData($GLOBALS['n']);
        else
            $adminData = $dataDB->getAdminData($data['author']);
        $name = $library->simHtmlentities($adminData['nick_name']);
        //some validate process here to add

        return $name;
    }

    /**
     * printContents()
    **/
    function printContents($data)
    {
        $library = new Library();
        $mainview = new Mainview();
        $postData = $_POST;

        $contents = $data['contents'];

        // get multimedia file
        $contents = $mainview->spgml2html($contents);
        $contents = $library->getXhtml($contents);

        return $contents;
    }

    /**
     * printNewPostList()
    **/
    function printNewPostList($adminData)
    {
        $data = new Data();
        $mainview = new Mainview();

        $result = $data->getNewPostList($this->level);

        while($posts = $result->fetchRow())
        {
            include SPG_SKIN_CACHE_DIR."/newpost.php";
        }
    }   

    /**
     * checkLevel()
     * :check level against db and return its level
     * @param $session : SESSION value 
     * $return int $level : level number
    **/
    function checkLevel($session)
    {
        $data = new Data();

        // level 3 => everyone
        // 2 => closer
        // 1 => more closer
        if($session['spg_neigh_user_id'])
        {
            $neighData = $data->checkNeighBlog($session['spg_neigh_user_id']);
            if($neighData['relationship'])
            {
                if($neighData['relationship'] == 9)
                    $level = 3;
                else
                    $level = $neighData['relationship'];
            }
            else
            {
                $level = 3;
            }
        }
        else
        {
            $level = 3;
        }

        // for administrator
        if($session['spg_user_name'] && ($session['spg_user_name'] == $GLOBALS['n']))
        {
            $level = 0;
        }

        // for super admin  
        if($session['spg_level'] && ($session['spg_level'] == 1))
        {
            $level = 0;
        }

        return $level;
    }

    /**
     * printNewCommentList()
    **/
    function printNewCommentList($adminData)
    {
        $data = new Data();
        $mainview = new Mainview();

        $result = $data->getNewCommentList($this->level);

        while($comment = $result->fetchRow())
        {
            include SPG_SKIN_CACHE_DIR."/newcomment.php";
        }
    }

    /**
     *
    **/
    function printArchiveList($adminData)
    {
        $data = new Data();

        $result = $data->getArchive($this->level);

        $i = 0;
        $num = $adminData['use_archive_list'];

        while ($archive = $result->fetchRow())
        {
            $name_month=date("F", mktime(1,1,1,$archive[month]));
            
            if($i >= $num)
            {
                if($i == $num)	echo "<div align=center id='arch_more'><span style='cursor:hand' onclick=\"toggle('arch_more', 'archive');\">...more</span></div><div id='archive' style='margin:0px; display:none;'>";
                
                echo "<a href='".SPG_URI."/".$GLOBALS['n']."/index.php/list/date/".$archive['year']."/".$archive['month']."'>".$archive['year']." ".$name_month." (".$archive['num'].")</a>";
                echo "<br />";

            }
            else
            {
                echo "<a href='".SPG_URI."/".$GLOBALS['n']."/index.php/list/date/".$archive['year']."/".$archive['month']."'>".$archive['year']." ".$name_month." (".$archive['num'].")</a>";
                echo "<br />";
            }
            $i++;
        }

        if ($i > $num)	echo "</div>";
    }

    function printLink($adminData)
    {
        $data = new Data();
        $library = new Library();

        $result = $data->getLinksGroups();

        while($gData = $result->fetchRow())
        {
            if($gData['visible'] == "1" && $gData['num_links'] > 0)
            {
                $lResult = $data->getLinksListByGroup($gData['group_no']);

                include SPG_SKIN_CACHE_DIR."/linksites.php";
            }
        }
    }

    /**
     * printNewTBList()
    **/
    function printNewTBList($adminData)
    {
        $data = new Data();
        $mainview = new Mainview();

        $result = $data->getNewTBList($this->level);

        while($tb = $result->fetchRow())
        {
            include SPG_SKIN_CACHE_DIR."/trackback.php";
        }
    }


    /**
     * printDate()
    **/
    function printDate($format, $time)
    {
        echo date($format, $time);
    }

    function printNowIam($imageSize, $adminData)
    {
        $size = explode(",", $imageSize);

        $data = new Data();
        $library = new Library();
        $mainview = new Mainview();

        $result = $data->getItems(0, 1, $this->level, $adminData['nowiamcate']);

        $nowIamData = $result->fetchRow();

        if($nowIamData['no'])
        {
            // get url of the first image
            $nowIamData['contents'] = $mainview->spgml2html($nowIamData['contents']);
            $imgSRC = $library->getImage($nowIamData['contents']);
            $subject = strip_tags($nowIamData['subject']);

            if($imgSRC['src'])
            {
                echo sprintf('<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/post/%s"><img src="%s" width="%s" border="0" alt="nowiam" /></a><br /><br />', $nowIamData['no'], $imgSRC['src'], $size[0]);
            }

            if($size[1])
                echo sprintf('<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/post/%s">%s</a>', $nowIamData['no'], $mainview->strCut($subject, $size[1]));
            else    echo sprintf('<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/post/%s">%s</a>', $nowIamData['no'], $subject);
        }
    }

    function printNowIAmTitle($adminData2)
    {
        echo $adminData2['admin_nowiam_title'];
    }

    function printComment($data, $commentData = "")
    {
        echo "<form name='frm_com_".$data['no']."' action=''><input type='hidden' name='comment_".$data['no']."' id='comment_".$data['no']."' value='0' /><input type='hidden' name='tb_".$data['no']."' id='tb_".$data['no']."' value='0' /></form>";
        if($commentData)
            echo "<div id='pcomment_".$data['no']."' style='display:block'>".$commentData."</div>";
        else
            echo "<div id='pcomment_".$data['no']."' style='display:none'></div>";
    }  

    function printReplyComment($comment)
    {
        if($comment['is_secret'] == "3")
        {
            $linkTag = "<!-- ";
        }
        else
        {
            if($GLOBALS['m'] == "guest")
                $linkTag = sprintf('<a href="#rcom" class="RGUEST" onclick=\'viewGuestAction("%s", "frm_com_%s.comment_%s", "replyguest", "pcomment_%s", "%s", "%s", "%s", "%s");\'>',
            $GLOBALS['n'], $GLOBALS['num'], $GLOBALS['num'], $GLOBALS['num'], $GLOBALS['num'], $comment['no'], $comment['seq'], $GLOBALS['page']);
            else
                $linkTag = sprintf('<a href="#rcom" class="RCOM" onclick=\'viewCommentAction("%s", "frm_com_%s.comment_%s", "replycomment", "pcomment_%s", "%s", "%s", "%s");\'>',
            $GLOBALS['n'], $GLOBALS['num'], $GLOBALS['num'], $GLOBALS['num'], $GLOBALS['num'], $comment['no'], $comment['seq']);
        }

        $tag = $linkTag;
        echo $tag;
    }

    function printModifyComment($comment)
    {
        if($comment['is_secret'] == "3" || $comment['is_secret'] == "1")
        {
            $linkTag = "<!-- ";
        }
        else
        {
            if($GLOBALS['m'] == "guest")
                $linkTag = sprintf('<a href="#mcom" class="MGUEST" onclick=\'viewGuestAction("%s", "frm_com_%s.comment_%s", "modifyguest", "pcomment_%s", "%s", "%s", "%s", "%s");\'>', 
            $GLOBALS['n'], $GLOBALS['num'], $GLOBALS['num'], $GLOBALS['num'], $GLOBALS['num'], $comment['no'], $comment['seq'], $_GET['page']);
            else
                $linkTag = sprintf('<a href="#mcom" class="MCOM" onclick=\'viewCommentAction("%s", "frm_com_%s.comment_%s", "modifycomment", "pcomment_%s", "%s", "%s", "%s");\'>', 
            $GLOBALS['n'], $GLOBALS['num'], $GLOBALS['num'], $GLOBALS['num'], $GLOBALS['num'], $comment['no'], $comment['seq']);
        }

        $tag = $linkTag;
        echo $tag;
    }
    
    function printDeleteComment($comment)
    {
        if($comment['is_secret'] == "3")
        {
            $linkTag = "<!-- ";
        }
        else
        {
            if($GLOBALS['m'] == "guest")
                $linkTag = sprintf('<a href="#dcom" class="DGUEST" onclick="popupDelCom(\''.SPG_URI.'/_skin/_default_/ask_pass.html?mode=guest&amp;n=%s&amp;no=%s&amp;num=%s&amp;child=%s&amp;p=%s\');">', $GLOBALS['n'], $comment['no'], $GLOBALS['num'], $comment['child_no'], $GLOBALS['page']);
            else
                $linkTag = sprintf('<a href="#dcom" class="DCOM" onclick="popupDelCom(\''.SPG_URI.'/_skin/_default_/ask_pass.html?mode=comment&amp;n=%s&amp;no=%s&amp;num=%s&amp;child=%s\');">', $GLOBALS['n'], $comment['no'], $GLOBALS['num'], $comment['child_no']);
        }

        $tag = $linkTag;
        echo $tag;
    }

    function printCommentButtonEnd($comment)
    {
        if($comment['is_secret'] == "3")
            echo " -->";
        else    echo "</a>";
    }

    function printCommentModifyButtonEnd($comment)
    {
        if($comment['is_secret'] == "3" || $comment['is_secret'] == "1")
            echo " -->";
        else    echo "</a>";
    }

    function printCrossChecking()
    {
        require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";
        $mainView = new Mainview();

        // print simplog version infomation in the source
        $this->printLicence();

        if(!session_id()) session_start();
        echo sprintf('
        <script language="JavaScript" type="text/javascript" src="'.SPG_URI.'/_lib/javascript.php?script=%s"></script>',
        $GLOBALS['n']);

        // if a visior has been here before
        if(!isset($_SESSION['spg_neigh_user_id']))
        {            
            echo sprintf('<iframe src="http://thesimplog.com/login/action.php?todo=checking&amp;who=%s/" style="width:0; height:0;" frameborder="0" scrolling="no" ></iframe>',
            SPG_URI."/".$GLOBALS['n']);
        }

        if(($_SESSION['spg_user_name'] == $mainView->getOwnerByBlog($GLOBALS['n'])) || isset($_SESSION['spg_neigh_user_id']))
        {
            // get message box script
            echo '
            <script language="JavaScript" type="text/javascript" src="'.SPG_URI.'/_lib/msgnotice.php"></script>
            ';

            $data = new Data();

            if($_SESSION['spg_user_name'] == $mainView->getOwnerByBlog($GLOBALS['n']))
            {
                $result = $data->getUsers(9, 0, 0);
                $numJoin = $result->numRows();
                $msg = sprintf($GLOBALS['lang']['main']['rootnotice'], $numJoin);
            }
            else
            {                
                $nData = $data->checkNeighBlog($_SESSION['spg_neigh_user_id']);            

                // generate message according to a visitor
                if($nData['num_visit'] > 2)
                {
                    // a visitor is neighbour
                    if($nData['relationship'] < 3)
                        $msg = $GLOBALS['lang']['main']['notice3'];
                    else if($nData['relationship'] == 3 && $nData['num_visit'] > 2)
                        $msg = $GLOBALS['lang']['main']['notice2'];
                    else if($nData['relationship'] == 9)
                        $msg = $GLOBALS['lang']['main']['notice4'];
                }
                else
                {
                    $msg = $GLOBALS['lang']['main']['notice1'];
                }

                $msg = $_SESSION['spg_neigh_nick'].$msg;
            }

                if($_COOKIE['noticeclose'] != 1)
                {
            // print message layer
?>
<!-- notice start -->
<div id="spg_message"  style="position:absolute; left:0px; top:-220px; width:200px; z-index:1;background-color:yellow;border:dashed 1px black;padding:10px">
  <table width="100%"  border="0" cellpadding="0" cellspacing="0">
    <tr>
      <td height="20"><table width="100%"  border="0" cellpadding="0" cellspacing="0">
        <tr style="font-size: 12px;font-weight:bold;">
          <td><img src="<?=SPG_URI?>/_skin/_default_/images/notice.gif" width="16" height="16" align="middle" alt="notice" /><?php echo $GLOBALS['lang']['main']['noticetitle1'];?> </td>
          <td width="21" align="right"><a href="#close" onclick="closeMsgNotice();">[X]</a></td>
        </tr>
      </table></td>
    </tr>
    <tr>
      <td align="center"><?php echo $msg;?></td>
    </tr>
  </table>
</div>
<!-- notice end -->
<?php
                }
        }   // end else

    }   // end function

    function printEnd()
    {
        global $mode;

        echo sprintf('<iframe name="action_window" src="about:blank" style="width:0; height:0;" frameborder="0" scrolling="no"></iframe>');

        if(!session_id()) session_start();
        if($_COOKIE['noticeclose'] != 1)
        {
            if(isset($_SESSION['spg_neigh_user_id']) || ($_SESSION['spg_user_name'] == $GLOBALS['n']))
                echo "<script language='javascript' type='text/javascript'>letsMove();</script>";
        }

        require_once dirname(dirname(__FILE__))."/_lib/script.inc";
        $script = new Script();

        //if($_GET['post'])    $script->showComment($_GET['post']);
        if($mode == "guest") $script->showGuest($_GET['p']);

        // initial jobs
        echo '<script language="JavaScript" type="text/javascript" src="'.SPG_URI.'/_lib/httpd.js"></script>';
        echo '<script language="JavaScript" type="text/javascript" src="'.SPG_URI.'/_lib/ajax_go.js"></script>';
        echo '<script language="JavaScript" type="text/javascript">do_initial();</script>';


    /**
        if($this->skinSetup['image_resize'])
            $script->imgResize($this->skinSetup['image_resize']);
    **/
    }

    function printHead($adminData)
    {
        // print calendar style sheet
        echo '<link href="'.SPG_URI.'/_skin/_calendar_/'.$adminData['cal_name'].'/cal.css" rel="stylesheet" type="text/css" />';
    }

    function printPostWriteButton($data)
    {
        require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";
        $mainView = new Mainview();

        $data = stripslashes($data);
        if(!session_id()) session_start();
        if($_SESSION['spg_level'] >= 1 && $_SESSION['spg_user_name'] == $mainView->getOwnerByBlog($GLOBALS['n']))
        {
            echo sprintf('<a href="'.SPG_URI.'/_admin/start.php?n=%s&amp;mode=write" class="POSTWRITE">%s</a>',$GLOBALS['n'], $data);
        }
    }

    function printXLoginButton($data)
    {
        $data = stripslashes($data);
        if(!session_id()) session_start();
        if(!isset($_SESSION['spg_neigh_user_id']))
        {
            echo '<a href="#xin" onclick="javascript:simploginOpenWin(\'?mode=xinopen\');" class="XIN">'.$data.'</a>';
        }
    }

    function printAdminLoginButton($data)
    {
        $data = stripslashes($data);
        if(!session_id()) session_start();
        echo sprintf('<a href="'.SPG_URI.'/_admin/start.php?n=%s&amp;mode=list" class="ADMININ">%s</a>',
            $GLOBALS['n'], $data);
    }

    function printJoinButton($data)
    {
        $data = stripslashes($data);

        $sqlData = new Data();
        if(!session_id()) session_start();
        if(isset($_SESSION['spg_neigh_user_id']))
        {
            $nData = $sqlData->checkNeighBlog($_SESSION['spg_neigh_user_id']);
            
            if($nData['relationship'] == 3)
            {
                echo '<a href="#join" class="JOIN" onclick="javascript:simploginOpenWin(\''.SPG_URI.'/'.$GLOBALS['n'].'/index.php?mode=join\');">'.$data.'</a>';
            }
        }
    }

    function printAdminLogoutButton()
    {
        require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";
        $mainView = new Mainview();

        if(!session_id()) session_start();
        if(isset($_SESSION['spg_user_name']) && $_SESSION['spg_user_name'] == $mainView->getOwnerByBlog($GLOBALS['n']))
        {
            echo '<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/logout" class="ADMINOUT">';
        }
    }

    function isAdmin()
    {
        require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";
        $mainView = new Mainview();

        if(!session_id()) session_start();
        if(isset($_SESSION['spg_user_name']) && $_SESSION['spg_user_name'] == $mainView->getOwnerByBlog($GLOBALS['n']))
            return true;
        else
            return false;
    }

    function printAdminLogoutButtonEnd()
    {
        require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";
        $mainView = new Mainview();

        if(!session_id()) session_start();
        if(isset($_SESSION['spg_user_name']) && $_SESSION['spg_user_name'] == $mainView->getOwnerByBlog($GLOBALS['n']))
        {
            echo '</a>';
        }
    }


    function printCalendar($cal)
    {
        global $mode, $arr;

        require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";

        $mainView = new Mainview();
        $mainView->printCal($cal);
    }

    function printMonth($month)
    {
        require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";

        $mainView = new Mainview();
        $mainView->printMonth($month);
    }

    function printPrepageButton($button, $nowPage)
    {
        if(!$this->noPageNum)
        {
            $library = new Library();
            $p = $nowPage - 1;
            if($p <= 0 ) $p = 1;

            $this->queryArray['p'] = $p;
            $queryString = $library->queryToStr($this->queryArray);

            echo '<a href="'.$queryString.'">'.$button.'</a>';
        }
    }   

    function printPageNumber($thisPage)
    {
        if(!$this->noPageNum)
        {
            $data = new Data();
            //get configuration data
            $confData = $data->getAdminData($GLOBALS['n']);

            require_once dirname(dirname(__FILE__))."/_lib/mainview.inc";
            $mainview = new Mainview();

            $mainview->printPageNum($this->totalNum, $this->numPPage, $this->queryArray, $confData['num_page'], $thisPage);
        }
    }

    function printNextpageButton($button, $nowPage)
    {
        if(!$this->noPageNum)
        {
            $library = new Library();
            $totalPage = ceil($this->totalNum / $this->numPPage);

            if($nowPage)
                $p = $nowPage;
            else $p = 1;

            $p = $p + 1;
            if($p >= $totalPage ) $p = $totalPage;

            $this->queryArray['p'] = $p;
            $queryString = $library->queryToStr($this->queryArray);

            $next = '<a href="'.$queryString.'">'.$button.'</a>';
            echo $next;
        }
    }

    function printItemList($res)
    {
        $mainview = new Mainview();
        while($data = $res->fetchRow())
        {
            include SPG_SKIN_CACHE_DIR."/itemlist.php";
        }
    }

    function printFiles($layout, $postNo)
    {
        $data = new Data();
        $mainview = new Mainview();
        $res = $data->getFileByPostNo($postNo);

        $out = "";

        while($fData = $res->fetchRow())
        {
            $out = str_replace('[SIMPLOG::FILENAME]', $mainview->printFileName($fData), $layout);
            $out = str_replace('[SIMPLOG::FILESIZE]', $mainview->printFileSize($fData['file_size']), $out);

            echo $out;
        }
    }

    function printCount($what)
    {
        $data = new Data();

        switch($what)
        {
            case "-1":  // yesterday
                $yester = $data->getCountYesterday();
                if($yester['total_count'])
                    echo $yester['total_count'];
                else echo "0";
                break;
            case "0":   //today
                $today = $data->getCountToday();
                if($today['total'])
                    echo $today['total'];
                else echo "0";
                break;
            case "1": //total
                $total = $data->getCountTotal();
                echo $total;
                break;
        }
    }

    /**
     * printModifyBtn()
     * print modify button
     *
     * @access public
     * @return void
    **/
    function printModifyBtn($text, $no)
    {
        if(isset($_SESSION['spg_user_name']) && $_SESSION['spg_user_name'] == $GLOBALS['n'])
        {
            printf('<a href="'.SPG_URI.'/_admin/start.php?n=%s&amp;mode=modify&amp;post=%s" class="MODIFY">', 
                $GLOBALS['n'], $no);
            echo stripslashes($text);
            echo "</a>";
        }
    }

    /**
     * printDeleteBtn()
     * print delete button
     *
     * @access public
     * @return void
    **/
    function printDeleteBtn($text, $no)
    {
        if(isset($_SESSION['spg_user_name']) && $_SESSION['spg_user_name'] == $GLOBALS['n'])
        {
            printf('<a href="#d" onclick="confirmDelPost(\'%s\', \'%s\');">', 
                $GLOBALS['n'], $no);
            echo stripslashes($text);
            echo "</a>";
        }
    }

    function getBannerSrc($num)
    {
        $data = new Data();
        $adminData = $data->getAdminData($GLOBALS['n']);
        
        $src = SPG_URI."/".$GLOBALS['n']."/".$adminData['banner'.$num];
        echo $src;
    }

    function getAdditionalBannerSrc($num)
    {
        $data = new Data();
        $adminData2 = $data->getAdminData2($GLOBALS['n']);
        
        $src = SPG_URI."/".$GLOBALS['n']."/".$adminData2['admin_additionalbanner'.$num];
        echo $src;
    }

    function getBannerSize($num, $what="width")
    {
        $data = new Data();
        if($num <= 2)
        {
            $adminData = $data->getAdminData($GLOBALS['n']);
            $path = SPG_ROOT."/".$GLOBALS['n']."/".$adminData['banner'.$num];
            $size = getimagesize($path);
        }
        else
        {
            $addnum = $num - 2;
            $adminData2 = $data->getAdminData2($GLOBALS['n']);
            $path = SPG_ROOT."/".$GLOBALS['n']."/".$adminData2['admin_additionalbanner'.$addnum];
            $size = getimagesize($path);
        }

        if($what == "width")
            echo $size[0];
        else echo $size[1];
    }

    function bannerExists($num)
    {
        $data = new Data();
        $adminData = $data->getAdminData($GLOBALS['n']);

        $path = SPG_ROOT."/".$GLOBALS['n']."/".$adminData['banner'.$num];

        if(file_exists($path) && $adminData['banner'.$num])
            return true;
        else return false;
    }

    function bannerExists2($num)
    {
        $data = new Data();
        $adminData2 = $data->getAdminData2($GLOBALS['n']);

        $path = SPG_ROOT."/".$GLOBALS['n']."/".$adminData2['admin_additionalbanner'.$num];

        if(file_exists($path) && $adminData2['admin_additionalbanner'.$num])
            return true;
        else return false;
    }


    /**
     * applyTemplate()
     * converts the design file to the actual skin files
     *
     * @access private
     * @return void
    **/
    function _applyTemplate()
    {
        $temp = array();
        $temp = file(SPG_SKIN_DIR."/index.html");

        $skinName = $this->getSkinName();

        //changes to relative path
        $temp = str_replace("./", SPG_URI.'/_skin/'.$skinName.'/', join('', $temp));

        //common values
        $temp = str_replace('[SIMPLOG::HEAD]', '<?php $this->printHead($adminData);?>', $temp);
        $temp = str_replace('[SIMPLOG::URL]', '<?php echo SPG_URI."/".$GLOBALS[\'n\']."/index.php";?>', $temp);
        $temp = str_replace('[SIMPLOG::RSSURL]', '<?php echo SPG_URI."/".$GLOBALS[\'n\']."/rss.xml";?>', $temp);
        $temp = str_replace('[SIMPLOG::BLOGNAME]', '<?php echo $adminData[\'blog_name\'];?>', $temp);
        $temp = str_replace('[SIMPLOG::BLOGDESC]', '<?php echo $adminData[\'blog_desc\'];?>', $temp);
        $temp = str_replace('<SIMPLOG::SIMPLOG>', '<?php $this->printCrossChecking();?>', $temp);
        $temp = str_replace('</SIMPLOG::SIMPLOG>', '<?php $this->printEnd();?>', $temp);
        $temp = str_replace('<SIMPLOG::BANNER1>', '<?php if($this->bannerExists(1)){?>', $temp);
        $temp = str_replace('</SIMPLOG::BANNER1>', '<?php } ?>', $temp);
        $temp = str_replace('<SIMPLOG::BANNER2>', '<?php if($this->bannerExists(2)){?>', $temp);
        $temp = str_replace('</SIMPLOG::BANNER2>', '<?php } ?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER1]', '<?php $this->getBannerSrc(1);?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER1WIDTH]', '<?php $this->getBannerSize(1, "width");?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER1HEIGHT]', '<?php $this->getBannerSize(1, "height");?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER2]', '<?php $this->getBannerSrc(2);?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER2WIDTH]', '<?php $this->getBannerSize(2, "width");?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER2HEIGHT]', '<?php $this->getBannerSize(2, "height");?>', $temp);
        $temp = str_replace('<SIMPLOG::ISADMIN>', '<?php if($this->isAdmin()){ ?>', $temp);
        $temp = str_replace('</SIMPLOG::ISADMIN>', '<?php } ?>', $temp);

        // additional banners
        $temp = str_replace('<SIMPLOG::BANNER3>', '<?php if($this->bannerExists2(1)){?>', $temp);
        $temp = str_replace('</SIMPLOG::BANNER3>', '<?php } ?>', $temp);
        $temp = str_replace('<SIMPLOG::BANNER4>', '<?php if($this->bannerExists2(2)){?>', $temp);
        $temp = str_replace('</SIMPLOG::BANNER4>', '<?php } ?>', $temp);
        $temp = str_replace('<SIMPLOG::BANNER5>', '<?php if($this->bannerExists2(3)){?>', $temp);
        $temp = str_replace('</SIMPLOG::BANNER5>', '<?php } ?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER3]', '<?php $this->getAdditionalBannerSrc(1);?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER3WIDTH]', '<?php $this->getBannerSize(3, "width");?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER3HEIGHT]', '<?php $this->getBannerSize(3, "height");?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER4]', '<?php $this->getAdditionalBannerSrc(2);?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER4WIDTH]', '<?php $this->getBannerSize(4, "width");?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER4HEIGHT]', '<?php $this->getBannerSize(4, "height");?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER5]', '<?php $this->getAdditionalBannerSrc(3);?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER5WIDTH]', '<?php $this->getBannerSize(5, "width");?>', $temp);
        $temp = str_replace('[SIMPLOG::BANNER5HEIGHT]', '<?php $this->getBannerSize(5, "height");?>', $temp);
        
        // print calendar
        $temp = str_replace('<SIMPLOG::CALENDAR>', '<?php if($adminData[\'use_calendar\'] == \'1\'){?>', $temp);
        $temp = str_replace('[SIMPLOG::CALENDAR]', '<?php $this->printCalendar($adminData[\'cal_name\']);?>', $temp);
        $temp = str_replace('</SIMPLOG::CALENDAR>', '<?php } ?>', $temp);

        // search print
        $temp = str_replace('<SIMPLOG::SEARCH>', '<?php if($adminData[\'use_search\'] == \'1\'){?><form method="get" name="search" action="" onsubmit="submitOldSearch(this);">', $temp);
        $temp = str_replace('</SIMPLOG::SEARCH>', '</form><?php } ?>', $temp);

        //paging
        preg_match('|<SIMPLOG::PREPAGE>(.+)</SIMPLOG::PREPAGE>|s', $temp, $prepageButton);
        $temp = preg_replace('|<SIMPLOG::PREPAGE>(.+)</SIMPLOG::PREPAGE>|s', '<?php $this->printPrepageButton("'.addslashes($prepageButton[1]).'", $nowPage); ?>', $temp);

        $temp = str_replace('[SIMPLOG::PAGENUM]', '<?php $this->printPageNumber($nowPage);?>', $temp);

        preg_match('|<SIMPLOG::NEXTPAGE>(.+)</SIMPLOG::NEXTPAGE>|s', $temp, $prepageButton);
        $temp = preg_replace('|<SIMPLOG::NEXTPAGE>(.+)</SIMPLOG::NEXTPAGE>|s', '<?php $this->printNextpageButton("'.addslashes($prepageButton[1]).'", $nowPage); ?>', $temp);

        //admin values
        //POSTWITE
        preg_match('|<SIMPLOG::POSTWRITE>(.+)</SIMPLOG::POSTWRITE>|s', $temp, $postWriteButton);
        $temp = preg_replace('|<SIMPLOG::POSTWRITE>(.+)</SIMPLOG::POSTWRITE>|s', '<?php $this->printPostWriteButton("'.addslashes($postWriteButton[1]).'"); ?>', $temp);
        //XIN
        preg_match('|<SIMPLOG::XIN>(.+)</SIMPLOG::XIN>|s', $temp, $postXINButton);
        $temp = preg_replace('|<SIMPLOG::XIN>(.+)</SIMPLOG::XIN>|s', '<?php $this->printXLoginButton("'.addslashes($postXINButton[1]).'"); ?>', $temp);
        //XOUT
        preg_match('|<SIMPLOG::JOIN>(.+)</SIMPLOG::JOIN>|s', $temp, $postXOUTButton);
        $temp = preg_replace('|<SIMPLOG::JOIN>(.+)</SIMPLOG::JOIN>|s', '<?php $this->printJoinButton("'.addslashes($postXOUTButton[1]).'"); ?>', $temp);
        //Admin Login
        preg_match('|<SIMPLOG::ADMINLOGIN>(.+)</SIMPLOG::ADMINLOGIN>|s', $temp, $postAdminLoginButton);
        $temp = preg_replace('|<SIMPLOG::ADMINLOGIN>(.+)</SIMPLOG::ADMINLOGIN>|s', '<?php $this->printAdminLoginButton("'.addslashes($postAdminLoginButton[1]).'"); ?>', $temp);
        //Admin Logout
        $temp = str_replace('<SIMPLOG::ADMINLOGOUT>', '<?php $this->printAdminLogoutButton();?>', $temp);
        $temp = str_replace('</SIMPLOG::ADMINLOGOUT>', '<?php $this->printAdminLogoutButtonEnd(); ?>', $temp);

        //category value $category
        $temp = str_replace('<SIMPLOG::CATEGORY>', '<?php if($adminData[\'use_category\'] == \'1\'){?>', $temp);
        $temp = str_replace('[SIMPLOG::CATEGORYLIST]', '<?php $this->printCategory();?>', $temp);
        $temp = str_replace('</SIMPLOG::CATEGORY>', '<?php } ?>', $temp);

        // now i am here
        $temp = str_replace('<SIMPLOG::NOWIAM>', '<?php if($adminData[\'use_nowiam\'] >= \'1\'){?>', $temp);
        $temp = preg_replace("/\[SIMPLOG::NOWIAM=\"(.*)\"\]/", "<?php \$this->printNowIam('$1', \$adminData);?>", $temp);
        $temp = str_replace('[SIMPLOG::NOWIAMURL]', '<?php echo SPG_URI."/index.php/post/".$posts[\'no\']; ?>', $temp);
        $temp = str_replace('[SIMPLOG::NOWIAMTITLE]', '<?php echo $this->printNowIAmTitle($adminData2); ?>', $temp);
        $temp = str_replace('</SIMPLOG::NOWIAM>', '<?php } ?>', $temp);        

        //new posts list $newpost
        $temp = str_replace('<SIMPLOG::NEWPOST>', '<?php if($adminData[\'use_newpost_list\'] >= \'1\'){?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWPOSTLISTTITLE]', '<?php echo $mainview->strCut($posts[\'subject\'], $adminData[\'newpost_cut\']); ?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWPOSTLISTCONTENTS]', '<?php echo $mainview->strCut($posts[\'contents\'], $adminData[\'newpost_cut\']*5); ?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWPOSTLISTAUTHOR]', '<?php echo $mainview->strCut($posts[\'author\'], $adminData[\'newpost_cut\']); ?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWPOSTLISTURL]', '<?php echo SPG_URI."/".$GLOBALS[\'n\']."/index.php/post/".$posts[\'no\']; ?>', $temp);
        $temp = preg_replace("/\[SIMPLOG::NEWPOSTLISTDATE=\"([^\]]*)\"\]/", "<?php \$this->printDate('$1', \$posts['post_time']);?>", $temp);
        preg_match('|<SIMPLOG::NEWPOSTLIST>(.+)</SIMPLOG::NEWPOSTLIST>|s', $temp, $newpost);
        // replace list layout a function to print list
        $temp = preg_replace('|<SIMPLOG::NEWPOSTLIST>(.+)</SIMPLOG::NEWPOSTLIST>|s', '<?php $this->printNewPostList($adminData);?>', $temp);
        $temp = str_replace('</SIMPLOG::NEWPOST>', '<?php } ?>', $temp);

        //Item related data generate
        $temp = str_replace('[SIMPLOG::TITLE]', '<?php echo $this->printTitle($data);?>', $temp);
        $temp = str_replace('[SIMPLOG::NAME]', '<?php echo $this->printName($data);?>', $temp);
        $temp = str_replace('[SIMPLOG::CATEGORYNAME]', '<?php echo $mainview->getCateById($data);?>', $temp);
        $temp = preg_replace("/\[SIMPLOG::DATE=\"([^\]]*)\"\]/", "<?php \$this->printDate('$1', \$data['post_time']);?>", $temp);
        $temp = str_replace('[SIMPLOG::COMMENTNUM]', '<?php $mainview->printNumComment($data[\'no\']);?>', $temp);
        $temp = str_replace('[SIMPLOG::TRACKBACKNUM]', '<?php $mainview->printNumTB($data[\'no\']);?>', $temp);
        $temp = str_replace('[SIMPLOG::PERMLINK]', '<?php $mainview->printPermLink($data[\'no\']);?>', $temp);        

        //new comments list $newcomment
        $temp = str_replace('<SIMPLOG::NEWCOMMENT>', '<?php if($adminData[\'use_newcomment_list\'] >= \'1\'){?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWCOMMENTCONTENT]', '<?php echo $mainview->strCut($comment[\'memo\'], $adminData[\'newcomment_cut\']); ?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWCOMMENTNAME]', '<?php echo $comment[\'name\']; ?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWCOMMENTURL]', '<?php echo SPG_URI.\'/\'.$GLOBALS[\'n\'].\'/index.php/post/\'.$comment[\'parent_no\'].\'#com\'.$comment[\'no\']; ?>', $temp);
        $temp = preg_replace("/\[SIMPLOG::NEWCOMMENTDATE=\"([^\]]*)\"\]/", "<?php \$this->printDate('$1', \$comment['date']);?>", $temp);
        preg_match('|<SIMPLOG::NEWCOMMENTLIST>(.+)</SIMPLOG::NEWCOMMENTLIST>|s', $temp, $newcomment);
        // replace list layout a function to print list
        $temp = preg_replace('|<SIMPLOG::NEWCOMMENTLIST>(.+)</SIMPLOG::NEWCOMMENTLIST>|s', '<?php $this->printNewCommentList($adminData);?>', $temp);
        $temp = str_replace('</SIMPLOG::NEWCOMMENT>', '<?php } ?>', $temp);

        // new trackback list $trackback
        $temp = str_replace('<SIMPLOG::NEWTB>', '<?php if($adminData[\'use_newtb_list\'] >= \'1\'){?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWTBPOSTURL]', '<?php echo SPG_URI."/".$GLOBALS[\'n\']."/index.php/post/".($tb[\'pno\']); ?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWTBCONTENTS]', '<?php echo $mainview->strCut(strip_tags($tb[\'contents\']), $adminData[\'newtb_cut\']); ?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWTBRAWCONTENTS]', '<?php echo strip_tags($tb[\'contents\']); ?>', $temp);
        $temp = str_replace('[SIMPLOG::NEWTBTITLE]', '<?php echo $mainview->strCut($tb[\'title\'], $adminData[\'newtb_cut\']); ?>', $temp);        
        $temp = preg_replace("/\[SIMPLOG::NEWTBSITENAME=\"([^\]]*)\"\]/", "<?php echo \$mainview->strCut(\$tb['site_name'], '$1'); ?>", $temp);
        $temp = str_replace('[SIMPLOG::NEWTBSITE]', '<?php echo $tb[\'p_link\']; ?>', $temp);
        $temp = preg_replace("/\[SIMPLOG::NEWTBDATE=\"([^\]]*)\"\]/", "<?php \$this->printDate('$1', \$tb['date']);?>", $temp);
        preg_match('|<SIMPLOG::NEWTBLIST>(.+)</SIMPLOG::NEWTBLIST>|s', $temp, $trackback);
        // replace list layout a function to print list
        $temp = preg_replace('|<SIMPLOG::NEWTBLIST>(.+)</SIMPLOG::NEWTBLIST>|s', '<?php $this->printNewTBList($adminData);?>', $temp);
        $temp = str_replace('</SIMPLOG::NEWTB>', '<?php } ?>', $temp);

        // archive every month
        $temp = str_replace('<SIMPLOG::ARCHIVE>', '<?php if($adminData[\'use_archive_list\'] >= \'1\'){?>', $temp);        
        $temp = preg_replace("/\[SIMPLOG::ARCHIVELIST]/", '<?php $this->printArchiveList($adminData);?>', $temp);        
        $temp = str_replace('</SIMPLOG::ARCHIVE>', '<?php } ?>', $temp);        

        // link  $linksites
        $temp = str_replace('<SIMPLOG::LINKLIST>', '<?php while($lData = $lResult->fetchRow()) { if($lData[\'visible\'] == \'1\'){?>', $temp);
        $temp = str_replace('[SIMPLOG::LINKTITLE]', '<?php echo $gData[\'group_name\'];?>', $temp);
        $temp = str_replace('[SIMPLOG::LINKURL]', '<?php echo $lData[\'link_url\'];?>', $temp);
        $temp = str_replace('[SIMPLOG::LINKNAME]', '<?php echo $lData[\'link_name\'];?>', $temp);
        $temp = str_replace('[SIMPLOG::LINKRSS]', '<?php echo $lData[\'link_rss\'];?>', $temp);
        $temp = str_replace('[SIMPLOG::LINKDESC]', '<?php echo $lData[\'link_desc\'];?>', $temp);
        $temp = str_replace('<SIMPLOG::LINKNEW>', '<?php if($this->isNewLink($lData)){ $rss = $library->parseRSSWithCache($lData[\'link_rss\'], $data, 3); $linkItem = $rss->getItems();?>', $temp);
        $temp = preg_replace("/\[SIMPLOG::LINKNEWTITLE=\"([0-9]+)\"\]/", "<?php \$this->printLinkNewTitle('$1', \$linkItem);?>", $temp);
        $temp = preg_replace("/\[SIMPLOG::LINKNEWCONTENT=\"([0-9]+)\"\]/", "<?php \$this->printLinkNewContent('$1', \$linkItem);?>", $temp);
        $temp = preg_replace("/\[SIMPLOG::LINKNEWDATE=\"([^\]]*)\"\]/", "<?php \$this->printLinkNewDate('$1', \$linkItem);?>", $temp);
        $temp = str_replace('</SIMPLOG::LINKNEW>', '<?php }?>', $temp);
        $temp = str_replace('</SIMPLOG::LINKLIST>', '<?php } } ?>', $temp);
        preg_match('|<SIMPLOG::LINK>(.+)</SIMPLOG::LINK>|s', $temp, $linksites);
        $temp = preg_replace('|<SIMPLOG::LINK>(.+)</SIMPLOG::LINK>|s', '<?php $this->printLink($adminData);?>', $temp);

        // count values
        $temp = str_replace('[SIMPLOG::CNTYESTERDAY]', '<?php $this->printCount(-1);?>', $temp);
        $temp = str_replace('[SIMPLOG::CNTTODAY]', '<?php $this->printCount(0);?>', $temp);
        $temp = str_replace('[SIMPLOG::CNTTOTAL]', '<?php $this->printCount(1);?>', $temp);        

        // Comment
        // comment main $commentMain            
        preg_match('|<SIMPLOG::COMMENT>(.+)</SIMPLOG::COMMENT>|s', $temp, $commentMain);

        // Comment content view
        $commentMain[1] = str_replace('[SIMPLOG::COMMENTNAME]', '<?php $this->printCommentName($comment);?>', $commentMain[1]);
        $commentMain[1] = str_replace('[SIMPLOG::COMMENTHOME]', '<?php $this->printCommentHomepage($comment);?>', $commentMain[1]);
        $commentMain[1] = preg_replace("/\[SIMPLOG::COMMENTDATE=\"([^\]]*)\"\]/", "<?php \$skin->printDate('$1', \$comment['date']);?>", $commentMain[1]);
        $commentMain[1] = str_replace('<SIMPLOG::COMMENTDELETE>', '<?php $this->skin->printDeleteComment($comment);?>', $commentMain[1]);
        $commentMain[1] = str_replace('</SIMPLOG::COMMENTDELETE>', '<?php $this->skin->printCommentButtonEnd($comment);?>', $commentMain[1]);
        $commentMain[1] = str_replace('<SIMPLOG::COMMENTREPLY>', '<?php $this->skin->printReplyComment($comment);?>', $commentMain[1]);
        $commentMain[1] = str_replace('</SIMPLOG::COMMENTREPLY>', '<?php $this->skin->printCommentButtonEnd($comment);?>', $commentMain[1]);
        $commentMain[1] = str_replace('<SIMPLOG::COMMENTMODIFY>', '<?php $this->skin->printModifyComment($comment);?>', $commentMain[1]);
        $commentMain[1] = str_replace('</SIMPLOG::COMMENTMODIFY>', '<?php $this->skin->printCommentModifyButtonEnd($comment);?>', $commentMain[1]);
        $commentMain[1] = str_replace('[SIMPLOG::COMMENTCONTENT]', '<?php $this->printCommentMemo($comment);?>', $commentMain[1]);

        // Comment reply $commentReply       
        preg_match('|<SIMPLOG::COMMENTREPLYCONTENT>(.+)</SIMPLOG::COMMENTREPLYCONTENT>|s', $commentMain[1], $commentReply);
        $commentMain[1] = preg_replace('|<SIMPLOG::COMMENTREPLYCONTENT>(.+)</SIMPLOG::COMMENTREPLYCONTENT>|s', '<?php $this->printReplyView($comment[\'no\']);?>', $commentMain[1]);

        // get content view part , $commentView
        preg_match('|<SIMPLOG::COMMENTCONTENT>(.+)</SIMPLOG::COMMENTCONTENT>|s', $commentMain[1], $commentView);
        $commentMain[1] = preg_replace('|<SIMPLOG::COMMENTCONTENT>(.+)</SIMPLOG::COMMENTCONTENT>|s', '', $commentMain[1]);

        // Comment Write form $commentForm
        $commentMain[1] = str_replace('[SIMPLOG::COMMENTNAMEVALUE]', '<?php echo $modify[\'name\'];?>', $commentMain[1]);
        $commentMain[1] = str_replace('[SIMPLOG::COMMENTSUBMIT]', '<?php echo "commentSubmit(document.frmwrite_".$num.");"?>', $commentMain[1]);
        $commentMain[1] = str_replace('[SIMPLOG::COMMENTCONTENTVALUE]', '<?php echo $modify[\'memo\'];?>', $commentMain[1]);
        $commentMain[1] = str_replace('[SIMPLOG::COMMENTHOMEVALUE]', '<?php echo $modify[\'homepage\'];?>', $commentMain[1]);        

        $commentMain[1] = str_replace('<SIMPLOG::COMMENTWRITE>', '<SIMPLOG::COMMENTWRITE><?php $this->printWriteForm();?>', $commentMain[1]);
        $commentMain[1] = str_replace('</SIMPLOG::COMMENTWRITE>', '</form></SIMPLOG::COMMENTWRITE>', $commentMain[1]);
        preg_match('|<SIMPLOG::COMMENTWRITE>(.+)</SIMPLOG::COMMENTWRITE>|s', $commentMain[1], $commentForm);        

        $commentMain[1] = preg_replace('|<SIMPLOG::COMMENTWRITE>(.+)</SIMPLOG::COMMENTWRITE>|s', '<?php echo $contents;?>', $commentMain[1]);
        
        // replace list layout to a function to print list
        $temp = preg_replace('|<SIMPLOG::COMMENT>(.+)</SIMPLOG::COMMENT>|s', '<?php $this->printComment($data, $commentData);?>', $temp);    
        

        // trackback
        $temp = str_replace('[SIMPLOG::TBURL]', '<?php $this->printTBUrl();?>', $temp);
        $temp = str_replace('[SIMPLOG::TBSUBJECT]', '<?php $this->printTBSubject($tb);?>', $temp);
        $temp = str_replace('[SIMPLOG::TBCONTENTS]', '<?php $this->printTBContents($tb);?>', $temp);        
        $temp = str_replace('[SIMPLOG::TBFROMURL]', '<?php echo $tb[\'p_link\'];?>', $temp);
        $temp = str_replace('[SIMPLOG::TBFROM]', '<?php $this->printTBFrom($tb);?>', $temp);
        $temp = str_replace('[SIMPLOG::TBFROMSITENAME]', '<?php echo $tb[\'site_name\'];?>', $temp);
        $temp = preg_replace("/\[SIMPLOG::TBDATE=\"([^\]]*)\"\]/", "<?php \$skin->printDate('$1', \$tb['date']);?>", $temp);

        // trackback $tbContents into a file
        preg_match('|<SIMPLOG::TBCONTENTS>(.+)</SIMPLOG::TBCONTENTS>|s', $temp, $tbContents);
        $temp = preg_replace('|<SIMPLOG::TBCONTENTS>(.+)</SIMPLOG::TBCONTENTS>|s','<?php $this->printTBView();?>', $temp);
        preg_match('|<SIMPLOG::TRACKBACK>(.+)</SIMPLOG::TRACKBACK>|s', $temp, $tbAll);
        $temp = preg_replace('|<SIMPLOG::TRACKBACK>(.+)</SIMPLOG::TRACKBACK>|s', '', $temp);

        // short tags here
        $temp = str_replace('<SIMPLOG::SHORTTAGS>', '<?php if($adminData2[\'admin_numtags\'] >= \'1\'){?>', $temp);
        $temp = str_replace('[SIMPLOG::SHORTTAGS]', '<?php $this->printShortTags($adminData2); ?>', $temp);
        $temp = str_replace('</SIMPLOG::SHORTTAGS>', '<?php } ?>', $temp);

        //Item List $itemList
        $temp = str_replace('<SIMPLOG::LISTITEM>', '<?php if($isList){?>', $temp);        
        preg_match('|<SIMPLOG::LISTITEMLOOP>(.+)</SIMPLOG::LISTITEMLOOP>|s', $temp, $itemList);
        $temp = preg_replace('|<SIMPLOG::LISTITEMLOOP>(.+)</SIMPLOG::LISTITEMLOOP>|s', '<?php $this->printItemList(\$res);?>', $temp);
        $temp = str_replace('</SIMPLOG::LISTITEM>', '<?php } ?>', $temp);

        // total number of items
        $temp = str_replace('[SIMPLOG::TOTALITEM]', '<?php echo $this->totalNum; ?>', $temp);

        // item list for tag
        $temp = str_replace('<SIMPLOG::TAGTITLE>', '<?php if($mode == "tag"){ ?>', $temp);
        $temp = str_replace('[SIMPLOG::TAGTITLE]', '<?php echo urldecode($tag); ?>', $temp);
        $temp = str_replace('</SIMPLOG::TAGTITLE>', '<?php } ?>', $temp);

        // item list for category
        $temp = str_replace('<SIMPLOG::CATEGORYTITLE>', '<?php if($mode == "category"){ ?>', $temp);
        $temp = str_replace('[SIMPLOG::CATEGORYTITLE]', '<?php if($arr[2]) echo $mainview->getCateByIdOutLink(array("category_id"=>$arr[2])); else echo $GLOBALS[\'lang\'][\'main\'][\'cateviewall\']; ?>', $temp);
        $temp = str_replace('</SIMPLOG::CATEGORYTITLE>', '<?php } ?>', $temp);

        // item list for date archive
        $temp = str_replace('<SIMPLOG::DATETITLE>', '<?php if($mode == "date" && $arr[2]){ ?>', $temp);
        $temp = preg_replace("/\[SIMPLOG::DATEYEAR=\"([^\]]*)\"\]/", "<?php \$this->printDate('$1', mktime(0, 0, 0, 1, 1, \$arr[2]) );?>", $temp);
        $temp = preg_replace("/\[SIMPLOG::DATEMONTH=\"([^\]]*)\"\]/", "<?php if(\$arr[3]) \$this->printDate('$1', mktime(0, 0, 0, \$arr[3], 1, 1) );?>", $temp);
        $temp = preg_replace("/\[SIMPLOG::DATEDAY=\"([^\]]*)\"\]/", "<?php if(\$arr[4]) \$this->printDate('$1', mktime(0, 0, 0, 1, \$arr[4], 1) );?>", $temp);
        $temp = str_replace('</SIMPLOG::DATETITLE>', '<?php } ?>', $temp);


        // guest book 
        $temp = str_replace('<SIMPLOG::GUEST>', '<?php if($mode == "guest"){?>', $temp);
        $temp = str_replace('</SIMPLOG::GUEST>', '<?php $this->printGuest();} ?>', $temp);
        preg_match("/\[SIMPLOG::GUESTNEW=\"(.*)\"\]/", $temp, $guestNew);
        $guestNew2 = addslashes($guestNew[1]);
        unset($guestNew);
        $temp = preg_replace("/\[SIMPLOG::GUESTNEW=\"(.*)\"\]/", '<?php $this->printGuestNew("'.$guestNew2.'");?>', $temp);

        // all tags here
        $temp = str_replace('<SIMPLOG::TAGS>', '<?php if($mode == "tag" && !$tag){?>', $temp);
        $temp = str_replace('[SIMPLOG::TAGS]', '<?php $this->printAllTags(); ?>', $temp);
        $temp = str_replace('</SIMPLOG::TAGS>', '<?php } ?>', $temp);

        //get position of each section
        $headerPos = explode("<SIMPLOG::ITEM>", $temp);
        $listFooterPos = explode("</SIMPLOG::ITEM>", $headerPos[1]);

        //header data is generated        
        $this->header = $headerPos[0];

        //// Main item part is generated
        $this->list = $listFooterPos[0];
        preg_match('|<SIMPLOG::FILE>(.+)</SIMPLOG::FILE>|s', $this->list, $fileList);
        $fileList = addslashes($fileList[1]);        
        $this->list = preg_replace("|<SIMPLOG::FILE>(.+)</SIMPLOG::FILE>|s", "<?php \$this->printFiles(\"".$fileList."\", \$data['no']);?>", $this->list);
        $this->list = str_replace('<SIMPLOG::TRACKBACKBUTTON>', '<a href="#tb" onclick="viewTB(\'<?php echo $GLOBALS[\'n\'];?>\',\'frm_com_<?php echo $data[\'no\'];?>\', \'pcomment_<?php echo $data[\'no\'];?>\', \'<?php echo $data[\'no\'];?>\')" class="A_TRACKBACK">', $this->list);
        $this->list = str_replace('</SIMPLOG::TRACKBACKBUTTON>', '</a>', $this->list);
        $this->list = str_replace('<SIMPLOG::COMMENTBUTTON>', '<a href="#com" onclick="viewComment(\'<?php echo $GLOBALS[\'n\'];?>\',\'frm_com_<?php echo $data[\'no\'];?>\', \'pcomment_<?php echo $data[\'no\'];?>\', \'<?php echo $data[\'no\'];?>\')" class="A_COMMENT">', $this->list);
        $this->list = str_replace('</SIMPLOG::COMMENTBUTTON>', '</a>', $this->list);
        $this->list = str_replace('[SIMPLOG::CONTENTS]', '<?php echo $this->printContents($data);?>', $this->list);

        preg_match('|<SIMPLOG::MODIFY>(.+)</SIMPLOG::MODIFY>|s', $this->list, $modifyBtn);
        $modifyBtn = addslashes($modifyBtn[1]);
        $this->list = preg_replace("|<SIMPLOG::MODIFY>(.+)</SIMPLOG::MODIFY>|s", "<?php \$this->printModifyBtn(\"".$modifyBtn."\", \$data['no']);?>", $this->list);

        preg_match('|<SIMPLOG::DELETE>(.+)</SIMPLOG::DELETE>|s', $this->list, $deleteBtn);
        $deleteBtn = addslashes($deleteBtn[1]);
        $this->list = preg_replace("|<SIMPLOG::DELETE>(.+)</SIMPLOG::DELETE>|s", "<?php \$this->printDeleteBtn(\"".$deleteBtn."\", \$data['no']);?>", $this->list);

        // link related posts
        $this->list = str_replace('<SIMPLOG::RELATED>', '<?php if($this->isKeywords($data[\'no\'])) { $dataRes = new Data(); $relRes = $dataRes->getRelatedPost($data[\'no\']); } if($this->isKeywords($data[\'no\']) && ($relRes->numRows() > 0)){?>', $this->list);
        preg_match('|<SIMPLOG::RELATEDLIST>(.+)</SIMPLOG::RELATEDLIST>|s', $this->list, $relatedList);
        $relatedList = addslashes($relatedList[1]);        
        $this->list = preg_replace("|<SIMPLOG::RELATEDLIST>(.+)</SIMPLOG::RELATEDLIST>|s", "<?php \$this->printRelatedPosts(\"".$relatedList."\", \$data['no'], \$relRes);?>", $this->list);
        $this->list = str_replace('</SIMPLOG::RELATED>', '<?php } ?>', $this->list);

        // tags in the post
        $this->list = str_replace('<SIMPLOG::TAGPOST>', '<?php if($this->isKeywords($data[\'no\'])) { ?>', $this->list);
        $this->list = preg_replace("/\[SIMPLOG::TAGPOST=\"([^\]]*)\"\]/", "<?php \$this->printTagPost(\$data['no'], '$1');?>", $this->list);
        $this->list = str_replace('</SIMPLOG::TAGPOST>', '<?php } ?>', $this->list);
        
        //footer data
        $this->footer = $listFooterPos[1];

        //free re-unuseable variables
        unset($temp);
        unset($headerPos);
        unset($listFooterPos);

        $this->_makeCacheDir();

        $this->makeSkinCache($this->header, "main_header.php");
        $this->makeSkinCache($this->list, "main_item.php");
        $this->makeSkinCache($this->footer, "main_footer.php");
        $this->makeSkinCache($commentView[1], "comment_view.php");
        $this->makeSkinCache($commentReply[1], "comment_reply.php");
        $this->makeSkinCache($commentForm[1], "comment_form.php");
        $this->makeSkinCache($tbAll[1], "trackback_view.php");
        $this->makeSkinCache($tbContents[1], "trackback_contents.php");
        $this->makeSkinCache($itemList[1], "itemlist.php");
        $this->makeSkinCache($newpost[1], "newpost.php");
        $this->makeSkinCache($newcomment[1], "newcomment.php");
        $this->makeSkinCache($trackback[1], "trackback.php");
        $this->makeSkinCache($linksites[1], "linksites.php");
        $this->makeSkinCache($commentMain[1], "comment_main.php");        

    }   //End _applyTemplate()


    /**
     * printTagPost
     * print tag(s) in the post
     * @param int $postNo : post number, string $spilit character
     * @return void
    **/
    function printTagPost($postNo, $spilit)
    {
        $data = new Data();
        $result = $data->getKeywordsByPostResult($postNo, $GLOBALS['n']);

        $tags = array();

        $i = 0;
        while ($row = $result->fetchRow())
        {
            if($i != 0)
                echo $spilit;
			echo '<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/list/tag/'.$row['keywords'].'" class="TAGPOST">'.$row['keywords'].'</a>';
            $i++;
        }
    }

    /**
     * isKeywords
     * check if there is keywords for that post
     * @param int $postNo : post number
     * @return bool
    **/
    function isKeywords($postNo)
    {
        $data = new Data();

        $keys = $data->getKeywordsByPost($postNo);

        if($keys)
            return true;
        else return false;
    }

    /**    
     * printRelatedPosts
     * print related posts for a particular post according to keywords
    **/
    function printRelatedPosts($layout, $postNo, $relRes)
    {
        $data = new Data();
        $mainview = new Mainview();
        $adminData2 = $data->getAdminData2();
        $i = 1;
        $hidden = "";
        while($reData = $relRes->fetchRow())
        {
            $reData['subject'] = $mainview->strCut($reData['subject'], 70);
            if($adminData2['admin_numrelated'] != "0" && $i >= $adminData2['admin_numrelated'] + 1)
            {
                $hidden .= '<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/post/'.$reData['no'].'" class="a_related">'.$reData['subject'].'</a><br />';                
            }
            else
            {
                $out = str_replace('[SIMPLOG::RELATEDTITLE]', '<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/post/'.$reData['no'].'"  class="a_related">'.$reData['subject'].'</a>', $layout);
                echo $out;
            }            
            $i++;
        }

        if($hidden)
        {
            $out = str_replace('[SIMPLOG::RELATEDTITLE]', '<span style="cursor:hand" id="rel_more_'.$postNo.'" onclick="toggle(\'rel_more_'.$postNo.'\',\'related_'.$postNo.'\');" class="related_btn">...more</span><div id="related_'.$postNo.'" style="display:none;">'.$hidden.'</div>', $layout);

            echo $out;
        }
    }

    //
    //
    //
    function _makeCacheDir()
    {
        if(!is_dir(SPG_SKIN_CACHE_DIR))
        {
            if(!mkdir(SPG_SKIN_CACHE_DIR, 0707))
            {
                echo "Making Cache Dir Error".__FILE__.__LINE__;
            }
			else
			{
				chmod(SPG_SKIN_CACHE_DIR, 0707);
			}
        }
    }


    /**
     * makeSkinCache()
     * 
     * @param String $data          data to be saved in a file
     * @param String $fileName      file to store data
     * @access public
     * @return void
    **/
    function makeSkinCache($data, $fileName)
    {
        //make cache directory for the skin
        //if there is no folder, then parse all files
        if(is_dir(SPG_SKIN_CACHE_DIR))
        {
            $fp = fopen(SPG_SKIN_CACHE_DIR."/".$fileName, "w");

            if(!$fp)
            {
                echo "fopen error";
            }

            if(!@chmod(SPG_SKIN_CACHE_DIR."/".$fileName, 0707))
            {
                echo "chmod error";
            }

            fputs($fp, $data);
            fclose($fp);
        }
        else
        {
            echo "Skin cache directory is not exist";
        }
    }

    /**
     * getSkinName()
     *
     * @access public
     * @return String
    **/
    function getSkinName()
    {
        $data = new Data();
        $adminData = $data->getAdminData($GLOBALS['n']);
        
        $res = $adminData['skin'];

        return $res;
    }   // End :: getSkinName()

    function isNewLink($linkData)
    {
        $data = new Data();
        $adminData2 = $data->getAdminRssById();
        $now = time();
        $age = 3600 * 3;

        // if a link has RSS
        if($linkData['link_rss'])
        {
            // That link has already cached.
            if($adminData2["rss_".$linkData['link_rss']])
            {
                $pos = strpos($adminData2["rss_".$linkData['link_rss']], "|");
                $rssTime = substr($adminData2["rss_".$linkData['link_rss']], 0, $pos);
                if($now - $rssTime < $age)
                    return true;
            }
        }
        // otherwise, that link has no cache or no RSS
        return false;
    }

    function printLinkNewTitle($cut, $item)
    {
        $mainview = new Mainview();
        $item[0]['title'] = trim($item[0]['title']);
        echo $mainview->strCut($item[0]['title'], $cut);
    }

    function printLinkNewContent($cut, $item)
    {
        $mainview = new Mainview();
        $item[0]['description'] = strip_tags(trim($item[0]['description']));
        echo $mainview->strCut($item[0]['description'], $cut);
    }

    function printLinkNewDate($format, $item)
    {
        if($item[0]['pubdate'])
            $date = $item[0]['pubdate'];
        else if($item[0]['dc:date'])
            $date = $item[0]['dc:date'];

        $pubDate = strtotime($date);

        echo date($format, $pubDate);
    }

    function printGuestNew($str)
    {
        $str = stripslashes($str);
        $data = new Data();
        $comment = $data->getRecentCommentByPost(0);
        $now = time();
        // 3 days
        $age = 86400 * 3;

        if($now - $comment['date'] < $age)
            echo sprintf('%s', $str);
    }

    function printShortTags($adminData2)
    {
        $mainview = new Mainview();
        $taginfo = $mainview->getTagCloud();

        $tagfreq = $taginfo['freq'];
        $tags = $taginfo['tags'];
        $avr = $taginfo['average'];

        $tags = $mainview->suffleArray($tags);

        $num = count($tags);
        if($adminData2['admin_numtags'] < $num)
        {
            $num = $adminData2['admin_numtags'];
        }        
         
        for($i = 0; $i < $num; $i++)
		{
			$style = $mainview->getStyleForShortTag($tags[$i]['cnt'], $tagfreq[0], $tagfreq[1]);
			$print_tag .= '<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/list/tag/'.($tags[$i]['tag']).'"  class="'.$style.'">'.$tags[$i]['tag']."</a> ";			
		}
        
        echo $print_tag;
    }

    function printAllTags()
    {
        $mainview = new Mainview();
        $taginfo = $mainview->getTagCloud();

        $tagfreq = $taginfo['freq'];
        $tags = $taginfo['tags'];
        $avr = $taginfo['average'];

        $tags = $mainview->suffleArray($tags);

        $num = count($tags);   
         
        for($i = 0; $i < $num; $i++)
		{
			$style = $mainview->getStyleForAllTag($tags[$i]['cnt'], $tagfreq[0], $tagfreq[1]);
			$print_tag .= '<a href="'.SPG_URI.'/'.$GLOBALS['n'].'/index.php/list/tag/'.($tags[$i]['tag']).'"  class="'.$style.'">'.$tags[$i]['tag']."</a> ";			
		}
        
        echo $print_tag;
    }
}
?>