<?php

/*제작자 : 유창화
사용제한 : 사용은 자유롭습니다. 단, 강의나 책의 내용으로서 사용될 경우 허락을 받으셔야 합니다.*/

//현재 마이크로타임 측정함수
function Yget_microtime(){

  list($usec, $sec) = explode(' ', microtime()); 
  return ((float)$usec + (float)$sec);
}

//현재 스크립트 실행 시간 측정함수
function Yget_usetime($start, $end){

  return (float)((int)(($end - $start) * 10000) / 10000);
}

//파일 하단에 실행시간 출력
function Yecho_usetime($start){

  if (!empty($start)) {

    //처리시간 측정끝
    $end = Yget_microtime();
    $Yusetime = Yget_usetime($start, $end);
    echo "\n\n\n\n<br><br><br><br>처리하는데 사용된 시간 : $Yusetime";
  }
}

//변수가 정의 되었으면 해당 값을 반환하고 정의 되어있지 않으면 지정된 기본값을 반환합니다.
function Yvar_check(&$var, $return=''){

  return (isset($var)) ? $var : $return;
}

//변수가 정의되지 않았거나 값이 NULL값 이거나, 값이 0, false 일경우 지정된 기본값을 반환합니다.
function Yvar_empty_check(&$var, $return=''){

  return (!empty($var)) ? $var : $return;
}

//변수가 정의되지 않았거나 값이 숫자가 아닐경우 지정된 기본값을 반환합니다.
function Yvar_number_check(&$var, $return=''){

  return (!empty($var) && is_numeric($var)) ? $var : $return;
}

//배열 addslashes, 배열안의 배열도 모두 처리, 재귀호출 함수
function Yarray_addslashes($array){

  if (is_array($array)){

    foreach($array as $key => $value){

      if (is_array($value)){

        $array[$key] = Yarray_addslashes($value);
      }
      else {

        $array[$key] = addslashes($value);
      }
    }
  }

  return $array;
}

//파일하단에 설명글 출력
function Yecho_guide($text){

  if (!empty($text)) {

    echo "\n\n<br><br><font color='red'>" . nl2br(htmlspecialchars(trim($text))) . "</font>";
  }
}

//파일하단에 소스보기 출력
function Yecho_viewsource($file_name=''){

  if (!empty($file_name)) {
    
    $url = 'source/Ydownload.php';
    $target = '';
    $title = '소스다운받기';
  }
  else {
    
    $url = 'source/Yfilereader.php';
    $file_name = preg_replace("'^.+/([^/]+)$'", "\\1", $_SERVER['SCRIPT_FILENAME']);
    $target = ' target=\'_blank\'';
    $title = '소스보기';
  }

  if (!empty($file_name)) {

    echo "\n\n<br><br><a href='" . $url . "?file=" . $file_name . "' " . $target . ">" . $title . "</a>";
    echo "\n<br><a href='./'>전체보기</a>";
  }
}

//http, GET 방식의 소켓연결
function Ysockopen($url, $referer='', $accept='*/*', $contenttype='application/x-www-form-urlencoded', $cachecontrol='private', $pragma='no-cache', $connection='close'){

  if (!empty($url) && preg_match("`^http://.+`i", $url)) {

    $array = parse_url($url);
    $url_scheme = Yvar_check($array['scheme']);
    $url_server = Yvar_check($array['host']);
    $url_path = Yvar_check($array['path']);
    $url_query= Yvar_check($array['query']);
    $url_port = Yvar_empty_check($array['port'], 80);

    $fp = fsockopen($url_server, $url_port);

    if (empty($fp)) {

      return false;
    }

    fputs($fp, "GET " . $url_path . "?" . $url_query . " HTTP/1.0\n");
    if (!empty($accept)) fputs($fp, "Accept: " . $accept . "\n");
    if (!empty($contenttype)) fputs($fp, "Content-Type: " . $contenttype . "\n");
    fputs($fp, "Host: $url_server:$url_port\n");
    if (!empty($referer)) fputs($fp, "Referer: " . $referer . "\n");
    if (!empty($cachecontrol)) fputs($fp, "Cache-control: " . $cachecontrol . "\n");
    if (!empty($pragma)) fputs($fp, "Pragma: " . $pragma . "\n");
    if (!empty($connection)) fputs($fp, "Connection: " . $connection . "\n\n");

    return $fp;
  }
  else {

    return false;
  }
}

function Ysockclose(&$fp){

  if (!empty($fp)) fclose($fp);

  return true;
}

//소켓으로 외부파일 통째로 텍스트로 읽어옴
function Yreadfile($url, $referer='', $accept='*/*', $contenttype='application/x-www-form-urlencoded', $cachecontrol='private', $pragma='no-cache', $connection='close') {

  $fp = Ysockopen($url, $referer, $accept, $contenttype, $cachecontrol, $pragma, $connection);
  if (!empty($fp)) {

    $text = '';
    $check_header = false;
    while (!feof($fp)){

      $temp = fgets($fp, 1024);

      if ($check_header == false){

        //실제 파일이 아닌 헤더 정보인지 체크 하여 추가하지 않는다.
        if (preg_match("'^(\r)?\n$'", $temp)) {

          $check_header = true;
          continue;
        }
      }
      else{

        //헤더 정보가 아닌 경우에만 추가한다.        
        $text .= $temp;
      }
    }

    Ysockclose($fp);

    return $text;
  }
  else {

    return '';
  }
}

//소켓으로 외부파일 통째로 배열로 읽어옴
function Yfile($url, $referer='', $accept='*/*', $contenttype='application/x-www-form-urlencoded', $cachecontrol='private', $pragma='no-cache', $connection='close') {

  $fp = Ysockopen($url, $referer, $accept, $contenttype, $cachecontrol, $pragma, $connection);
  if (!empty($fp)) {

    $return = Array();
    $check_header = false;
    while (!feof($fp)){

      $temp = fgets($fp, 1024);

      if ($check_header == false){

        //실제 파일이 아닌 헤더 정보인지 체크 하여 추가하지 않는다.
        if (preg_match("'^(\r)?\n$'", $temp)) {

          $check_header = true;
          continue;
        }
      }
      else{

        //헤더 정보가 아닌 경우에만 추가한다.        
        $return[] = $temp;
      }
    }

    Ysockclose($fp);

    return $return;
  }
  else {

    return Array();
  }
}

?>